/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.jdbc.SQLUtils;
import com.sun.sql.framework.utils.AttributeMap;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CorrelatedQueryExecutor
extends SimpleTask {
    private static final String LOG_CATEGORY = CorrelatedQueryExecutor.class.getName();
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private ETLTaskNode taskNode;
    private int batchSize = 5000;
    private DBConnectionFactory factory = DBConnectionFactory.getInstance();
    private String srcConnName = null;
    private String tgtConnName = null;
    private Connection srcConn = null;
    private Connection tgtConn = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        try {
            this.factory.closeConnection(this.srcConn);
            if (this.tgtConn != null) {
                this.taskNode.getContext().closeAndReleaseLater(this.tgtConn);
            }
            this.taskNode = null;
        }
        catch (Exception ex) {
            Logger.printThrowable(30000, LOG_CATEGORY, this.getClass().getName(), "Exception while task cleanup:", ex);
        }
        finally {
            super.cleanUp();
        }
    }

    private void handleInternalException(ETLTaskNode node, Throwable ex) throws ThreadDeath, ETLException {
        String msg = (ex = this.unwrapThrowable(ex)).getMessage();
        if (StringUtil.isNullString(msg)) {
            msg = ex.toString();
        }
        String failureMsg = MSG_MGR.getString("MSG_CQE_insert_or_update_failure", msg);
        try {
            if (this.tgtConn != null && !this.tgtConn.getAutoCommit()) {
                Logger.print(10000, LOG_CATEGORY, "Rolling back transactions");
                this.tgtConn.rollback();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.updateRowsProcessedCount(node, 0);
        throw new ETLException(failureMsg, ex);
    }

    public void handleException(ETLException ex) {
        this.cleanUp();
        Logger.printThrowable(10000, LOG_CATEGORY, "Co-related Query Executor:", "Handling exception for CorrelatedQueryExecutor.", ex);
        if (this.tgtConn != null && this.tgtConnName != null) {
            this.factory.closeConnection(this.tgtConn);
            this.tgtConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(ETLTaskNode node) throws ETLException {
        ETLEngineContext.CollabStatistics stats = null;
        String updateStmnt = null;
        String insSelect = null;
        ResultSet selectRS = null;
        int updateCount = 0;
        int insertCount = 0;
        try {
            int bsInt;
            if (node == null) {
                throw new ETLException("Task node is null.");
            }
            this.taskNode = node;
            AttributeMap taskAttrMap = this.taskNode.getAttributeMap();
            String batchSizeStr = (String)taskAttrMap.getAttributeValue("batchSize");
            stats = node.getParent().getContext().getStatistics();
            Timestamp startTime = super.createExecutionEntryInSummaryTable(node);
            stats.setTableStartTime(node.getTableName(), startTime);
            int executionId = super.getExecutionEntryIdFromSummaryTable(node, startTime);
            stats.setTableExecutionId(node.getTableName(), executionId);
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(3, node.getTableName(), "" + executionId);
            this.taskNode.fireETLEngineExecutionEvent(evnt);
            if (!StringUtil.isNullString(node.getDisplayName())) {
                this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
            }
            String msg = MSG_MGR.getString("MSG_CQE_started");
            node.fireETLEngineLogEvent(msg, 10000);
            if (!StringUtil.isNullString(batchSizeStr) && (bsInt = StringUtil.getInt(batchSizeStr)) > 0) {
                this.batchSize = bsInt;
            }
            List connList = node.getParent().getConnectionDefList();
            SQLPart updateSQLPart = node.getStatement("correlatedUpdate");
            if (updateSQLPart == null) {
                throw new ETLException(this.DN + "Missing required insert SQLPart element");
            }
            updateStmnt = updateSQLPart.getSQL();
            if (updateStmnt == null) {
                throw new ETLException(this.DN + "Missing required insert statement");
            }
            this.tgtConnName = updateSQLPart.getConnectionPoolName();
            this.tgtConn = this.getConnection(this.tgtConnName, connList);
            Logger.print(10000, LOG_CATEGORY, this.DN + " Got staging connection: " + this.tgtConn);
            this.setAutoCommitIfRequired(this.tgtConn, true);
            this.dropTable(node, this.tgtConn);
            this.createTable(node, this.tgtConn);
            this.setAutoCommitIfRequired(this.tgtConn, false);
            if (!this.createBeforeProcess(node, this.tgtConn)) {
                this.truncateBeforeProcess(node, this.tgtConn);
            }
            selectRS = this.selectData(node);
            List bindingVarJdbcTypes = (List)updateSQLPart.getAttribute("jdbcTypeList").getAttributeValue();
            List bindVariableSource = (List)updateSQLPart.getAttribute("DestinationsSource").getAttributeValue();
            updateCount = this.updateData(selectRS, updateStmnt, this.tgtConn, bindingVarJdbcTypes, bindVariableSource, node);
            SQLPart insSelectSQLPart = node.getStatement("insertSelectStatement");
            if (insSelectSQLPart != null) {
                insSelect = insSelectSQLPart.getSQL();
            }
            if (this.tgtConn != null && !this.tgtConn.isClosed() && insSelect != null) {
                insertCount = this.insertdata(node, insSelect, this.tgtConn, executionId);
            }
            node.getParent().getContext().commitLater(this.tgtConn);
            msg = MSG_MGR.getString("MSG_CQE_finished");
            node.fireETLEngineLogEvent(msg, 10000);
            stats.setRowsExtractedCount(node.getTableName(), updateCount + insertCount);
            this.updateRowsProcessedCount(node, updateCount + insertCount);
            evnt = new ETLEngineExecEvent(4, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
            this.taskNode.fireETLEngineExecutionEvent(evnt);
        }
        catch (Exception ex) {
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(5, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
            evnt.setCause(ex);
            node.fireETLEngineExecutionEvent(evnt);
            this.handleInternalException(node, ex);
        }
        finally {
            Statement rsStmt = null;
            if (selectRS != null) {
                try {
                    rsStmt = selectRS.getStatement();
                }
                catch (SQLException e) {}
                this.closeResultSet(selectRS);
                this.closeStatement(rsStmt);
            }
        }
        return "Success";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTable(ETLTaskNode node, Connection con) throws Exception {
        SQLPart createSQLPart;
        String createTableRelatedSql;
        Statement stmt;
        block8: {
            stmt = null;
            createTableRelatedSql = "";
            createSQLPart = node.getStatement("createStatement");
            if (createSQLPart != null) break block8;
            this.closeStatement(stmt);
            return;
        }
        try {
            Iterator itr = createSQLPart.getIterator();
            while (itr.hasNext()) {
                stmt = con.createStatement();
                createTableRelatedSql = (String)itr.next();
                String createStartMsg = MSG_MGR.getString("MSG_extractor_create_attempt");
                this.taskNode.fireETLEngineLogEvent(createStartMsg, 10000);
                String showSqlMsg = MSG_MGR.getString("MSG_common_using_sql", createTableRelatedSql);
                this.taskNode.fireETLEngineLogEvent(showSqlMsg, 10000);
                stmt.executeUpdate(createTableRelatedSql);
                String successMsg = MSG_MGR.getString("MSG_extractor_create_success");
                this.taskNode.fireETLEngineLogEvent(successMsg, 10000);
            }
        }
        catch (SQLException e) {
            block9: {
                try {
                    if (!this.isObjectAlreadyExistsException(e)) break block9;
                    String tableExistsMsg = MSG_MGR.getString("MSG_extractor_create_failure_table_exists");
                    this.taskNode.fireETLEngineLogEvent(tableExistsMsg, 30000);
                }
                catch (Throwable throwable) {
                    this.closeStatement(stmt);
                    throw throwable;
                }
                this.closeStatement(stmt);
                return;
            }
            super.logSQLException(40000, LOG_CATEGORY, e);
            throw e;
            catch (Exception e2) {
                String failureMsg = MSG_MGR.getString("MSG_extractor_create_failure");
                this.taskNode.fireETLEngineLogEvent(failureMsg, 10000);
                Logger.printThrowable(10000, LOG_CATEGORY, this, this.DN + failureMsg, e2);
                throw e2;
            }
        }
        this.closeStatement(stmt);
        return;
    }

    private void dropTable(ETLTaskNode node, Connection con) throws BaseException, SQLException {
        Statement stmt = null;
        try {
            SQLPart checkTablePart = node.getStatement("checkTableExists");
            SQLPart dropSQLPart = node.getStatement("dropStatement");
            if (dropSQLPart == null) {
                return;
            }
            String dropMsg = MSG_MGR.getString("MSG_extractor_drop_attempt");
            node.fireETLEngineLogEvent(dropMsg, 10000);
            String dropSQL = dropSQLPart.getSQL();
            String checkSQL = checkTablePart.getSQL();
            String checkStmtMsg = MSG_MGR.getString("MSG_common_using_sql", checkSQL);
            String dropStmtMsg = MSG_MGR.getString("MSG_common_using_sql", dropSQL);
            Logger.print(10000, LOG_CATEGORY, this.DN + checkStmtMsg);
            node.fireETLEngineLogEvent(dropStmtMsg, 10000);
            stmt = con.createStatement();
            if (this.isTableExists(con, checkSQL, node)) {
                stmt.executeUpdate(dropSQL);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            String droppedMsg = MSG_MGR.getString("MSG_common_table_dropped");
            node.fireETLEngineLogEvent(droppedMsg, 10000);
            this.closeStatement(stmt);
        }
        catch (SQLException e) {
            if (this.isObjectDoesNotExistException(e)) {
                String tableExistsMsg = MSG_MGR.getString("MSG_extractor_drop_failure_table_nonexistent");
                this.taskNode.fireETLEngineLogEvent(tableExistsMsg, 30000);
                return;
            }
            super.logSQLException(40000, LOG_CATEGORY, e);
            throw e;
        }
        catch (Exception t) {
            Logger.printThrowable(40000, LOG_CATEGORY, this, "Unexpected error while dropping table.", t);
            throw new BaseException(t);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    private ResultSet selectData(ETLTaskNode node) throws BaseException {
        ResultSet rs;
        SQLPart selectSQLPart = null;
        String selectStmt = null;
        PreparedStatement stmt = null;
        try {
            selectSQLPart = node.getStatement("correlatedSelect");
            if (selectSQLPart == null) {
                throw new ETLException(this.DN + "Missing required select SQLPart element");
            }
            selectStmt = selectSQLPart.getSQL();
            if (selectStmt == null) {
                throw new ETLException(this.DN + "Missing required select statement");
            }
            this.srcConnName = selectSQLPart.getConnectionPoolName();
            this.srcConn = this.getConnection(this.srcConnName, node.getParent().getConnectionDefList());
            Logger.print(10000, LOG_CATEGORY, this.DN + " got source connection: " + this.srcConn);
            String startMsg = MSG_MGR.getString("MSG_CQE_select_for_update_attempt");
            node.fireETLEngineLogEvent(startMsg, 10000);
            String showSqlMsg = MSG_MGR.getString("MSG_common_using_sql", selectStmt);
            node.fireETLEngineLogEvent(showSqlMsg, 10000);
            ArrayList paramList = new ArrayList();
            Map attribMap = this.taskNode.getParent().getInputAttrMap();
            String ps = SQLUtils.createPreparedStatement(selectStmt, attribMap, paramList);
            stmt = this.srcConn.prepareStatement(ps);
            stmt.setFetchSize(this.batchSize);
            SQLUtils.populatePreparedStatement(stmt, attribMap, paramList);
            rs = stmt.executeQuery();
            if (rs == null) {
                throw new ETLException(this.DN + "Failed to get the ResultSet in " + LOG_CATEGORY + "; SQL execution failed");
            }
            String successMsg = MSG_MGR.getString("MSG_CQE_got_select_for_update_rs");
            node.fireETLEngineLogEvent(successMsg, 10000);
        }
        catch (Exception e) {
            this.closeStatement(stmt);
            throw new BaseException("Failed to get the ResultSet for " + selectStmt, e);
        }
        return rs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int updateData(ResultSet rs, String insertStmt, Connection dbCon, List types, List destsSource, ETLTaskNode node) throws Exception {
        PreparedStatement prepStmt = null;
        Map attribMap = node.getParent().getInputAttrMap();
        Map attribValues = SQLUtils.getRuntimeInputNameValueMap(attribMap);
        int localBatchSize = 0;
        int updateCount = 0;
        int numOfBindingVars = 0;
        int srcNum = 0;
        int colType = 0;
        String src = null;
        try {
            ResultSetMetaData rsMeta = rs.getMetaData();
            if (rsMeta == null) {
                this.taskNode.fireETLEngineLogEvent("Unable to fetch source table metadata", 10000);
                throw new BaseException("Unable to fetch source table metadata");
            }
            String insertStartMsg = MSG_MGR.getString("MSG_CQE_update_attempt");
            this.taskNode.fireETLEngineLogEvent(insertStartMsg, 10000);
            String prepStmtMsg = MSG_MGR.getString("MSG_extractor_show_prep_stmt", insertStmt);
            this.taskNode.fireETLEngineLogEvent(prepStmtMsg, 10000);
            prepStmt = dbCon.prepareStatement(insertStmt);
            if (prepStmt == null) {
                String errMsg = MSG_MGR.getString("MSG_CQE_invalid_update");
                this.taskNode.fireETLEngineLogEvent(errMsg, 10000);
                throw new BaseException("Invalid UPDATE statement.");
            }
            numOfBindingVars = types.size();
            while (true) {
                if (rs.next()) {
                } else {
                    if (this.batchSize > 1) {
                        int[] row = prepStmt.executeBatch();
                        prepStmt.clearBatch();
                        String rowInsertMsg = MSG_MGR.getString("MSG_CQE_batch_update_cnt", new Integer(row.length));
                        this.taskNode.fireETLEngineLogEvent(rowInsertMsg);
                        updateCount += row.length;
                    }
                    String successMsg = MSG_MGR.getString("MSG_CQE_update_success", new Integer(updateCount));
                    this.taskNode.fireETLEngineLogEvent(successMsg, 20000);
                    int n = updateCount;
                    this.closeResultSet(rs);
                    this.closeStatement(prepStmt);
                    return n;
                }
                for (int bv = 1; bv <= numOfBindingVars; ++bv) {
                    Object value;
                    src = (String)destsSource.get(bv - 1);
                    if (src.startsWith("$")) {
                        srcNum = -1;
                        colType = StringUtil.getInt((String)types.get(bv - 1));
                        value = attribValues.get(src.substring(1));
                        SQLUtils.setAttributeValue(prepStmt, bv, colType, value);
                        continue;
                    }
                    srcNum = StringUtil.getInt(src);
                    colType = rsMeta.getColumnType(srcNum);
                    switch (colType) {
                        case 93: {
                            value = rs.getTimestamp(srcNum);
                            break;
                        }
                        default: {
                            value = rs.getObject(srcNum);
                        }
                    }
                    if (!rs.wasNull() && value != null) {
                        prepStmt.setObject(bv, value);
                        continue;
                    }
                    if (rsMeta.isNullable(srcNum) != 1) {
                        throw new BaseException("Column " + rsMeta.getColumnType(srcNum) + " is not nullable.");
                    }
                    prepStmt.setNull(bv, StringUtil.getInt((String)types.get(bv - 1)));
                }
                if (this.batchSize > 1) {
                    prepStmt.addBatch();
                    if (++localBatchSize != this.batchSize) continue;
                    String engineState = (String)this.taskNode.getContext().getValue("engineState");
                    if (engineState != null && engineState.trim().equalsIgnoreCase("not-active")) {
                        prepStmt.close();
                        int n = updateCount;
                        this.closeResultSet(rs);
                        this.closeStatement(prepStmt);
                        return n;
                    }
                    int[] row = prepStmt.executeBatch();
                    prepStmt.clearBatch();
                    String rowInsertMsg = MSG_MGR.getString("MSG_CQE_batch_update_cnt", new Integer(row.length));
                    this.taskNode.fireETLEngineLogEvent(rowInsertMsg);
                    updateCount += localBatchSize;
                    localBatchSize = 0;
                    continue;
                }
                prepStmt.executeUpdate();
                ++updateCount;
            }
        }
        catch (Exception se) {
            try {
                String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", se.getMessage());
                Logger.printThrowable(40000, LOG_CATEGORY, null, errMsg, se);
                this.taskNode.fireETLEngineLogEvent(errMsg, 40000);
                throw se;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(prepStmt);
                throw throwable;
            }
        }
    }

    private int insertdata(ETLTaskNode node, String strInsSel, Connection con, int execId) throws Exception {
        int n;
        PreparedStatement stmt = null;
        ArrayList paramList = new ArrayList();
        int insertCt = 0;
        try {
            Map attribMap = node.getParent().getInputAttrMap();
            String ps = SQLUtils.createPreparedStatement(strInsSel, attribMap, paramList);
            stmt = con.prepareStatement(ps);
            SQLUtils.populatePreparedStatement(stmt, attribMap, paramList);
            int rows = stmt.executeUpdate();
            insertCt += rows > 0 ? rows : 0;
            if (rows == -3) {
                String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", strInsSel);
                node.fireETLEngineLogEvent(errMsg, 40000);
            }
            stmt.close();
            String cntMsg = MSG_MGR.getString("MSG_CQE_insert_success", new Integer(insertCt));
            this.taskNode.fireETLEngineLogEvent(cntMsg, 20000);
            n = insertCt;
        }
        catch (Exception ex) {
            try {
                String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", ex.getMessage());
                Logger.printThrowable(40000, LOG_CATEGORY, null, errMsg, ex);
                this.taskNode.fireETLEngineLogEvent(errMsg, 40000);
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        return n;
    }

    private boolean isObjectAlreadyExistsException(SQLException e) {
        String sqlState = e.getSQLState();
        int vendorCode = e.getErrorCode();
        return "42710".equals(sqlState) || "42000".equals(sqlState) && 955 == vendorCode;
    }

    private boolean isObjectDoesNotExistException(SQLException e) {
        String sqlState = e.getSQLState();
        int vendorCode = e.getErrorCode();
        return "42704".equals(sqlState) || "42000".equals(sqlState) && 942 == vendorCode;
    }

    private void updateRowsProcessedCount(ETLTaskNode node, int insertCount) {
        ETLEngineContext context = node.getParent().getContext();
        ETLEngineContext.CollabStatistics stats = context.getStatistics();
        Timestamp endDate = new Timestamp(System.currentTimeMillis());
        stats.setTableFinishTime(node.getTableName(), endDate);
        stats.setRowsInsertedCount(node.getTableName(), insertCount);
    }
}

