/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBufferPrologue;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.PerfDataBufferImpl;

public abstract class AbstractPerfDataBuffer {
    protected PerfDataBufferImpl impl;

    public int getLocalVmId() {
        return this.impl.getLocalVmId();
    }

    public byte[] getBytes() {
        return this.impl.getBytes();
    }

    public int getCapacity() {
        return this.impl.getCapacity();
    }

    public Monitor findByName(String string) throws MonitorException {
        return this.impl.findByName(string);
    }

    public List findByPattern(String string) throws MonitorException {
        return this.impl.findByPattern(string);
    }

    public MonitorStatus getMonitorStatus() throws MonitorException {
        return this.impl.getMonitorStatus();
    }

    public ByteBuffer getByteBuffer() {
        return this.impl.getByteBuffer();
    }

    protected void createPerfDataBuffer(ByteBuffer byteBuffer, int n) throws MonitorException {
        int n2 = AbstractPerfDataBufferPrologue.getMajorVersion(byteBuffer);
        int n3 = AbstractPerfDataBufferPrologue.getMinorVersion(byteBuffer);
        String string = "sun.jvmstat.perfdata.monitor.v" + n2 + "_" + n3 + ".PerfDataBuffer";
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(Class.forName("java.nio.ByteBuffer"), Integer.TYPE);
            this.impl = (PerfDataBufferImpl)constructor.newInstance(byteBuffer, new Integer(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string + ": " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Expected constructor missing in " + string + ": " + noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unexpected constructor access in " + string + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string + "is abstract: " + instantiationException.getMessage(), instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof MonitorException) {
                throw (MonitorException)throwable;
            }
            throw new RuntimeException("Unexpected exception: " + invocationTargetException.getMessage(), invocationTargetException);
        }
    }
}

