/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.SharedMemoryConnection;
import com.sun.tools.jdi.SharedMemoryTransportServiceCapabilities;
import java.io.IOException;
import java.util.ResourceBundle;

class SharedMemoryTransportService
extends TransportService {
    private ResourceBundle messages = null;

    SharedMemoryTransportService() {
        System.loadLibrary("dt_shmem");
        this.initialize();
    }

    public String name() {
        return "SharedMemory";
    }

    public String defaultAddress() {
        return "javadebug";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String description() {
        SharedMemoryTransportService sharedMemoryTransportService = this;
        synchronized (sharedMemoryTransportService) {
            if (this.messages == null) {
                this.messages = ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi");
            }
        }
        return this.messages.getString("memory_transportservice.description");
    }

    public TransportService.Capabilities capabilities() {
        return new SharedMemoryTransportServiceCapabilities();
    }

    private native void initialize();

    private native long startListening0(String var1) throws IOException;

    private native long attach0(String var1, long var2) throws IOException;

    private native void stopListening0(long var1) throws IOException;

    private native long accept0(long var1, long var3) throws IOException;

    private native String name(long var1) throws IOException;

    public Connection attach(String string, long l, long l2) throws IOException {
        if (string == null) {
            throw new NullPointerException("address is null");
        }
        long l3 = this.attach0(string, l);
        SharedMemoryConnection sharedMemoryConnection = new SharedMemoryConnection(l3);
        sharedMemoryConnection.handshake(l2);
        return sharedMemoryConnection;
    }

    public TransportService.ListenKey startListening(String string) throws IOException {
        if (string == null || string.length() == 0) {
            string = this.defaultAddress();
        }
        long l = this.startListening0(string);
        return new SharedMemoryListenKey(l, this.name(l));
    }

    public TransportService.ListenKey startListening() throws IOException {
        return this.startListening(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening(TransportService.ListenKey listenKey) throws IOException {
        long l;
        SharedMemoryListenKey sharedMemoryListenKey;
        if (!(listenKey instanceof SharedMemoryListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        SharedMemoryListenKey sharedMemoryListenKey2 = sharedMemoryListenKey = (SharedMemoryListenKey)listenKey;
        synchronized (sharedMemoryListenKey2) {
            l = sharedMemoryListenKey.id();
            if (l == 0L) {
                throw new IllegalArgumentException("Invalid listener");
            }
            sharedMemoryListenKey.setId(0L);
        }
        this.stopListening0(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection accept(TransportService.ListenKey listenKey, long l, long l2) throws IOException {
        long l3;
        SharedMemoryListenKey sharedMemoryListenKey;
        if (!(listenKey instanceof SharedMemoryListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        SharedMemoryListenKey sharedMemoryListenKey2 = sharedMemoryListenKey = (SharedMemoryListenKey)listenKey;
        synchronized (sharedMemoryListenKey2) {
            l3 = sharedMemoryListenKey.id();
            if (l3 == 0L) {
                throw new IllegalArgumentException("Invalid listener");
            }
        }
        long l4 = this.accept0(l3, l);
        SharedMemoryConnection sharedMemoryConnection = new SharedMemoryConnection(l4);
        sharedMemoryConnection.handshake(l2);
        return sharedMemoryConnection;
    }

    static class SharedMemoryListenKey
    extends TransportService.ListenKey {
        long id;
        String name;

        SharedMemoryListenKey(long l, String string) {
            this.id = l;
            this.name = string;
        }

        long id() {
            return this.id;
        }

        void setId(long l) {
            this.id = l;
        }

        public String address() {
            return this.name;
        }

        public String toString() {
            return this.address();
        }
    }
}

