/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.tools.example.debug.tty.EventRequestSpecList;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.SourceMapper;
import com.sun.tools.example.debug.tty.VMConnection;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class Env {
    static EventRequestSpecList specList = new EventRequestSpecList();
    private static VMConnection connection;
    private static SourceMapper sourceMapper;
    private static List excludes;
    private static final int SOURCE_CACHE_SIZE = 5;
    private static List sourceCache;
    private static HashMap savedValues;

    Env() {
    }

    static void init(String string, boolean bl, int n) {
        connection = new VMConnection(string, n);
        if (!connection.isLaunch() || bl) {
            connection.open();
        }
    }

    static VMConnection connection() {
        return connection;
    }

    static VirtualMachine vm() {
        return connection.vm();
    }

    static void shutdown() {
        Env.shutdown(null);
    }

    static void shutdown(String string) {
        if (connection != null) {
            try {
                connection.disposeVM();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (string != null) {
            MessageOutput.lnprint(string);
            MessageOutput.println();
        }
        System.exit(0);
    }

    static void setSourcePath(String string) {
        sourceMapper = new SourceMapper(string);
        sourceCache.clear();
    }

    static void setSourcePath(List list) {
        sourceMapper = new SourceMapper(list);
        sourceCache.clear();
    }

    static String getSourcePath() {
        return sourceMapper.getSourcePath();
    }

    private static List excludes() {
        if (excludes == null) {
            Env.setExcludes("java.*, javax.*, sun.*, com.sun.*");
        }
        return excludes;
    }

    static String excludesString() {
        Iterator iterator = Env.excludes().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    static void addExcludes(StepRequest stepRequest) {
        for (String string : Env.excludes()) {
            stepRequest.addClassExclusionFilter(string);
        }
    }

    static void addExcludes(MethodEntryRequest methodEntryRequest) {
        for (String string : Env.excludes()) {
            methodEntryRequest.addClassExclusionFilter(string);
        }
    }

    static void addExcludes(MethodExitRequest methodExitRequest) {
        for (String string : Env.excludes()) {
            methodExitRequest.addClassExclusionFilter(string);
        }
    }

    static void setExcludes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        excludes = arrayList;
    }

    static BufferedReader sourceReader(Location location) {
        return sourceMapper.sourceReader(location);
    }

    static synchronized String sourceLine(Location location, int n) throws IOException {
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        try {
            Object object;
            String string = location.sourceName();
            Iterator iterator = sourceCache.iterator();
            Object object2 = null;
            while (iterator.hasNext()) {
                object = (SourceCode)iterator.next();
                if (!((SourceCode)object).fileName().equals(string)) continue;
                object2 = object;
                iterator.remove();
                break;
            }
            if (object2 == null) {
                object = Env.sourceReader(location);
                if (object == null) {
                    throw new FileNotFoundException(string);
                }
                object2 = new SourceCode(string, (BufferedReader)object);
                if (sourceCache.size() == 5) {
                    sourceCache.remove(sourceCache.size() - 1);
                }
            }
            sourceCache.add(0, object2);
            return ((SourceCode)object2).sourceLine(n);
        }
        catch (AbsentInformationException absentInformationException) {
            throw new IllegalArgumentException();
        }
    }

    static String description(ObjectReference objectReference) {
        ReferenceType referenceType = objectReference.referenceType();
        long l = objectReference.uniqueID();
        if (referenceType == null) {
            return Env.toHex(l);
        }
        return MessageOutput.format("object description and hex id", new Object[]{referenceType.name(), Env.toHex(l)});
    }

    static String toHex(long l) {
        char[] cArray = new char[16];
        char[] cArray2 = new char[18];
        int n = 0;
        do {
            long l2 = l & 0xFL;
            cArray[n++] = (char)(l2 < 10L ? 48L + l2 : 97L + l2 - 10L);
        } while ((l >>>= 4) > 0L);
        cArray2[0] = 48;
        cArray2[1] = 120;
        int n2 = 2;
        while (--n >= 0) {
            cArray2[n2++] = cArray[n];
        }
        return new String(cArray2, 0, n2);
    }

    static long fromHex(String string) {
        String string2;
        String string3 = string2 = string.startsWith("0x") ? string.substring(2).toLowerCase() : string.toLowerCase();
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        long l = 0L;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c >= '0' && c <= '9') {
                l = l * 16L + (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                l = l * 16L + (long)(c - 97 + 10);
                continue;
            }
            throw new NumberFormatException();
        }
        return l;
    }

    static ReferenceType getReferenceTypeFromToken(String string) {
        ReferenceType referenceType = null;
        if (Character.isDigit(string.charAt(0))) {
            referenceType = null;
        } else if (string.startsWith("*.")) {
            string = string.substring(1);
            List<ReferenceType> list = Env.vm().allClasses();
            for (ReferenceType referenceType2 : list) {
                if (!referenceType2.name().endsWith(string)) continue;
                referenceType = referenceType2;
                break;
            }
        } else {
            List<ReferenceType> list = Env.vm().classesByName(string);
            if (list.size() > 0) {
                referenceType = list.get(0);
            }
        }
        return referenceType;
    }

    static Set getSaveKeys() {
        return savedValues.keySet();
    }

    static Value getSavedValue(String string) {
        return (Value)savedValues.get(string);
    }

    static void setSavedValue(String string, Value value) {
        savedValues.put(string, value);
    }

    static {
        sourceMapper = new SourceMapper("");
        sourceCache = new LinkedList();
        savedValues = new HashMap();
    }

    static class SourceCode {
        private String fileName;
        private List sourceLines = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SourceCode(String string, BufferedReader bufferedReader) throws IOException {
            this.fileName = string;
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    this.sourceLines.add(string2);
                    string2 = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }

        String fileName() {
            return this.fileName;
        }

        String sourceLine(int n) {
            int n2 = n - 1;
            if (n2 >= this.sourceLines.size()) {
                return null;
            }
            return (String)this.sourceLines.get(n2);
        }
    }
}

