/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import prefuse.data.Table;
import prefuse.data.event.TableListener;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualTable;

public class JPrefuseTable
extends JTable {
    private Table m_table;
    private TableCellRenderer m_tcr = new DefaultTableCellRenderer();

    public JPrefuseTable(Table t) {
        this.m_table = t;
        PrefuseTableModel model = new PrefuseTableModel();
        super.setModel(model);
        this.m_table.addTableListener(model);
    }

    public Table getTable() {
        return this.m_table;
    }

    public TableCellRenderer getCellRenderer(int r, int c) {
        return this.m_tcr;
    }

    public static JFrame showTableWindow(Table t) {
        JPrefuseTable table = new JPrefuseTable(t);
        String title = t.toString();
        if (t instanceof VisualTable) {
            title = ((VisualTable)t).getGroup() + " " + title;
        }
        JFrame frame = new JFrame(title);
        frame.getContentPane().add(new JScrollPane(table));
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public class PrefuseTableModel
    implements TableModel,
    TableListener {
        private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
        private int[] m_rowmap;

        private void initRowMap() {
            this.m_rowmap = new int[JPrefuseTable.this.m_table.getRowCount()];
            IntIterator rows = JPrefuseTable.this.m_table.rows();
            int i = 0;
            while (rows.hasNext()) {
                this.m_rowmap[i] = rows.nextInt();
                ++i;
            }
        }

        private int getRow(int rowIndex) {
            if (this.m_rowmap == null) {
                this.initRowMap();
            }
            return this.m_rowmap[rowIndex];
        }

        public int getColumnCount() {
            return JPrefuseTable.this.m_table.getColumnCount();
        }

        public int getRowCount() {
            return JPrefuseTable.this.m_table.getRowCount();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return JPrefuseTable.this.m_table.isCellEditable(rowIndex, columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return JPrefuseTable.this.m_table.getColumnType(columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object o = JPrefuseTable.this.m_table.getValueAt(this.getRow(rowIndex), columnIndex);
            if (o != null && o.getClass().isArray()) {
                return StringLib.getArrayString(o);
            }
            return o;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            JPrefuseTable.this.m_table.setValueAt(this.getRow(rowIndex), columnIndex, aValue);
        }

        public String getColumnName(int columnIndex) {
            return JPrefuseTable.this.m_table.getColumnName(columnIndex);
        }

        public void addTableModelListener(TableModelListener l) {
            this.m_listeners.add(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            this.m_listeners.remove(l);
        }

        public void tableChanged(Table t, int start, int end, int col, int type) {
            Object[] lstnrs;
            if (type == 1 || type == -1) {
                this.m_rowmap = null;
            }
            if ((lstnrs = this.m_listeners.getArray()).length == 0) {
                return;
            }
            TableModelEvent evt = new TableModelEvent(this, start, end, col, type);
            for (int i = 0; i < lstnrs.length; ++i) {
                ((TableModelListener)lstnrs[i]).tableChanged(evt);
            }
        }
    }
}

