/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.util.TypeUtils;

public class ValueUtils {
    private static Map dynamicPropertyHandlerMap = new HashMap();
    private static Logger logger = Logger.getLogger(ValueUtils.class.getName());

    public static boolean isCollection(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof byte[]) {
            return false;
        }
        if (value.getClass().isArray()) {
            return true;
        }
        return value instanceof Collection;
    }

    public static int getCollectionHint(Class clazz) {
        if (clazz == null) {
            return 0;
        }
        if (clazz == byte[].class) {
            return -1;
        }
        if (clazz.isArray()) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (clazz.isPrimitive()) {
            return -1;
        }
        if (clazz.isInterface()) {
            return 0;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            return -1;
        }
        return 0;
    }

    public static int getLength(Object collection) {
        if (collection == null) {
            return 0;
        }
        if (collection.getClass().isArray()) {
            return Array.getLength(collection);
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).size();
        }
        return 1;
    }

    public static Iterator iterate(Object collection) {
        if (collection == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (collection.getClass().isArray()) {
            int length = Array.getLength(collection);
            if (length == 0) {
                return Collections.EMPTY_LIST.iterator();
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(collection, i));
            }
            return list.iterator();
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).iterator();
        }
        return Collections.singletonList(collection).iterator();
    }

    public static Object expandCollection(Object collection, int size) {
        if (collection == null) {
            return null;
        }
        if (collection.getClass().isArray()) {
            Object bigger = Array.newInstance(collection.getClass().getComponentType(), size);
            System.arraycopy(collection, 0, bigger, 0, Array.getLength(collection));
            return bigger;
        }
        if (collection instanceof Collection) {
            while (((Collection)collection).size() < size) {
                ((Collection)collection).add(null);
            }
            return collection;
        }
        throw new JXPathException("Cannot turn " + collection.getClass().getName() + " into a collection of size " + size);
    }

    public static Object remove(Object collection, int index) {
        if ((collection = ValueUtils.openContainers(collection)) == null) {
            return null;
        }
        if (collection.getClass().isArray()) {
            int length = Array.getLength(collection);
            Object smaller = Array.newInstance(collection.getClass().getComponentType(), length - 1);
            if (index > 0) {
                System.arraycopy(collection, 0, smaller, 0, index);
            }
            if (index < length - 1) {
                System.arraycopy(collection, index + 1, smaller, index, length - index - 1);
            }
            return smaller;
        }
        if (collection instanceof List) {
            int size = ((List)collection).size();
            if (index < size) {
                ((List)collection).remove(index);
            }
            return collection;
        }
        if (collection instanceof Collection) {
            Iterator it = ((Collection)collection).iterator();
            for (int i = 0; i < index && it.hasNext(); ++i) {
                it.next();
            }
            if (it.hasNext()) {
                it.next();
                it.remove();
            }
            return collection;
        }
        throw new JXPathException("Cannot remove " + collection.getClass().getName() + "[" + index + "]");
    }

    public static Object getValue(Object collection, int index) {
        Object value = collection = ValueUtils.openContainers(collection);
        if (collection != null) {
            if (collection.getClass().isArray()) {
                if (index < 0 || index >= Array.getLength(collection)) {
                    return null;
                }
                value = Array.get(collection, index);
            } else if (collection instanceof List) {
                if (index < 0 || index >= ((List)collection).size() + 1) {
                    return null;
                }
                value = ((List)collection).get(index);
            } else if (collection instanceof Collection) {
                Iterator it = ((Collection)collection).iterator();
                for (int i = 0; i < index; ++i) {
                    it.next();
                }
                value = it.hasNext() ? it.next() : null;
            }
        }
        return value;
    }

    public static void setValue(Object collection, int index, Object value) {
        if ((collection = ValueUtils.openContainers(collection)) != null) {
            if (collection.getClass().isArray()) {
                Array.set(collection, index, ValueUtils.convert(value, collection.getClass().getComponentType()));
            } else if (collection instanceof List) {
                List list = (List)collection;
                if (index == list.size()) {
                    list.add(value);
                } else {
                    list.set(index, value);
                }
            } else if (collection instanceof Collection) {
                throw new UnsupportedOperationException("Cannot set value of an element of a " + collection.getClass().getName());
            }
        }
    }

    public static Object getValue(Object bean, PropertyDescriptor propertyDescriptor) {
        Object value;
        try {
            Method method = ValueUtils.getAccessibleMethod(propertyDescriptor.getReadMethod());
            if (method == null) {
                throw new JXPathException("No read method");
            }
            value = method.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new JXPathException("Cannot access property: " + (bean == null ? "null" : bean.getClass().getName()) + "." + propertyDescriptor.getName(), ex);
        }
        return value;
    }

    public static void setValue(Object bean, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            Method method = ValueUtils.getAccessibleMethod(propertyDescriptor.getWriteMethod());
            if (method == null) {
                throw new JXPathException("No write method");
            }
            value = ValueUtils.convert(value, propertyDescriptor.getPropertyType());
            value = method.invoke(bean, value);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new JXPathException("Cannot modify property: " + (bean == null ? "null" : bean.getClass().getName()) + "." + propertyDescriptor.getName(), ex);
        }
    }

    private static Object convert(Object value, Class type) {
        try {
            return TypeUtils.convert(value, type);
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot convert value of class " + (value == null ? "null" : value.getClass().getName()) + " to type " + type, ex);
        }
    }

    public static Object getValue(Object bean, PropertyDescriptor propertyDescriptor, int index) {
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            try {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                Method method = ipd.getIndexedReadMethod();
                if (method != null) {
                    return method.invoke(bean, new Integer(index));
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                throw new JXPathException("Cannot access property: " + propertyDescriptor.getName(), ex);
            }
        }
        return ValueUtils.getValue(ValueUtils.getValue(bean, propertyDescriptor), index);
    }

    public static Object getIndexedValue(Object bean, PropertyDescriptor propertyDescriptor, int index) {
        Object test = ValueUtils.getValue(bean, propertyDescriptor, index);
        return test;
    }

    public static void setValue(Object bean, PropertyDescriptor propertyDescriptor, int index, Object value) {
        Object collection;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            try {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                Method method = ipd.getIndexedWriteMethod();
                if (method != null) {
                    method.invoke(bean, new Integer(index), ValueUtils.convert(value, ipd.getIndexedPropertyType()));
                    return;
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                ex.printStackTrace();
                throw new RuntimeException("Cannot access property: " + propertyDescriptor.getName() + ", " + ex.getMessage());
            }
        }
        if (ValueUtils.isCollection(ValueUtils.openContainers(collection = ValueUtils.getValue(bean, propertyDescriptor)))) {
            ValueUtils.setValue(collection, index, value);
        } else if (index == 0) {
            ValueUtils.setValue(bean, propertyDescriptor, value);
        } else {
            throw new RuntimeException("Not a collection: " + propertyDescriptor.getName());
        }
    }

    private static Object openContainers(Object collection) {
        while (collection instanceof Container) {
            collection = ((Container)collection).getValue();
        }
        return collection;
    }

    public static DynamicPropertyHandler getDynamicPropertyHandler(Class clazz) {
        DynamicPropertyHandler handler = (DynamicPropertyHandler)dynamicPropertyHandlerMap.get(clazz);
        if (handler == null) {
            try {
                handler = (DynamicPropertyHandler)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot allocate dynamic property handler of class " + clazz.getName(), ex);
            }
            dynamicPropertyHandlerMap.put(clazz, handler);
        }
        return handler;
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = ValueUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
            try {
                method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (method != null || (method = ValueUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
        }
        return method;
    }
}

