/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.BasicMatcher;
import proguard.util.ListUtil;
import proguard.util.StringMatcher;

public class BasicListMatcher
implements StringMatcher {
    private static final char REGULAR_EXPRESSION_SEPARATOR = ',';
    private static final char REGULAR_EXPRESSION_NEGATOR = '!';
    private StringMatcher[] regularExpressionMatchers;
    private boolean[] negatedRegularExpressions;

    public BasicListMatcher(String string) {
        this(ListUtil.commaSeparatedList(string));
    }

    public BasicListMatcher(List list) {
        int n = list.size();
        this.regularExpressionMatchers = new StringMatcher[n];
        this.negatedRegularExpressions = new boolean[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            if (string.length() > 0 && string.charAt(0) == '!') {
                string = string.substring(1);
                this.negatedRegularExpressions[i] = true;
            }
            this.regularExpressionMatchers[i] = this.createBasicMatcher(string);
        }
    }

    protected StringMatcher createBasicMatcher(String string) {
        return new BasicMatcher(string);
    }

    public boolean matches(String string) {
        boolean bl = true;
        for (int i = 0; i < this.regularExpressionMatchers.length; ++i) {
            bl = this.negatedRegularExpressions[i];
            if (!this.regularExpressionMatchers[i].matches(string)) continue;
            return !bl;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Regular expression [" + stringArray[0] + "]");
            BasicListMatcher basicListMatcher = new BasicListMatcher(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + basicListMatcher.matches(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

