/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.util.ClassUtil;

public class ChangedCodePrinter
implements AttrInfoVisitor {
    private AttrInfoVisitor attrInfoVisitor;

    public ChangedCodePrinter(AttrInfoVisitor attrInfoVisitor) {
        this.attrInfoVisitor = attrInfoVisitor;
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        this.attrInfoVisitor.visitUnknownAttrInfo(classFile, unknownAttrInfo);
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        this.attrInfoVisitor.visitInnerClassesAttrInfo(classFile, innerClassesAttrInfo);
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        this.attrInfoVisitor.visitEnclosingMethodAttrInfo(classFile, enclosingMethodAttrInfo);
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        this.attrInfoVisitor.visitConstantValueAttrInfo(classFile, fieldInfo, constantValueAttrInfo);
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        this.attrInfoVisitor.visitExceptionsAttrInfo(classFile, methodInfo, exceptionsAttrInfo);
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        this.attrInfoVisitor.visitLineNumberTableAttrInfo(classFile, methodInfo, codeAttrInfo, lineNumberTableAttrInfo);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        this.attrInfoVisitor.visitLocalVariableTableAttrInfo(classFile, methodInfo, codeAttrInfo, localVariableTableAttrInfo);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        this.attrInfoVisitor.visitLocalVariableTypeTableAttrInfo(classFile, methodInfo, codeAttrInfo, localVariableTypeTableAttrInfo);
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        this.attrInfoVisitor.visitSourceFileAttrInfo(classFile, sourceFileAttrInfo);
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        this.attrInfoVisitor.visitSourceDirAttrInfo(classFile, sourceDirAttrInfo);
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        this.attrInfoVisitor.visitDeprecatedAttrInfo(classFile, deprecatedAttrInfo);
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        this.attrInfoVisitor.visitSyntheticAttrInfo(classFile, syntheticAttrInfo);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        this.attrInfoVisitor.visitSignatureAttrInfo(classFile, signatureAttrInfo);
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        this.attrInfoVisitor.visitRuntimeVisibleAnnotationAttrInfo(classFile, runtimeVisibleAnnotationsAttrInfo);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        this.attrInfoVisitor.visitRuntimeInvisibleAnnotationAttrInfo(classFile, runtimeInvisibleAnnotationsAttrInfo);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        this.attrInfoVisitor.visitRuntimeVisibleParameterAnnotationAttrInfo(classFile, runtimeVisibleParameterAnnotationsAttrInfo);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        this.attrInfoVisitor.visitRuntimeInvisibleParameterAnnotationAttrInfo(classFile, runtimeInvisibleParameterAnnotationsAttrInfo);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        this.attrInfoVisitor.visitAnnotationDefaultAttrInfo(classFile, annotationDefaultAttrInfo);
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        byte[] byArray = codeAttrInfo.code;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < codeAttrInfo.u4codeLength; ++i) {
            byArray2[i] = byArray[i];
        }
        this.attrInfoVisitor.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
        if (this.codeHasChanged(codeAttrInfo, byArray2)) {
            this.printChangedCode(classFile, methodInfo, codeAttrInfo, byArray2);
        }
    }

    private boolean codeHasChanged(CodeAttrInfo codeAttrInfo, byte[] byArray) {
        if (byArray.length != codeAttrInfo.u4codeLength) {
            return true;
        }
        for (int i = 0; i < codeAttrInfo.u4codeLength; ++i) {
            if (byArray[i] == codeAttrInfo.code[i]) continue;
            return true;
        }
        return false;
    }

    private void printChangedCode(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, byte[] byArray) {
        System.out.println("Class " + ClassUtil.externalClassName(classFile.getName()));
        System.out.println("Method " + ClassUtil.externalFullMethodDescription(classFile.getName(), 0, methodInfo.getName(classFile), methodInfo.getDescriptor(classFile)));
        for (int i = 0; i < codeAttrInfo.u4codeLength; ++i) {
            System.out.println((byArray[i] == codeAttrInfo.code[i] ? "  -- " : "  => ") + i + ": " + Integer.toHexString(0x100 | byArray[i] & 0xFF).substring(1) + " " + Integer.toHexString(0x100 | codeAttrInfo.code[i] & 0xFF).substring(1));
        }
    }
}

