/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class ClassFileOpener
implements ClassFileVisitor,
MemberInfoVisitor {
    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.makePackageVisible(programClassFile);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.makePackageVisible(programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.makePackageVisible(programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private void makePackageVisible(ProgramClassFile programClassFile) {
        if (this.isPackageVisible(programClassFile.u2accessFlags)) {
            programClassFile.u2accessFlags = this.makePublic(programClassFile.u2accessFlags);
        }
    }

    private void makePackageVisible(ProgramMemberInfo programMemberInfo) {
        if (this.isPackageVisible(programMemberInfo.u2accessFlags)) {
            programMemberInfo.u2accessFlags = this.makePublic(programMemberInfo.u2accessFlags);
        }
    }

    private boolean isPackageVisible(int n) {
        return AccessUtil.accessLevel(n) >= 1;
    }

    private int makePublic(int n) {
        return AccessUtil.replaceAccessFlags(n, 1);
    }
}

