/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class ClassFileObfuscator
implements ClassFileVisitor {
    private boolean useMixedCaseClassNames;
    private String defaultPackageName;
    private final Map packageMap = new HashMap();
    private final NameFactory defaultPackageClassNameFactory;
    private final Set namesToAvoid = new HashSet();

    public ClassFileObfuscator(ClassPool classPool, String string, boolean bl) {
        this.defaultPackageName = string;
        this.useMixedCaseClassNames = bl;
        this.defaultPackageClassNameFactory = new SimpleNameFactory(bl);
        classPool.classFilesAccept(new ClassFileVisitor(){

            public void visitProgramClassFile(ProgramClassFile programClassFile) {
                String string = ClassFileObfuscator.newClassName(programClassFile);
                if (string != null) {
                    ClassFileObfuscator.this.namesToAvoid.add(string);
                }
            }

            public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
            }
        });
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (ClassFileObfuscator.newClassName(programClassFile) == null) {
            String string;
            String string2;
            String string3 = programClassFile.getName();
            String string4 = string2 = ClassUtil.internalPackageName(string3);
            NameFactory nameFactory = (NameFactory)this.packageMap.get(string2);
            if (nameFactory == null) {
                if (this.defaultPackageName == null) {
                    nameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
                    this.packageMap.put(string2, nameFactory);
                } else {
                    nameFactory = this.defaultPackageClassNameFactory;
                    string4 = this.defaultPackageName;
                }
            }
            do {
                string = nameFactory.nextName();
                if (string4.length() <= 0) continue;
                string = string4 + '/' + string;
            } while (this.namesToAvoid.contains(string));
            ClassFileObfuscator.setNewClassName(programClassFile, string);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    static void setNewClassName(ClassFile classFile, String string) {
        classFile.setVisitorInfo(string);
    }

    static String newClassName(ClassFile classFile) {
        Object object = classFile.getVisitorInfo();
        return object instanceof String ? (String)object : null;
    }
}

