/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;

public class SimpleInstruction
extends Instruction {
    public int constant;

    public SimpleInstruction() {
    }

    public SimpleInstruction(byte by) {
        this(by, 0);
    }

    public SimpleInstruction(byte by, int n) {
        this.opcode = by;
        this.constant = n;
    }

    public SimpleInstruction copy(SimpleInstruction simpleInstruction) {
        this.opcode = simpleInstruction.opcode;
        this.constant = simpleInstruction.constant;
        return this;
    }

    public Instruction shrink() {
        int n = this.requiredConstantSize();
        if (this.opcode != -68 && n != this.constantSize()) {
            switch (n) {
                case 0: {
                    this.opcode = (byte)(3 + this.constant);
                    break;
                }
                case 1: {
                    this.opcode = (byte)16;
                    break;
                }
                case 2: {
                    this.opcode = (byte)17;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Simple instruction can't be widened (" + this.toString() + ")");
                }
            }
        }
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        switch (this.opcode) {
            case 2: {
                this.constant = -1;
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 15: {
                this.constant = 1;
                break;
            }
            case 5: 
            case 13: {
                this.constant = 2;
                break;
            }
            case 6: {
                this.constant = 3;
                break;
            }
            case 7: {
                this.constant = 4;
                break;
            }
            case 8: {
                this.constant = 5;
                break;
            }
            default: {
                this.constant = SimpleInstruction.readSignedValue(byArray, n, this.constantSize());
            }
        }
    }

    protected void writeInfo(byte[] byArray, int n) {
        int n2 = this.constantSize();
        if (this.requiredConstantSize() > n2) {
            throw new IllegalArgumentException("Instruction has invalid constant size (" + this.toString(n) + ")");
        }
        SimpleInstruction.writeValue(byArray, n, this.constant, n2);
    }

    public int length(int n) {
        return 1 + this.constantSize();
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitSimpleInstruction(classFile, methodInfo, codeAttrInfo, n, this);
    }

    public String toString(int n) {
        return "[" + n + "] " + this.getName() + " (constant=" + this.constant + ")";
    }

    public String toString() {
        return this.getName() + " (constant=" + this.constant + ")";
    }

    private int constantSize() {
        return this.opcode == 16 || this.opcode == -68 ? 1 : (this.opcode == 17 ? 2 : 0);
    }

    private int requiredConstantSize() {
        return this.constant >= -1 && this.constant <= 5 ? 0 : (this.constant << 24 >> 24 == this.constant ? 1 : (this.constant << 16 >> 16 == this.constant ? 2 : 4));
    }
}

