/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;

class StackSizeUpdater
implements AttrInfoVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private boolean[] evaluated;
    private boolean exitInstructionBlock;
    private int stackSize;
    private int maxStackSize;

    public StackSizeUpdater(int n) {
        this.evaluated = new boolean[n];
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        int n = codeAttrInfo.u4codeLength;
        if (this.evaluated.length < n) {
            this.evaluated = new boolean[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.evaluated[i] = false;
            }
        }
        this.stackSize = 0;
        this.maxStackSize = 0;
        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, 0);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        codeAttrInfo.u2maxStack = this.maxStackSize;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        byte by = simpleInstruction.opcode;
        this.exitInstructionBlock = by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -79 || by == -65;
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        this.exitInstructionBlock = false;
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        byte by = variableInstruction.opcode;
        this.exitInstructionBlock = by == -87;
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, n + branchInstruction.branchOffset);
        if (by == -88 || by == -55) {
            --this.stackSize;
            this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, n + branchInstruction.length(n));
        }
        this.exitInstructionBlock = by == -89 || by == -56 || by == -88 || by == -55;
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        this.evaluateInstructionBlocks(classFile, methodInfo, codeAttrInfo, n, tableSwitchInstruction.jumpOffsets, tableSwitchInstruction.jumpOffsetCount, tableSwitchInstruction.defaultOffset);
        this.exitInstructionBlock = true;
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.evaluateInstructionBlocks(classFile, methodInfo, codeAttrInfo, n, lookUpSwitchInstruction.jumpOffsets, lookUpSwitchInstruction.jumpOffsetCount, lookUpSwitchInstruction.defaultOffset);
        this.exitInstructionBlock = true;
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        this.stackSize = 1;
        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, exceptionInfo.u2handlerpc);
    }

    private void evaluateInstructionBlocks(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, int[] nArray, int n2, int n3) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray = nArray2;
        for (int i = 0; i < n2; ++i) {
            this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, n + nArray[i]);
        }
        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, n + n3);
    }

    private void evaluateInstructionBlock(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n) {
        int n2 = this.stackSize;
        if (this.maxStackSize < this.stackSize) {
            this.maxStackSize = this.stackSize;
        }
        while (!this.evaluated[n]) {
            this.evaluated[n] = true;
            Instruction instruction = InstructionFactory.create(codeAttrInfo.code, n);
            this.stackSize += instruction.stackPushCount(classFile) - instruction.stackPopCount(classFile);
            if (this.maxStackSize < this.stackSize) {
                this.maxStackSize = this.stackSize;
            }
            int n3 = n + instruction.length(n);
            instruction.accept(classFile, methodInfo, codeAttrInfo, n, this);
            if (this.exitInstructionBlock) break;
            n = n3;
        }
        this.stackSize = n2;
    }
}

