/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;

public class InstructionWriter
implements InstructionVisitor,
AttrInfoVisitor {
    private int codeLength;
    private CodeAttrInfoEditor codeAttrInfoEditor;

    public void reset(int n) {
        this.codeLength = n;
        if (this.codeAttrInfoEditor != null) {
            this.codeAttrInfoEditor.reset(n);
        }
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        simpleInstruction.write(codeAttrInfo, n);
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        try {
            cpInstruction.write(codeAttrInfo, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Instruction instruction = new CpInstruction().copy(cpInstruction).shrink();
            this.replaceInstruction(n, instruction);
            cpInstruction.cpIndex = 0;
            cpInstruction.constant = 0;
            cpInstruction.write(codeAttrInfo, n);
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        try {
            variableInstruction.write(codeAttrInfo, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            VariableInstruction variableInstruction2 = new VariableInstruction(variableInstruction.opcode, variableInstruction.variableIndex, variableInstruction.constant);
            this.replaceInstruction(n, variableInstruction2);
            variableInstruction.variableIndex = 0;
            variableInstruction.constant = 0;
            variableInstruction.write(codeAttrInfo, n);
        }
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        try {
            branchInstruction.write(codeAttrInfo, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Instruction instruction = new BranchInstruction(-56, branchInstruction.branchOffset);
            switch (branchInstruction.opcode) {
                default: {
                    instruction = new BranchInstruction().copy(branchInstruction).shrink();
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: {
                    BranchInstruction branchInstruction2 = new BranchInstruction((byte)((branchInstruction.opcode + 1 ^ 1) - 1), 8);
                    this.insertBeforeInstruction(n, branchInstruction2);
                    break;
                }
                case -58: 
                case -57: {
                    BranchInstruction branchInstruction3 = new BranchInstruction((byte)(branchInstruction.opcode ^ 1), 8);
                    this.insertBeforeInstruction(n, branchInstruction3);
                }
            }
            this.replaceInstruction(n, instruction);
            branchInstruction.branchOffset = 0;
            branchInstruction.write(codeAttrInfo, n);
        }
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction.write(codeAttrInfo, n);
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction.write(codeAttrInfo, n);
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        if (this.codeAttrInfoEditor != null) {
            this.codeAttrInfoEditor.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
            this.codeAttrInfoEditor = null;
        }
    }

    private void insertBeforeInstruction(int n, Instruction instruction) {
        this.ensureCodeAttrInfoEditor();
        this.codeAttrInfoEditor.insertBeforeInstruction(n, instruction);
    }

    private void replaceInstruction(int n, Instruction instruction) {
        this.ensureCodeAttrInfoEditor();
        this.codeAttrInfoEditor.replaceInstruction(n, instruction);
    }

    private void insertAfterInstruction(int n, Instruction instruction) {
        this.ensureCodeAttrInfoEditor();
        this.codeAttrInfoEditor.insertAfterInstruction(n, instruction);
    }

    private void ensureCodeAttrInfoEditor() {
        if (this.codeAttrInfoEditor == null) {
            this.codeAttrInfoEditor = new CodeAttrInfoEditor(this.codeLength);
        }
    }
}

