/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import proguard.ClassMemberSpecification;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ConfigurationWriter {
    private static final String[] KEEP_NAMES_OPTIONS = new String[]{"-keepnames", "-keepclassmembernames", "-keepclasseswithmembernames"};
    private static final String[] KEEP_OPTIONS = new String[]{"-keep", "-keepclassmembers", "-keepclasseswithmembers"};
    private static final String[] WHY_ARE_YOU_KEEPING_OPTIONS = new String[]{"-whyareyoukeeping", "-whyareyoukeeping", "-whyareyoukeeping"};
    private static final String[] ASSUME_NO_SIDE_EFFECT_OPTIONS = new String[]{"-assumenosideeffects", "-assumenosideeffects", "-assumenosideeffects"};
    private PrintWriter writer;
    private File baseDir;

    public ConfigurationWriter(File file) throws IOException {
        this(new PrintWriter(new FileWriter(file)));
        this.baseDir = file.getParentFile();
    }

    public ConfigurationWriter(OutputStream outputStream) throws IOException {
        this(new PrintWriter(outputStream));
    }

    public ConfigurationWriter(PrintWriter printWriter) throws IOException {
        this.writer = printWriter;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(Configuration configuration) throws IOException {
        this.writeJarOptions("-injars", "-outjars", configuration.programJars);
        this.writer.println();
        this.writeJarOptions("-libraryjars", "-libraryjars", configuration.libraryJars);
        this.writer.println();
        this.writeOption("-dontskipnonpubliclibraryclasses", !configuration.skipNonPublicLibraryClasses);
        this.writeOption("-dontskipnonpubliclibraryclassmembers", !configuration.skipNonPublicLibraryClassMembers);
        this.writeOption("-dontshrink", !configuration.shrink);
        this.writeOption("-printusage", configuration.printUsage);
        this.writeOption("-dontoptimize", !configuration.optimize);
        this.writeOption("-allowaccessmodification", configuration.allowAccessModification);
        this.writeOption("-dontobfuscate", !configuration.obfuscate);
        this.writeOption("-printmapping", configuration.printMapping);
        this.writeOption("-applymapping", configuration.applyMapping);
        this.writeOption("-obfuscationdictionary", configuration.obfuscationDictionary);
        this.writeOption("-overloadaggressively", configuration.overloadAggressively);
        this.writeOption("-useuniqueclassmembernames", configuration.useUniqueClassMemberNames);
        this.writeOption("-defaultpackage", configuration.defaultPackage);
        this.writeOption("-dontusemixedcaseclassnames", !configuration.useMixedCaseClassNames);
        this.writeOption("-keepattributes", ListUtil.commaSeparatedString(configuration.keepAttributes));
        this.writeOption("-renamesourcefileattribute", configuration.newSourceFileAttribute);
        this.writeOption("-verbose", configuration.verbose);
        this.writeOption("-dontnote", !configuration.note);
        this.writeOption("-dontwarn", !configuration.warn);
        this.writeOption("-ignorewarnings", configuration.ignoreWarnings);
        this.writeOption("-printseeds", configuration.printSeeds);
        this.writer.println();
        this.writeOptions(WHY_ARE_YOU_KEEPING_OPTIONS, configuration.whyAreYouKeeping);
        this.writeOptions(KEEP_OPTIONS, configuration.keep);
        this.writeOptions(KEEP_NAMES_OPTIONS, configuration.keepNames);
        this.writeOptions(ASSUME_NO_SIDE_EFFECT_OPTIONS, configuration.assumeNoSideEffects);
    }

    private void writeJarOptions(String string, String string2, ClassPath classPath) {
        if (classPath != null) {
            for (int i = 0; i < classPath.size(); ++i) {
                ClassPathEntry classPathEntry = classPath.get(i);
                String string3 = classPathEntry.isOutput() ? string2 : string;
                this.writer.print(string3 + " " + this.relativeFileName(classPathEntry.getFile()));
                boolean bl = false;
                bl = this.writeFilter(bl, classPathEntry.getZipFilter());
                bl = this.writeFilter(bl, classPathEntry.getEarFilter());
                bl = this.writeFilter(bl, classPathEntry.getWarFilter());
                bl = this.writeFilter(bl, classPathEntry.getJarFilter());
                bl = this.writeFilter(bl, classPathEntry.getFilter());
                if (bl) {
                    this.writer.print(")");
                }
                this.writer.println();
            }
        }
    }

    private boolean writeFilter(boolean bl, String string) {
        if (bl) {
            this.writer.print(";");
        }
        if (string != null) {
            if (!bl) {
                this.writer.print("(");
            }
            this.writer.print(this.quotedString(string));
            bl = true;
        }
        return bl;
    }

    private void writeOption(String string, boolean bl) {
        if (bl) {
            this.writer.println(string);
        }
    }

    private void writeOption(String string, String string2) {
        if (string2 != null) {
            this.writer.println(string + " " + this.quotedString(string2));
        }
    }

    private void writeOption(String string, File file) {
        if (file != null) {
            if (file.getPath().length() > 0) {
                this.writer.println(string + " " + this.relativeFileName(file));
            } else {
                this.writer.println(string);
            }
        }
    }

    private void writeOptions(String[] stringArray, List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.writeOption(stringArray, (ClassSpecification)list.get(i));
            }
        }
    }

    private void writeOption(String[] stringArray, ClassSpecification classSpecification) {
        this.writer.println();
        this.writeComments(classSpecification.comments);
        this.writer.print(stringArray[classSpecification.markConditionally ? 2 : (classSpecification.markClassFiles ? 0 : 1)]);
        this.writer.print(" ");
        this.writer.print(ClassUtil.externalClassAccessFlags(classSpecification.requiredUnsetAccessFlags, "!"));
        this.writer.print(ClassUtil.externalClassAccessFlags(classSpecification.requiredSetAccessFlags));
        if (((classSpecification.requiredSetAccessFlags | classSpecification.requiredUnsetAccessFlags) & 0x200) == 0) {
            this.writer.print("class");
        }
        this.writer.print(" ");
        this.writer.print(classSpecification.className != null ? ClassUtil.externalClassName(classSpecification.className) : "*");
        if (classSpecification.extendsClassName != null) {
            this.writer.print(" extends " + ClassUtil.externalClassName(classSpecification.extendsClassName));
        }
        if (classSpecification.fieldSpecifications != null || classSpecification.methodSpecifications != null) {
            this.writer.println(" {");
            this.writeFieldSpecification(classSpecification.fieldSpecifications);
            this.writeMethodSpecification(classSpecification.methodSpecifications);
            this.writer.println("}");
        } else {
            this.writer.println();
        }
    }

    private void writeComments(String string) {
        if (string != null) {
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(10, n);
                if (n2 < 0) {
                    n2 = string.length();
                }
                this.writer.print('#');
                this.writer.println(string.substring(n, n2));
                n = n2 + 1;
            }
        }
    }

    private void writeFieldSpecification(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ClassMemberSpecification classMemberSpecification = (ClassMemberSpecification)list.get(i);
                this.writer.print("    ");
                this.writer.print(ClassUtil.externalFieldAccessFlags(classMemberSpecification.requiredUnsetAccessFlags, "!"));
                this.writer.print(ClassUtil.externalFieldAccessFlags(classMemberSpecification.requiredSetAccessFlags));
                String string = classMemberSpecification.name;
                String string2 = classMemberSpecification.descriptor;
                if (string == null) {
                    string = "*";
                }
                this.writer.print(string2 != null ? ClassUtil.externalFullFieldDescription(0, string, string2) : "<fields>");
                this.writer.println(";");
            }
        }
    }

    private void writeMethodSpecification(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ClassMemberSpecification classMemberSpecification = (ClassMemberSpecification)list.get(i);
                this.writer.print("    ");
                this.writer.print(ClassUtil.externalMethodAccessFlags(classMemberSpecification.requiredUnsetAccessFlags, "!"));
                this.writer.print(ClassUtil.externalMethodAccessFlags(classMemberSpecification.requiredSetAccessFlags));
                String string = classMemberSpecification.name;
                String string2 = classMemberSpecification.descriptor;
                if (string == null) {
                    string = "*";
                }
                this.writer.print(string2 != null ? ClassUtil.externalFullMethodDescription("<init>", 0, string, string2) : "<methods>");
                this.writer.println(";");
            }
        }
    }

    private String relativeFileName(File file) {
        String string;
        String string2 = file.getAbsolutePath();
        if (this.baseDir != null && string2.startsWith(string = this.baseDir.getAbsolutePath() + File.separator)) {
            string2 = string2.substring(string.length());
        }
        return this.quotedString(string2);
    }

    private String quotedString(String string) {
        return string.length() == 0 || string.indexOf(32) >= 0 || string.indexOf(64) >= 0 || string.indexOf(123) >= 0 || string.indexOf(125) >= 0 || string.indexOf(40) >= 0 || string.indexOf(41) >= 0 || string.indexOf(58) >= 0 || string.indexOf(59) >= 0 ? "'" + string + "'" : string;
    }

    public static void main(String[] stringArray) {
        try {
            ConfigurationWriter configurationWriter = new ConfigurationWriter(new File(stringArray[0]));
            configurationWriter.write(new Configuration());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

