/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;

public class BeanTypeInfo {
    private Map mappedName2typeName = new HashMap();
    private Map mappedName2pdName = new HashMap();
    private Map mappedName2type = new HashMap();
    private Class beanClass;
    private List attributes = new ArrayList();
    private List elements = new ArrayList();
    private PropertyDescriptor[] descriptors;
    private TypeMapping typeMapping;
    private boolean initialized;
    private String defaultNamespace;
    private int minOccurs = 0;
    private boolean nillable = true;
    private boolean isExtension = false;
    private boolean extensibleElements = true;
    private boolean extensibleAttributes = true;

    public BeanTypeInfo(Class typeClass, String defaultNamespace) {
        this.beanClass = typeClass;
        this.defaultNamespace = defaultNamespace;
        this.initializeProperties();
    }

    public BeanTypeInfo(Class typeClass, String defaultNamespace, boolean initialize) {
        this.beanClass = typeClass;
        this.defaultNamespace = defaultNamespace;
        this.initializeProperties();
        this.setInitialized(!initialize);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void initialize() {
        try {
            for (int i = 0; i < this.descriptors.length; ++i) {
                if (!this.isMapped(this.descriptors[i])) continue;
                this.mapProperty(this.descriptors[i]);
            }
        }
        catch (Exception e) {
            if (e instanceof XFireRuntimeException) {
                throw (XFireRuntimeException)e;
            }
            throw new XFireRuntimeException("Couldn't create TypeInfo.", (Throwable)e);
        }
        this.setInitialized(true);
    }

    public boolean isMapped(PropertyDescriptor pd) {
        return pd.getReadMethod() != null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected void mapProperty(PropertyDescriptor pd) {
        String name = pd.getName();
        if (this.isAttribute(pd)) {
            this.mapAttribute(name, this.createMappedName(pd));
        } else if (this.isElement(pd)) {
            this.mapElement(name, this.createMappedName(pd));
        }
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!this.descriptors[i].getName().equals(name)) continue;
            return this.descriptors[i];
        }
        return null;
    }

    public Type getType(QName name) {
        QName typeName;
        Type type = (Type)this.mappedName2type.get(name);
        if (type == null && (typeName = this.getMappedTypeName(name)) != null && (type = this.getTypeMapping().getType(typeName)) != null) {
            this.mapType(name, type);
        }
        if (type == null) {
            PropertyDescriptor desc;
            try {
                desc = this.getPropertyDescriptorFromMappedName(name);
            }
            catch (Exception e) {
                if (e instanceof XFireRuntimeException) {
                    throw (XFireRuntimeException)((Object)e);
                }
                throw new XFireRuntimeException("Couldn't get properties.", (Throwable)e);
            }
            if (desc == null) {
                return null;
            }
            try {
                TypeMapping tm = this.getTypeMapping();
                TypeCreator tc = tm.getTypeCreator();
                type = tc.createType(desc);
            }
            catch (XFireRuntimeException e) {
                e.prepend("Couldn't create type for property " + desc.getName() + " on " + this.getTypeClass());
                throw e;
            }
            if (this.registerType(desc)) {
                this.getTypeMapping().register(type);
            }
            this.mapType(name, type);
        }
        if (type == null) {
            throw new XFireRuntimeException("Couldn't find type for property " + name);
        }
        return type;
    }

    protected boolean registerType(PropertyDescriptor desc) {
        return true;
    }

    public void mapType(QName name, Type type) {
        this.mappedName2type.put(name, type);
    }

    private QName getMappedTypeName(QName name) {
        return (QName)this.mappedName2typeName.get(name);
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    protected QName createMappedName(PropertyDescriptor desc) {
        return new QName(this.getDefaultNamespace(), desc.getName());
    }

    public void mapAttribute(String property, QName mappedName) {
        this.mappedName2pdName.put(mappedName, property);
        this.attributes.add(mappedName);
    }

    public void mapElement(String property, QName mappedName) {
        this.mappedName2pdName.put(mappedName, property);
        this.elements.add(mappedName);
    }

    public void mapTypeName(QName mappedName, QName type) {
        this.mappedName2typeName.put(mappedName, type);
    }

    private void initializeProperties() {
        BeanInfo beanInfo = null;
        try {
            if (this.beanClass.isInterface() || this.beanClass.isPrimitive()) {
                this.descriptors = this.getInterfacePropertyDescriptors(this.beanClass);
            } else if (this.beanClass != Object.class && this.beanClass != Throwable.class && this.beanClass != Throwable.class) {
                beanInfo = Throwable.class.isAssignableFrom(this.beanClass) ? Introspector.getBeanInfo(this.beanClass, Throwable.class) : (RuntimeException.class.isAssignableFrom(this.beanClass) ? Introspector.getBeanInfo(this.beanClass, RuntimeException.class) : (Throwable.class.isAssignableFrom(this.beanClass) ? Introspector.getBeanInfo(this.beanClass, Throwable.class) : Introspector.getBeanInfo(this.beanClass, Object.class)));
            }
        }
        catch (IntrospectionException e) {
            throw new XFireRuntimeException("Couldn't introspect interface.", (Throwable)e);
        }
        if (beanInfo != null) {
            this.descriptors = beanInfo.getPropertyDescriptors();
        }
        if (this.descriptors == null) {
            this.descriptors = new PropertyDescriptor[0];
        }
    }

    public PropertyDescriptor[] getInterfacePropertyDescriptors(Class clazz) {
        ArrayList pds = new ArrayList();
        this.getInterfacePropertyDescriptors(clazz, pds, new HashSet());
        return pds.toArray(new PropertyDescriptor[pds.size()]);
    }

    public void getInterfacePropertyDescriptors(Class clazz, List pds, Set classes) {
        if (classes.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        try {
            Class<?>[] interfaces = clazz.getInterfaces();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (int j = 0; j < info.getPropertyDescriptors().length; ++j) {
                pds.add(info.getPropertyDescriptors()[j]);
            }
            for (int i = 0; i < interfaces.length; ++i) {
                BeanInfo superInfo = Introspector.getBeanInfo(interfaces[i]);
                for (int j = 0; j < superInfo.getPropertyDescriptors().length; ++j) {
                    pds.add(superInfo.getPropertyDescriptors()[j]);
                }
                this.getInterfacePropertyDescriptors(interfaces[i], pds, classes);
            }
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
    }

    public PropertyDescriptor getPropertyDescriptorFromMappedName(QName name) {
        return this.getPropertyDescriptor(this.getPropertyNameFromMappedName(name));
    }

    protected boolean isAttribute(PropertyDescriptor desc) {
        return false;
    }

    protected boolean isElement(PropertyDescriptor desc) {
        return true;
    }

    protected boolean isSerializable(PropertyDescriptor desc) {
        return true;
    }

    protected Class getTypeClass() {
        return this.beanClass;
    }

    public boolean isNillable(QName name) {
        Type type = this.getType(name);
        if (!type.isNillable()) {
            return false;
        }
        return this.nillable;
    }

    public int getMinOccurs(QName name) {
        return this.minOccurs;
    }

    public void setDefaultMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setDefaultNillable(boolean nillable) {
        this.nillable = nillable;
    }

    private String getPropertyNameFromMappedName(QName name) {
        return (String)this.mappedName2pdName.get(name);
    }

    public Iterator getAttributes() {
        return this.attributes.iterator();
    }

    public Iterator getElements() {
        return this.elements.iterator();
    }

    public boolean isExtensibleElements() {
        return this.extensibleElements;
    }

    public void setExtensibleElements(boolean futureProof) {
        this.extensibleElements = futureProof;
    }

    public boolean isExtensibleAttributes() {
        return this.extensibleAttributes;
    }

    public void setExtensibleAttributes(boolean extensibleAttributes) {
        this.extensibleAttributes = extensibleAttributes;
    }

    public void setExtension(boolean extension) {
        this.isExtension = extension;
    }

    public boolean isExtension() {
        return this.isExtension;
    }
}

