/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc10;

import java.util.Vector;
import jmunit.framework.cldc10.Test;
import jmunit.framework.cldc10.TestCase;

public class TestSuite
extends Test {
    private Node pointer;
    private Node first;

    public TestSuite() {
        super(0, "Default test suite");
        String prop = this.getAppProperty("JMUnitTestClasses");
        if (prop != null && !prop.equals("")) {
            String[] classes = this.parseTestClassProperty(prop);
            for (int i = 0; i < classes.length; ++i) {
                try {
                    this.add((TestCase)((Object)Class.forName(classes[i]).newInstance()));
                    System.out.println("clazz: " + classes[i]);
                    continue;
                }
                catch (Exception e) {
                    this.add(new EmptyTestCase(e));
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public TestSuite(String name) {
        super(0, name);
    }

    private String[] parseTestClassProperty(String property) {
        String delimiter = " ";
        Vector<String> classes = new Vector<String>();
        while (property.length() > 0) {
            int i = property.indexOf(" ");
            if (i > 0) {
                classes.addElement(property.substring(0, i));
                property = property.substring(property.indexOf(" ") + 1);
                continue;
            }
            classes.addElement(property);
            property = "";
        }
        String[] result = new String[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            result[i] = (String)classes.elementAt(i);
            System.out.println("result " + i + ": " + result[i]);
        }
        return result;
    }

    public final void add(TestCase testCase) {
        testCase.setScreen(this.screen);
        if (this.first == null) {
            this.first = new Node(testCase);
        } else {
            this.goFirst();
            while (this.hasNext()) {
                this.next();
            }
            this.pointer.setNext(new Node(testCase));
        }
    }

    public final void test() {
        this.goFirst();
        while (this.hasNext()) {
            this.next().test();
        }
    }

    private final void goFirst() {
        this.pointer = null;
    }

    private final Node next() {
        if (this.pointer == null) {
            this.pointer = this.first;
            return this.first;
        }
        this.pointer = this.pointer.getNext();
        return this.pointer;
    }

    private final boolean hasNext() {
        return this.pointer == null ? true : this.pointer.getNext() != null;
    }

    private class EmptyTestCase
    extends TestCase {
        private Exception e;

        public EmptyTestCase(Exception e) {
            super(1, "Empty Test");
            this.e = e;
        }

        public void test(int testNumber) throws Throwable {
            throw this.e;
        }
    }

    private class Node {
        private TestCase testCase;
        private Node next;

        public Node(TestCase testCase) {
            this.testCase = testCase;
        }

        public void setNext(Node node) {
            this.next = node;
        }

        public Node getNext() {
            return this.next;
        }

        public void test() {
            this.testCase.test();
        }
    }
}

