/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.BlockWithImpliedExitPath;
import antlr.CharFormatter;
import antlr.CodeGenerator;
import antlr.FileLineFormatter;
import antlr.Grammar;
import antlr.JavaCharFormatter;
import antlr.Lookahead;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.ToolErrorHandler;

class DefaultToolErrorHandler
implements ToolErrorHandler {
    CharFormatter javaCharFormatter = new JavaCharFormatter();

    private void dumpSets(Grammar grammar, boolean bl, int n, Lookahead[] lookaheadArray, String string) {
        int n2 = 1;
        while (n2 <= n) {
            System.out.print(String.valueOf(string) + "\tk==" + n2 + ":");
            if (bl) {
                String string2 = lookaheadArray[n2].fset.toStringWithRanges(",", this.javaCharFormatter);
                if (lookaheadArray[n2].containsEpsilon()) {
                    System.out.print("<end-of-token>");
                    if (string2.length() > 0) {
                        System.out.print(",");
                    }
                }
                System.out.println(string2);
            } else {
                System.out.println(lookaheadArray[n2].fset.toString(",", grammar.tokenManager.getVocabulary()));
            }
            ++n2;
        }
    }

    public void warnAltAmbiguity(Grammar grammar, AlternativeBlock alternativeBlock, boolean bl, int n, Lookahead[] lookaheadArray, int n2, int n3) {
        String string = FileLineFormatter.getFormatter().getFormatString(grammar.getFilename(), alternativeBlock.getLine());
        if (alternativeBlock instanceof RuleBlock && ((RuleBlock)alternativeBlock).isLexerAutoGenRule()) {
            System.out.print("warning: lexical nondeterminism between rules ");
            Alternative alternative = alternativeBlock.getAlternativeAt(n2);
            Alternative alternative2 = alternativeBlock.getAlternativeAt(n3);
            RuleRefElement ruleRefElement = (RuleRefElement)alternative.head;
            RuleRefElement ruleRefElement2 = (RuleRefElement)alternative2.head;
            String string2 = CodeGenerator.reverseLexerRuleName(ruleRefElement.targetRule);
            String string3 = CodeGenerator.reverseLexerRuleName(ruleRefElement2.targetRule);
            System.out.println(String.valueOf(string2) + " and " + string3 + " upon");
            this.dumpSets(grammar, bl, n, lookaheadArray, string);
            return;
        }
        System.out.println(String.valueOf(string) + "warning: " + (bl ? "lexical " : "") + "nondeterminism upon");
        this.dumpSets(grammar, bl, n, lookaheadArray, string);
        System.out.println(String.valueOf(string) + "\tbetween alts " + (n2 + 1) + " and " + (n3 + 1) + " of block");
    }

    public void warnAltExitAmbiguity(Grammar grammar, BlockWithImpliedExitPath blockWithImpliedExitPath, boolean bl, int n, Lookahead[] lookaheadArray, int n2) {
        String string = FileLineFormatter.getFormatter().getFormatString(grammar.getFilename(), blockWithImpliedExitPath.getLine());
        System.out.println(String.valueOf(string) + "warning: " + (bl ? "lexical " : "") + "nondeterminism upon");
        this.dumpSets(grammar, bl, n, lookaheadArray, string);
        System.out.println(String.valueOf(string) + "\tbetween alt " + (n2 + 1) + " and exit branch of block");
    }

    DefaultToolErrorHandler() {
    }
}

