/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGo3DRect
extends JGoRectangle {
    public static final int StateUp = 0;
    public static final int StateDown = 1;
    public static final int StateToggled = 2;
    public static final int ChangedState = 403;
    private int myState = 0;

    public JGo3DRect() {
        this.init();
    }

    public JGo3DRect(Rectangle rect) {
        super(rect);
        this.init();
    }

    public JGo3DRect(Point location, Dimension size) {
        super(location, size);
        this.init();
    }

    private final void init() {
        this.setBrush(JGoBrush.lightGray);
        this.setPen(JGoPen.lightGray);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGo3DRect newobj = (JGo3DRect)super.copyObject(env);
        if (newobj != null) {
            newobj.myState = this.myState;
        }
        return newobj;
    }

    public void setState(int state) {
        int oldState = this.myState;
        if (oldState != state) {
            this.myState = state;
            this.update(403, oldState, null);
        }
    }

    public int getState() {
        return this.myState;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 403: {
                e.setNewValueInt(this.getState());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 403: {
                this.setState(e.getValueInt(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoRect = svgDoc.createJGoClassElement("com.nwoods.jgo.JGo3DRect", jGoElementGroup);
            jGoRect.setAttribute("current_state", Integer.toString(this.myState));
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String obj_flags = jGoChildElement.getAttribute("current_state");
            this.myState = Integer.parseInt(obj_flags);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void paint(Graphics2D g, JGoView view) {
        boolean toggleState = true;
        Rectangle rect = this.getBoundingRect();
        switch (this.myState) {
            case 0: {
                toggleState = true;
                break;
            }
            case 1: 
            case 2: {
                toggleState = false;
            }
        }
        this.draw3DRect(g, rect.x, rect.y, rect.width, rect.height, toggleState);
    }
}

