/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.tasks.DaemonTaskServer;
import com.sun.jdmk.tasks.TaskServer;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpEventReportDispatcher;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.agent.SnmpTrap;
import com.sun.management.snmp.agent.TrapListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;

public class SnmpTrapReceiver {
    private static final String dbgTag = "SnmpTrapReceiver";
    private static int count = 0;
    private TrapListener listener = null;
    private SnmpEventReportDispatcher dispatcher = null;
    private SnmpEngine eng = null;
    private boolean started = false;
    private int port = 0;
    private Thread dispatchThread = null;
    private boolean receiveAsGeneric = false;
    private InetAddress address = null;
    private final TaskServer packetTaskServer;
    private final TaskServer callbackTaskServer;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTrapReceiver");

    public SnmpTrapReceiver(SnmpEngine snmpEngine, int n, InetAddress inetAddress) throws IllegalArgumentException {
        this.eng = snmpEngine;
        this.listener = new TrapListener(this);
        this.port = n;
        this.address = inetAddress;
        this.packetTaskServer = this.createPacketTaskServer();
        this.callbackTaskServer = this.createCallbackTaskServer();
    }

    public SnmpTrapReceiver(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, int n, InetAddress inetAddress) throws IllegalArgumentException {
        if (snmpEngineParameters == null) {
            snmpEngineParameters = new SnmpEngineParameters();
        }
        if (snmpEngineFactory == null) {
            snmpEngineFactory = new JdmkEngineFactory();
        }
        this.eng = snmpEngineFactory.createEngine(snmpEngineParameters);
        this.listener = new TrapListener(this);
        this.port = n;
        this.address = inetAddress;
        this.packetTaskServer = this.createPacketTaskServer();
        this.callbackTaskServer = this.createCallbackTaskServer();
    }

    public void receiveAsGeneric(boolean bl) {
        this.receiveAsGeneric = bl;
    }

    public synchronized void start() throws SocketException {
        if (this.started) {
            return;
        }
        this.dispatcher = new SnmpEventReportDispatcher(this.eng, this.port, this.address, this.packetTaskServer, this.callbackTaskServer);
        this.dispatcher.addTrapListener(this.listener);
        this.started = true;
        this.dispatchThread = new Thread(this.dispatcher);
        this.dispatchThread.start();
    }

    public synchronized void stop() throws SocketException {
        if (!this.started) {
            return;
        }
        try {
            this.dispatcher.close();
        }
        catch (IOException iOException) {
            logger.finest("stop", "Exception caught while closing dispatcher: " + iOException);
        }
        this.started = false;
        this.dispatchThread.interrupt();
    }

    synchronized void receivedV1(SnmpPduTrap snmpPduTrap) {
        if (this.receiveAsGeneric) {
            SnmpTrap snmpTrap = new SnmpTrap(snmpPduTrap);
            this.receivedTrap(snmpTrap);
        } else {
            this.receivedV1Trap(snmpPduTrap);
        }
    }

    synchronized void receivedV2(SnmpPduRequest snmpPduRequest) {
        if (this.receiveAsGeneric) {
            SnmpTrap snmpTrap = new SnmpTrap(snmpPduRequest);
            this.receivedTrap(snmpTrap);
        } else {
            this.receivedV2Trap(snmpPduRequest);
        }
    }

    synchronized void receivedV3(SnmpScopedPduRequest snmpScopedPduRequest) {
        if (this.receiveAsGeneric) {
            SnmpTrap snmpTrap = new SnmpTrap(snmpScopedPduRequest);
            this.receivedTrap(snmpTrap);
        } else {
            this.receivedV3Trap(snmpScopedPduRequest);
        }
    }

    protected TaskServer createPacketTaskServer() {
        DaemonTaskServer daemonTaskServer = new DaemonTaskServer();
        daemonTaskServer.start();
        return daemonTaskServer;
    }

    protected TaskServer createCallbackTaskServer() {
        return null;
    }

    protected Thread createDispatcherThread(Runnable runnable) {
        return new Thread(runnable, "SnmpTrapReceiver[" + count++ + "]");
    }

    protected void receivedTrap(SnmpTrap snmpTrap) {
    }

    protected void receivedV1Trap(SnmpPduTrap snmpPduTrap) {
    }

    protected void receivedV2Trap(SnmpPduRequest snmpPduRequest) {
    }

    protected void receivedV3Trap(SnmpScopedPduRequest snmpScopedPduRequest) {
    }
}

