/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpTarget;
import com.sun.management.snmp.agent.SnmpTrap;
import com.sun.management.snmp.agent.SnmpTrapForwarderMBean;
import com.sun.management.snmp.agent.SnmpTrapReceiver;
import com.sun.management.snmp.agent.SnmpV1V2Target;
import com.sun.management.snmp.agent.SnmpV3Target;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpTrapForwarder
extends SnmpTrapReceiver
implements SnmpTrapForwarderMBean {
    private SnmpV3AdaptorServer server = null;
    private boolean forwardV1 = false;
    private boolean forwardV2 = false;
    private boolean forwardV3 = false;
    private Vector v1targets = null;
    private Vector v2targets = null;
    private Vector v3targets = null;
    private boolean originator = true;
    private InetAddress addr = null;
    private String communityString = null;
    private String principal = null;
    private int msgFlags = 0;
    private String contextName = null;
    private boolean usm = false;
    private boolean useAcl = true;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpTrapForwarder");
    String dbgTag = "SnmpTrapForwarder";

    public SnmpTrapForwarder(SnmpV3AdaptorServer snmpV3AdaptorServer, int n) {
        super(snmpV3AdaptorServer.getEngine(), n, null);
        this.server = snmpV3AdaptorServer;
        this.receiveAsGeneric(true);
    }

    public SnmpTrapForwarder(SnmpV3AdaptorServer snmpV3AdaptorServer, int n, InetAddress inetAddress) {
        super(snmpV3AdaptorServer.getEngine(), n, inetAddress);
        this.server = snmpV3AdaptorServer;
        this.receiveAsGeneric(true);
    }

    public void setCommunityString(String string) {
        this.communityString = string;
    }

    public void setV3Parameters(String string, String string2, int n) {
        this.usm = true;
        this.principal = string;
        this.contextName = string2;
        this.msgFlags = n;
    }

    public void setInetAddressAclUsed(boolean bl) {
        this.useAcl = bl;
    }

    public boolean isInetAddressAclUsed() {
        return this.useAcl;
    }

    public synchronized boolean isV1Activated() {
        return this.forwardV1;
    }

    public synchronized boolean isV2Activated() {
        return this.forwardV2;
    }

    public synchronized boolean isV3Activated() {
        return this.forwardV3;
    }

    public synchronized void snmpV1forwarding(boolean bl) {
        this.forwardV1 = bl;
    }

    public synchronized void snmpV2forwarding(boolean bl) {
        this.forwardV2 = bl;
    }

    public synchronized void snmpV3forwarding(boolean bl) {
        this.forwardV3 = bl;
    }

    public boolean removeV1Target(String string) {
        return this.removeV1Target(string, -1);
    }

    public boolean removeV2Target(String string) {
        return this.removeV2Target(string, -1);
    }

    public boolean removeV3Target(String string) {
        return this.removeV3Target(string, -1);
    }

    public boolean removeV1Target(String string, int n) {
        SnmpTarget snmpTarget = new SnmpTarget(string, n);
        if (this.v1targets != null) {
            return this.v1targets.remove(snmpTarget);
        }
        return false;
    }

    public boolean removeV2Target(String string, int n) {
        SnmpTarget snmpTarget = new SnmpTarget(string, n);
        if (this.v2targets != null) {
            return this.v2targets.remove(snmpTarget);
        }
        return false;
    }

    public boolean removeV3Target(String string, int n) {
        SnmpTarget snmpTarget = new SnmpTarget(string, n);
        if (this.v3targets != null) {
            return this.v3targets.remove(snmpTarget);
        }
        return false;
    }

    public synchronized void addV1Target(String string, int n, String string2) {
        if (string == null) {
            return;
        }
        if (this.v1targets == null) {
            this.v1targets = new Vector();
        }
        this.snmpV1forwarding(true);
        SnmpV1V2Target snmpV1V2Target = new SnmpV1V2Target(string, n, string2);
        this.v1targets.add(snmpV1V2Target);
    }

    public synchronized void addV2Target(String string, int n, String string2) {
        if (string == null) {
            return;
        }
        if (this.v2targets == null) {
            this.v2targets = new Vector();
        }
        this.snmpV2forwarding(true);
        SnmpV1V2Target snmpV1V2Target = new SnmpV1V2Target(string, n, string2);
        this.v2targets.add(snmpV1V2Target);
    }

    public synchronized void addV3Target(String string, int n, String string2, String string3, int n2) {
        if (string == null) {
            return;
        }
        if (this.v3targets == null) {
            this.v3targets = new Vector();
        }
        this.snmpV3forwarding(true);
        SnmpV3Target snmpV3Target = new SnmpV3Target(string, n, string2, string3, n2);
        this.v3targets.add(snmpV3Target);
    }

    public synchronized void addV1Target(String string, String string2) {
        this.addV1Target(string, -1, string2);
    }

    public synchronized void addV2Target(String string, String string2) {
        this.addV2Target(string, -1, string2);
    }

    public void forwardAsNotificationOriginator() {
        this.originator = true;
    }

    public void forwardAsProxy() {
        this.originator = false;
    }

    public boolean isOriginatorWay() {
        return this.originator;
    }

    public boolean isProxyWay() {
        return !this.isOriginatorWay();
    }

    public void setSourceIpAddress(InetAddress inetAddress) {
        this.addr = inetAddress;
    }

    public synchronized void addV3Target(String string, String string2, String string3, int n) {
        this.addV3Target(string, -1, string2, string3, n);
    }

    protected synchronized void receivedTrap(SnmpTrap snmpTrap) {
        block36: {
            try {
                SnmpTarget snmpTarget;
                Enumeration enumeration;
                if (this.isOriginatorWay()) {
                    snmpTrap.setPduSourceAddress(this.addr);
                    snmpTrap.sendAsNotificationOriginator();
                } else {
                    snmpTrap.sendAsProxy();
                }
                if (this.isV1Activated()) {
                    block35: {
                        if (this.isInetAddressAclUsed()) {
                            if (logger.finestOn()) {
                                logger.finest("receivedTrap", " Sending SNMP V1 trap using InetAddressAcl conf");
                            }
                            try {
                                snmpTrap.sendV1(this.server);
                            }
                            catch (Exception exception) {
                                if (!logger.finestOn()) break block35;
                                logger.finest("receivedTrap", "Fail sending trap using acl");
                            }
                        }
                    }
                    snmpTrap.setDestinationAddress(null);
                    if (this.v1targets != null) {
                        enumeration = this.v1targets.elements();
                        while (enumeration.hasMoreElements()) {
                            snmpTarget = null;
                            try {
                                snmpTarget = (SnmpV1V2Target)enumeration.nextElement();
                                snmpTrap.setCommunityString(snmpTarget.community);
                                snmpTrap.setDestinationAddress(snmpTarget.address);
                                if (logger.finestOn()) {
                                    logger.finest("receivedTrap", "Sending SNMP V1 trap to : " + snmpTarget.address + " on port : " + snmpTarget.port);
                                }
                                if (snmpTarget.port != -1) {
                                    snmpTrap.setDestinationPort(snmpTarget.port);
                                }
                                snmpTrap.sendV1(this.server);
                            }
                            catch (Exception exception) {
                                if (!logger.finestOn()) continue;
                                logger.finest("receivedTrap", "Fail sending trap to target : " + snmpTarget.address + "/" + snmpTarget.port);
                            }
                        }
                    }
                }
                if (this.isV2Activated()) {
                    if (this.isInetAddressAclUsed()) {
                        if (logger.finestOn()) {
                            logger.finest("receivedTrap", "Sending SNMP V2 trap using InetAddressAcl conf");
                        }
                        snmpTrap.sendV2(this.server);
                    }
                    snmpTrap.setDestinationAddress(null);
                    if (this.v2targets != null) {
                        enumeration = this.v2targets.elements();
                        while (enumeration.hasMoreElements()) {
                            snmpTarget = null;
                            try {
                                snmpTarget = (SnmpV1V2Target)enumeration.nextElement();
                                snmpTrap.setCommunityString(snmpTarget.community);
                                snmpTrap.setDestinationAddress(snmpTarget.address);
                                if (logger.finestOn()) {
                                    logger.finest("receivedTrap", "Sending SNMP V2 trap to : " + snmpTarget.address + " on port : " + snmpTarget.port);
                                }
                                if (snmpTarget.port != -1) {
                                    snmpTrap.setDestinationPort(snmpTarget.port);
                                }
                                snmpTrap.sendV2(this.server);
                            }
                            catch (Exception exception) {
                                if (!logger.finestOn()) continue;
                                logger.finest("receivedTrap", "Fail sending trap to target : " + snmpTarget.address + "/" + snmpTarget.port);
                            }
                        }
                    }
                }
                if (this.isV3Activated()) {
                    if (this.isInetAddressAclUsed() && this.principal != null) {
                        if (logger.finestOn()) {
                            logger.finest("receivedTrap", "Sending SNMP V3 trap using InetAddressAcl conf");
                        }
                        snmpTrap.sendV3Usm(this.server, this.principal, (byte)this.msgFlags, this.contextName);
                    }
                    snmpTrap.setDestinationAddress(null);
                    if (this.v3targets != null) {
                        enumeration = this.v3targets.elements();
                        while (enumeration.hasMoreElements()) {
                            snmpTarget = null;
                            try {
                                snmpTarget = (SnmpV3Target)enumeration.nextElement();
                                snmpTrap.setDestinationAddress(((SnmpV3Target)snmpTarget).address);
                                if (logger.finestOn()) {
                                    logger.finest("receivedTrap", "Sending SNMP V3 trap to : " + ((SnmpV3Target)snmpTarget).address + " on port : " + ((SnmpV3Target)snmpTarget).port);
                                }
                                if (((SnmpV3Target)snmpTarget).port != -1) {
                                    snmpTrap.setDestinationPort(((SnmpV3Target)snmpTarget).port);
                                }
                                snmpTrap.sendV3Usm(this.server, ((SnmpV3Target)snmpTarget).principal, (byte)((SnmpV3Target)snmpTarget).msgFlags, ((SnmpV3Target)snmpTarget).contextName);
                            }
                            catch (Exception exception) {
                                if (!logger.finestOn()) continue;
                                logger.finest("receivedTrap", "Fail sending trap to target : " + ((SnmpV3Target)snmpTarget).address + "/" + ((SnmpV3Target)snmpTarget).port);
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (logger.finerOn()) {
                    logger.finer("receivedTrap", iOException.toString());
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!logger.finerOn()) break block36;
                logger.finer("receivedTrap", snmpStatusException.toString());
            }
        }
    }
}

