/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpSessionProvider;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import java.io.Serializable;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpProxy
extends SnmpMibAgent
implements Serializable {
    private static final long serialVersionUID = 5147896704225603584L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpProxy");
    public static final long defaultTimeout = 10000L;
    private transient SnmpEngine engine = null;
    private SnmpPeer peer = null;
    private String dbgTag = "SnmpProxy";
    private String mibName = null;
    private String oid = null;
    private long timeout = 10000L;
    private SnmpSessionProvider provider = null;
    private transient long[] rootOid = null;
    private boolean initialized = false;
    private boolean skipError = false;
    private boolean forwardOnCheck = false;
    private boolean hide = true;

    public SnmpProxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string) throws SnmpStatusException, IllegalArgumentException {
        this.initializeProxy(snmpEngine, snmpPeer, string, "SnmpProxy");
    }

    public SnmpProxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string, String string2) throws SnmpStatusException, IllegalArgumentException {
        this.initializeProxy(snmpEngine, snmpPeer, string, string2);
    }

    public void skipError(boolean bl) {
        this.skipError = bl;
    }

    public boolean skipError() {
        return this.skipError;
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public long getTimeout() {
        return this.syncGetTimeout();
    }

    public void setTimeout(long l) {
        this.syncSetTimeout(l);
    }

    public void init() throws IllegalAccessException {
        if (this.initialized) {
            return;
        }
        if (logger.finestOn()) {
            logger.finer("init", "init");
        }
        try {
            SnmpSession snmpSession = new SnmpSession(this.engine, "Snmp session", null);
            this.provider = new SnmpSessionProvider(this.peer, snmpSession);
        }
        catch (SnmpStatusException snmpStatusException) {
            if (logger.finerOn()) {
                logger.finer("init", snmpStatusException.toString());
            }
            throw new IllegalAccessException(snmpStatusException.toString());
        }
        this.initialized = true;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        this.init();
        return objectName;
    }

    private void initializeProxy(SnmpEngine snmpEngine, SnmpPeer snmpPeer, String string, String string2) throws SnmpStatusException, IllegalArgumentException {
        if (snmpEngine == null) {
            new IllegalArgumentException("Engine can't be null");
        }
        if (logger.finerOn()) {
            logger.finer("initializeProxy", "initializing snmp proxy with : \nengine : " + snmpEngine + "\n" + "peer : " + snmpPeer.toString() + "\n" + "root OID : " + string + "\n" + "mib name : " + string2 + "\n");
        }
        this.engine = snmpEngine;
        this.oid = string;
        this.mibName = string2;
        this.peer = snmpPeer;
    }

    public String getMibName() {
        return this.mibName;
    }

    public synchronized void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("get", "Sending get request to SNMP sub-agent");
        }
        this.provider.hideInvalidResponseError(this.hide);
        SnmpSession snmpSession = this.defineSession(snmpMibRequest);
        this.get(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
    }

    public synchronized void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (!this.isSetRequestForwardedOnCheck()) {
            if (logger.finerOn()) {
                logger.finer("set", "Sending set request to SNMP sub-agent.");
            }
            this.provider.hideInvalidResponseError(this.hide);
            SnmpSession snmpSession = this.provider.getDefaultSession();
            SnmpParams snmpParams = this.translateParameters(snmpMibRequest);
            snmpParams.setProtocolVersion(snmpSession.getDefaultPeer().getParams().getProtocolVersion());
            snmpSession.getDefaultPeer().setParams(snmpParams);
            this.set(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
        } else if (logger.finerOn()) {
            logger.finer("set", "Doing nothing, set already done on check.");
        }
    }

    public synchronized void forwardSetRequestOnCheck(boolean bl) {
        this.forwardOnCheck = bl;
    }

    public synchronized boolean isSetRequestForwardedOnCheck() {
        return this.forwardOnCheck;
    }

    public synchronized void hideInvalidResponseError(boolean bl) {
        this.hide = bl;
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.hide;
    }

    public synchronized void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        this.provider.hideInvalidResponseError(this.hide);
        if (this.isSetRequestForwardedOnCheck()) {
            if (logger.finerOn()) {
                logger.finer("check", "Sending set request to SNMP sub-agent.");
            }
            SnmpSession snmpSession = this.provider.getDefaultSession();
            SnmpParams snmpParams = this.translateParameters(snmpMibRequest);
            snmpParams.setProtocolVersion(snmpSession.getDefaultPeer().getParams().getProtocolVersion());
            snmpSession.getDefaultPeer().setParams(snmpParams);
            this.set(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
        } else if (logger.finerOn()) {
            logger.finer("check", "Nothing to do, set forwarded on set");
        }
    }

    public synchronized void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("getNext", "Sending getNext request to SNMP sub-agent.");
        }
        this.provider.hideInvalidResponseError(this.hide);
        SnmpSession snmpSession = this.defineSession(snmpMibRequest);
        this.getNext(snmpSession.getDefaultPeer(), snmpSession, snmpMibRequest);
    }

    public synchronized void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        int n3 = snmpMibRequest.getVersion();
        if (n3 == 0) {
            if (logger.finerOn()) {
                logger.finer("getBulk", "Receive a getBulk in SnmpV1 protocol for sub-agent.");
            }
            throw new SnmpStatusException(5, 0);
        }
        this.provider.hideInvalidResponseError(this.hide);
        if (logger.finerOn()) {
            logger.finer("getBulk", "Sending getBulk (using getNext) request to SNMP sub-agent.");
        }
        this.getBulkWithGetNext(snmpMibRequest, n, n2);
    }

    public long[] getRootOid() {
        if (logger.finerOn()) {
            logger.finer("getRootOid", "Root oid to return : " + this.oid);
        }
        this.rootOid = this.resolveOidString(this.oid);
        return this.rootOid;
    }

    public final SnmpPeer getPeer() {
        return this.peer;
    }

    protected boolean handleReport(SnmpRequest snmpRequest) {
        return false;
    }

    protected SnmpParams translateParameters(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpPdu snmpPdu = snmpMibRequest.getPdu();
        if (snmpPdu == null) {
            return new SnmpParameters("public", "private");
        }
        SnmpParameters snmpParameters = new SnmpParameters("public", "private");
        if (logger.finestOn()) {
            logger.finest("translateParameters", "From version : " + snmpPdu.version);
        }
        switch (snmpPdu.version) {
            case 0: 
            case 1: {
                SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPdu;
                if (snmpPduPacket.community == null) break;
                snmpParameters.setRdCommunity(new String(snmpPduPacket.community));
                snmpParameters.setWrCommunity(new String(snmpPduPacket.community));
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (!logger.finerOn()) break;
                logger.finer("translateParameters", "Unsupported snmp protocol version :" + snmpPdu.version);
            }
        }
        return snmpParameters;
    }

    protected synchronized void get(SnmpPeer snmpPeer, SnmpSession snmpSession, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        int n;
        boolean bl = true;
        SnmpRequest snmpRequest = null;
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SnmpProxy varbind list", snmpMibRequest.getSubList());
        while (bl) {
            if (logger.finestOn()) {
                logger.finest("get", "get(SnmpPeer " + snmpPeer + ",\n" + "SnmpSession " + snmpSession + ",\n" + "SnmpMibRequest " + snmpMibRequest + ")");
            }
            snmpRequest = snmpSession.snmpGetRequest(snmpPeer, null, snmpVarBindList);
            if (logger.finestOn()) {
                logger.finest("get(session, request)", "\nRequest:\n" + snmpRequest.toString());
            }
            if ((n = (int)(snmpRequest.waitForCompletion(this.getTimeout()) ? 1 : 0)) == 0) {
                if (logger.finestOn()) {
                    logger.finest("get(session, request)", "Request timed out.");
                }
                throw new SnmpStatusException(5, 0);
            }
            if (snmpRequest.isReport()) {
                bl = this.handleReport(snmpRequest);
                if (!bl) {
                    throw new SnmpStatusException(5);
                }
                if (!logger.finestOn()) continue;
                logger.finest("get", "Retrying");
                continue;
            }
            bl = false;
        }
        n = snmpRequest.getErrorStatus();
        int n2 = snmpRequest.getErrorIndex() + 1;
        if (n != 0) {
            if (logger.finestOn()) {
                logger.finest("get(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString(n) + "\nError index :" + n2);
            }
            throw new SnmpStatusException(n, n2);
        }
        if (snmpSession.snmpOptions.isPduFixedOnError()) {
            this.moveFixResult(snmpRequest, snmpMibRequest);
        } else {
            this.moveResult(snmpRequest, snmpMibRequest);
        }
    }

    protected synchronized void getNext(SnmpPeer snmpPeer, SnmpSession snmpSession, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        int n;
        boolean bl = true;
        SnmpRequest snmpRequest = null;
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SnmpProxy varbind list", snmpMibRequest.getSubList());
        while (bl) {
            if (logger.finestOn()) {
                logger.finest("get", "getnext(SnmpPeer " + snmpPeer + ",\n" + "SnmpSession " + snmpSession + ",\n" + "SnmpMibRequest " + snmpMibRequest + ")");
            }
            if ((n = (int)((snmpRequest = snmpSession.snmpGetNextRequest(snmpPeer, null, snmpVarBindList)).waitForCompletion(this.getTimeout()) ? 1 : 0)) == 0) {
                if (!this.skipError) {
                    if (logger.finestOn()) {
                        logger.finest("get(session, request)", "Request timed out.");
                    }
                    throw new SnmpStatusException(5, 0);
                }
                if (logger.finestOn()) {
                    logger.finest("getNext(session, request)", "Skipping error : timeout.");
                }
                return;
            }
            if (snmpRequest.isReport()) {
                bl = this.handleReport(snmpRequest);
                if (!bl) {
                    throw new SnmpStatusException(5);
                }
                if (!logger.finestOn()) continue;
                logger.finest("get", "Retrying");
                continue;
            }
            bl = false;
        }
        n = snmpRequest.getErrorStatus();
        int n2 = snmpRequest.getErrorIndex() + 1;
        if (n != 0) {
            if (this.skipError) {
                if (logger.finestOn()) {
                    logger.finest("getNext(session, request)", "Skipping error : " + n);
                }
                Enumeration enumeration = snmpMibRequest.getElements();
                while (enumeration.hasMoreElements()) {
                    SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
                    snmpVarBind.setSnmpValue(SnmpVarBind.endOfMibView);
                }
                return;
            }
            if (logger.finestOn()) {
                logger.finest("getNext(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString(n) + "\nError index :" + n2);
            }
            throw new SnmpStatusException(n, n2);
        }
        if (snmpSession.snmpOptions.isPduFixedOnError()) {
            this.moveFixGetNextResult(snmpRequest, snmpMibRequest);
        } else {
            this.moveGetNextResult(snmpRequest, snmpMibRequest);
        }
    }

    protected synchronized void set(SnmpPeer snmpPeer, SnmpSession snmpSession, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        int n;
        boolean bl = true;
        SnmpRequest snmpRequest = null;
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SnmpProxy varbind list", snmpMibRequest.getSubList());
        while (bl) {
            if (logger.finestOn()) {
                logger.finest("get", "getnext(SnmpPeer " + snmpPeer + ",\n" + "SnmpSession " + snmpSession + ",\n" + "SnmpMibRequest " + snmpMibRequest + ")");
            }
            if ((n = (int)((snmpRequest = snmpSession.snmpSetRequest(snmpPeer, null, snmpVarBindList)).waitForCompletion(this.getTimeout()) ? 1 : 0)) == 0) {
                if (logger.finestOn()) {
                    logger.finest("set(session, request)", "Request timed out.");
                }
                throw new SnmpStatusException(5, 0);
            }
            if (snmpRequest.isReport()) {
                bl = this.handleReport(snmpRequest);
                if (!logger.finestOn()) continue;
                logger.finest("get", "Retrying");
                continue;
            }
            bl = false;
        }
        n = snmpRequest.getErrorStatus();
        int n2 = snmpRequest.getErrorIndex() + 1;
        if (n != 0) {
            if (logger.finestOn()) {
                logger.finest("set(session, request)", "Error.\nError status :" + SnmpRequest.snmpErrorToString(n) + "\nError index :" + n2);
            }
            throw new SnmpStatusException(n, n2);
        }
        this.moveResult(snmpRequest, snmpMibRequest);
    }

    private synchronized void syncSetTimeout(long l) {
        this.timeout = l;
    }

    private synchronized long syncGetTimeout() {
        return this.timeout;
    }

    private SnmpSession defineSession(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("defineSession", snmpMibRequest.toString());
        }
        int n = snmpMibRequest.getVersion();
        SnmpSession snmpSession = this.provider.getSession(n);
        SnmpParams snmpParams = null;
        snmpParams = this.translateParameters(snmpMibRequest);
        if (snmpParams == null) {
            throw new SnmpStatusException("Unable to define parameters to send to distant peer.");
        }
        snmpParams.setProtocolVersion(snmpSession.getDefaultPeer().getParams().getProtocolVersion());
        snmpSession.getDefaultPeer().setParams(snmpParams);
        return snmpSession;
    }

    private void handleException(SnmpVarBind snmpVarBind, int n) throws SnmpStatusException {
        int n2 = snmpVarBind.status;
        if (n2 != 2) {
            if (n2 == 2 || n2 == 3 || n2 == 5) {
                throw new SnmpStatusException(n2, n + 1);
            }
            throw new SnmpStatusException(2, n + 1);
        }
    }

    private void handleCounter64(SnmpVarBind snmpVarBind, int n) throws SnmpStatusException {
        if (snmpVarBind.getSnmpValue() instanceof SnmpCounter64) {
            throw new SnmpStatusException(2, n);
        }
    }

    private void moveResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("moveResult", "Result to move with no error");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        int n = 0;
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpMibRequest.getVersion() == 0) {
                this.handleException(snmpVarBind, n);
                this.handleCounter64(snmpVarBind, n);
            }
            snmpVarBind2.setSnmpValue(snmpVarBind.getSnmpValue());
            ++n;
            if (!logger.finestOn()) continue;
            logger.finest("moveResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private void moveFixResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) {
        if (logger.finestOn()) {
            logger.finest("moveFixResult", "Result to move with errors");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpVarBind.status == 4 || snmpVarBind.status == 3) {
                snmpVarBind2.setSnmpValue(SnmpVarBind.noSuchInstance);
            } else {
                snmpVarBind2.setSnmpValue(snmpVarBind.getSnmpValue());
            }
            if (!logger.finestOn()) continue;
            logger.finest("moveResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private void moveGetNextResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("moveGetNextResult", "Result to move with no error");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        int n = 0;
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            if (snmpMibRequest.getVersion() == 0) {
                this.handleException(snmpVarBind, n);
                this.handleCounter64(snmpVarBind, n);
            }
            snmpVarBind2.setSnmpValue(snmpVarBind.getSnmpValue());
            snmpVarBind2.setOid(snmpVarBind.getOid(), false);
            ++n;
            if (!logger.finestOn()) continue;
            logger.finest("moveGetNextResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private void moveFixGetNextResult(SnmpRequest snmpRequest, SnmpMibRequest snmpMibRequest) {
        if (logger.finestOn()) {
            logger.finest("moveFixGetNextResult", "Result to move with errors");
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
        Enumeration enumeration = snmpMibRequest.getElements();
        Enumeration enumeration2 = snmpVarBindList.elements();
        while (enumeration2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration2.nextElement();
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind2.setOid(snmpVarBind.getOid(), false);
            if (snmpVarBind.status == 5) {
                snmpVarBind2.setSnmpValue(SnmpVarBind.endOfMibView);
            } else {
                snmpVarBind2.setSnmpValue(snmpVarBind.getSnmpValue());
            }
            if (!logger.finestOn()) continue;
            logger.finest("moveResult", "\nVarResult : " + snmpVarBind.toString() + "\nVarResult status: " + snmpVarBind.status + "\nVarBind : " + snmpVarBind2.toString() + "\nVarBind status: " + snmpVarBind2.status);
        }
    }

    private long[] resolveOidString(String string) {
        SnmpOid snmpOid = new SnmpOid(string);
        return snmpOid.longValue();
    }
}

