/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RemoteNotification;
import com.sun.jdmk.comm.RmiConnectorAddressV2;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import com.sun.jdmk.internal.ClassLogger;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class ServerNotificationDispatcher {
    public static final int NEW_CLIENT = 0;
    public static final int REMOTE_TERMINATE = 1;
    public static final int REGISTER_TO_MBEAN = 2;
    public static final int UNREGISTER_FROM_MBEAN = 3;
    public static final int GET_NOTIFICATIONS = 4;
    public static final int CLEAR_NOTIFICATIONS = 5;
    public static final int SET_PUSH_MODE = 6;
    public static final int SET_OVERFLOW_MODE = 7;
    public static final int GET_OVERFLOW_MODE = 8;
    public static final int SET_CACHE_SIZE = 9;
    public static final int GET_CACHE_SIZE = 10;
    public static final int SET_OVERFLOW_COUNT = 11;
    public static final int GET_OVERFLOW_COUNT = 12;
    public static final int GET_NOTIF_SERVER_VERSION = 13;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.notification", "ServerNotificationDispatcher");
    private static final ClassLogger ciLogger = new ClassLogger("com.sun.jdmk.notification", "ClientInfo");
    private static final ClassLogger rliLogger = new ClassLogger("com.sun.jdmk.notification", "RemoteListenerInfo");
    private MBeanServer mbServer;
    private ServerNotificationHandlerInternal connector;
    private PushNotification pushNotif;
    private HashMap clientList = new HashMap();
    private static long localCounter = 0L;
    private boolean isTerminated = false;
    private static final Integer SERVER_VERSION = new Integer(2);

    public ServerNotificationDispatcher(ServerNotificationHandlerInternal serverNotificationHandlerInternal, MBeanServer mBeanServer) throws IllegalArgumentException {
        if (serverNotificationHandlerInternal == null) {
            throw new IllegalArgumentException("It should specify a connector.");
        }
        if (mBeanServer == null) {
            throw new IllegalArgumentException("It should specify a MBeanServer.");
        }
        this.connector = serverNotificationHandlerInternal;
        this.mbServer = mBeanServer;
        this.pushNotif = new PushNotification();
        if (logger.finerOn()) {
            logger.finer("Constructor", "create a ServerNotificationDispatcher object.");
        }
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        Object[] objectArray2 = null;
        switch (n) {
            case 0: {
                objectArray2 = this.newClientNotificationDispatcher(objectArray);
                break;
            }
            case 1: {
                objectArray2 = this.remoteTerminate((Long)objectArray[0]);
                break;
            }
            case 2: {
                objectArray2 = this.registerToMBean((Long)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)objectArray[2]);
                break;
            }
            case 3: {
                objectArray2 = this.unregisterFromMBean((Long)objectArray[0], (Long)objectArray[1]);
                break;
            }
            case 4: {
                objectArray2 = this.getNotifications((Long)objectArray[0]);
                break;
            }
            case 5: {
                objectArray2 = this.clearNotifications(objectArray);
                break;
            }
            case 6: {
                objectArray2 = this.setPushMode((Long)objectArray[0], (Integer)objectArray[1], (ConnectorAddress)objectArray[2]);
                break;
            }
            case 7: {
                objectArray2 = this.setOverflowMode(objectArray);
                break;
            }
            case 8: {
                objectArray2 = this.getOverflowMode(objectArray);
                break;
            }
            case 9: {
                objectArray2 = this.setCacheSize(objectArray);
                break;
            }
            case 10: {
                objectArray2 = this.getCacheSize(objectArray);
                break;
            }
            case 11: {
                objectArray2 = this.setOverflowCount(objectArray);
                break;
            }
            case 12: {
                objectArray2 = this.getOverflowCount(objectArray);
                break;
            }
            case 13: {
                objectArray2 = new Object[]{SERVER_VERSION};
                break;
            }
            default: {
                throw new JMRuntimeException("The request is unknown.");
            }
        }
        return objectArray2;
    }

    public void terminate() {
        if (logger.finerOn()) {
            logger.finer("terminate", "the object is being terminated.");
        }
        this.clientList.clear();
        this.isTerminated = true;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mbServer = mBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] newClientNotificationDispatcher(Object[] objectArray) {
        this.isTerminated();
        Long l = ServerNotificationDispatcher.getID();
        if (logger.finerOn()) {
            logger.finer("newClientNotificationDispatcher", "New client is coming, its id is " + l);
        }
        Object[] objectArray2 = this.clientList;
        synchronized (this.clientList) {
            this.clientList.put(l, new ClientInfo(l, (Integer)objectArray[0], (Integer)objectArray[1]));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectArray2 = new Object[]{l};
            return objectArray2;
        }
    }

    protected Object[] remoteTerminate(Long l) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("newClientNotificationDispatcher", "A client is leaving, its id is " + l);
        }
        if ((clientInfo = (ClientInfo)this.clientList.remove(l)) != null) {
            clientInfo.terminate();
        }
        return new Object[0];
    }

    protected Object[] registerToMBean(Long l, ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException {
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("registerToMBean", "Add a remote listener from the client " + l + " to the mbean " + objectName.toString());
        }
        Object[] objectArray = new Object[1];
        ClientInfo clientInfo = (ClientInfo)this.clientList.get(l);
        if (clientInfo == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        objectArray[0] = clientInfo.addListener(objectName, notificationFilter);
        return objectArray;
    }

    protected Object[] unregisterFromMBean(Long l, Long l2) throws InstanceNotFoundException, ListenerNotFoundException {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("unregisterFromMBean", "Remove a remote listener " + l2 + " from the client " + l);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get(l)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        clientInfo.removeListener(l2);
        return new Object[0];
    }

    protected RemoteNotification[] getNotifications(Long l) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getNotifications", "Send back all saved notification to the client " + l);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get(l)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        return clientInfo.getAllNotifs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] clearNotifications(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("clearNotifications", "clear the notification cache.");
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) != null) {
            List list = clientInfo.notifLog;
            synchronized (list) {
                clientInfo.notifLog.clear();
            }
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] setPushMode(Long l, Integer n, ConnectorAddress connectorAddress) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setPushMode", "The client " + l + " asks to change push mode to " + n);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get(l)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ClientInfo clientInfo2 = clientInfo;
        synchronized (clientInfo2) {
            int n2 = n;
            if (clientInfo.forwardMode != n2) {
                if (n2 == 0) {
                    if (connectorAddress instanceof RmiConnectorAddressV2) {
                        Remote remote = ((RmiConnectorAddressV2)connectorAddress).getRemoteObj();
                        clientInfo.backConnector = (NotificationBackConnector)remote;
                    } else {
                        clientInfo.backConnector = this.connector.startPush(connectorAddress);
                    }
                    clientInfo.forwardMode = 0;
                    this.pushNotif.newNotif(clientInfo);
                } else if (n2 == 1) {
                    this.connector.stopPush(clientInfo.backConnector);
                    clientInfo.backConnector = null;
                }
                clientInfo.forwardMode = n2;
            }
        }
        return new Object[0];
    }

    protected Object[] setOverflowMode(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setOverflowMode", "Set the overflow mode to " + (Integer)objectArray[1] + " for the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        clientInfo.discard_mode = (Integer)objectArray[1];
        return new Object[0];
    }

    protected Object[] getOverflowMode(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getOverflowMode", "Get the overflow mode of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] objectArray2 = new Object[]{new Integer(clientInfo.discard_mode)};
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] setCacheSize(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setCacheSize", "Set the cache size of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        int n = (Integer)objectArray[1];
        Object[] objectArray2 = clientInfo.notifLog;
        synchronized (clientInfo.notifLog) {
            if (clientInfo.notifLog.size() > n) {
                if (((Boolean)objectArray[2]).booleanValue()) {
                    clientInfo.overflow_count += clientInfo.notifLog.size() - n;
                    if (clientInfo.discard_mode == 10) {
                        for (int i = 0; i < clientInfo.notifLog.size() - n; ++i) {
                            clientInfo.notifLog.remove(0);
                        }
                    } else if (clientInfo.discard_mode == 11) {
                        for (int i = clientInfo.notifLog.size() - 1; i >= n; --i) {
                            clientInfo.notifLog.remove(i);
                        }
                    }
                    clientInfo.cache_size = (Integer)objectArray[1];
                }
            } else {
                clientInfo.cache_size = (Integer)objectArray[1];
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            objectArray2 = new Object[]{new Integer(clientInfo.cache_size)};
            return objectArray2;
        }
    }

    protected Object[] getCacheSize(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getCacheSize", "Get the cache size of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] objectArray2 = new Object[]{new Integer(clientInfo.cache_size)};
        return objectArray2;
    }

    protected Object[] setOverflowCount(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setOverflowCount", "Set the overflow count of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        clientInfo.overflow_count = (Integer)objectArray[1];
        return new Object[0];
    }

    protected Object[] getOverflowCount(Object[] objectArray) {
        ClientInfo clientInfo;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getOverflowCount", "Get the overflow count of the client " + (Long)objectArray[0]);
        }
        if ((clientInfo = (ClientInfo)this.clientList.get((Long)objectArray[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] objectArray2 = new Object[]{new Integer(clientInfo.overflow_count)};
        return objectArray2;
    }

    private void isTerminated() {
        if (this.isTerminated) {
            throw new JMRuntimeException("This ServerNotificationDispatcher object has been terminated and is waiting to be destroyed.");
        }
    }

    private static Long getID() {
        if (localCounter == Long.MAX_VALUE) {
            localCounter = 0L;
        }
        return new Long(localCounter++);
    }

    private class PushNotification {
        private List waitingClientList = Collections.synchronizedList(new ArrayList());
        private TaskThread taskThread = null;
        private boolean tobeTerminated = false;

        public synchronized void newNotif(ClientInfo clientInfo) {
            if (!this.waitingClientList.contains(clientInfo)) {
                this.waitingClientList.add(clientInfo);
            }
            if (this.taskThread == null || !this.taskThread.isAlive()) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }

        public void terminate() {
            boolean bl = true;
            this.taskThread = null;
        }

        private class TaskThread
        extends Thread {
            public TaskThread() {
                super("taskThread");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!PushNotification.this.tobeTerminated) {
                    ClientInfo clientInfo = null;
                    Object[] objectArray = PushNotification.this.waitingClientList;
                    synchronized (objectArray) {
                        if (PushNotification.this.waitingClientList.isEmpty()) {
                            break;
                        }
                        clientInfo = (ClientInfo)PushNotification.this.waitingClientList.remove(0);
                    }
                    try {
                        objectArray = clientInfo.getAllNotifs();
                        clientInfo.backConnector.remoteRequest(0, objectArray);
                    }
                    catch (Exception exception) {
                        if (!logger.finestOn()) continue;
                        logger.finest("TaskThread", "run", exception);
                    }
                }
            }
        }
    }

    private class RemoteListenerInfo
    implements NotificationListener {
        public ObjectName mbean;
        public NotificationFilter filter;
        public Long listenerID;
        private ClientInfo client;

        public RemoteListenerInfo(ObjectName objectName, NotificationFilter notificationFilter, Long l, ClientInfo clientInfo) {
            this.mbean = objectName;
            this.filter = notificationFilter;
            this.listenerID = l;
            this.client = clientInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object object) {
            Object object2;
            if (rliLogger.finestOn()) {
                object2 = "Receive a notification for remote listener " + this.listenerID + " of the client " + this.client.clientID;
                rliLogger.finest("handleNotification", (String)object2);
            }
            object2 = this.client.notifLog;
            synchronized (object2) {
                if (this.client.forwardMode == 1 && this.client.cache_size >= 0) {
                    if (this.client.notifLog.size() < this.client.cache_size) {
                        this.client.notifLog.add(new RemoteNotification(this.listenerID, notification));
                    } else {
                        if (this.client.discard_mode == 10 && this.client.cache_size > 0) {
                            this.client.notifLog.remove(0);
                            this.client.notifLog.add(new RemoteNotification(this.listenerID, notification));
                        }
                        ++this.client.overflow_count;
                    }
                } else {
                    this.client.notifLog.add(new RemoteNotification(this.listenerID, notification));
                }
            }
            if (this.client.forwardMode == 0) {
                ServerNotificationDispatcher.this.pushNotif.newNotif(this.client);
            }
        }
    }

    private class ClientInfo {
        public Long clientID;
        public int forwardMode = 1;
        public NotificationBackConnector backConnector;
        public List notifLog = Collections.synchronizedList(new ArrayList());
        public int cache_size;
        public int discard_mode;
        public int overflow_count = 0;
        private HashMap rliList = new HashMap();

        public ClientInfo(Long l, int n, int n2) {
            this.clientID = l;
            this.discard_mode = n;
            this.cache_size = n2;
        }

        public Long addListener(ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException {
            Long l = ServerNotificationDispatcher.getID();
            RemoteListenerInfo remoteListenerInfo = new RemoteListenerInfo(objectName, notificationFilter, l, this);
            ServerNotificationDispatcher.this.mbServer.addNotificationListener(objectName, remoteListenerInfo, notificationFilter, null);
            this.rliList.put(l, remoteListenerInfo);
            return l;
        }

        public synchronized void removeListener(Long l) throws InstanceNotFoundException, ListenerNotFoundException {
            RemoteListenerInfo remoteListenerInfo = (RemoteListenerInfo)this.rliList.remove(l);
            if (remoteListenerInfo == null) {
                throw new ListenerNotFoundException("The listener does not find.");
            }
            ServerNotificationDispatcher.this.mbServer.removeNotificationListener(remoteListenerInfo.mbean, remoteListenerInfo);
        }

        public synchronized RemoteNotification[] getAllNotifs() {
            ArrayList arrayList = new ArrayList(this.notifLog.size());
            while (!this.notifLog.isEmpty()) {
                arrayList.add(this.notifLog.remove(0));
            }
            RemoteNotification[] remoteNotificationArray = new RemoteNotification[arrayList.size()];
            arrayList.toArray(remoteNotificationArray);
            return remoteNotificationArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            block9: {
                if (this.forwardMode == 0) {
                    try {
                        ServerNotificationDispatcher.this.connector.stopPush(this.backConnector);
                    }
                    catch (Exception exception) {
                        if (!ciLogger.finestOn()) break block9;
                        ciLogger.finest("terminate", exception);
                    }
                }
            }
            this.backConnector = null;
            HashMap hashMap = this.rliList;
            synchronized (hashMap) {
                Iterator iterator = this.rliList.values().iterator();
                while (iterator.hasNext()) {
                    RemoteListenerInfo remoteListenerInfo = (RemoteListenerInfo)iterator.next();
                    try {
                        ServerNotificationDispatcher.this.mbServer.removeNotificationListener(remoteListenerInfo.mbean, remoteListenerInfo);
                    }
                    catch (Exception exception) {
                        if (!ciLogger.finestOn()) continue;
                        ciLogger.finest("terminate", exception);
                    }
                }
            }
            this.notifLog.clear();
            this.rliList.clear();
        }
    }
}

