/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpConnectorServerMBean;
import com.sun.jdmk.comm.HttpNotificationForwarder;
import com.sun.jdmk.comm.HttpSocket;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HttpConnectorServer
extends GenericHttpConnectorServer
implements HttpConnectorServerMBean {
    private int timeout = 60000;

    public HttpConnectorServer() {
        super(2, 8081);
    }

    public HttpConnectorServer(int n) {
        super(2, n);
    }

    public HttpConnectorServer(int n, AuthInfo[] authInfoArray) {
        super(2, n, authInfoArray);
    }

    public HttpConnectorServer(int n, InetAddress inetAddress) {
        super(2, n, inetAddress);
    }

    public HttpConnectorServer(int n, AuthInfo[] authInfoArray, InetAddress inetAddress) {
        super(2, n, authInfoArray, inetAddress);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + "name=HttpConnectorServer");
        }
        return super.preRegister(mBeanServer, objectName);
    }

    GenericHttpSocket createSocket() {
        HttpSocket httpSocket = new HttpSocket();
        httpSocket.setTimeout(this.getTimeout());
        return httpSocket;
    }

    GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress genericHttpConnectorAddress) {
        return new HttpNotificationForwarder(genericHttpConnectorAddress);
    }

    public String getProtocol() {
        return "http";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = n;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(n);
        }
    }

    String makeDebugTag() {
        return "HttpConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

