/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.DynamicMetaDataImpl;
import com.sun.jdmk.Introspector;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.internal.ClassLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MetaDataImpl
extends DynamicMetaDataImpl {
    private static final String dbgTag = "MetaDataImpl";
    private static Hashtable mbeanInfoCache = new Hashtable();
    private static Hashtable mbeanInterfaceCache = new Hashtable();
    private static final Hashtable primitiveClasses = new Hashtable(8);
    private final ClassLogger logger;

    MetaDataImpl(MBeanInstantiator mBeanInstantiator) {
        super(mBeanInstantiator);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.logger = new ClassLogger("com.sun.jdmk.mbeanserver", dbgTag);
    }

    public synchronized void testCompliance(Class clazz) throws NotCompliantMBeanException {
        Class clazz2;
        MBeanInfo mBeanInfo = Introspector.testCompliance(clazz);
        if (mBeanInfo != null && mbeanInfoCache.get(clazz) == null) {
            mbeanInfoCache.put(clazz, mBeanInfo);
        }
        if ((clazz2 = Introspector.getMBeanInterface(clazz)) != null && mbeanInterfaceCache.get(clazz) == null) {
            mbeanInterfaceCache.put(clazz, clazz2);
        }
    }

    public Class getMBeanInterfaceFromClass(Class clazz) {
        Class clazz2 = (Class)mbeanInterfaceCache.get(clazz);
        return clazz2;
    }

    public MBeanInfo getMBeanInfoFromClass(Class clazz) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo mBeanInfo = (MBeanInfo)mbeanInfoCache.get(clazz);
        if (mBeanInfo != null) {
            return (MBeanInfo)mBeanInfo.clone();
        }
        this.testCompliance(clazz);
        mBeanInfo = (MBeanInfo)mbeanInfoCache.get(clazz);
        if (mBeanInfo != null) {
            return (MBeanInfo)mBeanInfo.clone();
        }
        return mBeanInfo;
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string) {
        Method method = null;
        try {
            int n;
            Method[] methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length && !methodArray[n].getName().equals(string); ++n) {
            }
            if (n < methodArray.length) {
                method = methodArray[n];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string, int n) {
        Method method = null;
        try {
            int n2;
            Method[] methodArray = clazz.getMethods();
            boolean bl = false;
            for (n2 = 0; n2 < methodArray.length && !bl; ++n2) {
                bl = methodArray[n2].getName().equals(string);
                if (!bl) continue;
                bl = methodArray[n2].getParameterTypes().length == n;
            }
            if (bl) {
                method = methodArray[n2 - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findGetter(Class clazz, String string) {
        Method method = MetaDataImpl.findMethod(clazz, "get" + string, null);
        if (method == null) {
            method = MetaDataImpl.findMethod(clazz, "is" + string, null);
        }
        return method;
    }

    public static Method findSetter(Class clazz, String string, Class clazz2) {
        Class<?>[] classArray;
        Method method = MetaDataImpl.findMethod(clazz, "set" + string, 1);
        if (method != null && (classArray = method.getParameterTypes())[0].isAssignableFrom(clazz2)) {
            return method;
        }
        return null;
    }

    public static Method findSetter(Class clazz, String string) {
        return MetaDataImpl.findMethod(clazz, "set" + string, 1);
    }

    public static Constructor findConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            return null;
        }
        return constructor;
    }

    public static Class findClassForPrim(String string) {
        return (Class)primitiveClasses.get(string);
    }

    public static Class findPrimForClass(Object object) {
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    public String getMBeanClassName(Object object) throws IntrospectionException, NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            return super.getMBeanClassName(object);
        }
        return object.getClass().getName();
    }

    public MBeanInfo getMBeanInfo(Object object) throws IntrospectionException {
        if (object instanceof DynamicMBean) {
            return super.getMBeanInfo(object);
        }
        try {
            MBeanInfo mBeanInfo = this.getMBeanInfoFromClass(object.getClass());
            return new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanInfo.getAttributes(), mBeanInfo.getConstructors(), mBeanInfo.getOperations(), this.findNotifications(object));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            this.logger.finest("getMBeanInfo", notCompliantMBeanException);
            throw new IntrospectionException("Can't build MBeanInfo for " + object.getClass().getName());
        }
    }

    public Object getAttribute(Object object, String string) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (object instanceof DynamicMBean) {
            return super.getAttribute(object, string);
        }
        Class clazz = this.getMBeanInterfaceFromClass(object.getClass());
        if (this.logger.finestOn()) {
            this.logger.finest("getAttribute", "MBean Class is " + object.getClass());
            this.logger.finest("getAttribute", "MBean Interface is " + clazz);
        }
        return this.getAttribute(object, string, clazz);
    }

    public AttributeList getAttributes(Object object, String[] stringArray) throws ReflectionException {
        if (object instanceof DynamicMBean) {
            return super.getAttributes(object, stringArray);
        }
        Class clazz = this.getMBeanInterfaceFromClass(object.getClass());
        if (this.logger.finestOn()) {
            this.logger.finest("getAttributes", "MBean Class is " + object.getClass());
            this.logger.finest("getAttributes", "MBean Interface is " + clazz);
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        int n = stringArray.length;
        AttributeList attributeList = new AttributeList(n);
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            try {
                Object object2 = this.getAttribute(object, string, clazz);
                attributeList.add(new Attribute(string, object2));
                continue;
            }
            catch (Exception exception) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("getAttributes", "Object= " + object + ", Attribute=" + string + " failed: " + exception);
            }
        }
        return attributeList;
    }

    public AttributeList setAttributes(Object object, AttributeList attributeList) throws ReflectionException {
        if (object instanceof DynamicMBean) {
            return super.setAttributes(object, attributeList);
        }
        Class<?> clazz = object.getClass();
        Class clazz2 = this.getMBeanInterfaceFromClass(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        if (this.logger.finestOn()) {
            this.logger.finest("setAttributes", "MBean Class is " + object.getClass());
            this.logger.finest("setAttributes", "MBean Interface is " + clazz2);
        }
        if (attributeList == null) {
            return new AttributeList();
        }
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getName();
            Object object2 = attribute.getValue();
            try {
                Object object3 = this.setAttribute(object, attribute, clazz2);
                if (this.logger.traceOn()) {
                    this.logger.trace("setAttributes", "Updating the list\n");
                }
                attributeList2.add(new Attribute(string, object3));
            }
            catch (Exception exception) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("setAttributes", "Unexpected exception occurred: " + exception.getClass().getName());
            }
        }
        return attributeList2;
    }

    public Object setAttribute(Object object, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (object instanceof DynamicMBean) {
            return super.setAttribute(object, attribute);
        }
        Class clazz = this.getMBeanInterfaceFromClass(object.getClass());
        if (this.logger.finestOn()) {
            this.logger.finest("setAttribute", "MBean Class is " + object.getClass());
            this.logger.finest("setAttribute", "MBean Interface is " + clazz);
        }
        return this.setAttribute(object, attribute, clazz);
    }

    public Object invoke(Object object, String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Class[] classArray;
        Method method;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Operation name  cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to invoke the operation on the MBean");
        }
        if (object instanceof DynamicMBean) {
            return super.invoke(object, string, objectArray, stringArray);
        }
        Class<?> clazz = object.getClass();
        Class clazz2 = this.getMBeanInterfaceFromClass(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        if (this.logger.finestOn()) {
            this.logger.finest("invoke", "MBean Class is " + object.getClass());
            this.logger.finest("invoke", "MBean Interface is " + clazz2);
        }
        if ((method = MetaDataImpl.findMethod(clazz2, string, classArray = stringArray == null ? null : this.instantiator.findSignatureClasses(stringArray, classLoader))) == null) {
            if (this.logger.traceOn()) {
                this.logger.trace("invoke", string + " not found in class " + clazz2.getName());
            }
            throw new ReflectionException(new NoSuchMethodException(string), "The operation with name " + string + " could not be found");
        }
        if (this.logger.traceOn()) {
            this.logger.trace("invoke", "Invoking " + string);
        }
        Object object2 = null;
        try {
            Object[] objectArray2 = this.instantiator.checkTransferParameters(classLoader, objectArray);
            object2 = method.invoke(object, objectArray2);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.finest("invoke", illegalAccessException);
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occurred trying to invoke operation " + string);
        }
        catch (RuntimeException runtimeException) {
            this.logger.finest("invoke", runtimeException);
            throw new RuntimeOperationsException(runtimeException, "RuntimeException occurred trying to invoke operation " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.logger.finest("invoke", throwable);
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in operation " + string);
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in operation " + string);
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in operation " + string);
        }
        if (this.logger.traceOn()) {
            this.logger.trace("invoke", "Send the result");
        }
        return object2;
    }

    public boolean isInstanceOf(Object object, String string) throws ReflectionException {
        boolean bl;
        if (object instanceof DynamicMBean && (bl = super.isInstanceOf(object, string))) {
            return true;
        }
        Class clazz = this.instantiator.findClass(string, object.getClass().getClassLoader());
        return clazz.isInstance(object);
    }

    protected Object getAttribute(Object object, String string, Class clazz) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to invoke the getter on the MBean");
        }
        Method method = null;
        method = MetaDataImpl.findGetter(clazz, string);
        if (method == null) {
            if (this.logger.traceOn()) {
                this.logger.trace("getAttribute", "Cannot find getter for " + string + " in class " + clazz.getName());
            }
            throw new AttributeNotFoundException(string + " not accessible");
        }
        if (this.logger.traceOn()) {
            this.logger.trace("getAttribute", "Invoke callback");
        }
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                this.logger.finest("getAttribute", throwable);
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the getter for the attribute " + string);
            }
            if (throwable instanceof Error) {
                this.logger.finest("getAttribute", throwable);
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the getter for the attribute " + string);
            }
            this.logger.finest("getAttribute", throwable);
            throw new MBeanException((Exception)throwable, "Exception thrown in the getter for the attribute " + string);
        }
        catch (RuntimeException runtimeException) {
            this.logger.finest("getAttribute", runtimeException);
            throw new RuntimeOperationsException(runtimeException, "RuntimeException thrown trying to invoke the getter for the attribute " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.finest("getAttribute", illegalAccessException);
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the getter for the attribute " + string);
        }
        catch (Error error) {
            this.logger.finest("getAttribute", error);
            throw new RuntimeErrorException(error, "Error thrown trying to invoke the getter  for the attribute " + string);
        }
        if (this.logger.traceOn()) {
            this.logger.trace("getAttribute", string + "= " + object2 + "\n");
        }
        return object2;
    }

    protected Object setAttribute(Object object, Attribute attribute, Class clazz) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object object2;
        if (attribute == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to invoke the setter on the MBean");
        }
        Class<?> clazz2 = object.getClass();
        ClassLoader classLoader = clazz2.getClassLoader();
        Object object3 = null;
        Attribute attribute2 = this.instantiator.checkTransferAttribute(classLoader, attribute);
        Object object4 = attribute2.getValue();
        String string = attribute2.getName();
        Method method = null;
        method = object4 == null ? MetaDataImpl.findSetter(clazz, string) : MetaDataImpl.findSetter(clazz, string, object4.getClass());
        if (method == null && (object2 = MetaDataImpl.findPrimForClass(object4)) != null) {
            method = MetaDataImpl.findSetter(clazz, string, (Class)object2);
        }
        if (method == null) {
            method = MetaDataImpl.findSetter(clazz, string);
            if (method == null) {
                if (this.logger.traceOn()) {
                    this.logger.trace("setAttribute", "Cannot find setter for " + attribute + " in class " + clazz.getName());
                }
                throw new AttributeNotFoundException(string + " not accessible");
            }
            object2 = attribute.getValue();
            if (object2 == null) {
                throw new InvalidAttributeValueException("attribute= " + string + " value = null");
            }
            throw new InvalidAttributeValueException("attribute= " + string + " value = " + object2);
        }
        if (this.logger.traceOn()) {
            this.logger.trace("setAttribute", "Invoking the set method for " + string);
        }
        object2 = new Object[]{object4};
        try {
            object3 = method.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.finest("setAttribute", illegalAccessException);
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occurred trying to invoke the setter on the MBean");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.logger.finest("setAttribute", throwable);
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's setter");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's setter");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's setter");
        }
        if (this.logger.traceOn()) {
            this.logger.trace("setAttribute", string + "= " + object4);
        }
        return object4;
    }

    static String[] findSignatures(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = MetaDataImpl.findSignature(classArray[i]);
        }
        return stringArray;
    }

    static String findSignature(Class clazz) {
        return clazz.getName();
    }

    private MBeanNotificationInfo[] findNotifications(Object object) {
        if (object instanceof NotificationBroadcaster) {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = ((NotificationBroadcaster)object).getNotificationInfo();
            if (mBeanNotificationInfoArray == null) {
                return new MBeanNotificationInfo[0];
            }
            MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length];
            for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
                mBeanNotificationInfoArray2[i] = (MBeanNotificationInfo)mBeanNotificationInfoArray[i].clone();
            }
            return mBeanNotificationInfoArray2;
        }
        return new MBeanNotificationInfo[0];
    }
}

