/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.ListenerInfo;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanPermission;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ServerNotifForwarder {
    private MBeanServer mbeanServer;
    private final long connectionTimeout;
    private static int listenerCounter = 0;
    private static final int[] listenerCounterLock = new int[0];
    private NotificationBuffer notifBuffer;
    private Set listenerList = new HashSet();
    private boolean terminated = false;
    private final int[] terminationLock = new int[0];
    static final String broadcasterClass = (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = ServerNotifForwarder.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName();
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ServerNotifForwarder");
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;

    public ServerNotifForwarder(MBeanServer mBeanServer, Map map, NotificationBuffer notificationBuffer) {
        this.mbeanServer = mBeanServer;
        this.notifBuffer = notificationBuffer;
        this.connectionTimeout = EnvHelp.getServerConnectionTimeout(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotificationListener(final ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException, IOException {
        Comparable<Boolean> comparable;
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "Add a listener at " + objectName);
        }
        this.checkState();
        this.checkMBeanPermission(objectName, "addNotificationListener");
        try {
            comparable = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return new Boolean(ServerNotifForwarder.this.mbeanServer.isInstanceOf(objectName, broadcasterClass));
                }
            });
            if (!comparable.booleanValue()) {
                throw new IllegalArgumentException("The specified MBean [" + objectName + "] is not a " + "NotificationBroadcaster " + "object.");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)ServerNotifForwarder.extractException(privilegedActionException);
        }
        comparable = this.getListenerID();
        Set set = this.listenerList;
        synchronized (set) {
            this.listenerList.add(new ListenerInfo((Integer)comparable, objectName, notificationFilter));
        }
        return comparable;
    }

    public void removeNotificationListener(ObjectName objectName, Integer[] integerArray) throws Exception {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove some listeners from " + objectName);
        }
        this.checkState();
        this.checkMBeanPermission(objectName, "removeNotificationListener");
        Exception exception = null;
        for (int i = 0; i < integerArray.length; ++i) {
            try {
                this.removeNotificationListener(objectName, integerArray[i]);
                continue;
            }
            catch (Exception exception2) {
                if (exception == null) continue;
                exception = exception2;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, Integer n) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + n + " from " + objectName);
        }
        this.checkState();
        if (objectName != null && !objectName.isPattern() && !this.mbeanServer.isRegistered(objectName)) {
            throw new InstanceNotFoundException("The MBean " + objectName + " is not registered.");
        }
        Set set = this.listenerList;
        synchronized (set) {
            if (!this.listenerList.remove(new ListenerInfo(n, objectName, null))) {
                throw new ListenerNotFoundException("Listener not found!");
            }
        }
    }

    public NotificationResult fetchNotifs(long l, long l2, int n) {
        if (logger.traceOn()) {
            logger.trace("fetchNotifs", "Fetching notifications, the startSequenceNumber is " + l + ", the timeout is " + l2 + ", the maxNotifications is " + n);
        }
        NotificationResult notificationResult = null;
        long l3 = Math.min(this.connectionTimeout, l2);
        try {
            notificationResult = this.notifBuffer.fetchNotifications(this.listenerList, l, l3, n);
        }
        catch (InterruptedException interruptedException) {
            notificationResult = new NotificationResult(0L, 0L, new TargetedNotification[0]);
        }
        if (logger.traceOn()) {
            logger.trace("fetchNotifs", "Forwarding the notifs: " + notificationResult);
        }
        return notificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (logger.traceOn()) {
            logger.trace("terminate", "Be called.");
        }
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            Set set = this.listenerList;
            synchronized (set) {
                this.listenerList.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (logger.traceOn()) {
                logger.trace("terminate", "Terminated.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                throw new IOException("The connection has been terminated.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getListenerID() {
        int[] nArray = listenerCounterLock;
        synchronized (listenerCounterLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Integer(listenerCounter++);
        }
    }

    private void checkMBeanPermission(final ObjectName objectName, String string) throws InstanceNotFoundException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessControlContext accessControlContext = AccessController.getContext();
            ObjectInstance objectInstance = null;
            try {
                objectInstance = (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstanceNotFoundException {
                        return ServerNotifForwarder.this.mbeanServer.getObjectInstance(objectName);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (InstanceNotFoundException)ServerNotifForwarder.extractException(privilegedActionException);
            }
            String string2 = objectInstance.getClassName();
            MBeanPermission mBeanPermission = new MBeanPermission(string2, null, objectName, string);
            securityManager.checkPermission(mBeanPermission, accessControlContext);
        }
    }

    private static Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

