/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.runtime.provider;

import com.sun.encoder.hl7.runtime.provider.HL7CharEscapeCoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class MarshalHandler
implements ContentHandler {
    private final String mCharset;
    private final OutputStream mOutputStream;
    private final SchemaGlobalElement mRootElement;
    private Writer mWriter;
    private DelimDataWriter mDelimDataWriter;
    private MarshalerFactory mMarshalFactory = new MarshalerFactory();
    private boolean mReceivedFirst = false;
    private Marshaler mMarshaler;
    private String mGroupNamePrefix;

    public MarshalHandler(SchemaGlobalElement element, OutputStream output) {
        this(element, output, "ASCII");
    }

    public MarshalHandler(SchemaGlobalElement element, OutputStream output, String charset) {
        if (element == null) {
            throw new NullPointerException("no element");
        }
        this.mRootElement = element;
        if (output == null) {
            throw new NullPointerException("no output");
        }
        this.mOutputStream = output;
        this.mWriter = null;
        this.mCharset = charset;
        this.mDelimDataWriter = null;
        this.mGroupNamePrefix = element.getName().getLocalPart() + ".";
    }

    public MarshalHandler(SchemaGlobalElement element, Writer output) {
        if (element == null) {
            throw new NullPointerException("no element");
        }
        this.mRootElement = element;
        if (output == null) {
            throw new NullPointerException("no output");
        }
        this.mWriter = output;
        this.mOutputStream = null;
        this.mCharset = null;
        this.mDelimDataWriter = null;
        this.mGroupNamePrefix = element.getName().getLocalPart() + ".";
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (this.mWriter == null) {
            if (this.mCharset != null) {
                try {
                    this.mWriter = new OutputStreamWriter(this.mOutputStream, this.mCharset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SAXException(e);
                }
            }
            try {
                this.mWriter = new OutputStreamWriter(this.mOutputStream, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new SAXException(e);
            }
        }
        this.mDelimDataWriter = new DelimDataWriter(this.mWriter);
    }

    public void endDocument() throws SAXException {
        try {
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.mReceivedFirst) {
            if (!this.mRootElement.getName().getLocalPart().equals(localName)) {
                throw new SAXException("Expecting '" + this.mRootElement.getName() + "', found '{" + uri + "}" + localName + "'");
            }
            this.mMarshaler = this.mMarshalFactory.getDocumentMarshaler(this.mRootElement, this.mDelimDataWriter, this.mGroupNamePrefix);
            this.mReceivedFirst = true;
        } else {
            this.mMarshaler = this.mMarshaler.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.mMarshaler = this.mMarshaler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mMarshaler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public String getGroupNamePrefix() {
        return this.mGroupNamePrefix;
    }

    public void setGroupNamePrefix(String groupNamePrefix) {
        this.mGroupNamePrefix = groupNamePrefix;
    }

    private static boolean isSimpleContent(SchemaType XMLType) {
        return XMLType.isSimpleType() || XMLType.getContentType() == 2 || XMLType.getContentType() == 4 || XMLType.isURType();
    }

    private static abstract class BaseMarshaler
    implements Marshaler {
        protected SchemaParticle mModel;
        protected int mChildrenCount;
        protected SchemaType mXMLType;
        protected int mChildIndex;
        protected int mRepetIndex;
        private Set<QName> mMatchedParts;
        private boolean mHasMeaninglessGroup;

        public BaseMarshaler(SchemaType xmlType) {
            this.reset(xmlType);
        }

        public void reset(SchemaType xmlType) {
            this.mXMLType = xmlType;
            this.mModel = xmlType.getContentModel();
            if (this.mModel.getParticleType() == 4 || this.mModel.getParticleType() == 5) {
                this.mHasMeaninglessGroup = true;
                this.mChildrenCount = 1;
            } else {
                this.mHasMeaninglessGroup = false;
                this.mChildrenCount = this.mModel.countOfParticleChild();
            }
            this.mChildIndex = -1;
            this.mRepetIndex = -1;
            this.mMatchedParts = null;
        }

        protected abstract void endOfRepetition();

        protected final void match(String uri, String localName, MatchResult result) throws SAXException {
            switch (this.mModel.getParticleType()) {
                case 3: 
                case 4: 
                case 5: {
                    this.sequenceMatch(uri, localName, result);
                    break;
                }
                case 2: {
                    this.choiceMatch(uri, localName, result);
                    break;
                }
                case 1: {
                    this.allMatch(uri, localName, result);
                    break;
                }
                default: {
                    throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                }
            }
        }

        protected final void endMatch(String uri, String localName) throws SAXException {
            switch (this.mModel.getParticleType()) {
                case 3: 
                case 4: 
                case 5: {
                    if (this.mChildrenCount == 0 || this.mChildIndex >= this.mChildrenCount) {
                        return;
                    }
                    int repet = this.mRepetIndex;
                    for (int i = this.mChildIndex; i < this.mChildrenCount; ++i) {
                        if (repet < this.mModel.getParticleChild(i).getIntMinOccurs() - 1) {
                            throw new SAXException("Expecting '" + this.mModel.getParticleChild(i).getName() + ", found '/{" + uri + "}" + localName + "'");
                        }
                        repet = -1;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.mChildrenCount; ++i) {
                        if (this.mModel.getParticleChild(i).getIntMinOccurs() != 0) continue;
                        return;
                    }
                    if (this.mChildIndex != -1) break;
                    throw new SAXException("Expecting at least one child in the choice group, found '/{" + uri + "}" + localName + "'");
                }
                case 1: {
                    for (int i = 0; i < this.mChildrenCount; ++i) {
                        if (this.mModel.getParticleChild(i).getIntMinOccurs() <= 0 || this.mMatchedParts.contains(this.mModel.getParticleChild(i).getName())) continue;
                        throw new SAXException("Expecting '" + this.mModel.getParticleChild(i).getName() + ", found '/{" + uri + "}" + localName + "'");
                    }
                    break;
                }
                default: {
                    throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                }
            }
        }

        private final void sequenceMatch(String uri, String localName, MatchResult result) throws SAXException {
            boolean isWildcard;
            if (this.mChildIndex == -1) {
                this.mChildIndex = 0;
                this.mRepetIndex = -1;
            }
            if (this.mChildIndex >= this.mChildrenCount) {
                throw new SAXException("Exceeding end of a sequence group.  No matching particle found for {" + uri + "}" + localName);
            }
            SchemaParticle childPart = this.mHasMeaninglessGroup ? this.mModel : this.mModel.getParticleChild(this.mChildIndex);
            boolean bl = isWildcard = childPart.getParticleType() == 5;
            if (isWildcard ? !this.matchWildcard(uri, localName, childPart) : !this.matchExactly(uri, localName, childPart)) {
                if (this.mRepetIndex > 0) {
                    this.endOfRepetition();
                }
                this.mRepetIndex = -1;
                ++this.mChildIndex;
                boolean match = false;
                while (this.mChildIndex < this.mChildrenCount) {
                    childPart = this.mModel.getParticleChild(this.mChildIndex);
                    boolean bl2 = isWildcard = childPart.getParticleType() == 5;
                    if (isWildcard ? this.matchWildcard(uri, localName, childPart) : this.matchExactly(uri, localName, childPart)) {
                        this.mRepetIndex = 0;
                        match = true;
                        break;
                    }
                    if (childPart.getIntMinOccurs() > 0) {
                        if (!isWildcard) {
                            throw new SAXException("Expecting element '" + childPart.getName() + "', found element '{" + uri + "}" + localName + "'");
                        }
                        throw new SAXException("Expecting element within " + childPart.getWildcardSet() + ", found element '{" + uri + "}" + localName + "'");
                    }
                    ++this.mChildIndex;
                    this.mRepetIndex = -1;
                }
                if (!match) {
                    throw new SAXException("No matching particle found for {" + uri + "}" + localName);
                }
            } else {
                ++this.mRepetIndex;
                if (childPart.getMaxOccurs() != null && this.mRepetIndex >= childPart.getIntMaxOccurs()) {
                    throw new SAXException("Too many element '{" + uri + "}" + localName + "'");
                }
            }
            if (childPart.getParticleType() == 5) {
                result.mResult = 2;
                result.mElementName = new QName(uri, localName);
                result.mElementType = null;
            } else {
                result.mResult = 1;
                result.mElementName = childPart.getName();
                result.mElementType = childPart.getType();
            }
        }

        private final void choiceMatch(String uri, String localName, MatchResult result) throws SAXException {
            boolean matchedWildcard = false;
            boolean matchedElement = false;
            SchemaParticle childPart = null;
            if (this.mChildIndex >= 0) {
                childPart = this.mModel.getParticleChild(this.mChildIndex);
                if (childPart.getParticleType() == 5) {
                    if (!this.matchWildcard(uri, localName, childPart)) {
                        throw new SAXException("A wildcard has been matched for the choice group. Putting an element '{" + uri + "}" + localName + "' that does not match the wildcard" + " is not allowed");
                    }
                    matchedWildcard = true;
                } else {
                    if (!this.matchExactly(uri, localName, childPart)) {
                        throw new SAXException("An element with name '" + childPart.getName() + "' already occurred in the choice group." + " Putting an element with a different name '{" + uri + "}" + localName + "' is not allowed");
                    }
                    matchedElement = true;
                }
            }
            if (matchedWildcard) {
                ++this.mRepetIndex;
                if (childPart.getMaxOccurs() != null && this.mRepetIndex >= childPart.getIntMaxOccurs()) {
                    throw new SAXException("Too many element '{" + uri + "}" + localName + "'");
                }
                result.mResult = 2;
                result.mElementName = new QName(uri, localName);
                result.mElementType = null;
                return;
            }
            if (matchedElement) {
                ++this.mRepetIndex;
                if (childPart.getMaxOccurs() != null && this.mRepetIndex >= childPart.getIntMaxOccurs()) {
                    throw new SAXException("Too many element '{" + uri + "}" + localName + "'");
                }
                result.mResult = 1;
                result.mElementName = childPart.getName();
                result.mElementType = childPart.getType();
                return;
            }
            for (int i = 0; i < this.mChildrenCount; ++i) {
                childPart = this.mModel.getParticleChild(i);
                if (childPart.getParticleType() == 5) {
                    if (!this.matchWildcard(uri, localName, childPart)) continue;
                    matchedWildcard = true;
                    this.mChildIndex = i;
                    break;
                }
                if (!this.matchExactly(uri, localName, childPart)) continue;
                this.mChildIndex = i;
                matchedElement = true;
                break;
            }
            if (matchedWildcard) {
                ++this.mRepetIndex;
                result.mResult = 2;
                result.mElementName = new QName(uri, localName);
                result.mElementType = null;
                return;
            }
            if (matchedElement) {
                ++this.mRepetIndex;
                result.mResult = 1;
                result.mElementName = childPart.getName();
                result.mElementType = childPart.getType();
                return;
            }
            throw new SAXException("No matching particle found for '{" + uri + "}" + localName + "'");
        }

        private final void allMatch(String uri, String localName, MatchResult result) throws SAXException {
            QName name;
            SchemaProperty elemProp;
            if (this.mMatchedParts == null) {
                this.mMatchedParts = new HashSet<QName>();
            }
            if ((elemProp = this.mXMLType.getElementProperty(name = new QName(uri, localName))) == null) {
                throw new SAXException("No matching particle found for '{" + uri + "}" + localName + "'");
            }
            if (this.mMatchedParts.contains(name)) {
                throw new SAXException("Too many element '{" + uri + "}" + localName + "'");
            }
            this.mMatchedParts.add(name);
            result.mResult = 1;
            result.mElementName = elemProp.getName();
            result.mElementType = elemProp.getType();
            this.mRepetIndex = 0;
        }

        private boolean matchWildcard(String uri, String localPart, SchemaParticle wildcard) {
            return wildcard.getWildcardSet().contains(new QName(uri, localPart));
        }

        private boolean matchExactly(String uri, String localPart, SchemaParticle particle) {
            return localPart.equals(particle.getName().getLocalPart());
        }
    }

    private static final class WildcardMarshaler
    implements Marshaler {
        public static final int SEGMENT_LEVEL = 1;
        public static final int FIELD_LEVEL = 2;
        public static final int COMPO_LEVEL = 3;
        public static final int SUBCOMPO_LEVEL = 4;
        public static final int NUM_OF_LEVELS = 5;
        private final DelimDataWriter mWriter;
        private Marshaler mParent;
        private int mStartingAt;
        private int mCurrentLevel;
        private QName[] mLastMatched = new QName[5];
        private int[] mChildIndex = new int[5];
        private int[] mRepetIndex = new int[5];
        private boolean[] mStartTagOpen = new boolean[5];

        public WildcardMarshaler(Marshaler parent, QName name, DelimDataWriter writer, int level) {
            this.mWriter = writer;
            this.reset(parent, name, level);
        }

        public void reset(Marshaler parent, QName name, int level) {
            this.mParent = parent;
            this.mStartingAt = level;
            this.mCurrentLevel = this.mStartingAt + 1;
            Arrays.fill(this.mLastMatched, null);
            Arrays.fill(this.mChildIndex, -1);
            Arrays.fill(this.mRepetIndex, -1);
            Arrays.fill(this.mStartTagOpen, false);
            this.mLastMatched[this.mStartingAt] = name;
        }

        public Marshaler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block12: {
                block11: {
                    if (this.mStartTagOpen[this.mCurrentLevel]) {
                        ++this.mCurrentLevel;
                        if (this.mCurrentLevel >= 5) {
                            throw new SAXException("Wildcard goes too deep. Cannot be deeper than sub-component level. Level: " + this.mCurrentLevel + " Name: '{" + uri + "}" + localName + "'");
                        }
                        this.mLastMatched[this.mCurrentLevel] = new QName(uri, localName);
                        this.mStartTagOpen[this.mCurrentLevel] = true;
                        this.mChildIndex[this.mCurrentLevel] = 0;
                        this.mRepetIndex[this.mCurrentLevel] = 0;
                        return this;
                    }
                    if (this.mChildIndex[this.mCurrentLevel] < 0) break block11;
                    if (this.mLastMatched[this.mCurrentLevel].getLocalPart().equals(localName)) {
                        int n = this.mCurrentLevel;
                        this.mRepetIndex[n] = this.mRepetIndex[n] + 1;
                    } else {
                        this.mLastMatched[this.mCurrentLevel] = new QName(uri, localName);
                        int n = this.mCurrentLevel;
                        this.mChildIndex[n] = this.mChildIndex[n] + 1;
                        this.mRepetIndex[this.mCurrentLevel] = 0;
                    }
                    switch (this.mCurrentLevel) {
                        case 2: {
                            if (this.mRepetIndex[this.mCurrentLevel] > 0) {
                                this.mWriter.writeRepetSep();
                            } else {
                                this.mWriter.writeFieldSep();
                            }
                            break block12;
                        }
                        case 3: {
                            this.mWriter.writeCompoSep();
                            break block12;
                        }
                        case 4: {
                            this.mWriter.writeSubCompoSep();
                            break block12;
                        }
                        default: {
                            throw new SAXException("Illegal level: " + this.mCurrentLevel + ", name: '{" + uri + "}" + localName + "'");
                        }
                    }
                }
                this.mLastMatched[this.mCurrentLevel] = new QName(uri, localName);
                this.mChildIndex[this.mCurrentLevel] = 0;
                this.mRepetIndex[this.mCurrentLevel] = 0;
            }
            this.mStartTagOpen[this.mCurrentLevel] = true;
            return this;
        }

        public Marshaler endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.mStartTagOpen[this.mCurrentLevel]) {
                --this.mCurrentLevel;
            } else {
                this.mWriter.endData();
            }
            if (this.mLastMatched[this.mCurrentLevel] == null) {
                throw new SAXException("No matching start tag for '{" + uri + "}" + localName + "'");
            }
            if (!this.mLastMatched[this.mCurrentLevel].getLocalPart().equals(localName)) {
                throw new SAXException("Expecting: '" + this.mLastMatched[this.mCurrentLevel] + ", found: '{" + uri + "}" + localName + "'");
            }
            this.mStartTagOpen[this.mCurrentLevel] = false;
            if (this.mCurrentLevel <= this.mStartingAt) {
                if (this.mStartingAt == 1) {
                    this.mWriter.writeSegSep();
                }
                return this.mParent;
            }
            return this;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mWriter.writeData(ch, start, length);
        }
    }

    private static final class ComponentMarshaler
    extends BaseMarshaler {
        private final MatchResult mMatchResult = new MatchResult();
        private final DelimDataWriter mWriter;
        private Marshaler mParent;
        private QName mName;
        private QName mMatchedSimpleElem = null;
        private boolean mReceivedEscape = false;
        private boolean mIsFirst = true;
        private int mIndexBeforeMatch;

        public ComponentMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            super(type);
            this.mParent = parent;
            this.mName = name;
            this.mWriter = writer;
        }

        public void reset(Marshaler parent, QName name, SchemaType type) {
            super.reset(type);
            this.mParent = parent;
            this.mName = name;
            this.mIsFirst = true;
        }

        protected void endOfRepetition() {
        }

        public Marshaler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block15: {
                block14: {
                    if (this.mMatchedSimpleElem != null) {
                        if ("escape".equals(localName)) {
                            this.mWriter.writeData("\\");
                            this.mWriter.writeData(atts.getValue("V"));
                            this.mWriter.writeData("\\");
                            this.mReceivedEscape = true;
                            return this;
                        }
                        throw new SAXException("Missing end tag for element '" + this.mMatchedSimpleElem);
                    }
                    this.mIndexBeforeMatch = this.mChildIndex;
                    this.match(uri, localName, this.mMatchResult);
                    if (this.mIsFirst) break block14;
                    switch (this.mModel.getParticleType()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            while (this.mIndexBeforeMatch < this.mChildIndex) {
                                this.mWriter.writeSubCompoSep();
                                ++this.mIndexBeforeMatch;
                            }
                            break block15;
                        }
                        case 2: {
                            throw new SAXException("Don't know how to handle repetitive subcomponent with name '{" + uri + "}" + localName + "'");
                        }
                        case 1: {
                            this.mWriter.writeSubCompoSep();
                            break block15;
                        }
                        default: {
                            throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                        }
                    }
                }
                switch (this.mModel.getParticleType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        while (this.mIndexBeforeMatch < this.mChildIndex - 1) {
                            this.mWriter.writeSubCompoSep();
                            ++this.mIndexBeforeMatch;
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                    }
                }
            }
            this.mIsFirst = false;
            if (this.mMatchResult.mResult == 1 && !MarshalHandler.isSimpleContent(this.mMatchResult.mElementType)) {
                throw new SAXException("Element '{" + uri + "}" + localName + "' must match simple content type, " + "but found complex content type.");
            }
            this.mMatchedSimpleElem = this.mMatchResult.mElementName;
            return this;
        }

        public Marshaler endElement(String uri, String localName, String qName) throws SAXException {
            if (this.mMatchedSimpleElem != null) {
                if (this.mReceivedEscape) {
                    if ("escape".equals(localName)) {
                        this.mReceivedEscape = false;
                        return this;
                    }
                    throw new SAXException("Expecting '/escape', found '/{" + uri + "}" + localName + "'");
                }
                if (!this.mMatchedSimpleElem.getLocalPart().equals(localName)) {
                    throw new SAXException("Expecting '/" + this.mMatchedSimpleElem + "', found '/{" + uri + "}" + localName + "'");
                }
                this.mWriter.endData();
                this.mMatchedSimpleElem = null;
                return this;
            }
            if (!this.mName.getLocalPart().equals(localName)) {
                throw new SAXException("Expecting '/" + this.mName + "', found '/{" + uri + "}" + localName + "'");
            }
            return this.mParent;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (length <= 0 || this.mMatchedSimpleElem == null) {
                return;
            }
            this.mWriter.writeData(ch, start, length);
        }
    }

    private static final class FieldMarshaler
    extends BaseMarshaler {
        private final MatchResult mMatchResult = new MatchResult();
        private final DelimDataWriter mWriter;
        private Marshaler mParent;
        private QName mName;
        private MarshalerFactory mMarshalFactory = null;
        private QName mMatchedSimpleElem = null;
        private boolean mReceivedEscape = false;
        private boolean mIsFirst = true;
        private int mIndexBeforeMatch;

        public FieldMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            super(type);
            this.mParent = parent;
            this.mName = name;
            this.mWriter = writer;
        }

        public void setFactory(MarshalerFactory factory) {
            this.mMarshalFactory = factory;
        }

        public void reset(Marshaler parent, QName name, SchemaType type) {
            super.reset(type);
            this.mParent = parent;
            this.mName = name;
            this.mIsFirst = true;
        }

        protected void endOfRepetition() {
        }

        public Marshaler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block16: {
                block15: {
                    if (this.mMatchedSimpleElem != null) {
                        if ("escape".equals(localName)) {
                            this.mWriter.writeData("\\");
                            this.mWriter.writeData(atts.getValue("V"));
                            this.mWriter.writeData("\\");
                            this.mReceivedEscape = true;
                            return this;
                        }
                        throw new SAXException("Missing end tag for element '" + this.mMatchedSimpleElem);
                    }
                    this.mIndexBeforeMatch = this.mChildIndex;
                    this.match(uri, localName, this.mMatchResult);
                    if (this.mIsFirst) break block15;
                    switch (this.mModel.getParticleType()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            while (this.mIndexBeforeMatch < this.mChildIndex) {
                                this.mWriter.writeCompoSep();
                                ++this.mIndexBeforeMatch;
                            }
                            break block16;
                        }
                        case 2: {
                            throw new SAXException("Don't know how to handle repetitive component with name '{" + uri + "}" + localName + "'");
                        }
                        case 1: {
                            this.mWriter.writeCompoSep();
                            break block16;
                        }
                        default: {
                            throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                        }
                    }
                }
                switch (this.mModel.getParticleType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        while (this.mIndexBeforeMatch < this.mChildIndex - 1) {
                            this.mWriter.writeCompoSep();
                            ++this.mIndexBeforeMatch;
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                    }
                }
            }
            this.mIsFirst = false;
            if (this.mMatchResult.mResult == 1) {
                if (MarshalHandler.isSimpleContent(this.mMatchResult.mElementType)) {
                    this.mMatchedSimpleElem = this.mMatchResult.mElementName;
                    return this;
                }
                return this.mMarshalFactory.getComponentMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter);
            }
            return this.mMarshalFactory.getWildcardMarshaler(this, new QName(uri, localName), this.mWriter, 3);
        }

        public Marshaler endElement(String uri, String localName, String qName) throws SAXException {
            if (this.mMatchedSimpleElem != null) {
                if (this.mReceivedEscape) {
                    if ("escape".equals(localName)) {
                        this.mReceivedEscape = false;
                        return this;
                    }
                    throw new SAXException("Expecting '/escape', found '/{" + uri + "}" + localName + "'");
                }
                if (!this.mMatchedSimpleElem.getLocalPart().equals(localName)) {
                    throw new SAXException("Expecting '/" + this.mMatchedSimpleElem + "', found '/{" + uri + "}" + localName + "'");
                }
                this.mWriter.endData();
                this.mMatchedSimpleElem = null;
                return this;
            }
            if (!this.mName.getLocalPart().equals(localName)) {
                throw new SAXException("Expecting '/" + this.mName + "', found '/{" + uri + "}" + localName + "'");
            }
            return this.mParent;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (length <= 0 || this.mMatchedSimpleElem == null) {
                return;
            }
            this.mWriter.writeData(ch, start, length);
        }
    }

    private static final class MSHSegmentMarshaler
    extends SegmentMarshaler {
        int mCharIndex = -1;
        int mLength = 0;

        public MSHSegmentMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            super(parent, name, type, writer);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mChildIndex == 0) {
                if (length > 0) {
                    this.mWriter.writeSegName("MSH");
                    this.mWriter.setFieldSep(ch[start]);
                    return;
                }
            } else if (this.mChildIndex == 1) {
                if (this.mCharIndex == -1) {
                    this.mCharIndex = 0;
                }
                int oldLength = this.mLength;
                this.mLength += length;
                while (this.mCharIndex < this.mLength) {
                    switch (this.mCharIndex) {
                        case 0: {
                            this.mWriter.setComponentSep(ch[start + this.mCharIndex - oldLength]);
                            break;
                        }
                        case 1: {
                            this.mWriter.setRepetSep(ch[start + this.mCharIndex - oldLength]);
                            break;
                        }
                        case 2: {
                            this.mWriter.setEscapeChar(ch[start + this.mCharIndex - oldLength]);
                            break;
                        }
                        case 3: {
                            this.mWriter.setSubCompoSep(ch[start + this.mCharIndex - oldLength]);
                        }
                    }
                    ++this.mCharIndex;
                }
                this.mWriter.mEscapeCoder = new HL7CharEscapeCoder(this.mWriter.getFieldSep(), this.mWriter.getComponentSep(), this.mWriter.getSubCompoSep(), this.mWriter.getRepetSep(), this.mWriter.getEscapeChar());
                this.mWriter.writeData(new String(ch, start, length));
                return;
            }
            super.characters(ch, start, length);
        }
    }

    private static class SegmentMarshaler
    extends BaseMarshaler {
        protected final DelimDataWriter mWriter;
        private final MatchResult mMatchResult = new MatchResult();
        private Marshaler mParent;
        private QName mName;
        private MarshalerFactory mMarshalFactory = null;
        private QName mMatchedSimpleElem = null;
        private boolean mReceivedEscape = false;
        protected boolean mIsFirst = true;
        private int mIndexBeforeMatch;

        public SegmentMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            super(type);
            this.mParent = parent;
            this.mName = name;
            this.mWriter = writer;
        }

        public void setFactory(MarshalerFactory factory) {
            this.mMarshalFactory = factory;
        }

        public void reset(Marshaler parent, QName name, SchemaType type) {
            super.reset(type);
            this.mParent = parent;
            this.mName = name;
            this.mIsFirst = true;
        }

        protected void endOfRepetition() {
        }

        public Marshaler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            block18: {
                block17: {
                    if (this.mMatchedSimpleElem != null) {
                        if ("escape".equals(localName)) {
                            this.mWriter.writeData("\\");
                            this.mWriter.writeData(atts.getValue("V"));
                            this.mWriter.writeData("\\");
                            this.mReceivedEscape = true;
                            return this;
                        }
                        throw new SAXException("Missing end tag for element '" + this.mMatchedSimpleElem);
                    }
                    this.mIndexBeforeMatch = this.mChildIndex;
                    this.match(uri, localName, this.mMatchResult);
                    if (this.mIsFirst) break block17;
                    switch (this.mModel.getParticleType()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            if (this.mRepetIndex > 0) {
                                this.mWriter.writeRepetSep();
                            } else {
                                while (this.mIndexBeforeMatch < this.mChildIndex) {
                                    this.mWriter.writeFieldSep();
                                    ++this.mIndexBeforeMatch;
                                }
                            }
                            break block18;
                        }
                        case 2: {
                            this.mWriter.writeRepetSep();
                            break block18;
                        }
                        case 1: {
                            this.mWriter.writeFieldSep();
                            break block18;
                        }
                        default: {
                            throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                        }
                    }
                }
                switch (this.mModel.getParticleType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        while (this.mIndexBeforeMatch < this.mChildIndex - 1) {
                            this.mWriter.writeFieldSep();
                            ++this.mIndexBeforeMatch;
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new SAXException("Illegal particle type: " + this.mModel.getParticleType());
                    }
                }
            }
            this.mIsFirst = false;
            if (this.mMatchResult.mResult == 1) {
                if (MarshalHandler.isSimpleContent(this.mMatchResult.mElementType)) {
                    this.mMatchedSimpleElem = this.mMatchResult.mElementName;
                    return this;
                }
                return this.mMarshalFactory.getFieldMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter);
            }
            return this.mMarshalFactory.getWildcardMarshaler(this, new QName(uri, localName), this.mWriter, 2);
        }

        public Marshaler endElement(String uri, String localName, String qName) throws SAXException {
            if (this.mMatchedSimpleElem != null) {
                if (this.mReceivedEscape) {
                    if ("escape".equals(localName)) {
                        this.mReceivedEscape = false;
                        return this;
                    }
                    throw new SAXException("Expecting '/escape', found '/{" + uri + "}" + localName + "'");
                }
                if (!this.mMatchedSimpleElem.getLocalPart().equals(localName)) {
                    throw new SAXException("Expecting '/" + this.mMatchedSimpleElem + "', found '/{" + uri + "}" + localName + "'");
                }
                this.mWriter.endData();
                this.mMatchedSimpleElem = null;
                return this;
            }
            if (!this.mName.getLocalPart().equals(localName)) {
                throw new SAXException("Expecting '/" + this.mName + "', found '/{" + uri + "}" + localName + "'");
            }
            this.mWriter.writeSegSep();
            return this.mParent;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (length <= 0 || this.mMatchedSimpleElem == null) {
                return;
            }
            this.mWriter.writeData(ch, start, length);
        }
    }

    private static final class PseudoGrpMarshaler
    extends BaseMarshaler {
        private final MatchResult mMatchResult = new MatchResult();
        private final DelimDataWriter mWriter;
        private Marshaler mParent;
        private QName mName;
        private String mPseudoGroupPrefix;
        private MarshalerFactory mMarshalFactory = null;

        public PseudoGrpMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer, String pseudoGroupPrefix) {
            super(type);
            this.mParent = parent;
            this.mName = name;
            this.mWriter = writer;
            this.mPseudoGroupPrefix = pseudoGroupPrefix;
        }

        public void setFactory(MarshalerFactory factory) {
            this.mMarshalFactory = factory;
        }

        public void reset(Marshaler parent, QName name, SchemaType type, String pseudoGroupPrefix) {
            super.reset(type);
            this.mParent = parent;
            this.mName = name;
            this.mPseudoGroupPrefix = pseudoGroupPrefix;
        }

        public void endOfRepetition() {
        }

        public Marshaler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.match(uri, localName, this.mMatchResult);
            if (this.mMatchResult.mResult == 1) {
                if (localName.startsWith(this.mPseudoGroupPrefix)) {
                    return this.mMarshalFactory.getPseudoGrpMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter, this.mPseudoGroupPrefix);
                }
                this.mWriter.writeSegName(localName);
                this.mWriter.writeFieldSep();
                return this.mMarshalFactory.getSegmentMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter);
            }
            SchemaGlobalElement knownElement = this.mXMLType.getTypeSystem().findElement(new QName(uri, localName));
            if (knownElement != null) {
                return this.mMarshalFactory.getSegmentMarshaler(this, knownElement.getName(), knownElement.getType(), this.mWriter);
            }
            return this.mMarshalFactory.getWildcardMarshaler(this, new QName(uri, localName), this.mWriter, 1);
        }

        public Marshaler endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.mName.getLocalPart().equals(localName)) {
                throw new SAXException("Expecting '/" + this.mName + "', found '/{" + uri + "}" + localName + "'");
            }
            return this.mParent;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }

    private static final class DocumentMarshaler
    extends BaseMarshaler {
        private final SchemaGlobalElement mElement;
        private final MatchResult mMatchResult = new MatchResult();
        private final DelimDataWriter mWriter;
        private final String mPseudoGroupPrefix;
        private MarshalerFactory mMarshalFactory = null;

        public DocumentMarshaler(SchemaGlobalElement element, DelimDataWriter writer, String pseudoGroupPrefix, int occursFactor) {
            super(element.getType());
            this.mElement = element;
            this.mWriter = writer;
            this.mPseudoGroupPrefix = pseudoGroupPrefix;
        }

        public void setFactory(MarshalerFactory factory) {
            this.mMarshalFactory = factory;
        }

        public void endOfRepetition() {
        }

        public Marshaler startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.match(uri, localName, this.mMatchResult);
            if (this.mMatchResult.mResult == 1) {
                if (localName.startsWith(this.mPseudoGroupPrefix)) {
                    return this.mMarshalFactory.getPseudoGrpMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter, this.mPseudoGroupPrefix);
                }
                if ("MSH".equals(localName)) {
                    return this.mMarshalFactory.getMSHSegmentMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter);
                }
                this.mWriter.writeSegName(localName);
                this.mWriter.writeFieldSep();
                return this.mMarshalFactory.getSegmentMarshaler(this, this.mMatchResult.mElementName, this.mMatchResult.mElementType, this.mWriter);
            }
            this.mWriter.writeSegName(localName);
            this.mWriter.writeFieldSep();
            SchemaGlobalElement knownElement = this.mElement.getTypeSystem().findElement(new QName(uri, localName));
            if (knownElement != null) {
                return this.mMarshalFactory.getSegmentMarshaler(this, knownElement.getName(), knownElement.getType(), this.mWriter);
            }
            return this.mMarshalFactory.getWildcardMarshaler(this, new QName(uri, localName), this.mWriter, 1);
        }

        public Marshaler endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.mElement.getName().getLocalPart().equals(localName)) {
                throw new SAXException("Expecting '/" + this.mElement.getName() + "', found '/{" + uri + "}" + localName + "'");
            }
            return null;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }

    private static class MatchResult {
        public static final int MATCH_ELEMENT = 1;
        public static final int MATCH_WILDCARD = 2;
        public int mResult;
        public QName mElementName;
        public SchemaType mElementType;

        private MatchResult() {
        }
    }

    private static final class MarshalerFactory {
        private DocumentMarshaler mDocumentMarshaler = null;
        private SegmentMarshaler mSegmentMarshaler = null;
        private FieldMarshaler mFieldMarshaler = null;
        private ComponentMarshaler mComponentMarshaler = null;
        private WildcardMarshaler mWildcardMarshaler = null;
        private MSHSegmentMarshaler mMSHSegmentMarshaler = null;

        private MarshalerFactory() {
        }

        Marshaler getDocumentMarshaler(SchemaGlobalElement rootElement, DelimDataWriter writer, String pseudoGroupPrefix) {
            if (this.mDocumentMarshaler == null) {
                this.mDocumentMarshaler = new DocumentMarshaler(rootElement, writer, pseudoGroupPrefix, 1);
                this.mDocumentMarshaler.setFactory(this);
            } else {
                this.mDocumentMarshaler.reset(rootElement.getType());
            }
            return this.mDocumentMarshaler;
        }

        Marshaler getSegmentMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            if (this.mSegmentMarshaler == null) {
                this.mSegmentMarshaler = new SegmentMarshaler(parent, name, type, writer);
                this.mSegmentMarshaler.setFactory(this);
            } else {
                this.mSegmentMarshaler.reset(parent, name, type);
            }
            return this.mSegmentMarshaler;
        }

        Marshaler getFieldMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            if (this.mFieldMarshaler == null) {
                this.mFieldMarshaler = new FieldMarshaler(parent, name, type, writer);
                this.mFieldMarshaler.setFactory(this);
            } else {
                this.mFieldMarshaler.reset(parent, name, type);
            }
            return this.mFieldMarshaler;
        }

        Marshaler getComponentMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            if (this.mComponentMarshaler == null) {
                this.mComponentMarshaler = new ComponentMarshaler(parent, name, type, writer);
            } else {
                this.mComponentMarshaler.reset(parent, name, type);
            }
            return this.mComponentMarshaler;
        }

        Marshaler getWildcardMarshaler(Marshaler parent, QName name, DelimDataWriter writer, int level) {
            if (this.mWildcardMarshaler == null) {
                this.mWildcardMarshaler = new WildcardMarshaler(parent, name, writer, level);
            } else {
                this.mWildcardMarshaler.reset(parent, name, level);
            }
            return this.mWildcardMarshaler;
        }

        Marshaler getPseudoGrpMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer, String pseudoGroupPrefix) {
            PseudoGrpMarshaler marshaler = new PseudoGrpMarshaler(parent, name, type, writer, pseudoGroupPrefix);
            marshaler.setFactory(this);
            return marshaler;
        }

        Marshaler getMSHSegmentMarshaler(Marshaler parent, QName name, SchemaType type, DelimDataWriter writer) {
            if (this.mMSHSegmentMarshaler == null) {
                this.mMSHSegmentMarshaler = new MSHSegmentMarshaler(parent, name, type, writer);
                this.mMSHSegmentMarshaler.setFactory(this);
            } else {
                this.mMSHSegmentMarshaler.reset(parent, name, type);
            }
            return this.mMSHSegmentMarshaler;
        }
    }

    private static final class DelimDataWriter {
        public HL7CharEscapeCoder mEscapeCoder;
        private final Writer mWriter;
        private char mSegSep = (char)13;
        private char mFieldSep = (char)124;
        private char mCompoSep = (char)94;
        private char mRepetSep = (char)126;
        private char mEscape = (char)92;
        private char mSubCompoSep = (char)38;

        public DelimDataWriter(Writer writer) {
            this.mWriter = writer;
        }

        void writeSegName(String segName) throws SAXException {
            try {
                this.mWriter.write(segName);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeSegSep() throws SAXException {
            try {
                this.mWriter.write(this.mSegSep);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeFieldSep() throws SAXException {
            try {
                this.mWriter.write(this.mFieldSep);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeCompoSep() throws SAXException {
            try {
                this.mWriter.write(this.mCompoSep);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeSubCompoSep() throws SAXException {
            try {
                this.mWriter.write(this.mSubCompoSep);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeRepetSep() throws SAXException {
            try {
                this.mWriter.write(this.mRepetSep);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeData(String data) throws SAXException {
            try {
                this.mWriter.write(data);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void writeData(char[] data, int start, int length) throws SAXException {
            try {
                if (this.mEscapeCoder != null) {
                    this.mEscapeCoder.escape(data, start, length);
                    if (this.mEscapeCoder.hasResult()) {
                        HL7CharEscapeCoder.Result res = this.mEscapeCoder.getResult();
                        this.mWriter.write(res.mData, res.mStart, res.mCount);
                        return;
                    }
                }
                this.mWriter.write(data, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        void endData() throws SAXException {
        }

        char getSegSep() {
            return this.mSegSep;
        }

        void setSegSep(char sep) {
            this.mSegSep = sep;
        }

        char getFieldSep() {
            return this.mFieldSep;
        }

        void setFieldSep(char sep) {
            this.mFieldSep = sep;
        }

        char getComponentSep() {
            return this.mCompoSep;
        }

        void setComponentSep(char sep) {
            this.mCompoSep = sep;
        }

        char getSubCompoSep() {
            return this.mSubCompoSep;
        }

        void setSubCompoSep(char sep) {
            this.mSubCompoSep = sep;
        }

        char getRepetSep() {
            return this.mRepetSep;
        }

        void setRepetSep(char sep) {
            this.mRepetSep = sep;
        }

        public char getEscapeChar() {
            return this.mEscape;
        }

        public void setEscapeChar(char escape) {
            this.mEscape = escape;
        }
    }

    private static interface Marshaler {
        public Marshaler startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

        public Marshaler endElement(String var1, String var2, String var3) throws SAXException;

        public void characters(char[] var1, int var2, int var3) throws SAXException;
    }
}

