/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.toolbox;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.StringTokenizer;
import javax.swing.JViewport;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.modules.visualweb.gravy.DNDDriver;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.designer.DesignerPaneOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.ToolBoxOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.actions.ShowPaletteAction;

public class PaletteContainerOperator
extends ContainerOperator {
    private static final String PALETTE_TITLE = "Palette";
    JListOperator theTree = null;
    JCheckBoxOperator categoryButton = null;
    private String name;
    static String defaultPaletteCategory = "Basic";

    private PaletteContainerOperator(ContainerOperator cont, String name) {
        super(cont, (ComponentChooser)new PaletteContainerChooser(name));
        this.name = name;
    }

    private static Container findPaletteContainer(String name) {
        return new JCheckBoxOperator((ContainerOperator)new TopComponentOperator(PALETTE_TITLE), name).getParent();
    }

    public PaletteContainerOperator(String name) {
        super(PaletteContainerOperator.findPaletteContainer(name));
        this.name = name;
    }

    public static String getDefaultPaletteCategory() {
        return defaultPaletteCategory;
    }

    public void showComponents() {
        if (this.categoryButton == null) {
            this.categoryButton = new JCheckBoxOperator((ContainerOperator)this, this.name);
        }
        this.categoryButton.changeSelection(true);
    }

    public void hideComponents() {
        if (this.categoryButton == null) {
            this.categoryButton = new JCheckBoxOperator((ContainerOperator)this, this.name);
        }
        this.categoryButton.changeSelection(false);
    }

    public Point getClickPoint(String componentName) {
        JListOperator theTree = this.getComponentsTree();
        return theTree.getClickPoint(theTree.findItemIndex(componentName));
    }

    public Point getClickPoint(String componentName, int index) {
        return this.getComponentsTree().getClickPoint(this.getComponentsTree().findItemIndex(componentName, index));
    }

    public Point getClickPointOfClass(Class clz) {
        return this.getClickPoint(this.getDisplayNameOfClass(clz));
    }

    public Point getClickPointOfClass(String className) {
        try {
            return this.getClickPointOfClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return this.getClickPoint(this.getShortClassName(className));
        }
    }

    private JViewport findViewportOfPalette() {
        JViewport viewPort = (JViewport)ContainerOperator.findContainerUnder((Component)this.getSource(), (ComponentChooser)new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JViewport.class.isInstance(comp);
            }

            public String getDescription() {
                return "JViewport";
            }
        });
        return viewPort;
    }

    public void dndPaletteComponent(String componentName, ComponentOperator designer, Point designerPoint) {
        Point clickPoint = this.getClickPoint(componentName);
        Util.wait(1000);
        this.dndPaletteComponent(clickPoint, designer, designerPoint);
    }

    public void dndComponentOfClass(String componentClassName, ComponentOperator designer, Point designerPoint) {
        Point clickPoint = this.getClickPointOfClass(componentClassName);
        Util.wait(1000);
        this.dndPaletteComponent(clickPoint, designer, designerPoint);
    }

    private void dndPaletteComponent(Point componentClickPoint, ComponentOperator designer, Point designerPoint) {
        JViewport viewPort = this.findViewportOfPalette();
        JListOperator component = this.getComponentsTree();
        int compX = component.getLocationOnScreen().x - viewPort.getLocationOnScreen().x + componentClickPoint.x;
        int compY = component.getLocationOnScreen().y - viewPort.getLocationOnScreen().y + componentClickPoint.y;
        System.out.println();
        System.out.println("+++ coordinates of component in Palette Panel = [" + compX + ", " + compY + "]");
        System.out.println();
        viewPort.setViewPosition(new Point(compX, compY));
        Util.wait(1000);
        component.clickMouse(componentClickPoint.x, componentClickPoint.y, 1);
        Util.wait(2000);
        System.out.println();
        System.out.println("+++ Component in Palette Panel should be visible and selected");
        System.out.println("+++ Left-top position in Palette Panel = " + viewPort.getViewPosition());
        System.out.println();
        DNDDriver dndDriver = new DNDDriver();
        Util.wait(1000);
        dndDriver.dnd((ComponentOperator)component, componentClickPoint, designer, designerPoint, 16, 0);
        Util.wait(3000);
        System.out.println();
        System.out.println("+++ Component should be put from Palette on Designer Pane");
        System.out.println();
    }

    public JListOperator getComponentsTree() {
        this.showComponents();
        if (this.theTree == null) {
            this.theTree = new JListOperator((ContainerOperator)this);
        }
        return this.theTree;
    }

    public void addComponent(String componentName) {
        Point clickPoint = this.getClickPoint(componentName);
        this.theTree.clickMouse(clickPoint.x, clickPoint.y, 2);
    }

    public void addComponent(String componentName, int index) {
        Point clickPoint = this.getClickPoint(componentName, index);
        this.theTree.clickMouse(clickPoint.x, clickPoint.y, 2);
    }

    public void addComponentOfClass(Class clz) {
        Point clickPoint = this.getClickPointOfClass(clz);
        this.theTree.clickMouse(clickPoint.x, clickPoint.y, 2);
        TestUtils.wait(2000);
    }

    public void addComponentOfClass(String className) {
        Point clickPoint = this.getClickPointOfClass(className);
        this.theTree.clickMouse(clickPoint.x, clickPoint.y, 2);
        TestUtils.wait(2000);
    }

    public void addComponent(String componentName, DesignerPaneOperator designer, Point location) {
        Point clickPoint = this.getClickPoint(componentName);
        JListOperator tree = this.getComponentsTree();
        if (tree.isSelectionEmpty()) {
            tree.selectItem(componentName);
        } else {
            tree.clearSelection();
            tree.selectItem(componentName);
        }
        TestUtils.wait(2000);
        designer.clickMouse(location.x, location.y, 1);
        TestUtils.wait(2000);
        designer.clickMouse(1, 100, 1);
        TestUtils.wait(2000);
        designer.clickMouse(location.x + 5, location.y + 5, 1);
        TestUtils.wait(2000);
    }

    public void addComponent(String componentName, int index, DesignerPaneOperator designer, Point location) {
        Point clickPoint = this.getClickPoint(componentName, index);
        this.getComponentsTree().clickMouse(clickPoint.x, clickPoint.y, 1);
        TestUtils.wait(2000);
        designer.clickMouse(location.x, location.y, 1);
        TestUtils.wait(2000);
    }

    public void addComponentOfClass(Class clz, DesignerPaneOperator designer, Point location) {
        Point clickPoint = this.getClickPointOfClass(clz);
        this.getComponentsTree().clickMouse(clickPoint.x, clickPoint.y, 1);
        designer.clickMouse(location.x, location.y, 1);
        TestUtils.wait(2000);
    }

    public void addComponentOfClass(String className, DesignerPaneOperator designer, Point location) {
        Point clickPoint = this.getClickPointOfClass(className);
        this.getComponentsTree().clickMouse(clickPoint.x, clickPoint.y, 1);
        designer.clickMouse(location.x, location.y, 1);
        TestUtils.wait(2000);
    }

    public void placeClip(String clipName, JEditorPaneOperator editor, int caretPosition) {
        Rectangle rect = editor.modelToView(caretPosition);
        Point location = new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
        this.dndComponentOfClass(clipName, (ComponentOperator)editor, location);
    }

    public void placeClip(String clipName, JEditorPaneOperator editor) {
        this.placeClip(clipName, editor, editor.getCaretPosition());
    }

    private String getDisplayNameOfClass(Class clz) {
        String name = null;
        try {
            name = Introspector.getBeanInfo(clz).getBeanDescriptor().getDisplayName();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (name == null) {
            name = this.getShortClassName(clz.getName());
        }
        return name;
    }

    private String getShortClassName(String className) {
        String name = null;
        StringTokenizer token = new StringTokenizer(className, ".");
        while (token.hasMoreTokens()) {
            name = token.nextToken();
        }
        return name;
    }

    public static void showPalette() {
        Util.getMainMenu().pushMenu("Window|Palette");
        new QueueTool().waitEmpty();
    }

    public static PaletteContainerOperator showPalette(String buttName, String paletteName) {
        new ShowPaletteAction().perform();
        new QueueTool().waitEmpty();
        new JToggleButtonOperator((ContainerOperator)new ToolBoxOperator(), buttName).push();
        return new PaletteContainerOperator(paletteName);
    }

    public static PaletteContainerOperator showCodeClips() {
        new ShowPaletteAction().perform();
        new QueueTool().waitEmpty();
        new JToggleButtonOperator((ContainerOperator)new ToolBoxOperator(), Bundle.getStringTrimmed((String)"com.sun.rave.toolbox.Bundle", (String)"CODE_CLIPS")).push();
        return new PaletteContainerOperator("Samples");
    }

    private static class PaletteContainerChooser
    implements ComponentChooser {
        String name;

        public PaletteContainerChooser(String name) {
            this.name = name;
        }

        public boolean checkComponent(Component comp) {
            System.out.println("Class =" + comp.getClass() + "   Name=" + comp.getClass().getName());
            return comp.getClass().getName().equals("org.netbeans.modules.palette.ui.CategoryDescriptor$1");
        }

        public String getDescription() {
            return " with \"" + this.name + "\" name";
        }
    }
}

