/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties.editors;

import java.awt.Point;
import java.awt.Robot;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.modules.visualweb.gravy.NbDialogOperator;

public class GoToLineEditorOperator
extends NbDialogOperator {
    private JLabelOperator _lblGoToLine;
    private JComboBoxOperator _cboGoToLine;
    private JButtonOperator _btGoto;
    private JButtonOperator _btClose;
    private JButtonOperator _btHelp;

    public GoToLineEditorOperator() {
        super(ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("goto-title"));
    }

    public GoToLineEditorOperator(JDialogOperator wrapper) {
        super((JDialog)wrapper.getSource());
    }

    public JLabelOperator lblGoToLine() {
        if (this._lblGoToLine == null) {
            this._lblGoToLine = new JLabelOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("goto-line"));
        }
        return this._lblGoToLine;
    }

    public JComboBoxOperator cboGoToLine() {
        if (this._cboGoToLine == null) {
            this._cboGoToLine = new JComboBoxOperator((ContainerOperator)this);
        }
        return this._cboGoToLine;
    }

    public JButtonOperator btGoto() {
        if (this._btGoto == null) {
            this._btGoto = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("goto-button-goto"));
        }
        return this._btGoto;
    }

    public JButtonOperator btClose() {
        if (this._btClose == null) {
            this._btClose = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("goto-button-cancel"));
        }
        return this._btClose;
    }

    public JButtonOperator btHelp() {
        if (this._btHelp == null) {
            this._btHelp = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.openide.explorer.propertysheet.Bundle").getString("CTL_Help"));
        }
        return this._btHelp;
    }

    public String getSelectedGoToLine() {
        return this.cboGoToLine().getSelectedItem().toString();
    }

    public void selectGoToLine(String item) {
        this.cboGoToLine().selectItem(item);
    }

    public void typeGoToLine(String text) {
        this.cboGoToLine().typeText(text);
    }

    public void goTo() {
        this.btGoto().push();
    }

    public void close() {
        this.btClose().push();
    }

    public void help() {
        this.btHelp().push();
    }

    public void verify() {
        this.lblGoToLine();
        this.cboGoToLine();
        this.btGoto();
        this.btClose();
        this.btHelp();
    }

    public static void goToLine(int line) {
        GoToLineEditorOperator op = new GoToLineEditorOperator();
        op.typeGoToLine(String.valueOf(line));
        op.goTo();
        while (op.isVisible()) {
            op.goTo();
        }
    }

    public static void goToLine(int line, Robot robot) {
        GoToLineEditorOperator op = new GoToLineEditorOperator();
        String s = String.valueOf(line);
        robot.waitForIdle();
        robot.delay(200);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            robot.keyPress(c);
            robot.delay(50);
            robot.keyRelease(c);
        }
        Point p = op.btGoto().getLocationOnScreen();
        int x = p.x + op.btGoto().getWidth() / 2;
        int y = p.y + op.btGoto().getHeight() / 2;
        robot.mouseMove(x, y);
        robot.mousePress(16);
        robot.delay(50);
        robot.mouseRelease(16);
        robot.delay(50);
        robot.waitForIdle();
        while (op.isVisible()) {
            robot.delay(50);
        }
    }

    public static void main(String[] args) {
        System.out.println("GoToLine verification finished.");
        int c = 48;
        System.out.println("Char c=" + Integer.toHexString(c));
    }
}

