/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.nodes;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.actions.Action;
import org.netbeans.modules.visualweb.gravy.actions.ActionNoBlock;
import org.openide.explorer.view.Visualizer;

public class Node {
    static final String linkSuffix = Bundle.getString((String)"org.openide.loaders.Bundle", (String)"FMT_shadowName", (Object[])new String[]{""});
    protected JTreeOperator treeOperator;
    protected TreePath treePath;
    private Operator.StringComparator comparator;

    public Node(JTreeOperator treeOperator, String treePath) {
        this(treeOperator, treeOperator.findPath(treePath, "|"));
    }

    public Node(JTreeOperator treeOperator, String treePath, String indexes) {
        this(treeOperator, treeOperator.findPath(treePath, indexes, "|"));
    }

    public Node(Node parent, String treeSubPath) {
        this(parent.tree(), parent.findSubPath(treeSubPath, "|"));
    }

    public Node(Node parent, int childIndex) {
        this(parent.tree(), parent.tree().getChildPath(parent.getTreePath(), childIndex));
    }

    public Node(JTreeOperator treeOperator, TreePath path) {
        this.treeOperator = treeOperator;
        this.treePath = path;
    }

    public void setComparator(Operator.StringComparator comparator) {
        this.comparator = comparator;
        this.tree().setComparator(comparator);
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = this.tree().getComparator();
        }
        return this.comparator;
    }

    public JTreeOperator tree() {
        return this.treeOperator;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public String getText() {
        return this.treePath.getLastPathComponent().toString();
    }

    private static String convertPath(TreePath path) {
        if (path == null) {
            return null;
        }
        int pathCount = path.getPathCount();
        if (pathCount < 2) {
            return "";
        }
        String result = path.getPathComponent(1).toString();
        for (int i = 2; i < pathCount; ++i) {
            result = result + "|" + path.getPathComponent(i).toString();
        }
        return result;
    }

    public String getPath() {
        return Node.convertPath(this.treePath);
    }

    public String getParentPath() {
        return Node.convertPath(this.treePath.getParentPath());
    }

    public Object getOpenideNode() {
        return Visualizer.findNode((Object)this.getTreePath().getLastPathComponent());
    }

    public JPopupMenuOperator callPopup() {
        return new JPopupMenuOperator(this.treeOperator.callPopupOnPath(this.treePath));
    }

    public void performMenuAction(String menuPath) {
        new Action(menuPath, null).performMenu(this);
    }

    public void performPopupAction(String popupPath) {
        new Action(null, popupPath).performPopup(this);
    }

    public void performAPIAction(String systemActionClass) {
        new Action(null, null, systemActionClass).performAPI(this);
    }

    public void performMenuActionNoBlock(String menuPath) {
        new ActionNoBlock(menuPath, null).performMenu(this);
    }

    public void performPopupActionNoBlock(String popupPath) {
        new ActionNoBlock(null, popupPath).performPopup(this);
    }

    public void performAPIActionNoBlock(String systemActionClass) {
        new ActionNoBlock(null, null, systemActionClass).performAPI(this);
    }

    public void select() {
        this.tree().selectPath(this.getTreePath());
        try {
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new JemmyException("Sleeping interrupted", (Throwable)e);
        }
    }

    public void addSelectionPath() {
        this.tree().addSelectionPath(this.getTreePath());
    }

    public boolean isLeaf() {
        return this.tree().getChildCount(this.treePath) < 1;
    }

    public String[] getChildren() {
        this.tree().expandPath(this.treePath);
        Object[] o = this.tree().getChildren(this.treePath.getLastPathComponent());
        if (o == null) {
            return new String[0];
        }
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = o[i].toString();
        }
        return s;
    }

    public boolean isLink() {
        return this.getText().endsWith(linkSuffix);
    }

    public boolean isPresent() {
        this.tree().expandPath(this.treePath.getParentPath());
        return this.tree().getRowForPath(this.treePath) >= 0;
    }

    public void verifyPopup(String popupPath) {
        this.verifyPopup(new String[]{popupPath});
    }

    public void verifyPopup(String[] popupPaths) {
        final JPopupMenuOperator popup = this.callPopup();
        for (int i = 0; i < popupPaths.length; ++i) {
            try {
                popup.showMenuItem(popupPaths[i], "|");
                continue;
            }
            catch (NullPointerException npe) {
                throw new JemmyException("Popup path [" + popupPaths[i] + "] not found.");
            }
        }
        popup.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                try {
                    popup.pushKey(27);
                    return false;
                }
                catch (JemmyException jemmyException) {
                    return true;
                }
            }

            public String getDescription() {
                return "Popup menu closer";
            }
        });
    }

    TreePath findSubPath(String subPath, String delimiter) {
        return this.findSubPath(subPath, "", delimiter);
    }

    TreePath findSubPath(String subPath, String indexes, String delimiter) {
        JTreeOperator o = this.tree();
        String[] indexStr = o.parseString(indexes, delimiter);
        int[] indexInt = new int[indexStr.length];
        for (int i = 0; i < indexStr.length; ++i) {
            indexInt[i] = Integer.parseInt(indexStr[i]);
        }
        return o.findPath((JTreeOperator.TreePathChooser)new StringArraySubPathChooser(this.treePath, o.parseString(subPath, delimiter), indexInt, this.getComparator()));
    }

    public void expand() {
        this.treeOperator.expandPath(this.treePath);
        this.waitExpanded();
    }

    public void collapse() {
        this.treeOperator.collapsePath(this.treePath);
        this.waitCollapsed();
    }

    public void waitExpanded() {
        this.treeOperator.waitExpanded(this.treePath);
    }

    public void waitCollapsed() {
        this.treeOperator.waitCollapsed(this.treePath);
    }

    public boolean isExpanded() {
        return this.treeOperator.isExpanded(this.treePath);
    }

    public boolean isCollapsed() {
        return this.treeOperator.isCollapsed(this.treePath);
    }

    public void verifyPopup(Action[] actions) {
        ArrayList<String> popupPaths = new ArrayList<String>();
        for (int i = 0; i < actions.length; ++i) {
            String path = actions[i].getPopupPath();
            if (path == null) continue;
            popupPaths.add(path);
        }
        this.verifyPopup(popupPaths.toArray(new String[0]));
    }

    public boolean isChildPresent(String childName) {
        String[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!this.getComparator().equals(children[i], childName)) continue;
            return true;
        }
        return false;
    }

    public void waitChildNotPresent(final String childName) {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object anObject) {
                    return Node.this.isChildPresent(childName) ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Child \"" + childName + "\" not present under parent \"" + Node.this.getPath() + "\"";
                }
            }).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    public void waitNotPresent() {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object anObject) {
                    return Node.this.isPresent() ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Wait node " + Node.this.getPath() + " not present.";
                }
            }).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    class StringArraySubPathChooser
    implements JTreeOperator.TreePathChooser {
        String[] arr;
        int[] indices;
        Operator.StringComparator comparator;
        TreePath parentPath;
        int parentPathCount;

        StringArraySubPathChooser(TreePath parentPath, String[] arr, int[] indices, Operator.StringComparator comparator) {
            this.arr = arr;
            this.comparator = comparator;
            this.indices = indices;
            this.parentPath = parentPath;
            this.parentPathCount = parentPath.getPathCount();
        }

        public boolean checkPath(TreePath path, int indexInParent) {
            return path.getPathCount() == this.arr.length + this.parentPathCount && this.hasAsParent(path, indexInParent);
        }

        public boolean hasAsParent(TreePath path, int indexInParent) {
            if (path.getPathCount() <= this.parentPathCount) {
                return path.isDescendant(this.parentPath);
            }
            if (this.arr.length + this.parentPathCount < path.getPathCount()) {
                return false;
            }
            if (this.indices.length >= path.getPathCount() - this.parentPathCount && this.indices[path.getPathCount() - this.parentPathCount - 1] != indexInParent) {
                return false;
            }
            Object[] comps = path.getPath();
            for (int i = this.parentPathCount; i < comps.length; ++i) {
                if (this.comparator.equals(comps[i].toString(), this.arr[i - this.parentPathCount])) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            int i;
            String desc = "";
            Object[] parr = this.parentPath.getPath();
            for (i = 0; i < parr.length; ++i) {
                desc = desc + parr[i].toString() + ", ";
            }
            for (i = 0; i < this.arr.length; ++i) {
                desc = desc + this.arr[i] + ", ";
            }
            if (desc.length() > 0) {
                desc = desc.substring(0, desc.length() - 2);
            }
            return "[ " + desc + " ]";
        }
    }
}

