/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.deployment;

import org.netbeans.jemmy.JemmyException;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.ServerNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.model.deployment.DeploymentTarget;
import org.netbeans.modules.visualweb.gravy.model.deployment.DeploymentTargetDescriptor;
import org.netbeans.modules.visualweb.gravy.model.deployment.DeploymentTargetFactory;
import org.netbeans.modules.visualweb.gravy.model.deployment.JBoss4;
import org.netbeans.modules.visualweb.gravy.model.deployment.SunApplicationServer;
import org.netbeans.modules.visualweb.gravy.model.deployment.Tomcat50;
import org.netbeans.modules.visualweb.gravy.model.deployment.Tomcat55;
import org.netbeans.modules.visualweb.gravy.model.deployment.Tomcat60;
import org.netbeans.modules.visualweb.gravy.model.deployment.WebLogic9;

public class DefaultDeploymentTargetFactory
extends DeploymentTargetFactory {
    private static DefaultDeploymentTargetFactory defaultDTFactory;

    public static DefaultDeploymentTargetFactory getFactory() {
        if (defaultDTFactory != null) {
            return defaultDTFactory;
        }
        defaultDTFactory = new DefaultDeploymentTargetFactory();
        return defaultDTFactory;
    }

    protected DeploymentTarget createInstance(DeploymentTargetDescriptor DTDescriptor) {
        try {
            ServerNavigatorOperator.addDeploymentTarget(DTDescriptor);
        }
        catch (Exception e) {
            throw new JemmyException("Deployment Target can't be added!", (Throwable)e);
        }
        String serverType = DTDescriptor.getProperty("deployment.target.type");
        if (serverType.equals("BEA WebLogic Server")) {
            return new WebLogic9(DTDescriptor);
        }
        if (serverType.equals("JBoss Application Server")) {
            return new JBoss4(DTDescriptor);
        }
        if (serverType.equals("GlassFish V1") || serverType.equals("GlassFish V2") || serverType.equals("Sun Java System Application Server")) {
            return new SunApplicationServer(DTDescriptor);
        }
        if (serverType.equals("Tomcat 5.0")) {
            return new Tomcat50(DTDescriptor);
        }
        if (serverType.equals("Tomcat 5.5")) {
            return new Tomcat55(DTDescriptor);
        }
        if (serverType.equals("Tomcat 6.0")) {
            return new Tomcat60(DTDescriptor);
        }
        return null;
    }
}

