/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.AWTEvent;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.DefaultVisualizer;
import org.netbeans.jemmy.util.NameComponentChooser;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.visualweb.gravy.MainWindowOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.openide.actions.SaveAllAction;

public class Util {
    public static final String WINDOWS_OS_FAMILY_NAME = "Windows";
    public static final String LINUX_OS_FAMILY_NAME = "Linux";
    public static final String SUN_OS_FAMILY_NAME = "SunOS";
    public static final String MAC_OS_FAMILY_NAME = "Mac";
    static MainWindowOperator mainWindow;
    static JMenuBarOperator mainMenu;

    public static double getDelayScale() {
        String s = System.getProperty("Env-RaveTestsDelayScale", "1");
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindowsOS() {
        String osName = Util.getOperatingSystemName();
        return osName.toUpperCase().indexOf(WINDOWS_OS_FAMILY_NAME.toUpperCase()) > -1;
    }

    public static boolean isSunOS() {
        String osName = Util.getOperatingSystemName();
        return osName.toUpperCase().indexOf(SUN_OS_FAMILY_NAME.toUpperCase()) > -1;
    }

    public static boolean isMacOS() {
        String osName = Util.getOperatingSystemName();
        return osName.toUpperCase().indexOf(MAC_OS_FAMILY_NAME.toUpperCase()) > -1;
    }

    public static MainWindowOperator getMainWindow() {
        if (mainWindow == null) {
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)new DefaultVisualizer());
            mainWindow = new MainWindowOperator();
        }
        return mainWindow;
    }

    public static JMenuBarOperator getMainMenu() {
        if (mainMenu == null) {
            mainMenu = new JMenuBarOperator((ContainerOperator)Util.getMainWindow());
        }
        return mainMenu;
    }

    public static JTabbedPaneOperator getMainTab() {
        return new JTabbedPaneOperator(new ContainerOperator((ContainerOperator)Util.getMainWindow(), (ComponentChooser)new NameComponentChooser("mainTab")));
    }

    public static void selectTab(String tabName) {
        new TopComponentOperator(tabName);
    }

    public static String generateTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        return "" + calendar.get(1) + calendar.get(2) + calendar.get(5) + calendar.get(11) + calendar.get(12) + calendar.get(13);
    }

    public static void closeWindow() {
        new Action(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/Window").substring(1) + "|" + Bundle.getStringTrimmed((String)"org.netbeans.core.windows.actions.Bundle", (String)"LBL_CloseWindowAction"), null).performMenu();
    }

    public static void saveAll() {
        JMenuItemOperator saveAll = Util.getMainMenu().showMenuItem(new String[]{"File", "Save All"});
        if (saveAll.isEnabled()) {
            Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + "|" + Bundle.getStringTrimmed((String)"com.sun.rave.gravy.project.actions.Bundle", (String)"LBL_SaveAllAction"));
        }
    }

    public static void saveAllAPICall() {
        ((SaveAllAction)SaveAllAction.findObject(SaveAllAction.class, (boolean)true)).performAction();
    }

    public static long getExecutionTime() {
        String execTime = System.getProperty("xtest.ide.execution.time");
        if (execTime != null) {
            System.out.println("Property = " + execTime);
            int[] comps = new int[6];
            StringTokenizer token = new StringTokenizer(execTime, ":");
            for (int i = 0; i < 6; ++i) {
                comps[i] = Integer.parseInt(token.nextToken());
            }
            Calendar calend = Calendar.getInstance();
            calend.set(comps[0], comps[1] - 1, comps[2], comps[3], comps[4], comps[5]);
            long result = calend.getTimeInMillis();
            System.out.print("Execution time: " + calend.toString());
            System.out.println(" = " + result);
            return result;
        }
        throw new RuntimeException("xtest.ide.execution.time property is empty");
    }

    public static long getCurrentTime() {
        Calendar calend = Calendar.getInstance();
        long result = calend.getTimeInMillis();
        System.out.print("Current time: " + calend.toString());
        System.out.println(" = " + result);
        return result;
    }

    public static void savePerformanceData(NbTestCase test, String id, long startTime, long endTime) {
        System.out.println("Time diff is " + (endTime - startTime));
        System.out.println("Saving it into " + test.getName() + ".perfdata");
        test.getLog(test.getName() + ".perfdata").print(test.getName() + "." + id + " = ");
        test.getLog(test.getName() + ".perfdata").println(endTime - startTime);
    }

    public static void savePerformanceData(NbTestCase test, String id, long startTime) {
        Util.savePerformanceData(test, id, startTime, Util.getCurrentTime());
    }

    public static void wait(int millisec) {
        millisec = new Double((double)millisec * Util.getDelayScale()).intValue();
        System.out.println("Delay scale() = " + Util.getDelayScale());
        System.out.println("Sleep to " + millisec / 1000 + " seconds");
        EventDispatcher.waitQueueEmpty();
        try {
            Thread.sleep(millisec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventDispatcher.waitQueueEmpty();
    }

    public static void waitKeyboardEvent() {
        Util.waitKeyboardEvent(1200000L);
    }

    public static void waitKeyboardEvent(long delay) {
        String interactiveTestMode = System.getProperty("interactive.test.mode");
        if (interactiveTestMode == null || !interactiveTestMode.equalsIgnoreCase("Yes")) {
            return;
        }
        Waiter kbdWaiter = Util.getKeyboardEventWaiter();
        kbdWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", delay);
        try {
            kbdWaiter.waitAction(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Waiter getKeyboardEventWaiter() {
        String msgKeyWasPressed = "Key was pressed";
        Waiter kbdWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                AWTEvent awtEvent = null;
                try {
                    awtEvent = EventTool.getLastEvent();
                }
                catch (Exception e) {
                    TestUtils.outMsg("+++ Exception was thrown = " + e.getMessage());
                    e.printStackTrace();
                    return e.getMessage();
                }
                Util.wait(1000);
                new QueueTool().waitEmpty();
                if (awtEvent.getID() == 402) {
                    TestUtils.outMsg("+++ Key was pressed");
                    return "Key was pressed";
                }
                return null;
            }

            public String getDescription() {
                return "Waiting for key press...";
            }
        });
        return kbdWaiter;
    }
}

