/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.util.BasicSAPConverter;
import com.sap.mw.jco.util.SAPByteToCharConverter;

public class SAPUCBEByteToCharConverter
extends BasicSAPConverter
implements SAPByteToCharConverter {
    protected SAPUCBEByteToCharConverter(String charEncoding) {
        super(charEncoding);
        this.codepageType = (byte)3;
    }

    public int convert(byte[] in, int inBeginIndex, int inEndIndex, char[] out, int outBeginIndex, int outEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        if (outBeginIndex < 0) {
            return 0;
        }
        if (outBeginIndex >= out.length) {
            return 0;
        }
        if (outEndIndex >= out.length) {
            outEndIndex = out.length - 1;
        }
        if (outBeginIndex > outEndIndex) {
            return 0;
        }
        int inIndex = inBeginIndex;
        int outIndex = outBeginIndex;
        while (inIndex + 1 <= inEndIndex && outIndex <= outEndIndex) {
            out[outIndex] = (char)(in[inIndex++] << 8);
            int n = outIndex++;
            out[n] = (char)(out[n] | in[inIndex++] & 0xFF);
        }
        return outIndex - outBeginIndex;
    }

    public char[] convert(byte[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return new char[0];
        }
        if (inBeginIndex < 0) {
            return new char[0];
        }
        if (inBeginIndex >= in.length) {
            return new char[0];
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return new char[0];
        }
        int outLength = this.outLength(in, inBeginIndex, inEndIndex);
        char[] out = new char[outLength];
        this.convert(in, inBeginIndex, inEndIndex, out, 0, outLength - 1);
        return out;
    }

    public char[] convert(byte[] in) {
        if (in == null) {
            return new char[0];
        }
        int outLength = this.outLength(in, 0, in.length - 1);
        char[] out = new char[outLength];
        this.convert(in, 0, in.length - 1, out, 0, outLength - 1);
        return out;
    }

    public int outLength(byte[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        return (inEndIndex - inBeginIndex + 1) / 2;
    }

    public int outLength(byte[] in) {
        if (in == null) {
            return 0;
        }
        return this.outLength(in, 0, in.length - 1);
    }
}

