/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.jdsr.writer.DsrFactory;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.mw.jco.IExtendedFieldMetaData;
import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.IMiddleware;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.IServerThread;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.rfc.MiddlewareRFC;
import com.sap.mw.jco.util.Codecs;
import com.sap.mw.jco.util.Dsr;
import com.sap.mw.jco.util.Jarm;
import com.sap.mw.jco.util.LimitedList;
import com.sap.mw.jco.util.ObjectList;
import com.sap.mw.jco.util.SyncDateFormat;
import com.sap.mw.jco.util.TraceWriter;
import com.sap.mw.jco.util.XMLReaderBase;
import com.sap.mw.jco.util.XMLWriterBase;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public class JCO {
    private static final String VERSION = "2.1.7 (2006-06-12)";
    private static final boolean JCO_STANDALONE = true;
    protected static final long SERIAL_VERSION_UID = 110011052001L;
    protected static String middleware_layer = "com.sap.mw.jco.rfc.MiddlewareRFC";
    protected static Class middleware_class;
    protected static IMiddleware middleware;
    public static final int UNINITIALIZED = -1;
    public static final int TYPE_INVALID = -1;
    public static final int TYPE_CHAR = 0;
    public static final int TYPE_DATE = 1;
    public static final int TYPE_BCD = 2;
    public static final int TYPE_TIME = 3;
    public static final int TYPE_BYTE = 4;
    public static final int TYPE_ITAB = 5;
    public static final int TYPE_NUM = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_INT = 8;
    public static final int TYPE_INT2 = 9;
    public static final int TYPE_INT1 = 10;
    public static final int TYPE_STRING = 29;
    public static final int TYPE_XSTRING = 30;
    public static final int TYPE_STRUCTURE = 17;
    public static final int TYPE_TABLE = 99;
    public static final int TYPE_EXCEPTION = 98;
    public static final char IDOC_VERSION_DEFAULT = '0';
    public static final char IDOC_VERSION_2 = '2';
    public static final char IDOC_VERSION_3 = '3';
    protected static final int TYPE_ITEM = 133;
    public static final int IMPORT_PARAMETER = 1;
    public static final int EXPORT_PARAMETER = 2;
    public static final int OPTIONAL_PARAMETER = 4;
    public static final int UNINITIALIZED_PARAMETER = 8;
    public static final int INACTIVE_PARAMETER = 16;
    protected static final int OMITTED_PARAMETER = 32;
    protected static final int HIDDEN_PARAMETER = 64;
    public static final byte STATE_DISCONNECTED = 1;
    public static final byte STATE_CONNECTED = 2;
    public static final byte STATE_STOPPED = 1;
    public static final byte STATE_STARTED = 2;
    public static final byte STATE_BUSY = 4;
    public static final byte STATE_LISTENING = 8;
    public static final byte STATE_USED = 16;
    public static final byte STATE_TRANSACTION = 32;
    public static final byte STATE_SUSPENDED = 64;
    public static final byte SNC_OPEN = 1;
    public static final byte SNC_INTEGRITY = 2;
    public static final byte SNC_PRIVACY = 3;
    public static final byte SNC_DEFAULT = 8;
    public static final byte SNC_MAX = 9;
    private static final String JCO_VERSION = "jco.version";
    private static final String JCO_TRACE_LEVEL = "jco.trace_level";
    private static final String JCO_TRACE_PATH = "jco.trace_path";
    private static final String JCO_HTML_TABLE_MAX_ROWS = "jco.html.table_max_rows";
    private static final String JCO_HTML_BACKGROUND = "jco.html.background";
    private static final String JCO_HTML_TABLE_HEADER_BACKGROUND1 = "jco.html.table_header_background1";
    private static final String JCO_HTML_TABLE_HEADER_FOREGROUND1 = "jco.html.table_header_foreground1";
    private static final String JCO_HTML_TABLE_HEADER_BACKGROUND2 = "jco.html.table_header_background2";
    private static final String JCO_HTML_TABLE_HEADER_FOREGROUND2 = "jco.html.table_header_foreground2";
    private static final String JCO_HTML_TABLE_HEADER_BACKGROUND3 = "jco.html.table_header_background3";
    private static final String JCO_HTML_TABLE_BORDER = "jco.html.table_border";
    private static final String JCO_HTML_TABLE_ROW_BACKGROUND1 = "jco.html.table_row_background1";
    private static final String JCO_HTML_TABLE_ROW_BACKGROUND2 = "jco.html.table_row_background2";
    private static final String JCO_HTML_FONT_FACE = "jco.html.font_face";
    private static final String JCO_HTML_FONT_SIZE = "jco.html.font_size";
    private static final String JCO_JDSR_COMP_NAME = "jco.jdsr.comp_name";
    private static final String JCO_JDSR = "jco.jdsr";
    private static final String JCO_JARM = "jco.jarm";
    private static final String JCO_WEBAS_JDSR = "jco.webas.jdsr";
    private static final String JCO_WEBAS_IGNORE_JDSR_ERROR = "jco.webas.ignore_jdsr_error";
    private static final String[][] pinfo;
    protected static final Properties properties;
    private static int jco_mode;
    private static final int MONITOR_JARM = 1;
    private static final int MONITOR_JDSR = 2;
    private static final int MONITOR_WEBAS_JDSR = 4;
    private static final int MONITOR_ON = 7;
    private static final int WEBAS_IGNORE_JDSR_ERROR = 16;
    protected static int trace_level;
    protected static final String CRLF;
    private static Vector trace_listeners;
    private static Vector server_exception_listeners;
    private static Vector server_error_listeners;
    private static Vector server_state_changed_listeners;

    protected static byte getJCOType(char type) {
        switch (type) {
            case 'C': {
                return 0;
            }
            case 'I': {
                return 8;
            }
            case 'N': {
                return 6;
            }
            case 'P': {
                return 2;
            }
            case 'D': {
                return 1;
            }
            case 'T': {
                return 3;
            }
            case 'F': {
                return 7;
            }
            case 'X': {
                return 4;
            }
            case 'g': {
                return 29;
            }
            case 'y': {
                return 30;
            }
            case 's': {
                return 9;
            }
            case 'b': {
                return 10;
            }
            case 'u': {
                return 17;
            }
            case 'v': {
                return 17;
            }
            case 'h': {
                return 99;
            }
            case 'E': {
                return 98;
            }
        }
        return -1;
    }

    protected static char getJCOTypeChar(int type) {
        switch (type) {
            case 0: {
                return 'C';
            }
            case 8: {
                return 'I';
            }
            case 6: {
                return 'N';
            }
            case 2: {
                return 'P';
            }
            case 1: {
                return 'D';
            }
            case 3: {
                return 'T';
            }
            case 7: {
                return 'F';
            }
            case 4: {
                return 'X';
            }
            case 29: {
                return 'g';
            }
            case 30: {
                return 'y';
            }
            case 9: {
                return 's';
            }
            case 10: {
                return 'b';
            }
            case 17: {
                return 'u';
            }
            case 99: {
                return 'h';
            }
            case 98: {
                return 'E';
            }
        }
        return 'C';
    }

    protected static String getJCOTypeString(int type) {
        switch (type) {
            case 0: {
                return "CHAR";
            }
            case 8: {
                return "INT";
            }
            case 6: {
                return "NUM";
            }
            case 2: {
                return "BCD";
            }
            case 1: {
                return "DATE";
            }
            case 3: {
                return "TIME";
            }
            case 7: {
                return "FLOAT";
            }
            case 4: {
                return "BYTE";
            }
            case 29: {
                return "STRING";
            }
            case 30: {
                return "XSTRING";
            }
            case 9: {
                return "INT2";
            }
            case 10: {
                return "INT1";
            }
            case 17: {
                return "STRUCTURE";
            }
            case 99: {
                return "TABLE";
            }
            case 98: {
                return "EXCEPTION";
            }
        }
        return "CHAR";
    }

    protected JCO() {
    }

    public static void testCodepage(String codepage) {
        JCO.testCodepage(codepage, 0);
    }

    public static void testCodepage(String codepage, int mode) {
        if (!(middleware instanceof MiddlewareRFC)) {
            return;
        }
        MiddlewareRFC mw = (MiddlewareRFC)middleware;
        char[] wchar = new char[1];
        StringBuffer buffer = new StringBuffer();
        int uc = 0;
        while (uc <= 65535) {
            block11: {
                wchar[0] = (char)uc;
                String s = new String(wchar);
                try {
                    byte[] bytes = s.getBytes(codepage);
                    if (bytes == null || bytes.length == 0) break block11;
                    if (bytes.length == 1 && bytes[0] == 63 && uc != 63) {
                    }
                }
                catch (java.lang.Exception ex) {}
                break block11;
                buffer.append((char)uc);
            }
            ++uc;
        }
        String unicode_charset = buffer.toString();
        System.out.println("Found " + unicode_charset.length() + " convertable characters for codepage " + codepage);
        try {
            char[] chars_in_j = unicode_charset.toCharArray();
            byte[] bytes_in_j = unicode_charset.getBytes(codepage);
            char[] chars_out_j = unicode_charset.toCharArray();
            byte[] bytes_out_j = unicode_charset.getBytes(codepage);
            char[] chars_out_c = new char[chars_in_j.length];
            byte[] bytes_out_c = new byte[bytes_in_j.length];
            MiddlewareRFC.testCodepage(bytes_in_j, chars_out_c, chars_in_j, bytes_out_c, codepage, mode);
            System.out.println("Checking unicode to bytes conversion");
            int num_errors = 0;
            int i = 0;
            while (i < bytes_out_j.length) {
                if (bytes_out_j[i] != bytes_out_c[i]) {
                    System.out.println("Byte " + Codecs.Hex.encode(bytes_out_j[i]) + " != " + Codecs.Hex.encode(bytes_out_c[i]) + " at " + i);
                    ++num_errors;
                }
                ++i;
            }
            System.out.println(num_errors + " char-to-byte errors out of " + bytes_out_j.length + " bytes in codepage " + codepage);
            System.out.println("Checking bytes to unicode conversion");
            num_errors = 0;
            int i2 = 0;
            while (i2 < chars_out_j.length) {
                if (chars_out_j[i2] != chars_out_c[i2]) {
                    System.out.println("!!! Char " + Codecs.Hex.encode(chars_out_j[i2]) + " != " + Codecs.Hex.encode(chars_out_c[i2]) + " at " + i2);
                    ++num_errors;
                }
                ++i2;
            }
            System.out.println(num_errors + " byte-to-char errors out of " + chars_out_j.length + " chars  in codepage " + codepage);
        }
        catch (java.lang.Exception ex) {
            JCO.fireTrace(0, "[JAV-LAYER] JCO.testCodepageConverter: Could not convert " + codepage);
            ex.printStackTrace();
            return;
        }
        System.out.println("Done with codepage " + codepage);
    }

    public static final IMiddleware getMiddlewareImplementation() {
        return middleware;
    }

    public static final String getMiddlewareLayer() {
        return middleware_layer;
    }

    public static final void setMiddlewareLayer(String middleware_layer) {
        if (middleware_class != null && middleware_class.getName().equals(middleware_layer)) {
            return;
        }
        JCO.middleware_layer = middleware_layer;
        try {
            middleware_class = Class.forName(middleware_layer);
            middleware = (IMiddleware)middleware_class.newInstance();
        }
        catch (java.lang.Exception ex) {
            JCO.fireTrace(0, "[JAV-LAYER] JCO.classInitialize(): Could not load middleware layer '" + JCO.middleware_layer + "'" + CRLF + ex.getMessage());
            throw new Exception(106, "JCO_ERROR_RESOURCE", ex.getMessage());
        }
    }

    public static final String getVersion() {
        return JCO.getProperty(JCO_VERSION);
    }

    public static final String[][] getPropertyInfo() {
        return pinfo;
    }

    public static final Properties getProperties() {
        return properties;
    }

    public static final String getProperty(String key) {
        return (String)((Hashtable)properties).get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setProperty(String key, String value) {
        if (trace_level > 0) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] JCO.setProperty(").append(key == null ? "null" : key).append(", ").append(value == null ? "null" : value).append(")");
            if (trace_level > 1) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                Throwable t = new Throwable();
                t.fillInStackTrace();
                t.printStackTrace(pw);
                pw.close();
                buf.append(CRLF);
                buf.append("-------------- Trace of where JCO.Pool.setProperty(").append(key == null ? "null" : key).append(", ").append(value == null ? "null" : value).append(") was called -----------------");
                buf.append(sw.getBuffer().delete(0, "java.lang.Throwable".length()).toString());
                buf.append("--------------------------------------------------------------------------");
            }
            JCO.fireTrace(1, buf.toString());
        }
        if (key == null || value == null) {
            return;
        }
        if (JCO_JARM.equals(key)) {
            if (!value.equals("0") && !value.equals("1")) throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for " + JCO_JARM + " are 0 or 1.");
            if (!properties.getProperty(JCO_JARM, "0").equals(value)) {
                Jarm.setState(value);
                JCO.setMiddlewareProperty("jco.middleware.monitoring", value);
                jco_mode = value.equals("0") ? (jco_mode &= 0xFFFFFFFE) : (jco_mode |= 1);
            }
        } else if (JCO_JDSR.equals(key)) {
            if (!value.equals("0") && !value.equals("1")) throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for " + JCO_JDSR + " are 0 or 1.");
            if (!properties.getProperty(JCO_JDSR, "0").equals(value)) {
                Dsr.setState(value);
                JCO.setMiddlewareProperty("jco.middleware.monitoring", value);
                jco_mode = value.equals("0") ? (jco_mode &= 0xFFFFFFFD) : (jco_mode |= 2);
            }
        } else if (JCO_JDSR_COMP_NAME.equals(key)) {
            Dsr.setDsrComponentName(value);
        } else if (JCO_WEBAS_JDSR.equals(key)) {
            if (!value.equals("0") && !value.equals("1")) throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Allowed values for " + JCO_WEBAS_JDSR + " are 0 or 1.");
            if (!properties.getProperty(JCO_WEBAS_JDSR, "0").equals(value)) {
                JCO.setMiddlewareProperty("jco.middleware.monitoring", value);
                jco_mode = value.equals("0") ? (jco_mode &= 0xFFFFFFFB) : (jco_mode |= 4);
            }
        } else if (JCO_WEBAS_IGNORE_JDSR_ERROR.equals(key)) {
            if (value.equals("0") || value.equals("1")) {
                jco_mode = value.equals("0") ? (jco_mode &= 0xFFFFFFEF) : (jco_mode |= 0x10);
            }
        } else if (JCO_TRACE_LEVEL.equals(key)) {
            if (value != null) {
                int system_trace_level = 0;
                trace_level = Integer.parseInt(value);
                try {
                    system_trace_level = Integer.parseInt(JCO.getProperty("SYSTEM_jco.trace_level"));
                }
                catch (RuntimeException ex) {
                    system_trace_level = 0;
                }
                if (trace_level >= system_trace_level) {
                    if (trace_level == 0) {
                        TraceWriter.stop();
                    }
                    middleware.setTraceLevel(trace_level);
                } else {
                    JCO.fireTrace(1, "[JAV-LAYER] WARNING: Ignore the trace level " + trace_level + ", because the system trace level " + system_trace_level + " is set");
                }
            }
        } else if (JCO_TRACE_PATH.equals(key) && value != null) {
            String system_trace_path = JCO.getProperty("SYSTEM_jco.trace_path");
            if (system_trace_path == null) {
                TraceWriter.start(value);
            } else {
                JCO.fireTrace(1, "[JAV-LAYER] WARNING: Ignore the trace path " + value + ", because the system trace path " + system_trace_path + " is set");
            }
        }
        ((Hashtable)properties).put(key, value);
    }

    public static final String getMiddlewareVersion() {
        return middleware.getVersion();
    }

    public static final String getMiddlewareProperty(String key) {
        return middleware.getProperty(key);
    }

    public static final void setMiddlewareProperty(String key, String value) {
        middleware.setProperty(key, value);
    }

    public static final String[][] getMiddlewarePropertyInfo() {
        return middleware.getPropertyInfo();
    }

    public static int getTraceLevel() {
        return trace_level;
    }

    public static void setTraceLevel(int level) {
        JCO.setProperty(JCO_TRACE_LEVEL, String.valueOf(level));
    }

    public static void setTracePath(String path) {
        JCO.setProperty(JCO_TRACE_PATH, path);
    }

    public static void addTraceListener(TraceListener listener) {
        Vector vector = trace_listeners;
        synchronized (vector) {
            trace_listeners.addElement(listener);
        }
    }

    public static void removeTraceListener(TraceListener listener) {
        Vector vector = trace_listeners;
        synchronized (vector) {
            trace_listeners.removeElement(listener);
        }
    }

    public static void fireTrace(int level, String message) {
        block8: {
            try {
                if (level > trace_level) {
                    return;
                }
                if (trace_listeners == null || trace_listeners.size() == 0) {
                    System.out.println(message);
                    break block8;
                }
                Vector vector = trace_listeners;
                synchronized (vector) {
                    Vector list = (Vector)trace_listeners.clone();
                    Enumeration e = list.elements();
                    while (e.hasMoreElements()) {
                        TraceListener listener = (TraceListener)e.nextElement();
                        listener.trace(level, message);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addServerExceptionListener(ServerExceptionListener listener) {
        Vector vector = server_exception_listeners;
        synchronized (vector) {
            server_exception_listeners.addElement(listener);
        }
    }

    public static void removeServerExceptionListener(ServerExceptionListener listener) {
        Vector vector = server_exception_listeners;
        synchronized (vector) {
            server_exception_listeners.removeElement(listener);
        }
    }

    protected static void fireServerExceptionOccurred(Server server, java.lang.Exception exception) {
        Vector list;
        if (server_exception_listeners == null || server_exception_listeners.size() == 0) {
            return;
        }
        Vector vector = server_exception_listeners;
        synchronized (vector) {
            list = (Vector)server_exception_listeners.clone();
        }
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ServerExceptionListener listener = (ServerExceptionListener)e.nextElement();
            listener.serverExceptionOccurred(server, exception);
        }
    }

    public static void addServerErrorListener(ServerErrorListener listener) {
        Vector vector = server_error_listeners;
        synchronized (vector) {
            server_error_listeners.addElement(listener);
        }
    }

    public static void removeServerErrorListener(ServerErrorListener listener) {
        Vector vector = server_error_listeners;
        synchronized (vector) {
            server_error_listeners.removeElement(listener);
        }
    }

    protected static void fireServerErrorOccurred(Server server, Error error) {
        Vector list;
        if (server_error_listeners == null || server_error_listeners.size() == 0) {
            return;
        }
        Vector vector = server_error_listeners;
        synchronized (vector) {
            list = (Vector)server_error_listeners.clone();
        }
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ServerErrorListener listener = (ServerErrorListener)e.nextElement();
            listener.serverErrorOccurred(server, error);
        }
    }

    public static void addServerStateChangedListener(ServerStateChangedListener listener) {
        Vector vector = server_state_changed_listeners;
        synchronized (vector) {
            server_state_changed_listeners.addElement(listener);
        }
    }

    public static void removeServerStateChangedListener(ServerStateChangedListener listener) {
        Vector vector = server_state_changed_listeners;
        synchronized (vector) {
            server_state_changed_listeners.removeElement(listener);
        }
    }

    protected static void fireServerStateChangeOccurred(Server server, int old_state, int new_state) {
        Vector list;
        if (server_state_changed_listeners == null || server_state_changed_listeners.size() == 0) {
            return;
        }
        Vector vector = server_state_changed_listeners;
        synchronized (vector) {
            list = (Vector)server_state_changed_listeners.clone();
        }
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            ServerStateChangedListener listener = (ServerStateChangedListener)e.nextElement();
            listener.serverStateChangeOccurred(server, old_state, new_state);
        }
    }

    public static Client createClient(Properties properties) {
        return new Client(properties);
    }

    public static Client createClient(String[][] params) {
        return new Client(params);
    }

    public static Client createClient(String client, String user, String passwd, String lang, String ashost, String sysnr) {
        return new Client(client, user, passwd, lang, ashost, sysnr);
    }

    public static Client createClient(String client, String user, String passwd, String lang, String ashost, String sysnr, String gwhost, String gwserv) {
        return new Client(client, user, passwd, lang, ashost, sysnr, gwhost, gwserv);
    }

    public static Client createClient(String client, String user, String passwd, String lang, String mshost, String r3name, String group) {
        return new Client(client, user, passwd, lang, mshost, r3name, group);
    }

    public static Client createClient(String client, String user, String passwd, String lang, String url) {
        return new Client(client, user, passwd, lang, url);
    }

    public static Client createClient(String gwhost, String gwserv, String tpname) {
        return new Client(gwhost, gwserv, tpname);
    }

    public static Client createClient(String gwhost, String gwserv, String tpname, String tphost) {
        return new Client(gwhost, gwserv, tpname, tphost);
    }

    public static PoolManager getClientPoolManager() {
        return PoolManager.singleton();
    }

    public static void addClientPool(String key, int max_connections, String[][] params) {
        JCO.getClientPoolManager().addPool(key, new Client(params), max_connections);
    }

    public static void addClientPool(String key, int max_connections, Properties properties) {
        PoolManager.singleton().addPool(key, new Client(properties), max_connections);
    }

    public static void addClientPool(String key, int max_connections, String client, String user, String passwd, String lang, String ashost, String sysnr) {
        JCO.getClientPoolManager().addPool(key, new Client(client, user, passwd, lang, ashost, sysnr), max_connections);
    }

    public static void addClientPool(String key, int max_connections, String client, String user, String passwd, String lang, String ashost, String sysnr, String gwhost, String gwserv) {
        JCO.getClientPoolManager().addPool(key, new Client(client, user, passwd, lang, ashost, sysnr, gwhost, gwserv), max_connections);
    }

    public static void addClientPool(String key, int max_connections, String client, String user, String passwd, String lang, String mshost, String r3name, String group) {
        JCO.getClientPoolManager().addPool(key, new Client(client, user, passwd, lang, mshost, r3name, group), max_connections);
    }

    public static void addClientPool(String key, int max_connections, String gwhost, String gwserv, String tpname) {
        JCO.getClientPoolManager().addPool(key, new Client(gwhost, gwserv, tpname), max_connections);
    }

    public static void addClientPool(String key, int max_connections, String gwhost, String gwserv, String tpname, String tphost) {
        JCO.getClientPoolManager().addPool(key, new Client(gwhost, gwserv, tpname, tphost), max_connections);
    }

    public static void removeClientPool(String key) {
        JCO.getClientPoolManager().removePool(key);
    }

    public static Client getClient(String key) {
        return PoolManager.singleton().getClient(key);
    }

    public static Client getClient(String key, boolean reset) {
        return PoolManager.singleton().getClient(key, reset);
    }

    public static void releaseClient(Client client) {
        PoolManager.singleton().releaseClient(client);
    }

    public static ParameterList createParameterList() {
        return new ParameterList();
    }

    public static ParameterList createParameterList(IMetaData meta_data) {
        return new ParameterList((IMetaData)meta_data.clone());
    }

    public static Structure createStructure(String name) {
        return new Structure(name);
    }

    public static Structure createStructure(IMetaData meta_data) {
        return new Structure(meta_data);
    }

    public static Table createTable(String name) {
        return new Table(name);
    }

    public static Table createTable(IMetaData meta_data) {
        return new Table(meta_data);
    }

    public static Function createFunction(String name, ParameterList input, ParameterList output, ParameterList tables) {
        return new Function(name, input, output, tables);
    }

    public static IRepository createRepository(String name, String pool_name) {
        return new Repository(name, pool_name);
    }

    public static IRepository createRepository(String name, String[] pool_names) {
        return new Repository(name, pool_names);
    }

    public static IRepository createRepository(String name, Client client) {
        return new Repository(name, client);
    }

    static {
        pinfo = new String[][]{{JCO_VERSION, "Version of the Java JCo toolkit"}, {JCO_TRACE_LEVEL, "Level of JCo trace messages"}, {JCO_TRACE_PATH, "Path to the JCo trace file"}, {JCO_HTML_BACKGROUND, "HTML page background color"}, {JCO_HTML_TABLE_HEADER_BACKGROUND1, "Primary background color of an HTML table header"}, {JCO_HTML_TABLE_HEADER_FOREGROUND1, "Primary foreground color of an HTML table header"}, {JCO_HTML_TABLE_HEADER_BACKGROUND2, "Secondary background color of an HTML table header"}, {JCO_HTML_TABLE_HEADER_FOREGROUND2, "Secondary foreground color of an HTML table header"}, {JCO_HTML_TABLE_HEADER_BACKGROUND3, "Tertiary background color of an HTML table header"}, {JCO_HTML_TABLE_BORDER, "Border thickness of na HTML table"}, {JCO_HTML_TABLE_ROW_BACKGROUND1, "Row color of an HTML table used for even rows"}, {JCO_HTML_TABLE_ROW_BACKGROUND2, "Row color of an HTML table used for odd  rows"}, {JCO_HTML_TABLE_MAX_ROWS, "The max. number of rows printed"}, {JCO_HTML_FONT_FACE, "The font to used"}, {JCO_HTML_FONT_SIZE, "The font size"}, {JCO_JDSR_COMP_NAME, "The component name in jDSR context"}, {JCO_JDSR, "jDSR on/off"}, {JCO_JARM, "jARM on/off"}};
        properties = new Properties();
        jco_mode = 0;
        trace_level = 0;
        CRLF = System.getProperty("line.separator");
        trace_listeners = new Vector();
        ((Hashtable)properties).put(JCO_VERSION, VERSION);
        ((Hashtable)properties).put(JCO_HTML_BACKGROUND, "#95b2c3");
        ((Hashtable)properties).put(JCO_HTML_TABLE_BORDER, "0");
        ((Hashtable)properties).put(JCO_HTML_TABLE_HEADER_BACKGROUND1, "#6780B8");
        ((Hashtable)properties).put(JCO_HTML_TABLE_HEADER_FOREGROUND1, "#FFFFFF");
        ((Hashtable)properties).put(JCO_HTML_TABLE_HEADER_BACKGROUND2, "#8D8D80");
        ((Hashtable)properties).put(JCO_HTML_TABLE_HEADER_FOREGROUND2, "#965136");
        ((Hashtable)properties).put(JCO_HTML_TABLE_HEADER_BACKGROUND3, "#CDCDBE");
        ((Hashtable)properties).put(JCO_HTML_TABLE_ROW_BACKGROUND1, "#F5F4E7");
        ((Hashtable)properties).put(JCO_HTML_TABLE_ROW_BACKGROUND2, "#E2E1D0");
        ((Hashtable)properties).put(JCO_HTML_FONT_FACE, "Verdana, Arial, Helvetica, sans-serif");
        ((Hashtable)properties).put(JCO_HTML_FONT_SIZE, "1");
        ((Hashtable)properties).put(JCO_HTML_TABLE_MAX_ROWS, "100");
        try {
            middleware_class = Class.forName(middleware_layer);
            middleware = (IMiddleware)middleware_class.newInstance();
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError("JCO.classInitialize(): Could not load middleware layer '" + middleware_layer + "'" + CRLF + ex.getMessage());
        }
        try {
            String system_trc = System.getProperty(JCO_TRACE_LEVEL, "0");
            if (!system_trc.equals("0")) {
                JCO.setProperty(JCO_TRACE_PATH, System.getProperty(JCO_TRACE_PATH, null));
                JCO.setProperty("SYSTEM_jco.trace_path", System.getProperty(JCO_TRACE_PATH, null));
            }
            JCO.setProperty(JCO_TRACE_LEVEL, system_trc);
            JCO.setProperty("SYSTEM_jco.trace_level", system_trc);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            JCO.setProperty(JCO_JDSR, System.getProperty(JCO_JDSR, null));
        }
        catch (Exception ex) {
            JCO.fireTrace(0, "[JAV-LAYER] " + ex.toString());
        }
        try {
            JCO.setProperty(JCO_JARM, System.getProperty(JCO_JARM, null));
        }
        catch (Exception ex) {
            JCO.fireTrace(0, "[JAV-LAYER] " + ex.toString());
        }
        server_exception_listeners = new Vector();
        server_error_listeners = new Vector();
        server_state_changed_listeners = new Vector();
    }

    public static class Repository
    extends BasicRepository
    implements IRepository {
        protected static final MetaData funint_v2 = new MetaData("RFC_FUNINT", 12);
        protected static final MetaData fields_v2 = new MetaData("RFC_FIELDS", 7);
        protected static final MetaData funint_v3 = new MetaData("RFC_FUNINT", 11);
        protected static final MetaData fields_v3 = new MetaData("RFC_FIELDS", 7);
        protected static final MetaData rsexc_v3 = new MetaData("RSEXC", 1);
        protected static final MetaData rsimp_v3 = new MetaData("RSIMP", 5);
        protected static final MetaData rstbl_v3 = new MetaData("RSTBL", 4);
        protected static final MetaData funint_v4 = funint_v2;
        protected static final MetaData x030l_v4 = new MetaData("SBC_TABLEN", 5);
        protected static final MetaData dfies_v4 = new MetaData("DFIES", 42);
        protected static final MetaData funint_v5 = funint_v4;
        protected static final MetaData dfies_v5;
        protected static final MetaData x030l_v5;
        protected static final MetaData ddtypelist_v5;
        protected static final MetaData funint_v6u;
        protected static final MetaData dfies_v6u;
        protected static final MetaData x030l_v6u;
        protected static final MetaData ddtypelist_v6u;
        protected static final String[] ABAP_TYPES;
        protected static final char[] ABAP_EXIDS;
        protected String[] pool_names = new String[0];
        protected int repository_version = 0;
        protected Client client = null;

        public Repository(String name, String pool_name) {
            this(name, new String[]{pool_name});
        }

        public Repository(String name, String[] pool_names) {
            super(name);
            if (pool_names != null) {
                this.pool_names = pool_names;
            }
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Repository create Repository with " + (pool_names.length == 1 ? pool_names[0] : String.valueOf(pool_names.length)) + " pool(s)");
            }
        }

        public Repository(String name, Client client) {
            super(name);
            this.client = client;
        }

        public synchronized void setName(String name) {
            this.name = name;
        }

        public synchronized String[] getPoolNames() {
            return this.pool_names;
        }

        public synchronized void setPoolNames(String[] pool_names) {
            this.pool_names = pool_names != null ? pool_names : new String[0];
        }

        protected final int getVersion(Client client) {
            if (!client.isValid()) {
                client.connect();
            }
            try {
                this.repository_version = client.getAttributes().getPartnerReleaseNumber();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.repository_version;
        }

        private Client getRepositoryClient(String pool_name) {
            Client client = null;
            Client client2 = client = pool_name != null ? JCO.getClient(pool_name) : this.client;
            if (client == null) {
                if (pool_name != null) {
                    if (trace_level > 0) {
                        Throwable t = new Throwable().fillInStackTrace();
                        StringWriter sw = new StringWriter();
                        t.printStackTrace(new PrintWriter(sw));
                        JCO.fireTrace(1, "[JAV-LAYER] Error: client equals null, pool " + pool_name + " stack of the calls:" + sw.getBuffer() + "\n");
                    }
                    if (JCO.getClientPoolManager().getPool(pool_name) == null) {
                        throw new Exception(106, "JCO_ERROR_RESOURCE", "Repository pool '" + pool_name + "' does not exist or was removed.");
                    }
                    throw new Exception(106, "JCO_ERROR_RESOURCE", "Error in repository pool '" + pool_name + "': pool returns client equals null.");
                }
                throw new Exception(106, "JCO_ERROR_RESOURCE", "Invalid connection encountered");
            }
            if (!client.isValid()) {
                client.connect();
            }
            return client;
        }

        private void releaseRepositoryClient(Client client) {
            if (client != null && client.isPooled()) {
                JCO.releaseClient(client);
            }
        }

        protected void execute(Client client, Function function) {
            if (client == this.client) {
                Client client2 = client;
                synchronized (client2) {
                    client.execute(function);
                }
            } else {
                client.execute(function);
            }
        }

        protected IMetaData queryFunctionInterface(String function_name, String pool_name) {
            Client client = this.getRepositoryClient(pool_name);
            IMetaData meta = null;
            try {
                try {
                    meta = this.queryFunctionInterface(client, function_name);
                }
                catch (Exception first_ex) {
                    if ((first_ex.getGroup() == 102 || first_ex.getGroup() == 105) && client != null) {
                        try {
                            client.disconnect(true);
                            client.connect();
                            meta = this.queryFunctionInterface(client, function_name);
                        }
                        catch (java.lang.Exception ex) {
                            throw first_ex;
                        }
                    } else {
                        throw first_ex;
                    }
                    Object var8_6 = null;
                    this.releaseRepositoryClient(client);
                }
                Object var8_5 = null;
                this.releaseRepositoryClient(client);
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.releaseRepositoryClient(client);
                throw throwable;
            }
            return meta;
        }

        protected IMetaData queryStructureDefinition(String structure_name, String pool_name) {
            Client client = this.getRepositoryClient(pool_name);
            IMetaData meta = null;
            try {
                try {
                    meta = this.queryStructureDefinition(client, structure_name);
                }
                catch (Exception first_ex) {
                    if ((first_ex.getGroup() == 102 || first_ex.getGroup() == 105) && client != null) {
                        try {
                            client.disconnect(true);
                            client.connect();
                            meta = this.queryStructureDefinition(client, structure_name);
                        }
                        catch (java.lang.Exception ex) {
                            throw first_ex;
                        }
                    } else {
                        throw first_ex;
                    }
                    Object var8_6 = null;
                    this.releaseRepositoryClient(client);
                }
                Object var8_5 = null;
                this.releaseRepositoryClient(client);
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.releaseRepositoryClient(client);
                throw throwable;
            }
            return meta;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IMetaData getFunctionInterface(String function_name) {
            IMetaData iMetaData;
            Jarm.Monitor jarm_monitor = null;
            try {
                if ((jco_mode & 7) != 0 && (jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.mw.jco.JCO.Repository")) != null) {
                    jarm_monitor.startComponent();
                }
                IMetaData meta = null;
                meta = (IMetaData)this.function_cache.get(function_name);
                if (meta != null) {
                    IMetaData iMetaData2 = meta;
                    Object var10_5 = null;
                    if (jarm_monitor == null) return iMetaData2;
                    jarm_monitor.compAction(function_name);
                    jarm_monitor.endComponent();
                    jarm_monitor.endRequest();
                    return iMetaData2;
                }
                Exception exc = null;
                int i = 0;
                while (i < (this.pool_names.length > 0 ? this.pool_names.length : 1)) {
                    block15: {
                        try {
                            meta = this.queryFunctionInterface(function_name, i < this.pool_names.length ? this.pool_names[i] : null);
                        }
                        catch (AbapException ex) {
                            if (exc == null && !"FU_NOT_FOUND".equalsIgnoreCase(ex.getKey())) {
                                exc = ex;
                            }
                        }
                        catch (Exception ex) {
                            if (exc != null) break block15;
                            exc = ex;
                        }
                    }
                    if (meta != null) break;
                    ++i;
                }
                if (meta != null) {
                    this.function_cache.put(function_name, meta);
                } else {
                    IRepository rep = this.getNextRepository();
                    if (rep != null) {
                        try {
                            meta = rep.getFunctionInterface(function_name);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    if (meta == null && exc != null) {
                        throw exc;
                    }
                }
                iMetaData = meta;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (jarm_monitor == null) throw throwable;
                jarm_monitor.compAction(function_name);
                jarm_monitor.endComponent();
                jarm_monitor.endRequest();
                throw throwable;
            }
            Object var10_6 = null;
            if (jarm_monitor == null) return iMetaData;
            jarm_monitor.compAction(function_name);
            jarm_monitor.endComponent();
            jarm_monitor.endRequest();
            return iMetaData;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IMetaData getStructureDefinition(String structure_name) {
            IMetaData iMetaData;
            Jarm.Monitor jarm_monitor = null;
            try {
                if ((jco_mode & 7) != 0 && (jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.mw.jco.JCO.Repository")) != null) {
                    jarm_monitor.startComponent();
                }
                IMetaData meta = null;
                meta = (IMetaData)this.structure_cache.get(structure_name);
                if (meta != null) {
                    IMetaData iMetaData2 = meta;
                    Object var10_5 = null;
                    if (jarm_monitor == null) return iMetaData2;
                    jarm_monitor.compAction(structure_name);
                    jarm_monitor.endComponent();
                    jarm_monitor.endRequest();
                    return iMetaData2;
                }
                Exception exc = null;
                int i = 0;
                while (i < (this.pool_names.length > 0 ? this.pool_names.length : 1)) {
                    block15: {
                        try {
                            meta = this.queryStructureDefinition(structure_name, i < this.pool_names.length ? this.pool_names[i] : null);
                        }
                        catch (AbapException ex) {
                            if (exc == null && !"NOT_FOUND".equalsIgnoreCase(ex.getKey()) && !"TABLE_NOT_ACTIVE".equalsIgnoreCase(ex.getKey())) {
                                exc = ex;
                            }
                        }
                        catch (Exception ex) {
                            if (exc != null) break block15;
                            exc = ex;
                        }
                    }
                    if (meta != null) break;
                    ++i;
                }
                if (meta != null) {
                    this.structure_cache.put(structure_name, meta);
                } else {
                    IRepository rep = this.getNextRepository();
                    if (rep != null) {
                        try {
                            meta = rep.getStructureDefinition(structure_name);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    if (meta == null && exc != null) {
                        throw exc;
                    }
                }
                iMetaData = meta;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (jarm_monitor == null) throw throwable;
                jarm_monitor.compAction(structure_name);
                jarm_monitor.endComponent();
                jarm_monitor.endRequest();
                throw throwable;
            }
            Object var10_6 = null;
            if (jarm_monitor == null) return iMetaData;
            jarm_monitor.compAction(structure_name);
            jarm_monitor.endComponent();
            jarm_monitor.endRequest();
            return iMetaData;
        }

        public final IMetaData queryFunctionInterface(Client client, String name) {
            String tabname;
            String pdflt;
            Table funint;
            String codepage;
            if (client == null) {
                throw new Exception(106, "JCO_ERROR_RESOURCE", "Invalid connection encountered");
            }
            MetaData meta = null;
            ParameterList imp = JCO.createParameterList();
            ParameterList tab = JCO.createParameterList();
            int version = this.getVersion(client);
            boolean is_unicode = false;
            if (version > 463 && (codepage = client.getAttributes().getPartnerCodepage().trim()).charAt(0) == '4') {
                is_unicode = true;
            }
            int unicode_factor = is_unicode ? -2 : 1;
            meta = new MetaData(name);
            imp.appendValue("FUNCNAME", 0, unicode_factor * 30, name);
            if (version >= 200 && version < 300) {
                funint = JCO.createTable(funint_v2);
            } else if (version >= 300 && version < 400) {
                funint = JCO.createTable(funint_v3);
            } else if (version >= 400 && version < 500) {
                funint = JCO.createTable(funint_v4);
            } else if (version >= 500 && !is_unicode) {
                funint = JCO.createTable(funint_v5);
            } else if (version >= 500 && is_unicode) {
                funint = JCO.createTable(funint_v6u);
            } else {
                throw new Exception(108, "JCO_ERROR_INTERNAL", "Wrong repository version = " + Integer.toString(version) + " encountered");
            }
            tab.appendValue("PARAMS", funint);
            Function function = new Function("RFC_GET_FUNCTION_INTERFACE", imp, null, tab);
            this.execute(client, function);
            meta = new MetaData(name);
            int irow = 0;
            while (irow < funint.getNumRows()) {
                block47: {
                    String descript;
                    String sdefault;
                    int ptype;
                    int flags;
                    block43: {
                        char pclass;
                        block46: {
                            block45: {
                                block44: {
                                    block42: {
                                        flags = 0;
                                        funint.setRow(irow);
                                        pclass = funint.getString(0).charAt(0);
                                        pdflt = version > 200 && version < 460 ? funint.getString(9).trim() : funint.getString(11);
                                        tabname = funint.getString(2);
                                        String fieldname = funint.getString(3);
                                        String stype = funint.getString(4);
                                        ptype = JCO.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                                        sdefault = null;
                                        descript = funint.getString(10).trim();
                                        String string = descript = descript.length() > 0 ? descript : null;
                                        if (ptype == -1 && (pclass == 'I' || pclass == 'E' || pclass == 'C')) {
                                            int j = 0;
                                            while (j < ABAP_TYPES.length && ptype == -1) {
                                                if (tabname.equals(ABAP_TYPES[j])) {
                                                    ptype = JCO.getJCOType(ABAP_EXIDS[j]);
                                                }
                                                ++j;
                                            }
                                        }
                                        if (version >= 462 && pclass != 'X' && pclass != 'T' && (ptype == -1 || ptype == 17 || ptype == 99)) {
                                            Function function2;
                                            ParameterList imp2 = JCO.createParameterList();
                                            ParameterList exp2 = JCO.createParameterList();
                                            Structure x030l_wa = null;
                                            Structure dfies_wa2 = null;
                                            imp2.appendValue("TABNAME", 0, unicode_factor * 30, tabname);
                                            imp2.appendValue("ALL_TYPES", 0, unicode_factor * 1, "X");
                                            if (fieldname.length() > 0) {
                                                imp2.appendValue("LFIELDNAME", 0, unicode_factor * 132, fieldname);
                                                dfies_wa2 = JCO.createStructure(is_unicode ? dfies_v6u : dfies_v5);
                                                exp2.appendValue("DFIES_WA", dfies_wa2);
                                                function2 = new Function("DDIF_FIELDINFO_GET", imp2, exp2, null);
                                                this.execute(client, function2);
                                                stype = dfies_wa2.getString(13);
                                                ptype = JCO.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                                                if (ptype == 17 || ptype == 99) {
                                                    tabname = dfies_wa2.getString(6);
                                                }
                                            } else if (ptype == -1 || ptype == 17) {
                                                String ddobjtype;
                                                boolean isNestedType1;
                                                exp2.appendValue("DDOBJTYPE", 0, unicode_factor * 31, (String)null);
                                                x030l_wa = JCO.createStructure(version < 500 ? x030l_v4 : (is_unicode ? x030l_v6u : x030l_v5));
                                                exp2.appendValue("X030L_WA", x030l_wa);
                                                function2 = new Function("DDIF_FIELDINFO_GET", imp2, exp2, null);
                                                this.execute(client, function2);
                                                byte flag3 = x030l_wa.getByteArray(13)[0];
                                                boolean bl = isNestedType1 = (flag3 & 1) != 0 && (flag3 & 2) == 0;
                                                if (isNestedType1) {
                                                    flags |= 0x80;
                                                }
                                                ptype = (ddobjtype = exp2.getString(0)).equalsIgnoreCase("INTTAB") || ddobjtype.equalsIgnoreCase("TRANSP") || ddobjtype.equalsIgnoreCase("POOL") || ddobjtype.equalsIgnoreCase("CLUSTER") ? 17 : (ddobjtype.equalsIgnoreCase("TTYP") ? 99 : -1);
                                            }
                                        }
                                        if (pclass != 'I') break block42;
                                        flags |= 1;
                                        if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                                            flags |= 4;
                                        }
                                        if (ptype == -1) {
                                            ptype = 17;
                                        }
                                        sdefault = (sdefault = funint.getString(9).trim()).length() > 0 ? sdefault : null;
                                        break block43;
                                    }
                                    if (pclass != 'E') break block44;
                                    flags |= 2;
                                    if (ptype == -1) {
                                        ptype = 17;
                                    }
                                    break block43;
                                }
                                if (pclass != 'C') break block45;
                                flags |= 3;
                                if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                                    flags |= 4;
                                }
                                if (ptype == -1) {
                                    ptype = 17;
                                }
                                sdefault = (sdefault = funint.getString(9).trim()).length() > 0 ? sdefault : null;
                                break block43;
                            }
                            if (pclass != 'T') break block46;
                            flags = 0;
                            if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                                flags |= 4;
                            }
                            ptype = 99;
                            break block43;
                        }
                        if (pclass != 'X') break block47;
                        flags = 0;
                        ptype = 98;
                        if (descript == null) {
                            descript = funint.getString(1);
                        }
                    }
                    meta.addInfo(funint.getString(1), ptype, funint.getInt(7) * (is_unicode ? -1 : 1), -1, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, null);
                }
                ++irow;
            }
            if (version > 200 && version < 460) {
                Table rsexc = JCO.createTable(rsexc_v3);
                Table rsimp = JCO.createTable(rsimp_v3);
                Table rsexp = JCO.createTable(rstbl_v3);
                Table rstbl = JCO.createTable(rstbl_v3);
                imp = JCO.createParameterList();
                ParameterList exp = JCO.createParameterList();
                tab = JCO.createParameterList();
                imp.appendValue("FUNCNAME", 0, 30, name);
                exp.addInfo("GLOBAL_FLAG", 0, 30);
                exp.addInfo("REMOTE_CALL", 0, 30);
                exp.addInfo("UPDATE_TASK", 0, 30);
                tab.appendValue("EXCEPTION_LIST", 99, 24, rsexc);
                tab.appendValue("EXPORT_PARAMETER", 99, 24, rsexp);
                tab.appendValue("IMPORT_PARAMETER", 99, 24, rsimp);
                tab.appendValue("TABLES_PARAMETER", 99, 24, rstbl);
                function = new Function("FUNCTION_IMPORT_INTERFACE", imp, exp, tab);
                this.execute(client, function);
                irow = 0;
                while (irow < rsimp.getNumRows()) {
                    pdflt = rsimp.getString(4).trim();
                    if (pdflt.length() >= 1) {
                        tabname = rsimp.getString(0);
                        int i = 0;
                        while (i < meta.name.length) {
                            if ((meta.flags[i] & 1) != 0 && meta.name[i].equals(tabname)) {
                                int n = i;
                                meta.flags[n] = (byte)(meta.flags[n] | 4);
                                break;
                            }
                            ++i;
                        }
                    }
                    ++irow;
                    rsimp.nextRow();
                }
                irow = 0;
                while (irow < rstbl.getNumRows()) {
                    pdflt = rstbl.getString(3).trim();
                    if (pdflt.length() >= 1) {
                        tabname = rstbl.getString(0);
                        int i = 0;
                        while (i < meta.name.length) {
                            if (meta.type[i] == 99 && meta.name[i].equals(tabname)) {
                                int n = i;
                                meta.flags[n] = (byte)(meta.flags[n] | 4);
                                break;
                            }
                            ++i;
                        }
                    }
                    ++irow;
                    rstbl.nextRow();
                }
            }
            funint.firstRow();
            this.queryFunctionInterfaceEpilog(client, meta, funint);
            return meta;
        }

        protected void queryFunctionInterfaceEpilog(Client client, MetaData meta_data, Table funint) {
        }

        public final IMetaData queryStructureDefinition(Client client, String name) {
            int unicode_factor;
            String codepage;
            if (client == null) {
                throw new Exception(106, "JCO_ERROR_RESOURCE", "Invalid connection encountered");
            }
            MetaData meta = null;
            ParameterList imp = JCO.createParameterList();
            ParameterList exp = JCO.createParameterList();
            ParameterList tab = JCO.createParameterList();
            Function function = null;
            int version = this.getVersion(client);
            boolean is_unicode = false;
            if (trace_level > 2) {
                JCO.fireTrace(3, "[JAV-LAYER] Client.queryStructureDefinition(\"" + name + "\") enter [SUCCESS]");
                JCO.fireTrace(3, "[JAV-LAYER] Client.getRepositoryVersion() = " + version + " [SUCCESS]");
            }
            if (version > 463 && (codepage = client.getAttributes().getPartnerCodepage().trim()).charAt(0) == '4') {
                is_unicode = true;
            }
            int n = unicode_factor = is_unicode ? -2 : 1;
            if (version >= 200 && version < 300) {
                if (trace_level > 2) {
                    JCO.fireTrace(3, "[JAV-LAYER] Client.queryStructureDefinition()  ");
                }
                imp.appendValue("TABNAME", 0, 30, name);
                exp.addInfo("TABLENGTH", 8, 4);
                Table fields = JCO.createTable(fields_v2);
                tab.appendValue("FIELDS", fields);
                function = new Function("RFC_GET_STRUCTURE_DEFINITION", imp, exp, tab);
                this.execute(client, function);
                int num_rows = fields.getNumRows();
                meta = new MetaData(name, num_rows);
                meta.setTabLength(exp.getInt(0));
                int irow = 0;
                while (irow < num_rows) {
                    String stype = fields.getString(6);
                    byte ptype = JCO.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    meta.addInfo(fields.getString(1), ptype, fields.getInt(4), fields.getInt(3), fields.getInt(5));
                    fields.nextRow();
                    ++irow;
                }
                fields.firstRow();
                this.queryStructureInterfaceEpilog(client, meta, fields);
            } else if (version >= 300 && version < 400) {
                if (trace_level > 2) {
                    JCO.fireTrace(3, "[JAV-LAYER] Client.queryStructureDefinition()  ");
                }
                imp.appendValue("TABNAME", 0, 10, name);
                exp.addInfo("TABLENGTH", 8, 4);
                Table fields = JCO.createTable(fields_v3);
                tab.appendValue("FIELDS", fields);
                function = new Function("RFC_GET_STRUCTURE_DEFINITION", imp, exp, tab);
                this.execute(client, function);
                int num_rows = fields.getNumRows();
                meta = new MetaData(name, num_rows);
                meta.setTabLength(exp.getInt(0));
                int irow = 0;
                while (irow < num_rows) {
                    String stype = fields.getString(6);
                    byte ptype = JCO.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    meta.addInfo(fields.getString(1), ptype, fields.getInt(4), fields.getInt(3), fields.getInt(5));
                    fields.nextRow();
                    ++irow;
                }
                fields.firstRow();
                this.queryStructureInterfaceEpilog(client, meta, fields);
            } else if (version >= 400 && version < 462) {
                imp.appendValue("TABNAME", 0, 30, name);
                imp.appendValue("ALL_TYPES", 0, 1, "X");
                Structure x030l_wa = JCO.createStructure(x030l_v4);
                exp.appendValue("X030L_WA", x030l_wa);
                Structure dfies_wa = JCO.createStructure(dfies_v4);
                exp.appendValue("DFIES_WA", dfies_wa);
                dfies_wa.setValue("", 0);
                Table dfies_tab = JCO.createTable(dfies_v4);
                tab.appendValue("DFIES_TAB", dfies_tab);
                function = new Function("DDIF_FIELDINFO_GET", imp, exp, tab);
                this.execute(client, function);
                int num_rows = dfies_tab.getNumRows();
                if (num_rows == 0) {
                    imp.setValue(dfies_wa.getString(6), 0);
                    this.execute(client, function);
                }
                num_rows = dfies_tab.getNumRows();
                meta = new MetaData(name, num_rows);
                meta.setTabLength(x030l_wa.getInt(4));
                int irow = 0;
                while (irow < num_rows) {
                    String stype = dfies_tab.getString(13);
                    byte ptype = JCO.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    meta.addInfo(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4), dfies_tab.getInt(11), null, dfies_tab.getString(27), 0, null, null);
                    dfies_tab.nextRow();
                    ++irow;
                }
                dfies_tab.firstRow();
                this.queryStructureInterfaceEpilog(client, meta, dfies_tab);
            } else if (version >= 462) {
                byte flag3;
                Table dfies_tab;
                Table lines_descr;
                Structure dfies_wa;
                Structure x030l_wa;
                imp.appendValue("TABNAME", 0, unicode_factor * 30, name);
                imp.appendValue("ALL_TYPES", 0, unicode_factor * 1, "X");
                if (version < 500) {
                    MetaData metatyp = x030l_v4;
                    x030l_wa = JCO.createStructure(metatyp);
                    dfies_wa = JCO.createStructure(dfies_v5);
                    lines_descr = JCO.createTable(ddtypelist_v5);
                    dfies_tab = JCO.createTable(dfies_v5);
                } else if (!is_unicode) {
                    MetaData metatyp = x030l_v5;
                    x030l_wa = JCO.createStructure(metatyp);
                    dfies_wa = JCO.createStructure(dfies_v5);
                    lines_descr = JCO.createTable(ddtypelist_v5);
                    dfies_tab = JCO.createTable(dfies_v5);
                } else {
                    MetaData metatyp = x030l_v6u;
                    x030l_wa = JCO.createStructure(metatyp);
                    dfies_wa = JCO.createStructure(dfies_v6u);
                    lines_descr = JCO.createTable(ddtypelist_v6u);
                    dfies_tab = JCO.createTable(dfies_v6u);
                }
                exp.appendValue("X030L_WA", x030l_wa);
                exp.appendValue("DFIES_WA", dfies_wa);
                exp.appendValue("DDOBJTYPE", 0, unicode_factor * 31, (String)null);
                exp.appendValue("LINES_DESCR", lines_descr);
                tab.appendValue("DFIES_TAB", dfies_tab);
                function = new Function("DDIF_FIELDINFO_GET", imp, exp, tab);
                this.execute(client, function);
                meta = new MetaData(name);
                if (x030l_wa.getString(8).equals("L")) {
                    if (lines_descr.getNumRows() == 1) {
                        dfies_tab = lines_descr.getTable(2);
                        meta.type_name = lines_descr.getString(0);
                    } else if (dfies_tab.getNumRows() == 0) {
                        dfies_tab.copyFrom(dfies_wa);
                    }
                }
                boolean isNestedType1 = ((flag3 = x030l_wa.getByteArray(13)[0]) & 1) != 0 && (flag3 & 2) == 0;
                meta.setTabLength(x030l_wa.getInt(4));
                meta.type1_data = isNestedType1 ? meta.new MetaData.Type1Data() : null;
                meta = this.constructMetaData(client, version, is_unicode, dfies_tab, lines_descr, meta, null, 0, 1);
                if (meta.type1_data != null) {
                    meta.type1_data.constructMetaData();
                }
            }
            return meta;
        }

        private boolean checkType1(MetaData meta) {
            int i = 0;
            while (i < meta.type.length) {
                switch (meta.type[i]) {
                    case 17: {
                        if (meta.isNestedType1Structure(i)) break;
                        MetaData childMeta = (MetaData)meta.getMetaData(i);
                        if (childMeta.num_odata == 0 || this.checkType1(childMeta)) break;
                    }
                    case 29: 
                    case 30: 
                    case 99: {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        private MetaData constructMetaData(Client client, int version, boolean is_unicode, Table dfies_tab, Table lines_descr, MetaData meta, String lfieldname, int base_offset, int level) {
            int unicode_factor;
            int num_rows = dfies_tab.getNumRows();
            if (num_rows == 0 || dfies_tab.getRow() >= num_rows) {
                return meta;
            }
            int n = unicode_factor = is_unicode ? -2 : 1;
            do {
                if (lfieldname != null && !dfies_tab.getString(43).startsWith(lfieldname)) {
                    if (level <= 1) break;
                    dfies_tab.previousRow();
                    break;
                }
                String fieldname = dfies_tab.getString(1);
                String comptype = dfies_tab.getString(42);
                String stype = dfies_tab.getString(13);
                int ptype = JCO.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                if (ptype == -1) {
                    String datatype = dfies_tab.getString(12);
                    if (datatype.equals("STRU")) {
                        ptype = 17;
                    } else if (datatype.equals("TTYP")) {
                        ptype = 99;
                    }
                }
                if (ptype == 17 || ptype == 99) {
                    MetaData meta_new;
                    String rollname = dfies_tab.getString(6);
                    if (comptype.equals("S")) {
                        meta_new = new MetaData(rollname);
                        meta_new.setTabLength(dfies_tab.getInt(9));
                        meta_new.type1_data = meta.isNestedType1Structure() ? meta_new.new MetaData.Type1Data() : null;
                        String lfieldname_new = dfies_tab.getString(43) + "-";
                        int offset_new = dfies_tab.getInt(4);
                        meta.addInfo(dfies_tab.getString(1), ptype, dfies_tab.getInt(8), dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab.getInt(11), null, dfies_tab.getString(27), 0, meta_new, null);
                        dfies_tab.nextRow();
                        this.constructMetaData(client, version, is_unicode, dfies_tab, lines_descr, meta_new, lfieldname_new, offset_new, level + 1);
                        if (meta.isNestedType1Structure() && meta_new.num_odata > 0) {
                            int n2 = meta.num_fields - 1;
                            meta.flags[n2] = (byte)(meta.flags[n2] | 0x80);
                            meta_new.type1_data.constructMetaData();
                            continue;
                        }
                        if (meta_new.num_odata > 0) {
                            if (!this.checkType1(meta_new)) continue;
                            meta_new.type1_data = meta_new.new MetaData.Type1Data();
                            meta_new.type1_data.constructMetaData();
                            int n3 = meta.num_fields - 1;
                            meta.flags[n3] = (byte)(meta.flags[n3] | 0x80);
                            continue;
                        }
                        meta_new.type1_data = null;
                        continue;
                    }
                    if (comptype.equals("L") || comptype.equals("T")) {
                        meta_new = null;
                        if (comptype.equals("T")) {
                            meta.type_name = rollname;
                        }
                        if (rollname.length() > 0 && this.structure_cache.containsKey(rollname)) {
                            meta_new = (MetaData)this.getStructureDefinition(rollname);
                            if (comptype.equals("L") || dfies_tab.getNumRows() == 1 && "TTYP".equals(dfies_tab.getString(12))) {
                                meta.addInfo(dfies_tab.getString(1), ptype, dfies_tab.getInt(8), dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab.getInt(11), null, dfies_tab.getString(27), 0, meta_new, null);
                                continue;
                            }
                            String curr_rec_name = meta.rec_name;
                            meta.copy(meta_new);
                            meta.rec_name = curr_rec_name;
                            meta.type_name = meta_new.rec_name;
                            continue;
                        }
                        if (rollname.length() > 0) {
                            Function function;
                            Structure x030l_wa;
                            ParameterList exp;
                            ParameterList imp;
                            Table dfies_tab_new = null;
                            String rollname_new = rollname;
                            int irow = 0;
                            String dataType = null;
                            String rollNameTemp = null;
                            while (irow < lines_descr.getNumRows() && dfies_tab_new == null) {
                                lines_descr.setRow(irow++);
                                if (rollname_new.length() <= 0 || !lines_descr.getString(0).equals(rollname_new)) continue;
                                dfies_tab_new = lines_descr.getTable(2);
                                dfies_tab_new.firstRow();
                                dataType = dfies_tab_new.getString(12);
                                rollNameTemp = dfies_tab_new.getString(6);
                                if (dfies_tab_new.getNumRows() != 1 || !dfies_tab_new.getString(42).equals("T")) continue;
                                if (rollNameTemp.equals(dfies_tab_new.getString(5))) {
                                    rollname_new = rollNameTemp;
                                    continue;
                                }
                                if (!"STRU".equals(dataType) && !"TTYP".equals(dataType)) continue;
                                rollname_new = rollNameTemp;
                                dfies_tab_new = null;
                                irow = 0;
                            }
                            if (dfies_tab_new != null && (comptype.equals("L") || dfies_tab.getNumRows() == 1 && "TTYP".equals(dfies_tab.getString(12)))) {
                                meta_new = new MetaData(rollname);
                                meta_new.type_name = rollname_new;
                                meta_new.setTabLength(dfies_tab.getInt(9));
                                imp = new ParameterList();
                                exp = new ParameterList();
                                imp.appendValue("TABNAME", 0, unicode_factor * 30, rollname);
                                imp.appendValue("ALL_TYPES", 0, unicode_factor * 1, "X");
                                x030l_wa = version < 500 ? JCO.createStructure(x030l_v4) : (!is_unicode ? JCO.createStructure(x030l_v5) : JCO.createStructure(x030l_v6u));
                                exp.appendValue("X030L_WA", x030l_wa);
                                function = new Function("DDIF_FIELDINFO_GET", imp, exp, null);
                                this.execute(client, function);
                                meta_new.setTabLength(x030l_wa.getInt(4));
                                this.constructMetaData(client, version, is_unicode, dfies_tab_new, lines_descr, meta_new, null, 0, level + 1);
                                if (rollname_new != null && rollname_new.length() > 0) {
                                    this.addStructureDefinitionToCache(rollname_new, meta_new);
                                }
                            } else {
                                if (dfies_tab_new != null && comptype.equals("T")) {
                                    imp = new ParameterList();
                                    exp = new ParameterList();
                                    imp.appendValue("TABNAME", 0, unicode_factor * 30, rollname);
                                    imp.appendValue("ALL_TYPES", 0, unicode_factor * 1, "X");
                                    x030l_wa = version < 500 ? JCO.createStructure(x030l_v4) : (!is_unicode ? JCO.createStructure(x030l_v5) : JCO.createStructure(x030l_v6u));
                                    exp.appendValue("X030L_WA", x030l_wa);
                                    function = new Function("DDIF_FIELDINFO_GET", imp, exp, null);
                                    this.execute(client, function);
                                    meta.setTabLength(x030l_wa.getInt(4));
                                    this.constructMetaData(client, version, is_unicode, dfies_tab_new, lines_descr, meta, null, 0, level + 1);
                                    if (rollname_new == null || rollname_new.length() <= 0) continue;
                                    this.addStructureDefinitionToCache(rollname_new, meta);
                                    continue;
                                }
                                String msg = "Could not find referenced or embedded table/structure " + rollname + " which was requested by " + meta.getName() + ", comptype=" + comptype;
                                JCO.fireTrace(1, "[JAV-LAYER] " + msg);
                                throw new Exception(108, "JCO_ERROR_INTERNAL", msg);
                            }
                        }
                        meta.addInfo(dfies_tab.getString(1), ptype, dfies_tab.getInt(8), dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab.getInt(11), null, dfies_tab.getString(27), 0, meta_new, null);
                        continue;
                    }
                    meta.addInfo(dfies_tab.getString(1), ptype, dfies_tab.getInt(8), dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab.getInt(11), null, dfies_tab.getString(27), 0, null, null);
                    continue;
                }
                meta.addInfo(dfies_tab.getString(1), ptype, dfies_tab.getInt(8), dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab.getInt(11), null, dfies_tab.getString(27), 0, null, null);
            } while (dfies_tab.nextRow());
            this.addStructureDefinitionToCache(meta);
            int save_row = dfies_tab.getRow();
            dfies_tab.firstRow();
            this.queryStructureInterfaceEpilog(client, meta, dfies_tab);
            dfies_tab.setRow(save_row);
            return meta;
        }

        protected void queryStructureInterfaceEpilog(Client client, MetaData meta_data, Table fields) {
        }

        public final IMetaData queryTableDefinition(Client client, String name) {
            return this.queryStructureDefinition(client, name);
        }

        static {
            x030l_v5 = new MetaData("X030L", 5);
            ddtypelist_v5 = new MetaData("DDTYPELIST", 3);
            funint_v6u = new MetaData("RFC_FUNINT", 12);
            dfies_v6u = new MetaData("DFIES", 44);
            x030l_v6u = new MetaData("X030L", 5);
            ddtypelist_v6u = new MetaData("DDTYPELIST", 3);
            ABAP_TYPES = new String[]{"b", "I", "P", "D", "N", "T", "C", "F", "s", "X", "STRING", "XSTRING", "u", "v", "h"};
            ABAP_EXIDS = new char[]{'b', 'I', 'P', 'D', 'N', 'T', 'C', 'F', 's', 'X', 'g', 'y', 'u', 'v', 'h'};
            funint_v2.addInfo("PARAMCLASS", 0, 1, 0);
            funint_v2.addInfo("PARAMETER", 0, 30, 1);
            funint_v2.addInfo("TABNAME", 0, 30, 31);
            funint_v2.addInfo("FIELDNAME", 0, 30, 61);
            funint_v2.addInfo("EXID", 0, 1, 91);
            funint_v2.addInfo("POSITION", 8, 4, 92);
            funint_v2.addInfo("OFFSET", 8, 4, 96);
            funint_v2.addInfo("INTLENGTH", 8, 4, 100);
            funint_v2.addInfo("DECIMALS", 8, 4, 104);
            funint_v2.addInfo("DEFAULT", 0, 21, 108);
            funint_v2.addInfo("PARAMTEXT", 0, 79, 129);
            funint_v2.addInfo("OPTIONAL", 0, 1, 208);
            funint_v2.setTabLength(216);
            fields_v2.addInfo("TABNAME", 0, 30, 0);
            fields_v2.addInfo("FIELDNAME", 0, 30, 30);
            fields_v2.addInfo("POSITION", 8, 4, 60);
            fields_v2.addInfo("OFFSET", 8, 4, 64);
            fields_v2.addInfo("INTLENGTH", 8, 4, 68);
            fields_v2.addInfo("DECIMALS", 8, 4, 72);
            fields_v2.addInfo("EXID", 0, 1, 76);
            fields_v2.setTabLength(77);
            funint_v3.addInfo("PARAMCLASS", 0, 1, 0);
            funint_v3.addInfo("PARAMETER", 0, 30, 1);
            funint_v3.addInfo("TABNAME", 0, 10, 31);
            funint_v3.addInfo("FIELDNAME", 0, 10, 41);
            funint_v3.addInfo("EXID", 0, 1, 51);
            funint_v3.addInfo("POSITION", 8, 4, 52);
            funint_v3.addInfo("OFFSET", 8, 4, 56);
            funint_v3.addInfo("INTLENGTH", 8, 4, 60);
            funint_v3.addInfo("DECIMALS", 8, 4, 64);
            funint_v3.addInfo("DEFAULT", 0, 21, 68);
            funint_v3.addInfo("PARAMTEXT", 0, 79, 89);
            funint_v3.setTabLength(168);
            fields_v3.addInfo("TABNAME", 0, 10, 0);
            fields_v3.addInfo("FIELDNAME", 0, 10, 10);
            fields_v3.addInfo("POSITION", 8, 4, 20);
            fields_v3.addInfo("OFFSET", 8, 4, 24);
            fields_v3.addInfo("INTLENGTH", 8, 4, 28);
            fields_v3.addInfo("DECIMALS", 8, 4, 32);
            fields_v3.addInfo("EXID", 0, 1, 36);
            fields_v3.setTabLength(40);
            rsexc_v3.addInfo("EXCEPTION", 0, 30, 0);
            rsexc_v3.setTabLength(32);
            rsimp_v3.addInfo("PARAMETER", 0, 30, 0);
            rsimp_v3.addInfo("DBFIELD", 0, 26, 30);
            rsimp_v3.addInfo("DEFAULT", 0, 21, 56);
            rsimp_v3.addInfo("TYPES", 0, 1, 77);
            rsimp_v3.addInfo("OPTIONAL", 0, 1, 78);
            rsimp_v3.setTabLength(112);
            rstbl_v3.addInfo("PARAMETER", 0, 30, 0);
            rstbl_v3.addInfo("DBSTRUCT", 0, 26, 30);
            rstbl_v3.addInfo("TYPES", 0, 1, 56);
            rstbl_v3.addInfo("OPTIONAL", 0, 1, 57);
            rstbl_v3.setTabLength(88);
            x030l_v4.addInfo("DUMMY1", 4, 31, 0);
            x030l_v4.addInfo("UUID", 4, 16, 31);
            x030l_v4.addInfo("DUMMY2", 4, 42, 47);
            x030l_v4.addInfo("FLDCNT", 4, 2, 89);
            x030l_v4.addInfo("TABLEN", 4, 2, 91);
            x030l_v4.addInfo("KEYCNT", 4, 1, 93);
            x030l_v4.addInfo("KEYLEN", 4, 1, 94);
            x030l_v4.addInfo("CLPOS", 4, 1, 95);
            x030l_v4.addInfo("TABTYPE", 0, 1, 96);
            x030l_v4.addInfo("TABFORM", 0, 1, 97);
            x030l_v4.addInfo("REFNAME", 0, 30, 98);
            x030l_v4.addInfo("FLAGBYTE", 4, 1, 128);
            x030l_v4.addInfo("EXROUT", 4, 1, 129);
            x030l_v4.addInfo("FLAG3", 4, 1, 130);
            x030l_v4.setTabLength(140);
            dfies_v4.addInfo("TABNAME", 0, 30, 0);
            dfies_v4.addInfo("FIELDNAME", 0, 30, 30);
            dfies_v4.addInfo("LANGU", 0, 1, 60);
            dfies_v4.addInfo("POSITION", 6, 4, 61);
            dfies_v4.addInfo("OFFSET", 6, 6, 65);
            dfies_v4.addInfo("DOMNAME", 0, 30, 71);
            dfies_v4.addInfo("ROLLNAME", 0, 30, 101);
            dfies_v4.addInfo("CHECKTABLE", 0, 30, 131);
            dfies_v4.addInfo("LENG", 6, 6, 161);
            dfies_v4.addInfo("INTLEN", 6, 6, 167);
            dfies_v4.addInfo("OUTPUTLEN", 6, 6, 173);
            dfies_v4.addInfo("DECIMALS", 6, 6, 179);
            dfies_v4.addInfo("DATATYPE", 0, 4, 185);
            dfies_v4.addInfo("INTTYPE", 0, 1, 189);
            dfies_v4.addInfo("REFTABLE", 0, 30, 190);
            dfies_v4.addInfo("REFFIELD", 0, 30, 220);
            dfies_v4.addInfo("PRECFIELD", 0, 30, 250);
            dfies_v4.addInfo("AUTHORID", 0, 3, 280);
            dfies_v4.addInfo("MEMORYID", 0, 20, 283);
            dfies_v4.addInfo("LOGFLAG", 0, 1, 303);
            dfies_v4.addInfo("MASK", 0, 20, 304);
            dfies_v4.addInfo("MASKLEN", 6, 4, 324);
            dfies_v4.addInfo("CONVEXIT", 0, 5, 328);
            dfies_v4.addInfo("HEADLEN", 6, 2, 333);
            dfies_v4.addInfo("SCRLEN1", 6, 2, 335);
            dfies_v4.addInfo("SCRLEN2", 6, 2, 337);
            dfies_v4.addInfo("SCRLEN3", 6, 2, 339);
            dfies_v4.addInfo("FIELDTEXT", 0, 60, 341);
            dfies_v4.addInfo("REPTEXT", 0, 55, 401);
            dfies_v4.addInfo("SCRTEXT_S", 0, 10, 456);
            dfies_v4.addInfo("SCRTEXT_M", 0, 20, 466);
            dfies_v4.addInfo("SCRTEXT_L", 0, 40, 486);
            dfies_v4.addInfo("KEYFLAG", 0, 1, 526);
            dfies_v4.addInfo("LOWERCASE", 0, 1, 527);
            dfies_v4.addInfo("MAC", 0, 1, 528);
            dfies_v4.addInfo("GENKEY", 0, 1, 529);
            dfies_v4.addInfo("NOFORKEY", 0, 1, 530);
            dfies_v4.addInfo("VALEXI", 0, 1, 531);
            dfies_v4.addInfo("NOAUTHCH", 0, 1, 532);
            dfies_v4.addInfo("SIGN", 0, 1, 533);
            dfies_v4.addInfo("DYNPFLD", 0, 1, 534);
            dfies_v4.addInfo("F4AVAILABL", 0, 1, 535);
            dfies_v4.setTabLength(536);
            x030l_v5.addInfo("DUMMY1", 4, 31, 0);
            x030l_v5.addInfo("UUID", 4, 16, 31);
            x030l_v5.addInfo("DUMMY2", 4, 42, 47);
            x030l_v5.addInfo("FLDCNT", 4, 2, 89);
            x030l_v5.addInfo("TABLEN", 4, 4, 91);
            x030l_v5.addInfo("KEYCNT", 4, 1, 95);
            x030l_v5.addInfo("KEYLEN", 4, 2, 96);
            x030l_v5.addInfo("CLPOS", 4, 1, 98);
            x030l_v5.addInfo("TABTYPE", 0, 1, 99);
            x030l_v5.addInfo("TABFORM", 0, 1, 100);
            x030l_v5.addInfo("REFNAME", 0, 30, 101);
            x030l_v5.addInfo("FLAGBYTE", 4, 1, 131);
            x030l_v5.addInfo("EXROUT", 4, 1, 132);
            x030l_v5.addInfo("FLAG3", 4, 1, 133);
            x030l_v5.setTabLength(147);
            dfies_v5 = (MetaData)dfies_v4.clone();
            dfies_v5.addInfo("COMPTYPE", 0, 1, 536);
            dfies_v5.addInfo("LFIELDNAME", 0, 132, 537);
            dfies_v5.setTabLength(669);
            ddtypelist_v5.addInfo("TYPENAME", 0, 30, 0);
            ddtypelist_v5.addInfo("TYPEKIND", 0, 4, 30);
            ddtypelist_v5.addInfo("FIELDS", 99, 6, 34, 0, 0, dfies_v5);
            ddtypelist_v5.setTabLength(48);
            funint_v6u.addInfo("PARAMCLASS", 0, -2, 0);
            funint_v6u.addInfo("PARAMETER", 0, -60, 2);
            funint_v6u.addInfo("TABNAME", 0, -60, 62);
            funint_v6u.addInfo("FIELDNAME", 0, -60, 122);
            funint_v6u.addInfo("EXID", 0, -2, 182);
            funint_v6u.addInfo("POSITION", 8, -4, 184);
            funint_v6u.addInfo("OFFSET", 8, -4, 188);
            funint_v6u.addInfo("INTLENGTH", 8, -4, 192);
            funint_v6u.addInfo("DECIMALS", 8, -4, 196);
            funint_v6u.addInfo("DEFAULT", 0, -42, 200);
            funint_v6u.addInfo("PARAMTEXT", 0, -158, 242);
            funint_v6u.addInfo("OPTIONAL", 0, -2, 400);
            funint_v6u.setTabLength(404);
            x030l_v6u.addInfo("DUMMY1", 4, -62, 0);
            x030l_v6u.addInfo("UUID", 4, -16, 62);
            x030l_v6u.addInfo("DUMMY2", 4, -84, 78);
            x030l_v6u.addInfo("FLDCNT", 4, -2, 162);
            x030l_v6u.addInfo("TABLEN", 4, -4, 164);
            x030l_v6u.addInfo("KEYCNT", 4, -1, 168);
            x030l_v6u.addInfo("KEYLEN", 4, -2, 169);
            x030l_v6u.addInfo("CLPOS", 4, -1, 171);
            x030l_v6u.addInfo("TABTYPE", 0, -2, 172);
            x030l_v6u.addInfo("TABFORM", 0, -2, 174);
            x030l_v6u.addInfo("REFNAME", 0, -60, 176);
            x030l_v6u.addInfo("FLAGBYTE", 4, -1, 236);
            x030l_v6u.addInfo("EXROUT", 4, -1, 237);
            x030l_v6u.addInfo("FLAG3", 4, -1, 238);
            x030l_v6u.setTabLength(254);
            dfies_v6u.addInfo("TABNAME", 0, -60, 0);
            dfies_v6u.addInfo("FIELDNAME", 0, -60, 60);
            dfies_v6u.addInfo("LANGU", 0, -2, 120);
            dfies_v6u.addInfo("POSITION", 6, -8, 122);
            dfies_v6u.addInfo("OFFSET", 6, -12, 130);
            dfies_v6u.addInfo("DOMNAME", 0, -60, 142);
            dfies_v6u.addInfo("ROLLNAME", 0, -60, 202);
            dfies_v6u.addInfo("CHECKTABLE", 0, -60, 262);
            dfies_v6u.addInfo("LENG", 6, -12, 322);
            dfies_v6u.addInfo("INTLEN", 6, -12, 334);
            dfies_v6u.addInfo("OUTPUTLEN", 6, -12, 346);
            dfies_v6u.addInfo("DECIMALS", 6, -12, 358);
            dfies_v6u.addInfo("DATATYPE", 0, -8, 370);
            dfies_v6u.addInfo("INTTYPE", 0, -2, 378);
            dfies_v6u.addInfo("REFTABLE", 0, -60, 380);
            dfies_v6u.addInfo("REFFIELD", 0, -60, 440);
            dfies_v6u.addInfo("PRECFIELD", 0, -60, 500);
            dfies_v6u.addInfo("AUTHORID", 0, -6, 560);
            dfies_v6u.addInfo("MEMORYID", 0, -40, 566);
            dfies_v6u.addInfo("LOGFLAG", 0, -2, 606);
            dfies_v6u.addInfo("MASK", 0, -40, 608);
            dfies_v6u.addInfo("MASKLEN", 6, -8, 648);
            dfies_v6u.addInfo("CONVEXIT", 0, -10, 656);
            dfies_v6u.addInfo("HEADLEN", 6, -4, 666);
            dfies_v6u.addInfo("SCRLEN1", 6, -4, 670);
            dfies_v6u.addInfo("SCRLEN2", 6, -4, 674);
            dfies_v6u.addInfo("SCRLEN3", 6, -4, 678);
            dfies_v6u.addInfo("FIELDTEXT", 0, -120, 682);
            dfies_v6u.addInfo("REPTEXT", 0, -110, 802);
            dfies_v6u.addInfo("SCRTEXT_S", 0, -20, 912);
            dfies_v6u.addInfo("SCRTEXT_M", 0, -40, 932);
            dfies_v6u.addInfo("SCRTEXT_L", 0, -80, 972);
            dfies_v6u.addInfo("KEYFLAG", 0, -2, 1052);
            dfies_v6u.addInfo("LOWERCASE", 0, -2, 1054);
            dfies_v6u.addInfo("MAC", 0, -2, 1056);
            dfies_v6u.addInfo("GENKEY", 0, -2, 1058);
            dfies_v6u.addInfo("NOFORKEY", 0, -2, 1060);
            dfies_v6u.addInfo("VALEXI", 0, -2, 1062);
            dfies_v6u.addInfo("NOAUTHCH", 0, -2, 1064);
            dfies_v6u.addInfo("SIGN", 0, -2, 1066);
            dfies_v6u.addInfo("DYNPFLD", 0, -2, 1068);
            dfies_v6u.addInfo("F4AVAILABL", 0, -2, 1070);
            dfies_v6u.addInfo("COMPTYPE", 0, -2, 1072);
            dfies_v6u.addInfo("LFIELDNAME", 0, -264, 1074);
            dfies_v6u.setTabLength(1338);
            ddtypelist_v6u.addInfo("TYPENAME", 0, -60, 0);
            ddtypelist_v6u.addInfo("TYPEKIND", 0, -8, 60);
            ddtypelist_v6u.addInfo("FIELDS", 99, -6, 72, 0, 0, dfies_v6u);
            ddtypelist_v6u.setTabLength(80);
        }
    }

    public static abstract class BasicRepository
    implements IRepository {
        protected String name;
        protected IRepository next_repository;
        protected Hashtable function_cache = new Hashtable(13);
        protected Hashtable structure_cache = new Hashtable(13);

        public BasicRepository(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public IFunctionTemplate getFunctionTemplate(String function_name) {
            IMetaData smeta;
            IMetaData fmeta;
            block33: {
                if (function_name == null) {
                    throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Function name equals null is not allowed.");
                }
                fmeta = null;
                smeta = null;
                try {
                    fmeta = this.getFunctionInterface(function_name);
                }
                catch (AbapException ex) {
                    if (ex.getKey().equalsIgnoreCase("FU_NOT_FOUND")) break block33;
                    throw ex;
                }
            }
            if (fmeta == null) {
                return null;
            }
            function_name = fmeta.getName();
            int num_fields = fmeta.getFieldCount();
            int ifields = 0;
            int efields = 0;
            int tfields = 0;
            int xfields = 0;
            int i = 0;
            while (i < num_fields) {
                if (fmeta.isImport(i) || fmeta.isExport(i)) {
                    if (fmeta.isExport(i)) {
                        ++efields;
                    }
                    if (fmeta.isImport(i)) {
                        ++ifields;
                    }
                } else if (fmeta.isTable(i)) {
                    ++tfields;
                } else if (fmeta.isException(i)) {
                    ++xfields;
                }
                ++i;
            }
            MetaData imeta = ifields > 0 ? new MetaData("INPUT", ifields) : null;
            MetaData emeta = efields > 0 ? new MetaData("OUTPUT", efields) : null;
            MetaData tmeta = tfields > 0 ? new MetaData("TABLES", tfields) : null;
            Vector<AbapException> xmeta = xfields > 0 ? new Vector<AbapException>(xfields) : null;
            i = 0;
            while (i < num_fields) {
                int charlength;
                int length;
                int flags;
                int n = flags = fmeta.isOptional(i) ? 4 : 0;
                if (fmeta.isNestedType1Structure(i)) {
                    flags |= 0x80;
                }
                if (fmeta.isImport(i) && !fmeta.isExport(i)) {
                    flags |= 1;
                    if (fmeta.getType(i) == 17 || fmeta.getType(i) == 99) {
                        smeta = this.getStructureDefinition(fmeta.getTabName(i));
                        if (smeta == null) {
                            return null;
                        }
                        charlength = length = fmeta.getName(i).length();
                    } else {
                        length = fmeta.getInternalLength(i);
                        charlength = fmeta.getLength(i);
                    }
                    imeta.addInfo(fmeta.getName(i), fmeta.getType(i), charlength, length, -1, fmeta.getDecimals(i), fmeta.getDefault(i), fmeta.getDescription(i), flags, smeta, fmeta.getExtendedFieldMetaData(i));
                } else if (fmeta.isExport(i) && !fmeta.isImport(i)) {
                    flags |= 2;
                    if (fmeta.getType(i) == 17 || fmeta.getType(i) == 99) {
                        smeta = this.getStructureDefinition(fmeta.getTabName(i));
                        if (smeta == null) {
                            return null;
                        }
                        charlength = length = fmeta.getName(i).length();
                    } else {
                        length = fmeta.getInternalLength(i);
                        charlength = fmeta.getLength(i);
                    }
                    emeta.addInfo(fmeta.getName(i), fmeta.getType(i), charlength, length, -1, fmeta.getDecimals(i), fmeta.getDefault(i), fmeta.getDescription(i), flags, smeta, fmeta.getExtendedFieldMetaData(i));
                } else if (fmeta.isImport(i) && fmeta.isExport(i)) {
                    flags |= 3;
                    if (fmeta.getType(i) == 17 || fmeta.getType(i) == 99) {
                        smeta = this.getStructureDefinition(fmeta.getTabName(i));
                        if (smeta == null) {
                            return null;
                        }
                        charlength = length = fmeta.getName(i).length();
                    } else {
                        length = fmeta.getInternalLength(i);
                        charlength = fmeta.getLength(i);
                    }
                    imeta.addInfo(fmeta.getName(i), fmeta.getType(i), charlength, length, -1, fmeta.getDecimals(i), fmeta.getDefault(i), fmeta.getDescription(i), flags, smeta, fmeta.getExtendedFieldMetaData(i));
                    emeta.addInfo(fmeta.getName(i), fmeta.getType(i), charlength, length, -1, fmeta.getDecimals(i), fmeta.getDefault(i), fmeta.getDescription(i), flags, smeta, fmeta.getExtendedFieldMetaData(i));
                } else if (fmeta.isTable(i)) {
                    smeta = this.getTableDefinition(fmeta.getTabName(i));
                    if (smeta == null) {
                        return null;
                    }
                    length = fmeta.getName(i).length();
                    tmeta.addInfo(fmeta.getName(i), fmeta.getType(i), length, length, -1, fmeta.getDecimals(i), fmeta.getDefault(i), fmeta.getDescription(i), flags, smeta, fmeta.getExtendedFieldMetaData(i));
                } else if (fmeta.isException(i)) {
                    xmeta.addElement(new AbapException(fmeta.getName(i), fmeta.getDescription(i)));
                }
                ++i;
            }
            return new FunctionTemplate(function_name, (IMetaData)imeta, (IMetaData)emeta, (IMetaData)tmeta, xmeta);
        }

        public IMetaData getFunctionInterface(String function_name) {
            if (function_name == null) {
                throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Function name equals null is not allowed.");
            }
            return (IMetaData)this.function_cache.get(function_name);
        }

        public IMetaData getStructureDefinition(String structure_name) {
            if (structure_name == null) {
                throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Structure name equals null is not allowed.");
            }
            return (IMetaData)this.structure_cache.get(structure_name);
        }

        public IMetaData getTableDefinition(String table_name) {
            return this.getStructureDefinition(table_name);
        }

        public IRepository getNextRepository() {
            return this.next_repository;
        }

        public void setNextRepository(IRepository next) {
            this.next_repository = next;
        }

        public synchronized void addFunctionInterfaceToCache(IMetaData meta) {
            if (meta != null) {
                this.addFunctionInterfaceToCache(meta.getName(), meta);
            }
        }

        public synchronized void addFunctionInterfaceToCache(String key, IMetaData meta) {
            if (key == null || meta == null) {
                return;
            }
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] addFunctionInterfaceToCache(\"" + key + "\") inserting into cache");
            }
            this.function_cache.put(key, meta);
        }

        public synchronized void addStructureDefinitionToCache(IMetaData meta) {
            if (meta != null) {
                this.addStructureDefinitionToCache(meta.getName(), meta);
            }
        }

        public synchronized void addStructureDefinitionToCache(String key, IMetaData meta) {
            if (key == null || meta == null) {
                return;
            }
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] addStructureDefinitionToCache(\"" + key + "\") inserting into cache");
            }
            this.structure_cache.put(key, meta);
        }

        public synchronized void removeFunctionInterfaceFromCache(String function_name) {
            this.function_cache.remove(function_name);
        }

        public synchronized void removeStructureDefinitionFromCache(String structure_name) {
            this.structure_cache.remove(structure_name);
        }

        public synchronized String[] getCachedFunctionInterfaces() {
            String[] list = new String[this.function_cache.size()];
            int i = 0;
            Enumeration e = this.function_cache.keys();
            while (e.hasMoreElements()) {
                list[i++] = (String)e.nextElement();
            }
            return list;
        }

        public synchronized String[] getCachedStructureDefinitions() {
            String[] list = new String[this.structure_cache.size()];
            int i = 0;
            Enumeration e = this.structure_cache.keys();
            while (e.hasMoreElements()) {
                list[i++] = (String)e.nextElement();
            }
            return list;
        }

        public synchronized void save(String filename) throws IOException {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(filename));
            try {
                os.writeObject(this.name);
                os.writeObject(this.function_cache);
                os.writeObject(this.structure_cache);
            }
            catch (NotSerializableException ex) {
                throw new IOException("NotSerializableException: " + ex.getMessage());
            }
        }

        public synchronized void load(String filename) throws IOException {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(filename));
            try {
                this.name = (String)is.readObject();
                this.function_cache = (Hashtable)is.readObject();
                this.structure_cache = (Hashtable)is.readObject();
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex.getMessage());
            }
        }

        protected void writeHTML(String html_filename) {
            try {
                MetaData meta;
                PrintWriter os = new PrintWriter(new FileWriter(html_filename));
                os.println("<html><head></head>");
                os.println("<body bgcolor='" + JCO.getProperty(JCO.JCO_HTML_BACKGROUND) + "'>");
                String th = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND2);
                String hc = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND3);
                String bdr = JCO.getProperty(JCO.JCO_HTML_TABLE_BORDER);
                String fface = JCO.getProperty(JCO.JCO_HTML_FONT_FACE);
                String fsize = JCO.getProperty(JCO.JCO_HTML_FONT_SIZE);
                os.println("<table border='0' bgcolor='" + th + "' width='100%'>" + CRLF);
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Name:</th>");
                os.println("<tr align='LEFT' bgcolor='" + hc + "'>" + this.function_cache.size() + " Function Cache Entries</tr>" + CRLF);
                Enumeration e = this.function_cache.elements();
                while (e.hasMoreElements()) {
                    meta = (MetaData)e.nextElement();
                    os.println("<tr align='LEFT' bgcolor='" + hc + "'>" + meta.getName() + "</tr><tr>" + CRLF);
                    meta.printHTML(os, meta, 0);
                    os.println(CRLF + "</tr>" + CRLF);
                }
                os.println("<tr align='LEFT' bgcolor='" + hc + "'>" + this.structure_cache.size() + " Structure Cache Entries</tr>" + CRLF);
                Enumeration e2 = this.structure_cache.keys();
                while (e2.hasMoreElements()) {
                    String key = (String)e2.nextElement();
                    meta = (MetaData)this.structure_cache.get(key);
                    os.println("<tr align='LEFT' bgcolor='" + hc + "'>" + key + "</tr><tr>" + CRLF);
                    meta.printHTML(os, meta, 0);
                    os.println(CRLF + "</tr>" + CRLF);
                }
                os.println("</table></body></html>");
                os.close();
            }
            catch (IOException ex) {
                throw new ConversionException("Cannot write repository " + this.getName() + " to HTML file " + html_filename);
            }
        }
    }

    public static class Function
    implements Serializable {
        private static final long serialVersionUID = 110011052001L;
        private String name;
        private ParameterList import_parameters;
        private ParameterList export_parameters;
        private ParameterList table_parameters;
        private AbapException[] exception_list;

        public Function(String name) {
            this(name, null, null, null);
        }

        public Function(String name, ParameterList input, ParameterList output, ParameterList tables) {
            if (input != null && input.rec_name == null) {
                input.rec_name = "INPUT";
            }
            if (output != null && output.rec_name == null) {
                output.rec_name = "OUTPUT";
            }
            if (tables != null && tables.rec_name == null) {
                tables.rec_name = "TABLES";
            }
            this.name = name;
            this.import_parameters = input;
            this.export_parameters = output;
            this.table_parameters = tables;
        }

        public Function(IFunctionTemplate template) {
            this.name = template.getName();
            IMetaData import_meta = template.getImportParameterList();
            IMetaData export_meta = template.getExportParameterList();
            IMetaData tables_meta = template.getTableParameterList();
            this.exception_list = template.getExceptionList();
            if (import_meta != null) {
                this.import_parameters = new Request(import_meta, export_meta, this.exception_list);
                this.import_parameters.rec_type = (byte)(this.import_parameters.rec_type & 0xFFFFFFEF);
            }
            if (export_meta != null) {
                this.export_parameters = new Response(export_meta, import_meta, this.exception_list);
                this.export_parameters.rec_type = (byte)(this.export_parameters.rec_type & 0xFFFFFFDF);
            }
            if (tables_meta != null) {
                this.table_parameters = new ParameterList(tables_meta);
            }
            this.exception_list = template.getExceptionList();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ParameterList getImportParameterList() {
            return this.import_parameters;
        }

        public void setImportParameterList(ParameterList import_parameters) {
            if (import_parameters.rec_name == null) {
                import_parameters.rec_name = "INPUT";
            }
            this.import_parameters = import_parameters;
        }

        public ParameterList getExportParameterList() {
            return this.export_parameters;
        }

        public void setExportParameterList(ParameterList export_parameters) {
            if (export_parameters.rec_name == null) {
                export_parameters.rec_name = "OUTPUT";
            }
            this.export_parameters = export_parameters;
        }

        public ParameterList getTableParameterList() {
            return this.table_parameters;
        }

        public void setTableParameterList(ParameterList table_parameters) {
            if (table_parameters.rec_name == null) {
                table_parameters.rec_name = "OUTPUT";
            }
            this.table_parameters = table_parameters;
        }

        public AbapException[] getExceptionList() {
            return this.exception_list;
        }

        public void setExceptionList(AbapException[] exception_list) {
            this.exception_list = exception_list;
        }

        public AbapException getException(String key) {
            if (this.exception_list == null) {
                return null;
            }
            int i = 0;
            while (i < this.exception_list.length) {
                if (this.exception_list[i].getKey().equalsIgnoreCase(key)) {
                    AbapException ex = this.exception_list[i];
                    return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
                }
                ++i;
            }
            return null;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("Name:   " + this.getName() + CRLF);
            b.append("Input:  \n" + this.import_parameters + CRLF);
            b.append("Output: \n" + this.export_parameters + CRLF);
            b.append("Tables: \n" + this.table_parameters + CRLF);
            if (this.exception_list != null) {
                b.append("Exceptions: \n");
                int i = 0;
                while (i < this.exception_list.length) {
                    b.append(this.exception_list[i].getKey() + CRLF);
                    ++i;
                }
            }
            return b.toString();
        }

        public void writeHTML(String html_filename) {
            try {
                this.writeHTML(new FileWriter(html_filename));
            }
            catch (java.lang.Exception ex) {
                throw new ConversionException("Cannot write function " + this.getName() + " to HTML file " + html_filename);
            }
        }

        public void writeHTML(Writer writer) throws IOException {
            String bg = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND1);
            String fg = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_FOREGROUND1);
            String fface = JCO.getProperty(JCO.JCO_HTML_FONT_FACE);
            String fsize = JCO.getProperty(JCO.JCO_HTML_FONT_SIZE);
            PrintWriter os = new PrintWriter(writer);
            os.println("<html><head></head>");
            os.println("<body bgcolor='" + JCO.getProperty(JCO.JCO_HTML_BACKGROUND) + "'>");
            os.println("<font face='" + fface + "' size='" + fsize + "'>");
            os.println("<table width='100%' border='1' bgcolor='" + bg + "'>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>" + this.name + "&nbsp;&nbsp;&nbsp;Date: " + new Date() + "</font></b></td></tr>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>Input Parameters</font></b></td></td>");
            os.println("<tr align='left'><td>");
            if (this.import_parameters != null && this.import_parameters.getFieldCount() > 0) {
                this.import_parameters.printHTML(os);
            } else {
                os.print("None");
            }
            os.println("</td></tr>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>Output Parameters</font></b></td></td>");
            os.println("<tr align='left'><td>");
            if (this.export_parameters != null && this.export_parameters.getFieldCount() > 0) {
                this.export_parameters.printHTML(os);
            } else {
                os.print("None");
            }
            os.println("</td></tr>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>Table Parameters</font></b></td></td>");
            os.println("<tr align='left'><td>");
            if (this.table_parameters != null && this.table_parameters.getFieldCount() > 0) {
                this.table_parameters.printHTML(os);
            } else {
                os.print("None");
            }
            os.println("</td></tr>");
            os.println("</table></font></body></html>");
            os.close();
        }

        public void writeXML(String xml_filename) {
            try {
                FileOutputStream os = new FileOutputStream(xml_filename);
                this.writeXML(os);
                os.close();
            }
            catch (IOException ex) {
                throw new ConversionException("Cannot write function " + this.getName() + " to XML file " + xml_filename);
            }
        }

        protected void writeXML(OutputStream output_stream) throws IOException {
            XMLWriterBase xmlWriterBase = new XMLWriterBase();
            OutputStreamWriter os = new OutputStreamWriter(output_stream, "UTF-8");
            PrintWriter out = new PrintWriter(os);
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<" + xmlWriterBase.escape(this.getName()) + ">");
            if (this.getImportParameterList() != null) {
                out.println(this.getImportParameterList().toXML());
            }
            if (this.getExportParameterList() != null) {
                out.println(this.getExportParameterList().toXML());
            }
            if (this.getTableParameterList() != null) {
                out.println(this.getTableParameterList().toXML());
            }
            out.println("</" + xmlWriterBase.escape(this.getName()) + ">");
            out.flush();
            os.flush();
        }
    }

    public static class FunctionTemplate
    implements IFunctionTemplate {
        private String name;
        private IMetaData import_parameters;
        private IMetaData export_parameters;
        private IMetaData table_parameters;
        private AbapException[] exception_list;

        public FunctionTemplate(String name, IMetaData input, IMetaData output, IMetaData tables, Vector exceptions) {
            this.name = name;
            this.import_parameters = input;
            this.export_parameters = output;
            this.table_parameters = tables;
            if (exceptions != null && exceptions.size() > 0) {
                this.exception_list = new AbapException[exceptions.size()];
                exceptions.copyInto(this.exception_list);
            }
        }

        public FunctionTemplate(String name, IMetaData input, IMetaData output, IMetaData tables, AbapException[] exceptions) {
            this.name = name;
            this.import_parameters = input;
            this.export_parameters = output;
            this.table_parameters = tables;
            this.exception_list = exceptions;
        }

        public Object clone() {
            try {
                return (IFunctionTemplate)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public IMetaData getImportParameterList() {
            return this.import_parameters;
        }

        public IMetaData getExportParameterList() {
            return this.export_parameters;
        }

        public IMetaData getTableParameterList() {
            return this.table_parameters;
        }

        public AbapException[] getExceptionList() {
            return this.exception_list;
        }

        public AbapException getException(String key) {
            if (this.exception_list == null) {
                return null;
            }
            int i = 0;
            while (i < this.exception_list.length) {
                if (this.exception_list[i].getKey().equalsIgnoreCase(key)) {
                    AbapException ex = this.exception_list[i];
                    return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
                }
                ++i;
            }
            return null;
        }

        public Function getFunction() {
            return new Function(this);
        }

        public Request getRequest() {
            int i;
            int num_tables;
            MetaData request_meta_data = null;
            MetaData response_meta_data = null;
            if (this.import_parameters != null) {
                request_meta_data = new MetaData(this.import_parameters);
                request_meta_data.rec_name = this.name;
            } else {
                request_meta_data = new MetaData(this.name);
            }
            if (this.table_parameters != null) {
                num_tables = this.table_parameters != null ? this.table_parameters.getFieldCount() : 0;
                i = 0;
                while (i < num_tables) {
                    request_meta_data.addInfo(this.table_parameters.getName(i), this.table_parameters.getType(i), this.table_parameters.getLength(i), this.table_parameters.getInternalLength(i), -1, this.table_parameters.getDecimals(i), this.table_parameters.getDefault(i), this.table_parameters.getDescription(i), ((MetaData)this.table_parameters).getFlags(i) | 0x40, this.table_parameters.getMetaData(i), this.table_parameters.getExtendedFieldMetaData(i));
                    ++i;
                }
            }
            if (this.export_parameters != null) {
                response_meta_data = new MetaData(this.export_parameters);
                response_meta_data.rec_name = this.name;
            } else {
                response_meta_data = new MetaData(this.name);
            }
            if (this.table_parameters != null) {
                num_tables = this.table_parameters != null ? this.table_parameters.getFieldCount() : 0;
                i = 0;
                while (i < num_tables) {
                    response_meta_data.addInfo(this.table_parameters.getName(i), this.table_parameters.getType(i), this.table_parameters.getLength(i), this.table_parameters.getInternalLength(i), -1, this.table_parameters.getDecimals(i), this.table_parameters.getDefault(i), this.table_parameters.getDescription(i), ((MetaData)this.table_parameters).getFlags(i) | 0x40, this.table_parameters.getMetaData(i), this.table_parameters.getExtendedFieldMetaData(i));
                    ++i;
                }
            }
            return new Request(request_meta_data, response_meta_data, this.getExceptionList());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Function:  " + CRLF + this.name + CRLF);
            sb.append("Input:     " + CRLF + this.import_parameters);
            sb.append("Output:    " + CRLF + this.export_parameters);
            sb.append("Tables:    " + CRLF + this.table_parameters);
            sb.append("Exceptions:");
            if (this.exception_list != null) {
                int i = 0;
                while (i < this.exception_list.length) {
                    sb.append(this.exception_list[i].getKey() + "  (" + this.exception_list[i].getMessage() + ")" + CRLF);
                    ++i;
                }
            }
            return sb.toString();
        }
    }

    public static interface IDocument {
        public void send(Client var1, String var2, String var3, int var4, char var5, int var6);
    }

    public static class Response
    extends ParameterList
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;

        protected Response(String name, AbapException[] exception_list) {
            this.rec_name = name;
            this.rec_type = (byte)(this.rec_type | 0x20);
            this.exception_list = exception_list;
        }

        protected Response(IMetaData response_meta_data, IMetaData request_meta_data, AbapException[] exception_list) {
            super(response_meta_data);
            this.rec_type = (byte)(this.rec_type | 0x20);
            this.dependant_meta_data = request_meta_data;
            this.exception_list = exception_list;
        }

        public AbapException[] getExceptionList() {
            return super.getExceptionList();
        }

        public AbapException getException(String key) {
            return super.getException(key);
        }
    }

    public static class Request
    extends ParameterList
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;

        protected Request(String name, AbapException[] exception_list) {
            this.rec_name = name;
            this.rec_type = (byte)(this.rec_type | 0x10);
            this.exception_list = exception_list;
        }

        protected Request(IMetaData request_meta_data, IMetaData response_meta_data, AbapException[] exception_list) {
            super(request_meta_data);
            this.rec_type = (byte)(this.rec_type | 0x10);
            this.dependant_meta_data = response_meta_data;
            this.exception_list = exception_list;
        }

        public AbapException[] getExceptionList() {
            return super.getExceptionList();
        }

        public AbapException getException(String key) {
            return super.getException(key);
        }
    }

    public static class Table
    extends Record
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;
        protected static final byte OP_NOOP = 0;
        protected static final byte OP_APPEND = 1;
        protected static final byte OP_INSERT = 2;
        protected static final byte OP_DELETE = 3;
        protected static final byte OP_UPDATE = 4;
        protected static final byte OP_CLEAR = 5;
        protected static final int OP_SHIFT = 29;
        protected static final int OP_OPCODE_MASK = -536870912;
        protected static final int OP_VALUE_MASK = 0x1FFFFFFF;
        private int row_capacity = 0;
        private int row_capacity_increment = 0;

        public Table(String name) {
            super(4, name);
        }

        public Table(IMetaData meta_data) {
            super(4, meta_data);
        }

        public Table(Table value) {
            super(4, value.getMetaData());
            this.copyContent(value, this);
        }

        protected Table(Structure value) {
            super(4, value.getMetaData());
            this.row_length = value.row_length;
            this.appendRow();
            System.arraycopy(value.data, 0, this.data, 0, this.row_length);
            int i = 0;
            while (i < value.num_odata) {
                Object o = value.odata[i];
                if (o != null) {
                    if (o instanceof Record) {
                        o = ((Record)o).clone();
                    } else if (!(o instanceof String) && o instanceof byte[]) {
                        o = ((byte[])o).clone();
                    }
                }
                this.odata[i] = o;
                ++i;
            }
            this.modified = true;
        }

        protected void copyContent(Record rsrc, Record rdest) {
            Table src = (Table)rsrc;
            Table dest = (Table)rdest;
            dest.row_capacity = src.row_capacity;
            dest.row_capacity_increment = src.row_capacity_increment;
            super.copyContent(src, dest);
        }

        protected static void copyRaw(Structure src, Table dest) {
            dest.copyRaw(src);
        }

        protected static void copyRaw(Table src, int srcrow, Table dest, int destrow) {
            if (srcrow < 0 || srcrow > src.num_rows || destrow < 0 || destrow > dest.num_rows) {
                throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Illegal row number in source or destination table.");
            }
            int save_destrow = dest.row;
            dest.row = destrow;
            dest.copyRaw(src, srcrow);
            dest.row = save_destrow;
        }

        protected void copyRaw(Structure src) {
            this.copyRaw(src, 0);
        }

        private void copyRaw(Record src, int srcrow) {
            int ioffset = this.boffset[0] + this.row * this.row_length;
            int src_ioffset = src.boffset[0] + srcrow * src.row_length;
            System.arraycopy(src.data, src_ioffset, this.data, ioffset, this.row_length);
            if (src.odata != null) {
                int src_offset = src.row * src.num_odata;
                int i = 0;
                while (i < src.num_odata) {
                    Object o = src.odata[i + src_offset];
                    if (o != null) {
                        if (o instanceof Record) {
                            o = ((Record)o).clone();
                        } else if (!(o instanceof String) && o instanceof byte[]) {
                            o = ((byte[])o).clone();
                        }
                    }
                    this.odata[this.row * this.num_odata + i] = o;
                    ++i;
                }
            }
            this.setModified(this.row);
        }

        public void addInfo(String name, int type, int length, int offset, int decimals, String sdefault, String description, int flags, Object tab_meta, IExtendedFieldMetaData extended) {
            if (!this.isEmpty()) {
                throw new Exception(128, "JCO_ERROR_NOT_SUPPORTED", "Changing of metadata is not allowed if the table already contains data. Please consult JCo documentation.");
            }
            super.addInfo(name, type, length, offset, decimals, sdefault, description, flags, tab_meta, extended);
            this.row_capacity = 0;
        }

        public void ensureBufferCapacity(int required_rows) {
            if (required_rows <= this.row_capacity) {
                return;
            }
            if (this.row_capacity <= 0) {
                this.row_capacity = Math.max(required_rows + 1, 2);
            } else {
                this.row_capacity = this.row_capacity_increment <= 0 ? (int)((double)this.row_capacity * 1.2 + 10.0) : this.row_capacity_increment + this.row_capacity + 1;
                this.row_capacity = Math.max(required_rows + 1, this.row_capacity);
            }
            int saved_num_rows = this.num_rows;
            this.num_rows = this.row_capacity;
            try {
                super.ensureBufferCapacity();
                int irow = this.num_rows;
                while (irow >= saved_num_rows) {
                    this.initializeRow(irow);
                    --irow;
                }
                Object var5_4 = null;
                this.num_rows = saved_num_rows;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.num_rows = saved_num_rows;
                throw throwable;
            }
        }

        public void trimToRows() {
            if (this.num_rows == 0 || this.num_rows == this.row_capacity) {
                return;
            }
            int capacity = (this.num_rows + 1) * this.row_length;
            char[] old_data = this.data;
            this.data = new char[capacity];
            System.arraycopy(old_data, 0, this.data, 0, Math.min(old_data.length, this.data.length));
            capacity = this.num_rows * this.num_odata;
            Object[] old_odata = this.odata;
            this.odata = new Object[capacity];
            System.arraycopy(old_odata, 0, this.odata, 0, Math.min(old_odata.length, this.odata.length));
            byte[] old_opcode = this.opcode;
            this.opcode = new byte[this.num_rows];
            System.arraycopy(old_opcode, 0, this.opcode, 0, Math.min(old_opcode.length, this.opcode.length));
            this.row_capacity = this.num_rows;
        }

        protected void setModified(int row) {
            super.setModified(row);
            if (this.opcode[row] == 0) {
                this.opcode[row] = 4;
            }
        }

        protected void appendDelta(byte opcode, int opvalue) {
            int old_code;
            byte old_opcode;
            super.setModified(0);
            if (opcode == 1 && this.delta != null && this.delta.length > 0 && (old_opcode = (byte)(((old_code = this.delta[this.delta.length - 1]) & 0xE0000000) >> 29)) == 1) {
                this.delta[this.delta.length - 1] = opcode << 29 | (opvalue += old_code & 0x1FFFFFFF) & 0x1FFFFFFF;
                return;
            }
            int[] old_delta = this.delta;
            this.delta = new int[(old_delta != null ? old_delta.length : 0) + 1];
            if (old_delta != null) {
                System.arraycopy(old_delta, 0, this.delta, 0, old_delta.length);
            }
            this.delta[this.delta.length - 1] = opcode << 29 | opvalue & 0x1FFFFFFF;
        }

        public int copyFrom(Record source) {
            int old_num_rows = this.num_rows;
            int n = super.copyFrom(source);
            this.appendDelta((byte)1, source.num_rows);
            int i = old_num_rows;
            while (i < this.num_rows) {
                this.opcode[i] = 1;
                ++i;
            }
            return n;
        }

        public final boolean isEmpty() {
            return this.num_rows == 0;
        }

        public final boolean isFirstRow() {
            return this.num_rows > 0 && this.row == 0;
        }

        public final boolean isLastRow() {
            return this.num_rows > 0 && this.row == this.num_rows - 1;
        }

        public final int getNumRows() {
            return this.num_rows;
        }

        public final int getNumColumns() {
            return this.num_fields;
        }

        public void clear() {
            if (this.num_rows == 0) {
                return;
            }
            this.data = new char[0];
            this.odata = new Object[0];
            this.opcode = new byte[0];
            this.appendDelta((byte)5, this.num_rows);
            this.row_capacity = 0;
            this.num_rows = 0;
            this.row = 0;
        }

        public void deleteAllRows() {
            this.clear();
        }

        public final void firstRow() {
            this.row = 0;
        }

        public final void lastRow() {
            this.row = this.num_rows <= 0 ? 0 : this.num_rows - 1;
        }

        public final boolean nextRow() {
            boolean eor;
            boolean bl = eor = ++this.row < this.num_rows;
            if (this.row >= this.num_rows) {
                this.row = this.num_rows - 1;
            }
            return eor;
        }

        public final boolean previousRow() {
            boolean bor;
            boolean bl = bor = --this.row >= 0;
            if (this.row < 0) {
                this.row = 0;
            }
            return bor;
        }

        public final int getRow() {
            return this.row;
        }

        public void setRow(int pos) {
            this.row = pos;
            if (this.row < 0) {
                this.row = 0;
            } else if (this.row >= this.num_rows) {
                this.row = this.num_rows > 0 ? this.num_rows - 1 : 0;
            }
        }

        public void appendRow() {
            this.insertRow(this.num_rows);
        }

        public void appendRows(int num_rows) {
            if (num_rows < 1) {
                return;
            }
            int old_num_rows = this.num_rows;
            this.row = this.num_rows;
            this.ensureBufferCapacity(this.num_rows + num_rows);
            this.num_rows += num_rows;
            int irow = this.num_rows;
            while (irow >= old_num_rows) {
                if (irow < this.num_rows) {
                    this.opcode[irow] = 1;
                }
                --irow;
            }
            this.appendDelta((byte)1, num_rows);
        }

        public void insertRow(int pos) {
            int mode = pos >= this.num_rows ? 1 : 2;
            pos = Math.min(Math.max(pos, 0), this.num_rows);
            this.ensureBufferCapacity(this.num_rows + 1);
            this.row = pos;
            int irow = this.num_rows;
            while (irow > pos) {
                System.arraycopy(this.data, (irow - 1) * this.row_length, this.data, irow * this.row_length, this.row_length);
                System.arraycopy(this.odata, (irow - 1) * this.num_odata, this.odata, irow * this.num_odata, this.num_odata);
                if (irow < this.num_rows) {
                    this.opcode[irow] = this.opcode[irow - 1];
                }
                --irow;
            }
            ++this.num_rows;
            this.initializeRow(pos);
            if (mode == 1) {
                this.opcode[pos] = 1;
                this.appendDelta((byte)1, 1);
            } else {
                this.opcode[pos] = 2;
                this.appendDelta((byte)2, pos);
            }
        }

        public void deleteRow() {
            this.deleteRow(this.row);
        }

        public void deleteRow(int pos) {
            if (pos < 0 && pos >= this.num_rows) {
                return;
            }
            int i = pos;
            while (i < this.num_rows) {
                System.arraycopy(this.data, (i + 1) * this.row_length, this.data, i * this.row_length, this.row_length);
                System.arraycopy(this.odata, (i + 1) * this.num_odata, this.odata, i * this.num_odata, this.num_odata);
                if (i < this.num_rows - 1) {
                    this.opcode[i] = this.opcode[i + 1];
                }
                ++i;
            }
            this.appendDelta((byte)3, pos);
            --this.num_rows;
            if (this.odata != null) {
                int i2 = (this.num_rows + 1) * this.num_odata;
                while (i2 < this.odata.length) {
                    this.odata[i2] = null;
                    ++i2;
                }
            }
            this.row = Math.min(Math.max(this.row, 0), this.num_rows - 1);
        }
    }

    public static class Structure
    extends Record
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;

        public Structure(String name) {
            super(2, name);
        }

        public Structure(IMetaData meta_data) {
            super(2, meta_data);
        }

        protected Structure(int rec_type, IMetaData meta_data) {
            super(rec_type, meta_data);
        }

        public Structure(Structure value) {
            super(value);
        }

        protected Structure(Table value) {
            this(value, value.getRow());
        }

        protected Structure(Table value, int row) {
            super(2, value.getMetaData());
            this.row_length = value.row_length;
            this.ensureBufferCapacity();
            System.arraycopy(value.data, row * value.row_length, this.data, 0, this.row_length);
            int i = 0;
            while (i < value.num_odata) {
                Object o = value.odata[row * value.num_odata + i];
                if (o != null) {
                    if (o instanceof Record) {
                        o = ((Record)o).clone();
                    } else if (!(o instanceof String) && o instanceof byte[]) {
                        o = ((byte[])o).clone();
                    }
                }
                this.odata[i] = o;
                ++i;
            }
        }
    }

    public static class ParameterList
    extends Record
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;
        protected IMetaData dependant_meta_data;
        protected AbapException[] exception_list;

        public ParameterList() {
            super(1, (String)null);
        }

        public ParameterList(IMetaData meta_data) {
            super(1, meta_data);
        }

        public ParameterList(ParameterList value) {
            super(value);
        }

        protected AbapException[] getExceptionList() {
            return this.exception_list;
        }

        protected AbapException getException(String key) {
            if (this.exception_list == null) {
                return null;
            }
            int i = 0;
            while (i < this.exception_list.length) {
                if (this.exception_list[i].getKey().equalsIgnoreCase(key)) {
                    AbapException ex = this.exception_list[i];
                    return new AbapException(ex.getKey(), ex.getMessage() == null ? ex.getKey() : ex.getMessage());
                }
                ++i;
            }
            return null;
        }

        private void appendField(String name, int type, int length, int decimals) {
            byte saved_rec_type = this.rec_type;
            try {
                this.rec_type = (byte)4;
                char[] old_data = this.data;
                Object[] old_odata = this.odata;
                this.addInfo(name, type, length, -1, decimals, null, null, 0, null, null);
                if (this.num_fields > 0) {
                    this.row_length = this.boffset[this.num_fields - 1] + this.blength[this.num_fields - 1];
                }
                if (old_data == null || old_data.length < this.row_length) {
                    this.data = new char[this.row_length];
                    System.arraycopy(old_data, 0, this.data, 0, old_data.length);
                }
                if (old_odata == null || old_odata.length < this.num_odata) {
                    this.odata = new Object[this.num_odata];
                    System.arraycopy(old_odata, 0, this.odata, 0, old_odata.length);
                }
                Object var9_8 = null;
                this.rec_type = saved_rec_type;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.rec_type = saved_rec_type;
                throw throwable;
            }
        }

        public void appendValue(String name, int type, int length, String value) {
            this.appendField(name, type, length, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, int value) {
            this.appendField(name, type, length, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, double value) {
            this.appendField(name, type, length, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, byte[] value) {
            this.appendField(name, type, length, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, Object value) {
            this.appendField(name, type, length, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, Table value) {
            this.appendField(name, 99, 0, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, Structure value) {
            this.appendField(name, 17, 0, 0);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, int decimals, String value) {
            this.appendField(name, type, length, decimals);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, int decimals, int value) {
            this.appendField(name, type, length, decimals);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, int decimals, double value) {
            this.appendField(name, type, length, decimals);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, int decimals, byte[] value) {
            this.appendField(name, type, length, decimals);
            this.setValue(value, this.num_fields - 1);
        }

        public void appendValue(String name, int type, int length, int decimals, Object value) {
            this.appendField(name, type, length, decimals);
            this.setValue(value, this.num_fields - 1);
        }

        public void setActive(boolean active, int index) {
            if (this.type[index] == 99 || this.type[index] == 5 || this.type[index] == 17 && !this.isNestedType1Structure(index)) {
                if (active) {
                    int n = index;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFEF);
                } else {
                    int n = index;
                    this.flags[n] = (byte)(this.flags[n] | 0x10);
                }
            }
        }

        public void setActive(boolean active, String name) {
            this.setActive(active, this.indexOf(name));
        }

        protected String dumpContent() {
            byte itype;
            int index;
            Record r;
            Object o;
            StringBuffer buf = new StringBuffer();
            ArrayList<Object> mdsToDump = new ArrayList<Object>();
            ArrayList mdsDumped = new ArrayList();
            mdsToDump.add(this);
            while (!mdsToDump.isEmpty()) {
                MetaData md;
                o = mdsToDump.remove(0);
                mdsDumped.add(o);
                if (o instanceof Record) {
                    r = (Record)o;
                    md = (MetaData)o;
                } else if (o instanceof MetaData) {
                    r = null;
                    md = (MetaData)o;
                } else {
                    buf.append("warning unexpected class ").append(o.getClass().getName()).append(CRLF);
                    continue;
                }
                buf.append(md.getName());
                buf.append(" (").append(md.getUnicodeTypeAsString()).append(")");
                buf.append(CRLF);
                index = 0;
                while (index < md.num_fields) {
                    buf.append("   ");
                    String str = md.name[index];
                    buf.append(str);
                    int c = str.length();
                    while (c < 32) {
                        buf.append(' ');
                        ++c;
                    }
                    str = "-";
                    o = md.tab_meta[index];
                    if (o != null) {
                        if (o instanceof String) {
                            str = (String)o;
                        } else if (o instanceof IMetaData) {
                            str = ((IMetaData)o).getName();
                        }
                    }
                    buf.append(str);
                    int c2 = str.length();
                    while (c2 < 32) {
                        buf.append(' ');
                        ++c2;
                    }
                    str = md.getTypeAsString(index);
                    buf.append(str);
                    int c3 = str.length();
                    while (c3 < 10) {
                        buf.append(' ');
                        ++c3;
                    }
                    str = String.valueOf(md.boffset[index]);
                    buf.append(str);
                    int c4 = str.length();
                    while (c4 < 8) {
                        buf.append(' ');
                        ++c4;
                    }
                    str = String.valueOf(md.blength[index]);
                    buf.append(str);
                    int c5 = str.length();
                    while (c5 < 8) {
                        buf.append(' ');
                        ++c5;
                    }
                    str = String.valueOf(md.offset[index]);
                    buf.append(str);
                    int c6 = str.length();
                    while (c6 < 8) {
                        buf.append(' ');
                        ++c6;
                    }
                    str = String.valueOf(md.length[index]);
                    buf.append(str);
                    int c7 = str.length();
                    while (c7 < 8) {
                        buf.append(' ');
                        ++c7;
                    }
                    if ((md.flags[index] & 1) != 0) {
                        buf.append('i');
                    }
                    if ((md.flags[index] & 2) != 0) {
                        buf.append('e');
                    }
                    if ((md.flags[index] & 4) != 0) {
                        buf.append('o');
                    }
                    if ((md.flags[index] & 0x40) != 0) {
                        buf.append('H');
                    }
                    if ((md.flags[index] & 0x10) == 0) {
                        buf.append("A");
                    }
                    if ((md.flags[index] & 0x20) != 0) {
                        buf.append("M");
                    }
                    if ((md.flags[index] & 8) != 0) {
                        buf.append("U");
                    }
                    buf.append(CRLF);
                    itype = md.type[index];
                    if ((itype == 17 || itype == 99) && md.tab_meta[index] != null) {
                        if (!mdsToDump.contains(md.tab_meta[index]) && !mdsDumped.contains(md.tab_meta[index])) {
                            mdsToDump.add(md.tab_meta[index]);
                        } else {
                            try {
                                if (!mdsToDump.contains(r.getValue(index)) && !mdsDumped.contains(r.getValue(index))) {
                                    mdsToDump.add(r.getValue(index));
                                }
                            }
                            catch (java.lang.Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    ++index;
                }
            }
            if (this.num_odata != this.num_fields) {
                buf.append("content:").append(CRLF).append(TraceWriter.dumpContent(this.data, trace_level > 6, trace_level > 7 ? this.data.length : Math.min(1000, this.data.length)));
            }
            index = 0;
            while (index < this.num_fields) {
                itype = this.type[index];
                if (itype == 29 || itype == 30 || itype == 17 || itype == 99) {
                    o = this.odata[this.oindex[index]];
                    buf.append(this.name[index]).append(": ");
                    if (o == null) {
                        buf.append("null");
                    } else if (itype == 29) {
                        char[] ca = ((String)o).toCharArray();
                        buf.append(CRLF).append(TraceWriter.dumpContent(ca, trace_level > 6, trace_level > 7 ? ca.length : Math.min(1000, ca.length)));
                    } else if (itype == 30) {
                        byte[] ba = (byte[])o;
                        buf.append(CRLF).append(TraceWriter.dumpContent(ba, trace_level > 7 ? ba.length : Math.min(1000, ba.length)));
                    } else {
                        r = (Record)o;
                        boolean isFlat = true;
                        int rIdx = 0;
                        while (rIdx < r.getNumFields()) {
                            int rType = r.getType(rIdx);
                            if (rType == 29 || rType == 30 || rType == 17 || rType == 99) {
                                isFlat = false;
                                break;
                            }
                            ++rIdx;
                        }
                        if (isFlat) {
                            if (itype == 17) {
                                buf.append(CRLF).append(TraceWriter.dumpContent(r.data, trace_level > 6, trace_level > 7 ? r.data.length : Math.min(1000, r.data.length)));
                            } else {
                                buf.append(r.num_rows).append(" row(s)").append(CRLF);
                                int rowsToDump = trace_level > 7 ? r.num_rows : Math.min(5, r.num_rows);
                                char[] row_chars = new char[r.row_length];
                                int row = 0;
                                while (row < rowsToDump) {
                                    buf.append("row ").append(row).append(CRLF);
                                    System.arraycopy(r.data, row * r.row_length, row_chars, 0, row_chars.length);
                                    buf.append(TraceWriter.dumpContent(row_chars, trace_level > 6, trace_level > 7 ? row_chars.length : Math.min(1000, row_chars.length)));
                                    ++row;
                                }
                            }
                        } else {
                            char[] ca = r.toXML().toCharArray();
                            buf.append(CRLF).append(TraceWriter.dumpContent(ca, trace_level > 6, trace_level > 7 ? ca.length : Math.min(1000, ca.length)));
                        }
                    }
                    buf.append(CRLF);
                }
                ++index;
            }
            return buf.toString();
        }
    }

    public static class Record
    extends MetaData
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;
        protected static final byte PARAMETER = 1;
        protected static final byte STRUCTURE = 2;
        protected static final byte TABLE = 4;
        protected static final byte SEGMENT = 8;
        protected static final byte REQUEST = 16;
        protected static final byte RESPONSE = 32;
        protected byte rec_type = 1;
        protected char[] data = new char[0];
        protected Object[] odata = new Object[0];
        protected byte[] opcode = new byte[0];
        protected int[] delta = null;
        protected Type1Record type1_record = null;
        protected int row_length = 0;
        protected int num_rows = 0;
        protected int row = 0;
        protected boolean modified = false;
        private static final SyncDateFormat daterfc = new SyncDateFormat("yyyyMMdd");
        private static final SyncDateFormat dateiso = new SyncDateFormat("yyyy-MM-dd");
        private static final SyncDateFormat timerfc = new SyncDateFormat("HHmmss");
        private static final SyncDateFormat timeiso = new SyncDateFormat("HH:mm:ss");
        private static final String EMPTY_STRING = new String();

        public Record(int type) {
            this(type, (String)null);
        }

        public Record(IMetaData meta_data) {
            this(1, meta_data);
        }

        public Record(int rec_type, IMetaData meta_data) {
            super(meta_data);
            this.rec_type = (byte)rec_type;
            this.num_rows = (this.rec_type & 4) != 0 ? 0 : 1;
            this.ensureBufferCapacity();
            if ((rec_type & 1) != 0 || (rec_type & 2) != 0) {
                int i = 0;
                while (i < this.num_fields) {
                    int n = i++;
                    this.flags[n] = (byte)(this.flags[n] | 8);
                }
                if (meta_data != null && meta_data.isNestedType1Structure()) {
                    this.type1_record = new Type1Record();
                }
            }
            if (trace_level > 9) {
                JCO.fireTrace(10, "[JAV-LAYER] Record() [>>> " + Integer.toHexString(this.getObjectId()) + "]");
            }
        }

        protected Record(int rec_type, String rec_name) {
            this.rec_type = (byte)rec_type;
            this.num_rows = (this.rec_type & 4) != 0 ? 0 : 1;
            this.rec_name = rec_name;
            if (trace_level > 9) {
                JCO.fireTrace(10, "[JAV-LAYER] Record() [>>> " + Integer.toHexString(this.getObjectId()) + "]");
            }
        }

        protected Record(Record value) {
            super(value.getMetaData());
            this.copyContent(value, this);
            if (trace_level > 9) {
                JCO.fireTrace(10, "[JAV-LAYER] Record() [>>> " + Integer.toHexString(this.getObjectId()) + "]");
            }
        }

        protected void finalize() throws Throwable {
            if (trace_level > 9) {
                JCO.fireTrace(10, "[JAV-LAYER] Record.finalize() [<<< " + Integer.toHexString(this.getObjectId()) + "]");
            }
            super.finalize();
        }

        public Object clone() {
            Record obj = (Record)super.clone();
            this.copyContent(this, obj);
            if (trace_level > 9) {
                JCO.fireTrace(10, "[JAV-LAYER] Record.clone() [>>> " + Integer.toHexString(obj.getObjectId()) + "]");
            }
            return obj;
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Record)) {
                return false;
            }
            Record rec = (Record)obj;
            if (this.num_rows != rec.num_rows) {
                return false;
            }
            if (this.num_odata != rec.num_odata) {
                return false;
            }
            if (this.tab_length != rec.tab_length) {
                return false;
            }
            char[] d1 = this.data;
            char[] d2 = rec.data;
            int i = 0;
            int size = this.num_rows * this.row_length;
            while (i < size) {
                if (d1[i] != d2[i]) {
                    return false;
                }
                ++i;
            }
            int i2 = 0;
            int size2 = this.num_rows * this.num_odata;
            while (i2 < size2) {
                if (this.odata[i2] != null || rec.odata[i2] != null) {
                    if (this.odata[i2] == null && rec.odata[i2] != null || this.odata[i2] != null && rec.odata[i2] == null) {
                        return false;
                    }
                    if (this.odata[i2] instanceof Record || this.odata[i2] instanceof String) {
                        if (!this.odata[i2].equals(rec.odata[i2])) {
                            return false;
                        }
                        if (this.odata[i2] instanceof byte[]) {
                            if (!Arrays.equals((byte[])this.odata[i2], (byte[])rec.odata[i2])) {
                                return false;
                            }
                            throw new Exception(108, "JCO_ERROR_INTERNAL", "Unknown object type inside JCO.Record");
                        }
                    }
                }
                ++i2;
            }
            return true;
        }

        public int hashCode() {
            int hashcode = super.hashCode();
            int size = this.num_rows * this.row_length;
            int i = 0;
            while (i < size) {
                hashcode = 31 * hashcode + this.data[i];
                ++i;
            }
            size = this.num_rows * this.num_odata;
            int i2 = 0;
            while (i2 < size) {
                if (this.odata[i2] != null) {
                    hashcode = 31 * hashcode + this.odata[i2].hashCode();
                }
                ++i2;
            }
            return hashcode;
        }

        protected void copyContent(Record src, Record dest) {
            dest.rec_type = src.rec_type;
            dest.row_length = src.row_length;
            dest.num_rows = src.num_rows;
            dest.row = src.row;
            dest.modified = src.modified;
            if (src.type1_record != null) {
                dest.type1_record = (Type1Record)src.type1_record.clone();
            }
            if (src.data != null) {
                dest.data = (char[])src.data.clone();
            }
            if (src.delta != null) {
                dest.delta = (int[])src.delta.clone();
            }
            if (src.opcode != null) {
                dest.opcode = (byte[])src.opcode.clone();
            }
            if (src.odata != null) {
                dest.odata = (Object[])src.odata.clone();
                int i = 0;
                while (i < dest.odata.length) {
                    Object o = dest.odata[i];
                    if (o != null) {
                        if (o instanceof Record) {
                            o = ((Record)o).clone();
                        } else if (!(o instanceof String) && o instanceof byte[]) {
                            o = ((byte[])o).clone();
                        }
                    }
                    dest.odata[i] = o;
                    ++i;
                }
            }
        }

        protected ConversionException createConversionException(int index, String to_type) {
            return new ConversionException("Cannot convert field " + this.name[index] + " of type " + JCO.getJCOTypeString(this.type[index]) + " to " + to_type);
        }

        protected ConversionException createConversionException(int index, String from_type, String value) {
            if (value != null) {
                throw new ConversionException("Cannot convert a value of '" + value + "' from type " + from_type + " to " + JCO.getJCOTypeString(this.type[index]) + " at field " + this.name[index]);
            }
            throw new ConversionException("Cannot convert a value from type " + from_type + " to " + JCO.getJCOTypeString(this.type[index]) + " at field " + this.name[index]);
        }

        public void addInfo(String name, int type, int length, int offset, int decimals, String sdefault, String description, int flags, Object tab_meta, IExtendedFieldMetaData extended) {
            super.addInfo(name, type, length, offset, decimals, sdefault, description, flags, tab_meta, extended);
            if ((this.rec_type & 4) == 0) {
                this.ensureBufferCapacity();
                if (type == 17 && tab_meta instanceof IMetaData) {
                    int n = this.num_fields - 1;
                    this.flags[n] = (byte)(this.flags[n] | 8);
                } else if (type != 99) {
                    int n = this.num_fields - 1;
                    this.flags[n] = (byte)(this.flags[n] | 8);
                }
            }
        }

        protected void setModified(int row) {
            this.modified = true;
        }

        protected final boolean checkIfInitialized() {
            boolean is_initialized = false;
            int i = 0;
            while (i < this.num_fields) {
                if (this.type[i] == 17 || this.type[i] == 99 || this.type[i] == 29 || this.type[i] == 30) {
                    if (this.type[i] == 17 && ((Structure)this.odata[this.oindex[i]]).checkIfInitialized()) {
                        int n = i;
                        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
                        is_initialized = true;
                    } else if (this.type[i] == 99) {
                        int n = i;
                        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.num_fields && !is_initialized) {
                is_initialized = (this.flags[i] & 8) == 0;
                ++i;
            }
            return is_initialized;
        }

        protected void initializeRow(int irow) {
            int row_save = this.row;
            this.row = irow;
            String defval = null;
            if ((this.rec_type & 4) != 0 && this.row < this.num_rows) {
                System.arraycopy(this.data, this.num_rows * this.row_length, this.data, this.row * this.row_length, this.row_length);
                if (this.odata != null && this.odata.length > 0) {
                    int ifield = 0;
                    while (ifield < this.num_fields) {
                        byte itype = this.type[ifield];
                        Object template = this.odata[this.num_rows * this.num_odata + this.oindex[ifield]];
                        if ((itype == 17 || itype == 99) && template instanceof Record) {
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = ((Record)template).clone();
                        } else if (itype == 30 && template instanceof byte[]) {
                            byte[] cloned = new byte[((byte[])template).length];
                            System.arraycopy((byte[])template, 0, cloned, 0, ((byte[])template).length);
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = cloned;
                        } else if (itype == 29) {
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = template;
                        }
                        ++ifield;
                    }
                }
            } else {
                int ifield = 0;
                while (ifield < this.num_fields) {
                    int ilength;
                    int i;
                    int iend;
                    byte itype = this.type[ifield];
                    if ((this.rec_type & 1) != 0 && irow == 0 && this.defaults != null && this.defaults[ifield] != null) {
                        defval = this.defaults[ifield];
                        if (defval.equalsIgnoreCase("SY-DATUM")) {
                            defval = daterfc.format(new Date());
                        } else if (defval.equalsIgnoreCase("SY-LANGU")) {
                            defval = "EN";
                        } else if (defval.equalsIgnoreCase("SPACE")) {
                            defval = null;
                        } else if (defval.indexOf("'") >= 0 && defval.lastIndexOf("'") > 0) {
                            int i1 = defval.indexOf("'") + 1;
                            int i2 = defval.lastIndexOf("'");
                            defval = i1 > 0 && i2 > i1 ? defval.substring(i1, i2) : null;
                        }
                    } else {
                        defval = null;
                    }
                    if (itype == 0 || itype == 17 || itype == 99 || itype == 29 || itype == 30) {
                        int istart = this.boffset[ifield] + this.row * this.row_length;
                        iend = istart + this.blength[ifield];
                        i = istart;
                        while (i < iend) {
                            this.data[i] = 32;
                            ++i;
                        }
                        if (itype == 0 && defval != null) {
                            int ioffset = this.boffset[ifield] + this.row * this.row_length;
                            ilength = Math.min(this.blength[ifield], defval.length());
                            defval.getChars(0, ilength, this.data, ioffset);
                        } else if (itype == 29 && this.odata != null) {
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = defval != null ? defval : null;
                        } else if (itype == 30) {
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = defval == null ? null : (Object)Codecs.Hex.decode(defval);
                        }
                    } else if (itype == 1 || itype == 3 || itype == 6) {
                        int istart = this.boffset[ifield] + this.row * this.row_length;
                        iend = istart + this.blength[ifield];
                        i = istart;
                        while (i < iend) {
                            this.data[i] = 48;
                            ++i;
                        }
                        if (defval != null) {
                            int ioffset = this.boffset[ifield] + this.row * this.row_length;
                            ilength = Math.min(this.blength[ifield], defval.length());
                            defval.getChars(0, ilength, this.data, ioffset);
                        }
                    } else if (itype == 8 || itype == 9 || itype == 10) {
                        if (defval != null) {
                            try {
                                this.encodeINT(Integer.parseInt(defval), ifield, false);
                            }
                            catch (Exception ex) {}
                        }
                    } else if (itype == 7 && defval != null) {
                        try {
                            this.encodeFLOAT(Double.valueOf(defval), ifield, false);
                        }
                        catch (Exception ex) {}
                    } else if (itype == 2) {
                        if (defval != null) {
                            try {
                                this.encodeBCD(defval, ifield, false);
                            }
                            catch (Exception ex) {}
                        } else {
                            int ilength2 = this.length[ifield] * 2 - 1;
                            int n = this.boffset[ifield] + this.row * this.row_length + (ilength2 >> 2);
                            this.data[n] = (char)(this.data[n] | 12 << (3 - (ilength2 & 3) << 2));
                        }
                    }
                    if ((itype == 17 || itype == 99) && this.tab_meta[ifield] instanceof IMetaData) {
                        int ioffset = this.boffset[ifield] + this.row * this.row_length;
                        int ilength3 = this.blength[ifield];
                        String value = ((IMetaData)this.tab_meta[ifield]).getName();
                        ilength3 = Math.min(value.length(), ilength3);
                        value.getChars(0, ilength3, this.data, ioffset);
                    }
                    if (this.odata != null && this.odata.length > 0) {
                        if (itype == 17 && this.tab_meta[ifield] instanceof IMetaData) {
                            Structure obj = new Structure((IMetaData)this.tab_meta[ifield]);
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = obj;
                            obj.ensureBufferCapacity();
                        } else if (itype == 99 && this.tab_meta[ifield] instanceof IMetaData) {
                            Table obj = new Table((IMetaData)this.tab_meta[ifield]);
                            this.odata[this.row * this.num_odata + this.oindex[ifield]] = obj;
                            obj.ensureBufferCapacity();
                        }
                    }
                    ++ifield;
                }
            }
            this.row = row_save;
        }

        protected void ensureBufferCapacity() {
            Object[] old_odata = null;
            char[] old_data = null;
            boolean should_init = false;
            if (this.num_fields > 0) {
                this.row_length = this.boffset[this.num_fields - 1] + this.blength[this.num_fields - 1];
            }
            int ocapacity = (Math.max(this.num_rows, 1) + ((this.rec_type & 4) != 0 ? 1 : 0)) * this.num_odata;
            if (this.odata == null || this.odata.length < ocapacity) {
                should_init = true;
            }
            int capacity = (Math.max(this.num_rows, 1) + ((this.rec_type & 4) != 0 ? 1 : 0)) * this.row_length;
            if (this.data == null || this.data.length < capacity) {
                should_init = true;
            }
            if (should_init) {
                if (this.data != null && this.data.length > 0) {
                    old_data = this.data;
                }
                this.data = new char[capacity];
                if (this.odata != null && this.odata.length > 0) {
                    old_odata = this.odata;
                }
                this.odata = new Object[ocapacity];
                if ((this.rec_type & 4) == 0) {
                    int irow = 0;
                    while (irow < this.num_rows) {
                        this.initializeRow(irow);
                        ++irow;
                    }
                }
                if (old_data != null && old_data.length > 0) {
                    System.arraycopy(old_data, 0, this.data, 0, old_data.length);
                }
                if (old_odata != null && old_odata.length > 0) {
                    System.arraycopy(old_odata, 0, this.odata, 0, old_odata.length);
                }
            }
            if (this.opcode == null || this.opcode.length < this.num_rows) {
                byte[] old_opcode = this.opcode;
                this.opcode = new byte[this.num_rows];
                if (old_opcode != null) {
                    System.arraycopy(old_opcode, 0, this.opcode, 0, old_opcode.length);
                }
            }
        }

        protected final void checkRowCapacity() {
            if ((this.rec_type & 4) != 0 && this.num_rows == 0) {
                throw new Exception(106, "JCO_ERROR_RESOURCE", "Trying to access row values in a table which does not have any rows yet");
            }
        }

        public void clear() {
            this.initializeRow(0);
            int i = 0;
            while (i < this.num_fields) {
                if (this.type[i] == 99) {
                    this.getTable(i).clear();
                } else if (this.type[i] == 17) {
                    this.getStructure(i).clear();
                }
                ++i;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int copyFrom(Record source) {
            int n;
            int jrow_save;
            int irow_save;
            block53: {
                block54: {
                    boolean is_table;
                    if (source == null) return 0;
                    if (source.num_fields == 0) return 0;
                    if (source.num_rows == 0) {
                        return 0;
                    }
                    if (source.num_fields != this.num_fields) break block54;
                    boolean metadata_equals = true;
                    int i = 0;
                    while (i < source.num_fields) {
                        if (source.type[i] != this.type[i] || source.name[i] != this.name[i] || source.boffset[i] != this.boffset[i] || source.blength[i] != this.blength[i]) {
                            metadata_equals = false;
                            break;
                        }
                        ++i;
                    }
                    if (!metadata_equals) break block54;
                    boolean bl = is_table = (this.rec_type & 4) != 0;
                    if (is_table) {
                        ((Table)this).ensureBufferCapacity(this.num_rows + source.num_rows);
                    } else {
                        this.ensureBufferCapacity();
                    }
                    int offset = is_table ? this.boffset[0] + this.row_length * this.num_rows : this.boffset[0];
                    System.arraycopy(source.data, source.boffset[0], this.data, offset, source.row_length * source.num_rows);
                    offset = is_table ? this.boffset[0] + this.num_odata * this.num_rows : 0;
                    int i2 = 0;
                    while (true) {
                        block55: {
                            if (i2 < source.num_rows * source.num_odata) break block55;
                        }
                        if (source.odata[i2] instanceof String) {
                            this.odata[offset + i2] = source.odata[i2];
                        } else if (source.odata[i2] instanceof Record) {
                            this.odata[offset + i2] = ((Record)source.odata[i2]).clone();
                        } else if (source.odata[i2] instanceof byte[]) {
                            this.odata[offset + i2] = ((byte[])source.odata[i2]).clone();
                        } else {
                            JCO.fireTrace(0, "[JAV-LAYER] JCO.Record.copyFrom() unknown type in " + this.rec_name);
                        }
                        ++i2;
                    }
                    this.num_rows = is_table ? this.num_rows + source.num_rows : 1;
                    int i3 = 0;
                    while (true) {
                        if (i3 >= this.num_fields) {
                            this.modified = true;
                            return this.num_fields;
                        }
                        if ((source.flags[i3] & 8) != 0) {
                            int n2 = i3;
                            this.flags[n2] = (byte)(this.flags[n2] | 8);
                        } else {
                            int n3 = i3;
                            this.flags[n3] = (byte)(this.flags[n3] & 0xFFFFFFF7);
                        }
                        ++i3;
                    }
                }
                int[] index = new int[source.num_fields];
                irow_save = source.row;
                jrow_save = this.row;
                int jnum_rows_save = this.num_rows;
                boolean modified_save = this.modified;
                char[] data_save = null;
                Object[] odata_save = null;
                byte[] opcode_save = null;
                byte[] flags_save = null;
                try {
                    int n4;
                    block52: {
                        try {
                            int j;
                            int i = 0;
                            n = 0;
                            while (true) {
                                if (i >= source.num_fields) {
                                    if (n != 0) break;
                                    n4 = n;
                                    Object var23_23 = null;
                                    break block52;
                                }
                                index[i] = -1;
                                j = 0;
                                while (j < this.num_fields) {
                                    if (source.type[i] == this.type[j] && source.name[i].equals(this.name[j])) {
                                        index[i] = j;
                                        ++n;
                                        break;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            if (this.flags != null) {
                                flags_save = new byte[this.flags.length];
                                System.arraycopy(this.flags, 0, flags_save, 0, this.flags.length);
                            }
                            if (this.data != null) {
                                data_save = new char[this.data.length];
                                System.arraycopy(this.data, 0, data_save, 0, this.data.length);
                            }
                            if (this.odata != null) {
                                odata_save = new Object[this.odata.length];
                                System.arraycopy(this.odata, 0, odata_save, 0, this.odata.length);
                            }
                            if (this.opcode != null) {
                                opcode_save = new byte[this.opcode.length];
                                System.arraycopy(this.opcode, 0, opcode_save, 0, this.opcode.length);
                            }
                            if ((this.rec_type & 4) != 0) {
                                this.num_rows += source.num_rows;
                            }
                            this.ensureBufferCapacity();
                            i = 0;
                            while (true) {
                                if (i >= source.num_fields) {
                                    this.modified = true;
                                    break block53;
                                }
                                j = index[i];
                                if (j >= 0) {
                                    this.row = (this.rec_type & 4) != 0 ? jnum_rows_save : 0;
                                    byte itype = source.type[i];
                                    int ioffset = source.boffset[i];
                                    int ilength = source.blength[i];
                                    int joffset = this.boffset[j] + this.row * this.row_length;
                                    int jlength = this.blength[j];
                                    ilength = Math.min(ilength, jlength);
                                    if ((source.flags[i] & 8) != 0) {
                                        int n5 = j;
                                        this.flags[n5] = (byte)(this.flags[n5] | 8);
                                    } else {
                                        int n6 = j;
                                        this.flags[n6] = (byte)(this.flags[n6] & 0xFFFFFFF7);
                                    }
                                    source.row = 0;
                                    while (source.row < source.num_rows) {
                                        int k;
                                        if (itype == 0) {
                                            System.arraycopy(source.data, ioffset, this.data, joffset, ilength);
                                            k = ilength;
                                            while (k < jlength) {
                                                this.data[joffset + k] = 32;
                                                ++k;
                                            }
                                        } else if (itype == 2) {
                                            this.setValue((Object)source.getBigDecimal(i), j);
                                        } else if (itype == 6) {
                                            this.setValue(source.decodeNUM(i), j);
                                        } else if (itype == 4) {
                                            System.arraycopy(source.data, ioffset, this.data, joffset, ilength);
                                            k = ilength;
                                            while (k < jlength) {
                                                this.data[joffset + k] = '\u0000';
                                                ++k;
                                            }
                                        } else if (itype == 17) {
                                            Structure s = source.getStructure(i);
                                            this.setValue((Structure)(s == null ? s : s.clone()), j);
                                        } else if (itype == 99) {
                                            Table t = source.getTable(i);
                                            this.setValue((Table)(t == null ? t : t.clone()), j);
                                        } else if (itype == 29 || itype == 30) {
                                            this.setValue(source.getValue(i), j);
                                        } else {
                                            System.arraycopy(source.data, ioffset, this.data, joffset, ilength);
                                        }
                                        ioffset += source.row_length;
                                        joffset += this.row_length;
                                        ++this.row;
                                        ++source.row;
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            this.row = jrow_save;
                            this.num_rows = jnum_rows_save;
                            this.data = data_save;
                            this.odata = odata_save;
                            this.opcode = opcode_save;
                            this.flags = flags_save;
                            this.modified = modified_save;
                            source.row = irow_save;
                            throw ex;
                        }
                    }
                    source.row = irow_save;
                    this.row = jrow_save;
                    return n4;
                }
                catch (Throwable throwable) {
                    Object var23_25 = null;
                    source.row = irow_save;
                    this.row = jrow_save;
                    throw throwable;
                }
            }
            Object var23_24 = null;
            source.row = irow_save;
            this.row = jrow_save;
            return n;
        }

        public final Field getField(int index) {
            return new Field(this, index);
        }

        public final String getClassNameOfValue(int index) {
            byte t = this.type[index];
            switch (t) {
                case 0: 
                case 2: 
                case 6: 
                case 29: {
                    return "java.lang.String";
                }
                case 8: 
                case 9: 
                case 10: {
                    return "java.lang.Integer";
                }
                case 7: {
                    return "java.lang.Double";
                }
                case 4: 
                case 30: {
                    return "byte[]";
                }
                case 1: 
                case 3: {
                    return "java.util.Date";
                }
                case 17: {
                    return "com.sap.mw.jco.JCO.Structure";
                }
                case 99: {
                    return "com.sap.mw.jco.JCO.Table";
                }
            }
            return "java.lang.Object";
        }

        public Object getValue(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 0) {
                return this.decodeCHAR(index);
            }
            if (itype == 8 || itype == 10 || itype == 9) {
                return new Integer(this.decodeINT(index));
            }
            if (itype == 7) {
                return new Double(this.decodeFLOAT(index));
            }
            if (itype == 6) {
                return this.decodeNUM(index);
            }
            if (itype == 2) {
                return this.decodeBCD(index);
            }
            if (itype == 1) {
                return this.decodeDATE(index);
            }
            if (itype == 3) {
                return this.decodeTIME(index);
            }
            if (itype == 4) {
                return this.decodeBYTE(index);
            }
            if (itype == 29) {
                return this.decodeSTRING(index);
            }
            if (itype == 30) {
                return this.decodeXSTRING(index);
            }
            if (itype == 17) {
                return this.decodeSTRUCTURE(index);
            }
            if (itype == 99) {
                return this.decodeTABLE(index);
            }
            throw this.createConversionException(index, "object");
        }

        public String getString(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 0 || itype == 99 || itype == 17) {
                return this.decodeCHAR(index);
            }
            if (itype == 8 || itype == 10 || itype == 9) {
                return Integer.toString(this.decodeINT(index));
            }
            if (itype == 7) {
                return Double.toString(this.decodeFLOAT(index));
            }
            if (itype == 6) {
                return this.decodeNUM(index);
            }
            if (itype == 2) {
                return this.decodeBCD(index);
            }
            if (itype == 1) {
                String date = this.decodeCHAR(index);
                if (date != null && date.length() == 8) {
                    char[] buffer = new char[10];
                    date.getChars(0, 4, buffer, 0);
                    buffer[4] = 45;
                    date.getChars(4, 6, buffer, 5);
                    buffer[7] = 45;
                    date.getChars(6, 8, buffer, 8);
                    return new String(buffer);
                }
                return date;
            }
            if (itype == 3) {
                String time = this.decodeCHAR(index);
                if (time != null && time.length() == 6) {
                    char[] buffer = new char[8];
                    time.getChars(0, 2, buffer, 0);
                    buffer[2] = 58;
                    time.getChars(2, 4, buffer, 3);
                    buffer[5] = 58;
                    time.getChars(4, 6, buffer, 6);
                    return new String(buffer);
                }
                return time;
            }
            if (itype == 4) {
                return Codecs.Hex.encode(this.decodeBYTE(index));
            }
            if (itype == 29) {
                return this.decodeSTRING(index);
            }
            if (itype == 30) {
                return Codecs.Hex.encode(this.decodeXSTRING(index));
            }
            throw this.createConversionException(index, "java.lang.String");
        }

        public char getChar(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 0 || itype == 29) {
                String value;
                String string = value = itype == 0 ? this.decodeCHAR(index) : this.decodeSTRING(index);
                if (value == null || value.length() == 0) {
                    return ' ';
                }
                if (value.length() == 1) {
                    return value.charAt(0);
                }
                conversion_error = true;
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "char");
            }
            return ' ';
        }

        public byte getByte(int index) {
            if (this.blength[index] <= 1) {
                try {
                    byte itype = this.type[index];
                    if (itype == 0 || itype == 29) {
                        char c = this.getChar(index);
                        byte b = (byte)c;
                        if (b == c) {
                            return b;
                        }
                    } else {
                        short value = this.getShort(index);
                        byte casted_value = (byte)value;
                        if (casted_value == value) {
                            return casted_value;
                        }
                    }
                }
                catch (ConversionException conversionException) {
                    // empty catch block
                }
            }
            throw this.createConversionException(index, "byte");
        }

        public final byte getByte(String field_name) {
            return this.getByte(this.indexOf(field_name));
        }

        public float getFloat(int index) {
            try {
                double value = this.getDouble(index);
                return (float)value;
            }
            catch (ConversionException conversionException) {
                throw this.createConversionException(index, "float");
            }
        }

        public final float getFloat(String field_name) {
            return this.getFloat(this.indexOf(field_name));
        }

        public short getShort(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 8 || itype == 10 || itype == 9) {
                int value = this.decodeINT(index);
                short casted_value = (short)value;
                if (casted_value != value) {
                    throw this.createConversionException(index, "short");
                }
                return casted_value;
            }
            if ((itype == 4 || itype == 30) && this.length[index] <= 2) {
                byte[] b = itype == 4 ? this.decodeBYTE(index) : this.decodeXSTRING(index);
                short value = 0;
                int i = 0;
                while (i < b.length) {
                    value = (short)(value << 8 | b[i] & 0xFF);
                    ++i;
                }
                return value;
            }
            if (itype == 6) {
                try {
                    return Short.parseShort(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 0) {
                try {
                    return Short.parseShort(this.decodeCHAR(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                try {
                    return Short.parseShort(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "short");
            }
            return 0;
        }

        public int getInt(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 8 || itype == 10 || itype == 9) {
                return this.decodeINT(index);
            }
            if ((itype == 4 || itype == 30) && this.length[index] <= 4) {
                byte[] b = itype == 4 ? this.decodeBYTE(index) : this.decodeXSTRING(index);
                int value = 0;
                int i = 0;
                while (i < b.length) {
                    value = value << 8 | b[i] & 0xFF;
                    ++i;
                }
                return value;
            }
            if (itype == 6) {
                try {
                    return Integer.parseInt(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 0) {
                try {
                    return Integer.parseInt(this.decodeCHAR(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                try {
                    return Integer.parseInt(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "int");
            }
            return 0;
        }

        public long getLong(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 8 || itype == 10 || itype == 9) {
                return this.decodeINT(index);
            }
            if ((itype == 4 || itype == 30) && this.length[index] <= 8) {
                byte[] b = itype == 4 ? this.decodeBYTE(index) : this.decodeXSTRING(index);
                long value = 0L;
                int i = 0;
                while (i < b.length) {
                    value = value << 8 | (long)b[i] & 0xFFL;
                    ++i;
                }
                return value;
            }
            if (itype == 6) {
                try {
                    return Long.parseLong(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 0) {
                try {
                    return Long.parseLong(this.decodeCHAR(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                try {
                    return Long.parseLong(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "long");
            }
            return 0L;
        }

        public BigInteger getBigInteger(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 6) {
                try {
                    return new BigInteger(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 8 || itype == 10 || itype == 9) {
                try {
                    return new BigInteger(Integer.toString(this.decodeINT(index)));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 2) {
                try {
                    return new BigInteger(this.decodeBCD(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 0) {
                try {
                    return new BigInteger(this.decodeCHAR(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                try {
                    return new BigInteger(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "java.math.BigInteger");
            }
            return null;
        }

        public double getDouble(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 7) {
                return this.decodeFLOAT(index);
            }
            if (itype == 8 || itype == 10 || itype == 9) {
                return this.decodeINT(index);
            }
            if (itype == 6) {
                try {
                    return Double.valueOf(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 2) {
                try {
                    return Double.valueOf(this.decodeBCD(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 0) {
                try {
                    return Double.valueOf(this.decodeCHAR(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                try {
                    return Double.valueOf(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "double");
            }
            return 0.0;
        }

        public BigDecimal getBigDecimal(int index) {
            this.checkRowCapacity();
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 7) {
                try {
                    BigDecimal bd = new BigDecimal(this.decodeFLOAT(index));
                    return bd.setScale((int)this.decimals[index], 6);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 8 || itype == 10 || itype == 9) {
                try {
                    return new BigDecimal((double)this.decodeINT(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 6) {
                try {
                    return new BigDecimal(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 2) {
                try {
                    return new BigDecimal(this.decodeBCD(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 0) {
                try {
                    return new BigDecimal(this.decodeCHAR(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                try {
                    return new BigDecimal(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "java.math.BigDecimal");
            }
            return null;
        }

        public Date getDate(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 1 || itype == 0 || itype == 29) {
                return this.decodeDATE(index);
            }
            if (itype == 3) {
                return this.decodeTIME(index);
            }
            throw this.createConversionException(index, "java.util.Date");
        }

        public Date getTime(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 3 || itype == 0 || itype == 29) {
                return this.decodeTIME(index);
            }
            if (itype == 1) {
                return this.decodeDATE(index);
            }
            throw this.createConversionException(index, "java.util.Date");
        }

        public byte[] getByteArray(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 0) {
                return this.decodeCHAR(index).getBytes();
            }
            if (itype == 4) {
                return this.decodeBYTE(index);
            }
            if (itype == 29) {
                return this.decodeSTRING(index).getBytes();
            }
            if (itype == 30) {
                return this.decodeXSTRING(index);
            }
            throw this.createConversionException(index, "byte[]");
        }

        public char[] getCharArray(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 0) {
                return this.decodeCHARARRAY(index);
            }
            if (itype == 29) {
                String value = this.decodeSTRING(index);
                char[] result = new char[value.length()];
                value.getChars(0, value.length(), result, 0);
                return result;
            }
            throw this.createConversionException(index, "char[]");
        }

        public InputStream getBinaryStream(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 4) {
                return new ByteArrayInputStream(this.decodeBYTE(index));
            }
            if (itype == 30) {
                return new ByteArrayInputStream(this.decodeXSTRING(index));
            }
            if (itype == 0) {
                return new ByteArrayInputStream(this.decodeCHAR(index).getBytes());
            }
            if (itype == 29) {
                return new ByteArrayInputStream(this.decodeSTRING(index).getBytes());
            }
            throw this.createConversionException(index, "java.io.InputStream");
        }

        public Reader getCharacterStream(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 0) {
                return new StringReader(this.decodeCHAR(index));
            }
            if (itype == 29) {
                return new StringReader(this.decodeSTRING(index));
            }
            throw this.createConversionException(index, "java.io.Reader");
        }

        public Table getTable(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 99) {
                return this.decodeTABLE(index);
            }
            throw this.createConversionException(index, "JCO.Table");
        }

        public Structure getStructure(int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 17) {
                return this.decodeSTRUCTURE(index);
            }
            throw this.createConversionException(index, "JCO.Structure");
        }

        protected String getHTMLString(int index) {
            String s = this.getString(index);
            if (s == null) {
                return "&nbsp;";
            }
            if ((s = s.trim()).length() == 0) {
                return "&nbsp;";
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == ' ') {
                    sb.append("&nbsp;");
                } else if (c < '\u0080' && c != '&' & c != '<') {
                    sb.append(c);
                } else {
                    sb.append("&#" + c + ";");
                }
                ++i;
            }
            return sb.toString();
        }

        public String toXML(int index) {
            try {
                if (this.type[index] == 17) {
                    return XMLWriter.createXMLDocument(this.decodeSTRUCTURE(index), this.name[index]);
                }
                if (this.type[index] == 99) {
                    return XMLWriter.createXMLDocument(this.decodeTABLE(index), this.name[index]);
                }
                return new XMLWriter().element(index).toString();
            }
            catch (Exception ex1) {
                throw ex1;
            }
            catch (java.lang.Exception ex2) {
                throw this.createConversionException(index, "XML");
            }
        }

        public String toXML(String field_name) {
            return this.toXML(this.indexOf(field_name));
        }

        public String toXML() {
            return XMLWriter.createXMLDocument(this, this.rec_name);
        }

        public void fromXML(String data) {
            XMLReader reader = new XMLReader(this);
            reader.parse(data);
        }

        private void fromCharArray(char[] data) {
            XMLReader reader = new XMLReader(this);
            reader.parse(data, 0, data.length);
        }

        public void setValue(String value, int index) {
            this.checkRowCapacity();
            if (value == null || value.length() == 0) {
                this.setDefault(index);
                return;
            }
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 0) {
                this.encodeCHAR(value, index);
            } else if (itype == 10 || itype == 9 || itype == 8) {
                try {
                    this.encodeINT(Integer.parseInt(value), index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 7) {
                try {
                    Double dble = new Double(value.length() > 0 ? value : "0");
                    this.encodeFLOAT(dble, index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 6) {
                try {
                    this.encodeNUM(value, index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 2) {
                this.encodeBCD(value.length() > 0 ? value : "0", index);
            } else if (itype == 1) {
                try {
                    this.encodeDATE(value, index);
                }
                catch (java.lang.Exception ex) {
                    conversion_error = true;
                }
            } else if (itype == 3) {
                try {
                    this.encodeTIME(value, index);
                }
                catch (java.lang.Exception ex) {
                    conversion_error = true;
                }
            } else if (itype == 4) {
                try {
                    this.encodeBYTE(Codecs.Hex.decode(value), index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
            } else if (itype == 29) {
                this.encodeSTRING(value, index);
            } else if (itype == 30) {
                this.encodeXSTRING(Codecs.Hex.decode(value), index);
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "java.lang.String", value);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public final Field getField(String field_name) {
            return new Field(this, this.indexOf(field_name));
        }

        public final String getClassNameOfValue(String field_name) {
            return this.getClassNameOfValue(this.indexOf(field_name));
        }

        public final Object getValue(String field_name) {
            return this.getValue(this.indexOf(field_name));
        }

        public final String getString(String field_name) {
            return this.getString(this.indexOf(field_name));
        }

        public final char getChar(String field_name) {
            return this.getChar(this.indexOf(field_name));
        }

        public final short getShort(String field_name) {
            return this.getShort(this.indexOf(field_name));
        }

        public final int getInt(String field_name) {
            return this.getInt(this.indexOf(field_name));
        }

        public final long getLong(String field_name) {
            return this.getLong(this.indexOf(field_name));
        }

        public final BigInteger getBigInteger(String field_name) {
            return this.getBigInteger(this.indexOf(field_name));
        }

        public final double getDouble(String field_name) {
            return this.getDouble(this.indexOf(field_name));
        }

        public final BigDecimal getBigDecimal(String field_name) {
            return this.getBigDecimal(this.indexOf(field_name));
        }

        public final Date getDate(String field_name) {
            return this.getDate(this.indexOf(field_name));
        }

        public final Date getTime(String field_name) {
            return this.getTime(this.indexOf(field_name));
        }

        public final byte[] getByteArray(String field_name) {
            return this.getByteArray(this.indexOf(field_name));
        }

        public final char[] getCharArray(String field_name) {
            return this.getCharArray(this.indexOf(field_name));
        }

        public final InputStream getBinaryStream(String field_name) {
            return this.getBinaryStream(this.indexOf(field_name));
        }

        public final Reader getCharacterStream(String field_name) {
            return this.getCharacterStream(this.indexOf(field_name));
        }

        public final Table getTable(String field_name) {
            return this.getTable(this.indexOf(field_name));
        }

        public final Structure getStructure(String field_name) {
            return this.getStructure(this.indexOf(field_name));
        }

        protected void setDefault(int index) {
            byte itype = this.type[index];
            if (itype == 0) {
                this.encodeCHAR("", index);
            } else if (itype == 8 || itype == 9 || itype == 10) {
                this.encodeINT(0, index);
            } else if (itype == 1) {
                this.encodeCHAR("00000000", index);
            } else if (itype == 3) {
                this.encodeCHAR("000000", index);
            } else if (itype == 6) {
                try {
                    this.encodeNUM(0L, index);
                }
                catch (Exception exception) {}
            } else if (itype == 7) {
                this.encodeFLOAT(0.0, index);
            } else if (itype == 2) {
                this.encodeBCD("0", index);
            } else if (itype == 4) {
                this.encodeBYTE(new byte[1], index);
            } else if (itype == 29) {
                this.encodeSTRING("", index);
            } else if (itype == 30) {
                this.encodeXSTRING(new byte[1], index);
            } else {
                return;
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(char value, int index) {
            this.setValue(new String(new char[]{value}), index);
        }

        public void setValue(char[] value, int index) {
            this.setValue(value, 0, value.length, index);
        }

        public void setValue(char[] value, int from, int length, int index) {
            this.checkRowCapacity();
            if (value == null || length == 0) {
                this.setDefault(index);
                return;
            }
            if (length < 0) {
                throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Illegal length [" + length + "] was passed. Current field " + this.name[index]);
            }
            if (value.length < from + length) {
                throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Array length [" + value.length + "] less than length was passed [" + (from + length) + "]. Currentat field " + this.name[index]);
            }
            boolean conversion_error = false;
            byte itype = this.type[index];
            if (itype == 0) {
                this.encodeCHARS(value, from, length, index);
            } else if (itype == 29) {
                this.encodeSTRING(new String(value, from, length), index);
            } else {
                conversion_error = true;
            }
            if (conversion_error) {
                throw this.createConversionException(index, "char[]", new String(value, from, length));
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(short value, int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 8 || itype == 9 || itype == 10) {
                this.encodeINT(value, index);
            } else if (itype == 6) {
                try {
                    this.encodeNUM(value, index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (itype == 0) {
                this.encodeCHAR(Short.toString(value), index);
            } else if (itype == 7) {
                this.encodeFLOAT(value, index);
            } else if (itype == 2) {
                this.encodeBCD(Short.toString(value), index);
            } else if (itype == 29) {
                this.encodeSTRING(Short.toString(value), index);
            } else {
                throw this.createConversionException(index, "short", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(int value, int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 8 || itype == 9 || itype == 10) {
                this.encodeINT(value, index);
            } else if (itype == 6) {
                try {
                    this.encodeNUM(value, index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (itype == 0) {
                this.encodeCHAR(Integer.toString(value), index);
            } else if (itype == 7) {
                this.encodeFLOAT(value, index);
            } else if (itype == 2) {
                this.encodeBCD(Integer.toString(value), index);
            } else if (itype == 29) {
                this.encodeSTRING(Integer.toString(value), index);
            } else {
                throw this.createConversionException(index, "int", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(long value, int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 8 || itype == 9 || itype == 10) {
                int casted_value = (int)value;
                if ((long)casted_value != value) {
                    throw this.createConversionException(index, "long", null);
                }
                this.encodeINT(casted_value, index);
            } else if (itype == 6) {
                try {
                    this.encodeNUM(value, index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (itype == 0) {
                this.encodeCHAR(Long.toString(value), index);
            } else if (itype == 7) {
                this.encodeFLOAT(value, index);
            } else if (itype == 2) {
                this.encodeBCD(Long.toString(value), index);
            } else if (itype == 29) {
                this.encodeSTRING(Long.toString(value), index);
            } else {
                throw this.createConversionException(index, "long", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(double value, int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 7) {
                this.encodeFLOAT(value, index);
            } else if (itype == 0) {
                this.encodeCHAR(Double.toString(value), index);
            } else if (itype == 2) {
                this.encodeBCD(this.dtoa(value, this.decimals[index]), index);
            } else if (itype == 29) {
                this.encodeSTRING(Double.toString(value), index);
            } else {
                throw this.createConversionException(index, "double", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(byte[] value, int index) {
            this.checkRowCapacity();
            if (value == null || value.length == 0) {
                this.setDefault(index);
                return;
            }
            byte itype = this.type[index];
            if (itype == 4) {
                this.encodeBYTE(value, index);
            } else if (itype == 30) {
                this.encodeXSTRING(value, index);
            } else {
                throw this.createConversionException(index, "byte[]", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(Structure value, int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype != 17) {
                throw this.createConversionException(index, "JCO.Structure", value.getName());
            }
            this.encodeSTRUCTURE(value, index);
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(Table value, int index) {
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype != 99) {
                throw this.createConversionException(index, "JCO.Table", value.getName());
            }
            this.encodeTABLE(value, index);
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(Object value, int index) {
            this.checkRowCapacity();
            if (value == null) {
                this.setDefault(index);
                return;
            }
            byte itype = this.type[index];
            if (value instanceof String) {
                this.setValue((String)value, index);
            } else if (value instanceof char[]) {
                this.setValue((char[])value, index);
            } else if (value instanceof Integer) {
                this.setValue((int)((Integer)value), index);
            } else if (value instanceof Long) {
                this.setValue((long)((Long)value), index);
            } else if (value instanceof Short) {
                this.setValue(((Short)value).intValue(), index);
            } else if (value instanceof Double) {
                this.setValue((double)((Double)value), index);
            } else if (value instanceof Float) {
                this.setValue(((Float)value).doubleValue(), index);
            } else if (value instanceof BigInteger && itype == 6) {
                try {
                    this.encodeNUM(value.toString(), index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (value instanceof BigDecimal && itype == 2) {
                try {
                    BigDecimal bd = (BigDecimal)value;
                    bd = bd.setScale((int)this.decimals[index], 6);
                    this.encodeBCD(bd.toString(), index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (value instanceof BigDecimal && itype == 7) {
                try {
                    BigDecimal bd = (BigDecimal)value;
                    bd = bd.setScale((int)this.decimals[index], 6);
                    this.setValue(bd.doubleValue(), index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (itype == 1 && value == null) {
                this.encodeCHAR("00000000", index);
            } else if (itype == 1 && value instanceof Date) {
                this.setValue(dateiso.format((Date)value), index);
            } else if (itype == 3 && value == null) {
                this.encodeCHAR("000000", index);
            } else if (itype == 3 && value instanceof Date) {
                this.setValue(timeiso.format((Date)value), index);
            } else if (value instanceof byte[] && itype == 4) {
                this.setValue((byte[])value, index);
            } else if (value instanceof byte[] && itype == 30) {
                this.setValue((byte[])value, index);
            } else if (value instanceof Structure && itype == 17) {
                this.setValue((Structure)value, index);
            } else if (value instanceof Table && itype == 99) {
                this.setValue((Table)value, index);
            } else {
                throw this.createConversionException(index, "java.lang.Object", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(String value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(char[] value, String name) {
            this.setValue(value, 0, value.length, this.indexOf(name));
        }

        public void setValue(char[] value, int from, int length, String name) {
            this.setValue(value, from, length, this.indexOf(name));
        }

        public void setValue(char value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(short value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(int value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(long value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(double value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(float value, int index) {
            this.setValue((double)value, index);
        }

        public void setValue(float value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(byte value, int index) {
            if (this.blength[index] > 1) {
                throw new ConversionException("This is not a proper method to set the field " + this.name[index] + " , since this field is longer then 1 byte. Use different method.");
            }
            this.checkRowCapacity();
            byte itype = this.type[index];
            if (itype == 4) {
                byte[] b = new byte[]{value};
                this.encodeBYTE(b, index);
            } else if (itype == 30) {
                byte[] b = new byte[]{value};
                this.encodeXSTRING(b, index);
            } else if (itype == 0) {
                char[] c = new char[]{(char)value};
                this.encodeCHAR(new String(c), index);
            } else if (itype == 29) {
                char[] c = new char[]{(char)value};
                this.encodeSTRING(new String(c), index);
            } else if (itype == 10) {
                this.encodeINT(value, index);
            } else if (itype == 6) {
                try {
                    this.encodeNUM(value, index);
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage());
                }
            } else if (itype == 2) {
                this.encodeBCD(Byte.toString(value), index);
            } else {
                throw this.createConversionException(index, "byte", null);
            }
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
            this.setModified(this.row);
        }

        public void setValue(byte value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(byte[] value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(Structure value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(Table value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        public void setValue(Object value, String name) {
            this.setValue(value, this.indexOf(name));
        }

        protected char[] getDataBuffer() {
            return this.data;
        }

        protected int getDataBufferOffset(int index) {
            return this.row * this.row_length + this.boffset[index];
        }

        protected int getDataBufferRowLength() {
            return this.row_length;
        }

        private final void encodeCHAR(String value, int index) {
            if (value == null) {
                value = EMPTY_STRING;
            }
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            int iend = ioffset + ilength;
            ilength = Math.min(value.length(), ilength);
            this.ensureBufferCapacity();
            value.getChars(0, ilength, this.data, ioffset);
            ioffset += ilength;
            while (ioffset < iend) {
                this.data[ioffset++] = 32;
            }
        }

        private final void encodeCHARS(char[] value, int from, int length, int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            int iend = ioffset + ilength;
            ilength = Math.min(length, ilength);
            this.ensureBufferCapacity();
            System.arraycopy(value, from, this.data, ioffset, ilength);
            ioffset += ilength;
            while (ioffset < iend) {
                this.data[ioffset++] = 32;
            }
        }

        private final void encodeINT(int value, int index) {
            this.encodeINT(value, index, true);
        }

        /*
         * Unable to fully structure code
         */
        private final void encodeINT(int value, int index, boolean check_buffer) {
            block5: {
                block4: {
                    ioffset = this.boffset[index] + this.row * this.row_length;
                    iend = ioffset + this.blength[index];
                    itype = this.type[index];
                    if (check_buffer) {
                        this.ensureBufferCapacity();
                    }
                    if (itype != 10) break block4;
                    if (value < 0 || value > 255) {
                        throw this.createConversionException(index, "int", Integer.toString(value));
                    }
                    this.data[ioffset] = (char)((value & 255) << 8);
                    break block5;
                }
                if (itype != 9) ** GOTO lbl19
                if (value < -32768 || value > 32767) {
                    throw this.createConversionException(index, "int", Integer.toString(value));
                }
                this.data[ioffset] = (char)value;
                break block5;
lbl-1000:
                // 1 sources

                {
                    this.data[--iend] = (char)(value & 65535);
                    value >>= 16;
lbl19:
                    // 2 sources

                    ** while (iend > ioffset)
                }
            }
        }

        private final void encodeFLOAT(double dvalue, int index) {
            this.encodeFLOAT(dvalue, index, true);
        }

        private final void encodeFLOAT(double dvalue, int index, boolean check_buffer) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int iend = ioffset + this.blength[index];
            long value = Double.doubleToLongBits(dvalue);
            if (check_buffer) {
                this.ensureBufferCapacity();
            }
            while (iend > ioffset) {
                this.data[--iend] = (char)(value & 0xFFFFL);
                value >>= 16;
            }
        }

        private final void encodeNUM(long value, int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            int length = 0;
            this.ensureBufferCapacity();
            if (value < 0L) {
                throw new ConversionException("Value '" + value + "' cannot be converted to " + JCO.getJCOTypeString(this.type[index]) + " type at field " + this.name[index]);
            }
            long tmp_value = value;
            while (tmp_value > 0L) {
                ++length;
                tmp_value /= 10L;
            }
            if (length > ilength) {
                throw new ConversionException("Integer '" + value + "' has to many digits at field " + this.name[index]);
            }
            int i = 0;
            while (i < ilength - length) {
                this.data[ioffset++] = 48;
                ++i;
            }
            i = ilength - 1;
            ioffset += length;
            while (i >= ilength - length) {
                this.data[--ioffset] = (char)(48L + value % 10L);
                --i;
                value /= 10L;
            }
        }

        private final void encodeNUM(String value, int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            int length = 0;
            int start = 0;
            this.ensureBufferCapacity();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (length == 0 && c == '0') {
                    ++start;
                } else if (c >= '0' && c <= '9') {
                    ++length;
                } else {
                    throw new ConversionException("Value '" + value + "' cannot be converted to " + JCO.getJCOTypeString(this.type[index]) + " type at field " + this.name[index]);
                }
                ++i;
            }
            if (length > ilength) {
                throw new ConversionException("Integer '" + value + "' has to many digits at field " + this.name[index]);
            }
            i = 0;
            while (i < ilength - length) {
                this.data[ioffset++] = 48;
                ++i;
            }
            i = 0;
            while (i < length) {
                this.data[ioffset++] = value.charAt(start + i);
                ++i;
            }
        }

        private final void encodeBCD(String svalue, int index) {
            this.encodeBCD(svalue, index, true);
        }

        private final void encodeBCD(String svalue, int index, boolean check_buffer) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int iend = ioffset + this.blength[index];
            int ilength = this.length[index] * 2 - 1;
            int lradix = ilength + 1;
            byte ldecimals = this.decimals[index];
            String value = svalue;
            if (check_buffer) {
                this.ensureBufferCapacity();
            }
            int i = ioffset;
            while (i < iend) {
                this.data[i] = '\u0000';
                ++i;
            }
            if ((value = value.trim()).length() == 0) {
                value = "0";
            }
            if (value.charAt(0) == '-') {
                value = value.substring(1);
                int n = ioffset + (ilength >> 2);
                this.data[n] = (char)(this.data[n] | 13 << (3 - (ilength & 3) << 2));
            } else {
                if (value.charAt(0) == '+') {
                    value = value.substring(1);
                }
                int n = ioffset + (ilength >> 2);
                this.data[n] = (char)(this.data[n] | 12 << (3 - (ilength & 3) << 2));
            }
            int dot = value.indexOf(46);
            lradix = dot < 0 ? value.length() : dot;
            int lfraction = value.length() - lradix - 1;
            if (lradix + ldecimals > ilength) {
                throw new ConversionException("Number " + svalue + " cannot be encoded as a BCD of length " + ilength + " with " + ldecimals + " decimal places at field " + this.name[index]);
            }
            i = 0;
            int k = ilength - lradix - ldecimals;
            while (i < lradix) {
                int n = ioffset + (k >> 2);
                this.data[n] = (char)(this.data[n] | (value.charAt(i) - 48 & 0xF) << (3 - (k & 3) << 2));
                ++i;
                ++k;
            }
            if (lfraction <= 0) {
                return;
            }
            lfraction = dot + Math.min(lfraction, ldecimals) + 1;
            i = dot + 1;
            while (i < lfraction) {
                int n = ioffset + (k >> 2);
                this.data[n] = (char)(this.data[n] | (value.charAt(i) - 48 & 0xF) << (3 - (k & 3) << 2));
                ++i;
                ++k;
            }
        }

        private final void encodeBYTE(byte[] value, int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            int iend = ioffset + ilength;
            this.ensureBufferCapacity();
            int i = ioffset;
            while (i < iend) {
                this.data[i] = '\u0000';
                ++i;
            }
            ilength = Math.min(ilength * 2, value.length);
            int i2 = 0;
            while (i2 < ilength) {
                int n = ioffset + (i2 >> 1);
                this.data[n] = (char)(this.data[n] | (char)((value[i2] & 0xFF) << (1 - (i2 & 1) << 3)));
                ++i2;
            }
        }

        private final void encodeTIME(String value, int index) throws ParseException {
            String time = value;
            if (value.equals("240000") || value.equals("24:00:00") || value.equals("  :  :  ")) {
                time = "240000";
            } else {
                try {
                    time = timerfc.format(timeiso.parse(value));
                }
                catch (ParseException ex) {
                    time = timerfc.format(timerfc.parse(value));
                }
            }
            this.encodeCHAR(time, index);
        }

        private final void encodeDATE(String value, int index) throws ParseException {
            String date = value;
            if (value.length() == 0 || value.equals("0000-00-00") || value.equals("00000000") || value.equals("    -  -  ")) {
                date = "00000000";
            } else if (value.equals("9999-99-99") || value.equals("99999999")) {
                date = "99999999";
            } else {
                try {
                    date = daterfc.format(dateiso.parse(value));
                }
                catch (ParseException ex) {
                    date = daterfc.format(daterfc.parse(value));
                }
            }
            this.encodeCHAR(date, index);
        }

        private final void encodeSTRING(String value, int index) {
            this.ensureBufferCapacity();
            this.odata[this.row * this.num_odata + this.oindex[index]] = value;
        }

        private final void encodeXSTRING(byte[] value, int index) {
            this.ensureBufferCapacity();
            this.odata[this.row * this.num_odata + this.oindex[index]] = value;
        }

        private final void encodeSTRUCTURE(Structure value, int index) {
            this.encodeCHAR(value.getName(), index);
            this.odata[this.row * this.num_odata + this.oindex[index]] = value;
            value.ensureBufferCapacity();
        }

        private final void encodeTABLE(Table value, int index) {
            this.encodeCHAR(value.getName(), index);
            this.odata[this.row * this.num_odata + this.oindex[index]] = value;
            value.ensureBufferCapacity();
        }

        protected final void encodeGENERIC(char[] value, int voffset, int vlength, int index) {
            byte itype = this.type[index];
            this.ensureBufferCapacity();
            if (itype == 0) {
                int ioffset = this.boffset[index] + this.row * this.row_length;
                int ilength = this.blength[index];
                int iend = ioffset + ilength;
                ilength = Math.min(vlength, ilength);
                System.arraycopy(value, voffset, this.data, ioffset, ilength);
                ioffset += ilength;
                while (ioffset < iend) {
                    this.data[ioffset++] = 32;
                }
                int n = index;
                this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
                this.setModified(this.row);
            } else if (itype == 6) {
                int ioffset = this.boffset[index] + this.row * this.row_length;
                int ilength = this.blength[index];
                if (vlength > ilength) {
                    throw new ConversionException("Integer '" + new String(value, voffset, vlength) + "' has to many figures at field " + this.name[index]);
                }
                int i = 0;
                while (i < ilength - vlength) {
                    this.data[ioffset++] = 48;
                    ++i;
                }
                i = 0;
                while (i < vlength) {
                    this.data[ioffset++] = value[voffset++];
                    ++i;
                }
                int n = index;
                this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFF7);
                this.setModified(this.row);
            } else if (itype == 30 || itype == 4) {
                byte[] bytes = Codecs.Base64.decode(value, voffset, vlength);
                this.setValue(bytes, index);
            } else {
                this.setValue(new String(value, voffset, vlength), index);
            }
        }

        private final String decodeHEX(int index) {
            char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int llength = Math.max(this.length[index], 2 * this.blength[index]);
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < llength) {
                byte value = (byte)(this.data[ioffset + (i >> 1)] >> (1 - (i & 1) << 3) & 0xFF);
                buf.append(hex[value >> 4 & 0xF]);
                buf.append(hex[value >> 0 & 0xF]);
                ++i;
            }
            return buf.toString();
        }

        private final String decodeCHAR(int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            while (ilength > 0 && this.data[ioffset + ilength - 1] == ' ') {
                --ilength;
            }
            return new String(this.data, ioffset, ilength);
        }

        private final char[] decodeCHARARRAY(int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            char[] result = new char[ilength];
            System.arraycopy(this.data, ioffset, result, 0, ilength);
            return result;
        }

        /*
         * Unable to fully structure code
         */
        private final int decodeINT(int index) {
            block2: {
                block1: {
                    ioffset = this.boffset[index] + this.row * this.row_length;
                    iend = ioffset + this.blength[index];
                    itype = this.type[index];
                    value = 0;
                    if (itype != 10) break block1;
                    value = this.data[ioffset] >> 8;
                    break block2;
                }
                if (itype != 9) ** GOTO lbl13
                value = (short)this.data[ioffset];
                break block2;
lbl-1000:
                // 1 sources

                {
                    value = value << 16 | this.data[ioffset++];
lbl13:
                    // 2 sources

                    ** while (ioffset < iend)
                }
            }
            return value;
        }

        private final double decodeFLOAT(int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int iend = ioffset + this.blength[index];
            long value = 0L;
            while (ioffset < iend) {
                value = value << 16 | (long)this.data[ioffset++];
            }
            return Double.longBitsToDouble(value);
        }

        private final Date decodeDATE(int index) {
            String str = new String(this.data, this.boffset[index] + this.row * this.row_length, this.blength[index]);
            if ((str = str.trim()).length() == 0 || str.equals("00000000") || str.equals("0000-00-00")) {
                return null;
            }
            if (str.equals("99999999") || str.equals("9999-99-99")) {
                str = "99991231";
            }
            try {
                return daterfc.parse(str);
            }
            catch (java.lang.Exception ex) {
                try {
                    return dateiso.parse(str);
                }
                catch (java.lang.Exception ex2) {
                    throw new ConversionException(ex2.getMessage() + " in record " + this.rec_name + " at field " + this.name[index]);
                }
            }
        }

        private final Date decodeTIME(int index) {
            String str = new String(this.data, this.boffset[index] + this.row * this.row_length, this.blength[index]);
            if ((str = str.trim()).length() == 0) {
                return null;
            }
            if (str.equals("240000") || str.equals("24:00:00")) {
                str = "000000";
            }
            try {
                return timerfc.parse(str);
            }
            catch (java.lang.Exception ex) {
                try {
                    return timeiso.parse(str);
                }
                catch (java.lang.Exception ex2) {
                    throw new ConversionException(ex2.getMessage() + " in record " + this.rec_name + " at field " + this.name[index]);
                }
            }
        }

        private final String decodeNUM(int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int ilength = this.blength[index];
            return new String(this.data, ioffset, ilength);
        }

        private final String decodeBCD(int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int istart = -1;
            byte ldecimals = this.decimals[index];
            int llength = this.length[index] * 2 - 1;
            StringBuffer buf = new StringBuffer(llength);
            if ((this.data[ioffset + (llength >> 2)] >> (3 - (llength & 3) << 2) & 0xF) == 13) {
                buf.append('-');
            }
            int i = 0;
            while (i < llength && istart < 0) {
                if ((this.data[ioffset + (i >> 2)] >> (3 - (i & 3) << 2) & 0xF) != 0) {
                    istart = i;
                }
                ++i;
            }
            if (istart < 0) {
                return "0";
            }
            i = istart;
            while (i < llength - ldecimals) {
                buf.append((char)((this.data[ioffset + (i >> 2)] >> (3 - (i & 3) << 2) & 0xF) + 48));
                ++i;
            }
            if (ldecimals <= 0) {
                return buf.toString();
            }
            istart = llength - ldecimals;
            buf.append('.');
            i = istart;
            while (i < llength) {
                buf.append((char)((this.data[ioffset + (i >> 2)] >> (3 - (i & 3) << 2) & 0xF) + 48));
                ++i;
            }
            return buf.toString();
        }

        private final byte[] decodeBYTE(int index) {
            int ioffset = this.boffset[index] + this.row * this.row_length;
            int llength = this.length[index];
            byte[] value = new byte[llength];
            int i = 0;
            while (i < llength) {
                value[i] = (byte)(this.data[ioffset + (i >> 1)] >> (1 - (i & 1) << 3) & 0xFF);
                ++i;
            }
            return value;
        }

        private final String decodeSTRING(int index) {
            return (String)this.odata[this.row * this.num_odata + this.oindex[index]];
        }

        private final byte[] decodeXSTRING(int index) {
            return (byte[])this.odata[this.row * this.num_odata + this.oindex[index]];
        }

        private final Structure decodeSTRUCTURE(int index) {
            return (Structure)this.odata[this.row * this.num_odata + this.oindex[index]];
        }

        private final Table decodeTABLE(int index) {
            Table t = (Table)this.odata[this.row * this.num_odata + this.oindex[index]];
            if (t != null) {
                t.firstRow();
            }
            return t;
        }

        private double atod(char[] d, int from, int length) {
            if (length <= 0) {
                throw new NumberFormatException("length is less or equals zero");
            }
            int i = from;
            int end = from + length;
            int sign = 1;
            double result = 0.0;
            if (d[i] == '+') {
                sign = 1;
                ++i;
            } else if (d[i] == '-') {
                sign = -1;
                ++i;
            }
            while (d[i] != '.' && i < end) {
                if (d[i] < '0' || d[i] > '9') {
                    throw new NumberFormatException("Illegal character [" + d[i] + "] at position " + i);
                }
                result = result * 10.0 + (double)(d[i] - 48);
                ++i;
            }
            if (i >= end) {
                return (double)sign * result;
            }
            if (d[i] == '.') {
                ++i;
            }
            int exp = -1;
            while (i < end && d[i] != 'E' && d[i] != 'e') {
                if (d[i] < '0' || d[i] > '9') {
                    throw new NumberFormatException("Illegal character [" + d[i] + "] at position " + i);
                }
                result += (double)(d[i] - 48) * Math.pow(10.0, exp);
                ++i;
                --exp;
            }
            if (i >= end) {
                return result * (double)sign;
            }
            exp = 0;
            int expsign = 1;
            if (d[i] == 'E' || d[i] == 'e') {
                ++i;
            }
            if (d[i] == '+') {
                ++i;
            } else if (d[i] == '-') {
                ++i;
                expsign = -1;
            }
            while (i < end) {
                if (d[i] < '0' || d[i] > '9') {
                    throw new NumberFormatException("Illegal character [" + d[i] + "] at position " + i);
                }
                exp = exp * 10 + (d[i] - 48);
                ++i;
            }
            return result * Math.pow(10.0, exp * expsign) * (double)sign;
        }

        private String dtoa(double d, int decimals) {
            StringBuffer buf = new StringBuffer();
            boolean sign = false;
            if (d < 0.0) {
                sign = true;
                d *= -1.0;
            }
            int i = 0;
            while (i < decimals) {
                d *= 10.0;
                ++i;
            }
            long digits = (long)(d += 0.5);
            if (digits == 0L) {
                return "0";
            }
            buf.append(String.valueOf(digits));
            i = buf.length();
            if (i <= decimals) {
                buf.insert(0, "0.");
                i = decimals - i;
                while (--i >= 0) {
                    buf.insert(2, '0');
                }
            } else {
                buf.insert(buf.length() - decimals, '.');
            }
            i = buf.length();
            while (--i >= 0) {
                if (buf.charAt(i) != '0') break;
            }
            if (buf.charAt(i) != '.') {
                ++i;
            }
            buf.delete(i, buf.length());
            if (sign) {
                buf.insert(0, '-');
            }
            return buf.toString();
        }

        protected void internalSize(DataSize size) {
            super.internalSize(size);
            if (this.isNestedType1Structure() && this.type1_record != null) {
                this.type1_record.internalSize(size);
            }
            size.addDataBytes(this.data.length * 2);
            size.addDataBytes(this.odata.length * 2);
            int i = 0;
            while (i < this.odata.length) {
                if (this.odata[i] instanceof String) {
                    size.addDataBytes(((String)this.odata[i]).length() * 2);
                } else if (this.odata[i] instanceof Record) {
                    ((Record)this.odata[i]).internalSize(size);
                } else {
                    JCO.fireTrace(0, "[JAV-LAYER] Record.internalSize() unsupported type: " + this.odata[i].toString());
                }
                ++i;
            }
        }

        public final FieldIterator fields() {
            return new FieldIterator(this);
        }

        public void writeHTML(String html_filename) {
            try {
                this.writeHTML(new FileWriter(html_filename));
            }
            catch (IOException ex) {
                throw new ConversionException("Cannot write table " + this.getName() + " to HTML file " + html_filename);
            }
        }

        public void writeHTML(Writer writer) throws IOException {
            PrintWriter os = new PrintWriter(writer);
            os.println("<html><head></head>");
            os.println("<body bgcolor='" + JCO.getProperty(JCO.JCO_HTML_BACKGROUND) + "'>");
            this.printHTML(os);
            os.println("</body></html>");
            os.close();
        }

        protected void printHTML(PrintWriter os) {
            this.printHTML(os, (String)null, 0, MetaData.PRINT_HEADER_ALL);
        }

        protected void printHTML(PrintWriter os, String text, int level) {
            this.printHTML(os, (String)null, 0, MetaData.PRINT_HEADER_ALL);
        }

        protected void printHTML(PrintWriter os, String text, int level, int print_flags) {
            if (!(this.data != null && this.data.length != 0 || this.odata != null && this.odata.length != 0)) {
                super.printHTML(os, this, 0, print_flags);
                return;
            }
            String[] rc = new String[2];
            String th = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND2);
            String hc = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND3);
            rc[0] = JCO.getProperty(JCO.JCO_HTML_TABLE_ROW_BACKGROUND1);
            rc[1] = JCO.getProperty(JCO.JCO_HTML_TABLE_ROW_BACKGROUND2);
            String bdr = JCO.getProperty(JCO.JCO_HTML_TABLE_BORDER);
            String fface = JCO.getProperty(JCO.JCO_HTML_FONT_FACE);
            String fsize = JCO.getProperty(JCO.JCO_HTML_FONT_SIZE);
            int max_rows = 100;
            try {
                max_rows = Integer.parseInt(JCO.getProperty(JCO.JCO_HTML_TABLE_MAX_ROWS));
            }
            catch (Exception ex) {
                max_rows = 100;
            }
            int num_rows = Math.min(this.num_rows, max_rows);
            text = text == null ? (this.rec_name != null ? this.rec_name : "") : text + " (" + (this.rec_name != null ? this.rec_name : "") + ")";
            os.println("<font face='" + fface + "' size='" + fsize + "'>");
            os.println("<table border='" + bdr + "' bgcolor='" + th + "'" + (level > 0 ? " width='100%'" : "") + ">");
            os.println("<tr align='LEFT'>");
            if ((this.rec_type & 4) != 0) {
                os.print("<th colspan='" + (this.num_fields + 1) + "'>Table: " + text + " No. of Rows: " + this.num_rows + " Row-length: " + this.row_length + " (chars) " + this.tab_length + " (bytes)</th>" + CRLF);
            } else if ((this.rec_type & 2) != 0) {
                os.print("<th colspan='" + (this.num_fields + 1) + "'>Structure: " + text + "</th>" + CRLF);
            } else if ((this.rec_type & 0x10) != 0) {
                os.print("<th colspan='" + (this.num_fields + 1) + "'>Request: " + text + "</th>" + CRLF);
            } else if ((this.rec_type & 0x20) != 0) {
                os.print("<th colspan='" + (this.num_fields + 1) + "'>Response: " + text + "</th>" + CRLF);
            } else if ((this.rec_type & 1) != 0) {
                os.print("<th colspan='" + (this.num_fields + 1) + "'>Parameters: " + text + "</th>" + CRLF);
            } else if ((this.rec_type & 8) != 0) {
                os.print("<th colspan='" + (this.num_fields + 1) + "'>Segment: " + text + "</th>" + CRLF);
            }
            os.println(CRLF + "</tr>");
            os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Index:</th>");
            int i = 0;
            while (i < this.num_fields) {
                os.print("<th>" + (i + 1) + "</th>");
                ++i;
            }
            os.println(CRLF + "</tr>");
            if ((print_flags & MetaData.PRINT_HEADER_NAME) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Name:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<th>" + this.name[i] + "</th>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_TYPE) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Type:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + JCO.getJCOTypeString(this.type[i]) + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_LENGTH) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Size:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + this.getLength(i) + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_OFFSET) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Offset:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + this.offset[i] + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_DECIMALS) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Decimals:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + this.decimals[i] + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_DEFAULT) != 0 && this.defaults != null) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Default:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + (this.defaults[i] != null ? this.defaults[i] : "&nbsp;") + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_INTERNAL_LENGTH) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Internal Size:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + this.length[i] + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & MetaData.PRINT_HEADER_INTERNAL_OFFSET) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Internal Offset:</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>" + this.offset[i] + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if (this.data == null || this.data.length == 0) {
                os.println("</table></font>");
                return;
            }
            int row_save = this.row;
            int start_row = 0;
            int end_row = num_rows;
            while (true) {
                this.row = start_row;
                while (this.row < end_row) {
                    if ((this.rec_type & 4) != 0) {
                        if (this.row < this.num_rows) {
                            os.print("<tr bgcolor='" + rc[this.row % 2] + "' align='CENTER'><th align='left'>");
                            os.print(this.row + 1);
                            if (this.opcode != null && this.row < this.opcode.length && this.opcode[this.row] != 0) {
                                switch (this.opcode[this.row]) {
                                    case 1: {
                                        os.print("A");
                                        break;
                                    }
                                    case 2: {
                                        os.print("I");
                                        break;
                                    }
                                    case 4: {
                                        os.print("U");
                                    }
                                }
                            }
                            os.println("</th>");
                        } else {
                            os.println("<tr bgcolor='" + rc[this.row % 2] + "' align='CENTER'><th align='left'>" + "HDR" + "</th>");
                        }
                    } else {
                        os.println("<tr bgcolor='" + rc[this.row % 2] + "' align='CENTER'><th align='left'>Value:</th>");
                    }
                    i = 0;
                    while (i < this.num_fields) {
                        byte itype = this.type[i];
                        if (itype != 99 && (this.flags[i] & 4) != 0 && (this.flags[i] & 8) != 0) {
                            os.print("<td align='left'>&nbsp;");
                        } else if (itype == 0 || itype == 29) {
                            os.print("<td align='left'>\"" + this.getHTMLString(i) + "\"");
                        } else if (itype == 30 || itype == 6 || itype == 1 || itype == 3) {
                            os.print("<td align='left'>" + this.getHTMLString(i));
                        } else if (itype == 8 || itype == 10 || itype == 9) {
                            os.print("<td align='right'>" + this.getInt(i));
                        } else if (itype == 7 || itype == 2 || itype == 4) {
                            os.print("<td align='right'>" + this.getString(i));
                        } else if (itype == 17) {
                            os.print("<td align='center'><a href='#" + this.name[i] + "_" + this.row + "'>" + this.getStructure(i).getName());
                        } else if (itype == 99) {
                            os.print("<td align='center'><a href='#" + this.name[i] + "_" + this.row + "'>" + this.getTable(i).getName());
                        } else if (itype == 29 || itype == 30) {
                            os.print("<td align='center'><a href='#" + this.name[i] + "_" + this.row + "'>" + this.getHTMLString(i));
                        } else {
                            os.print("<td align='center'>??" + JCO.getJCOTypeString(this.type[i]) + "??");
                        }
                        os.print("</td>");
                        ++i;
                    }
                    os.println(CRLF + "</tr>");
                    ++this.row;
                }
                if (num_rows >= this.num_rows) break;
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>...</th>");
                i = 0;
                while (i < this.num_fields) {
                    os.print("<td>...</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
                start_row = this.num_rows - 1;
                end_row = num_rows = this.num_rows;
            }
            os.println("</table></font>");
            start_row = 0;
            while (true) {
                this.row = start_row;
                while (this.row < end_row) {
                    i = 0;
                    while (i < this.num_fields) {
                        if ((this.flags[i] & 0x10) == 0) {
                            if (this.type[i] == 99) {
                                os.print("<a name='" + this.name[i] + "_" + this.row + "'>");
                                Table table = (Table)this.getValue(i);
                                table.printHTML(os, this.name[i], 0, print_flags);
                            } else if (this.type[i] == 17) {
                                os.print("<a name='" + this.name[i] + "_" + this.row + "'>");
                                Structure structure = (Structure)this.getValue(i);
                                structure.printHTML(os, this.name[i], 0, print_flags);
                            }
                        }
                        ++i;
                    }
                    ++this.row;
                }
                if (num_rows >= this.num_rows) break;
                start_row = this.num_rows - 1;
                num_rows = this.num_rows;
            }
            this.row = row_save;
        }

        public String toString() {
            int ilength;
            int ioffset;
            byte itype;
            StringBuffer buf = new StringBuffer();
            int row_save = this.row;
            String line = null;
            int index = 0;
            while (index < this.num_fields) {
                itype = this.type[index];
                ioffset = this.boffset[index];
                ilength = this.blength[index];
                int i = ioffset;
                while (i < ioffset + ilength) {
                    if (itype == 8 || itype == 9 || itype == 10 || itype == 7 || itype == 2 || itype == 4) {
                        buf.append("----");
                    }
                    buf.append('-');
                    ++i;
                }
                ++index;
            }
            line = buf.toString();
            buf.setLength(0);
            buf.append(line);
            buf.append(CRLF);
            if ((this.rec_type & 4) != 0) {
                buf.append("| TABLE");
            } else if ((this.rec_type & 2) != 0) {
                buf.append("| STRUCTURE");
            } else if ((this.rec_type & 0x10) != 0) {
                buf.append("| REQUEST");
            } else if ((this.rec_type & 0x20) != 0) {
                buf.append("| RESPONSE");
            } else if ((this.rec_type & 1) != 0) {
                buf.append("| PARAMETERS");
            }
            buf.append(" '");
            buf.append(this.rec_name);
            buf.append("'" + CRLF);
            buf.append(line);
            buf.append(CRLF);
            int index2 = 0;
            while (index2 < this.num_fields) {
                itype = this.type[index2];
                ioffset = this.boffset[index2];
                ilength = this.blength[index2];
                String iname = this.name[index2];
                if (itype == 8 || itype == 9 || itype == 10 || itype == 7 || itype == 2 || itype == 4) {
                    ilength *= 4;
                }
                if (iname.length() > ilength - 1) {
                    iname = iname.substring(0, Math.max(ilength - 1, 0));
                }
                buf.append("| ");
                buf.append(iname);
                int j = 0;
                while (j < ilength - iname.length() - 1) {
                    buf.append(' ');
                    ++j;
                }
                ++index2;
            }
            buf.append("|" + CRLF);
            buf.append(line);
            buf.append(CRLF);
            buf.append('|');
            int index3 = 0;
            while (index3 < this.num_fields) {
                itype = this.type[index3];
                ioffset = this.boffset[index3];
                ilength = this.blength[index3];
                int i = ioffset;
                while (i < ioffset + ilength) {
                    if (itype == 8 || itype == 9 || itype == 10 || itype == 7 || itype == 2 || itype == 4) {
                        buf.append("   ");
                    }
                    buf.append(i % 10);
                    ++i;
                }
                buf.append('|');
                ++index3;
            }
            buf.append(CRLF);
            buf.append(line);
            buf.append(CRLF);
            if (this.data != null && this.data.length > 0) {
                this.row = 0;
                while (this.row < this.num_rows) {
                    buf.append('|');
                    int index4 = 0;
                    while (index4 < this.num_fields) {
                        itype = this.type[index4];
                        ioffset = this.boffset[index4] + this.row * this.row_length;
                        ilength = this.blength[index4];
                        if (itype == 0 || itype == 6 || itype == 1 || itype == 3 || itype == 99 || itype == 17) {
                            buf.append(this.data, ioffset, ilength);
                        } else if (itype == 8 || itype == 10 || itype == 9 || itype == 7 || itype == 6 || itype == 2 || itype == 4) {
                            buf.append(this.decodeHEX(index4));
                        } else if (itype == 29 || itype == 30) {
                            buf.append(this.getString(index4));
                        }
                        buf.append('|');
                        ++index4;
                    }
                    if (this.row < this.num_rows - 1) {
                        buf.append(CRLF);
                    }
                    ++this.row;
                }
            }
            buf.append(CRLF);
            buf.append(line);
            buf.append(CRLF);
            this.row = row_save;
            return buf.toString();
        }

        public void readXML(Reader reader) throws IOException {
            XMLReader.readXMLDocument(this, reader);
        }

        public void readXML(String xml_filename) throws IOException {
            FileInputStream is = new FileInputStream(xml_filename);
            InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
            this.readXML(reader);
            reader.close();
            is.close();
        }

        public void writeXML(Writer writer) throws IOException {
            this.writeXML(writer, "urn:sap-com:document:sap:rfc:functions", true);
        }

        public void writeXML(Writer writer, boolean with_header) throws IOException {
            this.writeXML(writer, "urn:sap-com:document:sap:rfc:functions", with_header);
        }

        public void writeXML(Writer writer, String namespace_urn, boolean with_header) throws IOException {
            XMLWriter w = new XMLWriter(writer);
            if (with_header) {
                w.prolog();
            }
            w.encode(this, this.rec_name + ((this.rec_type & 0x20) != 0 ? ".Response" : ""), "rfc", namespace_urn).flush();
            writer.flush();
        }

        public void writeXML(String xml_filename) throws IOException {
            FileOutputStream os = new FileOutputStream(xml_filename);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
            this.writeXML(writer);
            writer.flush();
            os.close();
        }

        protected static class XMLWriter
        extends XMLWriterBase {
            public static final String DEFAULT_NAMESPACE = "rfc";
            protected String m_namespace_urn;
            protected String[] m_tags = null;
            protected Record m_record = null;

            public static String createXMLDocument(Record record, String root_tag) {
                return XMLWriter.createXMLDocument(record, root_tag, null, null);
            }

            public static String createXMLDocument(Record record, String root_tag, String namespace, String namespace_urn) {
                String document = null;
                try {
                    XMLWriter w = new XMLWriter();
                    w.encode(record, root_tag, namespace, namespace_urn);
                    document = w.toString();
                    if (trace_level > 9) {
                        StringBuffer buffer = new StringBuffer(document);
                        int i = 0;
                        while (i < buffer.length()) {
                            buffer.insert(i, "\n");
                            i += 80;
                        }
                        JCO.fireTrace(10, "[JAV-LAYER] JCO.Record.XMLWriter.createXMLDocument(" + record.getName() + ") " + buffer);
                    }
                }
                catch (IOException ex) {
                    throw new ConversionException(ex.getMessage());
                }
                return document;
            }

            public static void writeXMLDocument(Record record, String root_tag, Writer writer) throws IOException {
                XMLWriter w = new XMLWriter(writer);
                w.encode(record, root_tag, null, null).flush();
            }

            public static void writeXMLDocument(Record record, String root_tag, String namespace, String namespace_urn, Writer writer) throws IOException {
                XMLWriter w = new XMLWriter(writer);
                w.encode(record, root_tag, namespace, namespace_urn).flush();
            }

            public XMLWriter() {
            }

            public XMLWriter(Writer writer) {
                this(null, writer);
            }

            public XMLWriter(XMLWriter parent, Writer writer) {
                super(parent, writer);
            }

            public XMLWriter encode(Record record, String root_tag) throws IOException {
                return this.encode(record, root_tag, null, null);
            }

            public XMLWriter encode(Record record, String root_tag, String namespace, String namespace_urn) throws IOException {
                this.m_record = record;
                this.m_namespace_urn = namespace_urn;
                int num_fields = this.m_record.getNumFields();
                if (num_fields == 1 && this.m_record.getName().length() == 0) {
                    this.m_tags = null;
                } else {
                    this.m_tags = new String[num_fields];
                    int i = 0;
                    while (i < num_fields) {
                        this.m_tags[i] = this.escape(this.m_record.getName(i));
                        ++i;
                    }
                }
                if (root_tag != null) {
                    root_tag = this.escape(root_tag);
                }
                String root_stag = root_tag;
                String root_etag = root_tag;
                String row_tag = "ITEM";
                if (root_tag != null && namespace != null) {
                    StringBuffer sb = new StringBuffer(root_stag.length() + namespace.length());
                    sb.append(namespace);
                    sb.append(':');
                    sb.append(root_stag);
                    root_etag = sb.toString();
                    if (namespace_urn != null) {
                        sb.append(" xmlns:");
                        sb.append(namespace);
                        sb.append("=\"");
                        sb.append(namespace_urn);
                        sb.append('\"');
                    }
                    root_stag = sb.toString();
                }
                row_tag = this.m_namespace_urn != null && this.m_namespace_urn.equals("urn:sap-com:document:sap:soap:functions:uc-style") ? (record.getLineTypeName() != null ? record.getLineTypeName() : "ITEM") : "item";
                int row_save = this.m_record.row;
                try {
                    if (root_stag != null) {
                        this.stag(root_stag);
                    }
                    this.m_record.row = 0;
                    while (this.m_record.row < this.m_record.num_rows) {
                        if ((this.m_record.rec_type & 4) != 0) {
                            this.stag(row_tag);
                        }
                        int i = 0;
                        while (i < num_fields) {
                            this.element(i);
                            ++i;
                        }
                        if ((this.m_record.rec_type & 4) != 0) {
                            this.etag(row_tag);
                        }
                        ++this.m_record.row;
                    }
                    if (root_etag != null) {
                        this.etag(root_etag);
                    }
                    Object var12_13 = null;
                    this.m_record.row = row_save;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    this.m_record.row = row_save;
                    throw throwable;
                }
                return this;
            }

            public XMLWriter element(int index) throws IOException {
                byte itype = this.m_record.type[index];
                String tag = this.m_tags != null ? this.m_tags[index] : null;
                this.stag(tag);
                switch (itype) {
                    case 0: 
                    case 6: {
                        int ioffset = this.m_record.boffset[index] + this.m_record.row * this.m_record.row_length;
                        int ilength = this.m_record.blength[index];
                        this.content(this.m_record.data, ioffset, ilength);
                        break;
                    }
                    case 4: 
                    case 30: {
                        this.content(this.m_record.getByteArray(index));
                        break;
                    }
                    case 17: 
                    case 99: {
                        XMLWriter w = new XMLWriter(this, null);
                        w.encode((Record)this.m_record.getValue(index), null, null, this.m_namespace_urn);
                        w.close();
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.m_escape_mode == 2 || this.m_escape_mode == 3) {
                            int ioffset = this.m_record.boffset[index] + this.m_record.row * this.m_record.row_length;
                            int ilength = this.m_record.blength[index];
                            this.content(this.m_record.data, ioffset, ilength);
                            break;
                        }
                        this.content(this.m_record.getString(index));
                        break;
                    }
                    default: {
                        this.content(this.m_record.getString(index));
                    }
                }
                this.etag(tag);
                return this;
            }
        }

        protected static class XMLReader
        extends XMLReaderBase {
            public static void readXMLDocument(Record record, String xmldoc) {
                XMLReader parser = new XMLReader(record);
                parser.parse(xmldoc);
            }

            public static void readXMLDocument(Record record, Reader reader) {
                XMLReader parser = new XMLReader(record);
                parser.parse(reader);
            }

            public XMLReader(Record record) {
                super(record);
            }

            protected void store(Record record, char[] value, int offset, int length, int index) {
                record.encodeGENERIC(value, offset, length, index);
            }
        }

        protected class Type1Record
        implements Cloneable,
        Serializable {
            protected char[] data = new char[0];
            protected int row_length = 0;

            protected Type1Record() {
                if (trace_level > 9) {
                    JCO.fireTrace(10, "[JAV-LAYER] Type1Record() [>>> " + this.hashCode() + "]");
                }
            }

            public Object clone() {
                try {
                    Type1Record obj = (Type1Record)super.clone();
                    obj.copy(this);
                    return obj;
                }
                catch (CloneNotSupportedException ex) {
                    return null;
                }
            }

            protected void copy(Type1Record type1Record) {
                if (type1Record == null) {
                    return;
                }
                this.ensureCapacity(type1Record.row_length);
                this.row_length = type1Record.row_length;
                System.arraycopy(type1Record.data, 0, this.data, 0, this.row_length);
            }

            private void ensureCapacity(int capacity) {
                if (this.data.length < capacity) {
                    char[] old_data = this.data;
                    this.data = new char[capacity];
                    System.arraycopy(old_data, 0, this.data, 0, old_data.length);
                }
            }

            protected void ensureBufferCapacity() {
                if (this.row_length == 0 && Record.this.type1_data.num_fields > 0) {
                    this.row_length = Record.this.type1_data.boffset[Record.this.type1_data.num_fields - 1] + Record.this.type1_data.blength[Record.this.type1_data.num_fields - 1];
                }
                if (this.data.length < this.row_length) {
                    char[] old_data = this.data;
                    this.data = new char[this.row_length];
                    System.arraycopy(old_data, 0, this.data, 0, old_data.length);
                }
            }

            protected void initialize() {
                Record.this.initializeRow(0);
                this.nested2Flat();
            }

            protected void nested2Flat() {
                this.ensureBufferCapacity();
                this.nested2Flat(Record.this, 0);
            }

            private final int nested2Flat(Record record, int dataOffset) {
                int dataLength;
                int startOffset;
                int i = 0;
                int lastCopyIndex = 0;
                while (i < record.num_fields) {
                    if (record.type[i] == 17) {
                        if (i > lastCopyIndex) {
                            startOffset = record.boffset[lastCopyIndex];
                            dataLength = record.boffset[i - 1] + record.blength[i - 1] - startOffset;
                            System.arraycopy(record.data, startOffset, this.data, dataOffset, dataLength);
                            dataOffset += dataLength;
                        }
                        lastCopyIndex = i + 1;
                        dataOffset = this.nested2Flat(record.decodeSTRUCTURE(i), dataOffset);
                    }
                    ++i;
                }
                if (i > lastCopyIndex) {
                    startOffset = record.boffset[lastCopyIndex];
                    dataLength = record.boffset[i - 1] + record.blength[i - 1] - startOffset;
                    System.arraycopy(record.data, startOffset, this.data, dataOffset, dataLength);
                    dataOffset += dataLength;
                }
                return dataOffset;
            }

            protected void flat2Nested() {
                this.flat2Nested(Record.this, 0);
            }

            private final int flat2Nested(Record record, int dataOffset) {
                int dataLength;
                int startOffset;
                int i = 0;
                int lastCopyIndex = 0;
                while (i < record.num_fields) {
                    if (record.type[i] == 17) {
                        if (i > lastCopyIndex) {
                            startOffset = record.boffset[lastCopyIndex];
                            dataLength = record.boffset[i - 1] + record.blength[i - 1] - startOffset;
                            System.arraycopy(this.data, dataOffset, record.data, startOffset, dataLength);
                            dataOffset += dataLength;
                        }
                        lastCopyIndex = i + 1;
                        dataOffset = this.flat2Nested(record.decodeSTRUCTURE(i), dataOffset);
                    }
                    ++i;
                }
                if (i > lastCopyIndex) {
                    startOffset = record.boffset[lastCopyIndex];
                    dataLength = record.boffset[i - 1] + record.blength[i - 1] - startOffset;
                    System.arraycopy(this.data, dataOffset, record.data, startOffset, dataLength);
                    dataOffset += dataLength;
                }
                return dataOffset;
            }

            protected void cleanup() {
                this.row_length = 0;
                this.data = new char[0];
            }

            protected void internalSize(DataSize size) {
                size.addDataBytes(this.data.length * 2);
            }

            protected void finalize() throws Throwable {
                if (trace_level > 9) {
                    JCO.fireTrace(10, "[JAV-LAYER] Type1Record.finalize() [<<< " + this.hashCode() + "]");
                }
                super.finalize();
            }
        }
    }

    public static class FieldIterator {
        private Field[] fields;
        int index = 0;

        public FieldIterator(Record rec) {
            int num_fields = rec.getFieldCount();
            this.fields = new Field[num_fields];
            int i = 0;
            while (i < num_fields) {
                this.fields[i] = new Field(rec, i);
                ++i;
            }
        }

        public void reset() {
            this.index = 0;
        }

        public boolean hasMoreElements() {
            return this.index < this.fields.length;
        }

        public boolean hasMoreFields() {
            return this.index < this.fields.length;
        }

        public boolean hasNextFields() {
            return this.index < this.fields.length;
        }

        public boolean hasPreviousFields() {
            return this.index > 0;
        }

        public Object nextElement() {
            if (this.index < this.fields.length) {
                return this.fields[this.index++];
            }
            throw new NoSuchElementException("FieldEnumerator");
        }

        public Field nextField() {
            if (this.index < this.fields.length) {
                return this.fields[this.index++];
            }
            throw new NoSuchElementException("FieldEnumerator");
        }

        public Field previousField() {
            if (this.index > 0) {
                return this.fields[--this.index];
            }
            throw new NoSuchElementException("FieldEnumerator");
        }
    }

    public static final class Field {
        private Record record;
        int index;

        protected Field(Record record, int index) {
            this.record = record;
            this.index = index;
        }

        public boolean isActive() {
            return (this.record.flags[this.index] & 0x10) == 0;
        }

        public boolean isInitialized() {
            return (this.record.flags[this.index] & 8) == 0;
        }

        public boolean isOptional() {
            return (this.record.flags[this.index] & 4) != 0;
        }

        public boolean isImport() {
            return (this.record.flags[this.index] & 1) != 0;
        }

        public boolean isExport() {
            return (this.record.flags[this.index] & 2) != 0;
        }

        public boolean isStructure() {
            return this.record.type[this.index] == 17;
        }

        public boolean isTable() {
            return this.record.type[this.index] == 99;
        }

        public String getName() {
            return this.record.getName(this.index);
        }

        public int getType() {
            return this.record.getType(this.index);
        }

        public int getOffset() {
            return this.record.getOffset(this.index);
        }

        public int getLength() {
            return this.record.getLength(this.index);
        }

        public int getDecimals() {
            return this.record.getDecimals(this.index);
        }

        public String getDefault() {
            return this.record.getDefault(this.index);
        }

        public String getDescription() {
            return this.record.getDescription(this.index);
        }

        public String getTypeAsString() {
            return JCO.getJCOTypeString(this.record.getType(this.index));
        }

        public IExtendedFieldMetaData getExtendedFieldMetaData() {
            return this.record.getExtendedFieldMetaData(this.index);
        }

        public final String getClassNameOfValue() {
            return this.record.getClassNameOfValue(this.index);
        }

        public Object getValue() {
            return this.record.getValue(this.index);
        }

        public String getString() {
            return this.record.getString(this.index);
        }

        public char getChar() {
            return this.record.getChar(this.index);
        }

        public short getShort() {
            return this.record.getShort(this.index);
        }

        public int getInt() {
            return this.record.getInt(this.index);
        }

        public long getLong() {
            return this.record.getLong(this.index);
        }

        public BigInteger getBigInteger() {
            return this.record.getBigInteger(this.index);
        }

        public double getDouble() {
            return this.record.getDouble(this.index);
        }

        public byte getByte(int index) {
            return this.record.getByte(index);
        }

        public float getFloat() {
            return this.record.getFloat(this.index);
        }

        public BigDecimal getBigDecimal() {
            return this.record.getBigDecimal(this.index);
        }

        public Date getDate() {
            return this.record.getDate(this.index);
        }

        public Date getTime() {
            return this.record.getTime(this.index);
        }

        public byte[] getByteArray() {
            return this.record.getByteArray(this.index);
        }

        public InputStream getBinaryStream() {
            return this.record.getBinaryStream(this.index);
        }

        public Reader getCharacterStream() {
            return this.record.getCharacterStream(this.index);
        }

        public Table getTable() {
            return this.record.getTable(this.index);
        }

        public Structure getStructure() {
            return this.record.getStructure(this.index);
        }

        public void setValue(Object value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(String value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(char value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(short value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(int value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(long value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(double value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(byte[] value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(Structure value) {
            this.record.setValue(value, this.index);
        }

        public void setValue(Table value) {
            this.record.setValue(value, this.index);
        }
    }

    public static class MetaData
    implements IMetaData,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 110011052001L;
        protected String[] name = new String[0];
        protected Object[] tab_meta = new Object[0];
        protected int[] offset = new int[0];
        protected int[] length = new int[0];
        protected int[] boffset = new int[0];
        protected int[] blength = new int[0];
        protected byte[] type = new byte[0];
        protected byte[] decimals = new byte[0];
        protected byte[] oindex = new byte[0];
        protected byte[] flags = new byte[0];
        protected String[] defaults = null;
        protected String[] description = null;
        protected IExtendedFieldMetaData[] extended_field_meta_data = null;
        protected int num_fields = 0;
        protected int num_odata = 0;
        protected int tab_length = 0;
        protected long type_handle = 0L;
        protected String rec_name = null;
        protected String type_name = null;
        protected Type1Data type1_data = null;
        protected Hashtable hash_of_indices = null;
        protected static int PRINT_HEADER_NAME = 1;
        protected static int PRINT_HEADER_TYPE = 2;
        protected static int PRINT_HEADER_LENGTH = 4;
        protected static int PRINT_HEADER_OFFSET = 8;
        protected static int PRINT_HEADER_DECIMALS = 16;
        protected static int PRINT_HEADER_DEFAULT = 32;
        protected static int PRINT_HEADER_INTERNAL_LENGTH = 64;
        protected static int PRINT_HEADER_INTERNAL_OFFSET = 128;
        protected static int PRINT_HEADER_ALL = 63;
        protected long last_active_timestamp = 0L;
        protected byte unicode_type = (byte)4;

        protected MetaData() {
            this(null, 0);
        }

        public MetaData(String rec_name) {
            this(rec_name, 0);
        }

        public MetaData(String rec_name, int capacity) {
            this.ensureCapacity(capacity);
            this.rec_name = rec_name;
        }

        public MetaData(IMetaData obj) {
            if (obj != null) {
                this.ensureCapacity(obj.getFieldCount());
                this.copy(obj);
                int i = 0;
                while (i < this.num_fields) {
                    if (this.tab_meta[i] != null) {
                        this.tab_meta[i] = this.tab_meta[i] instanceof String ? this.tab_meta[i] : (this.tab_meta[i] instanceof MetaData ? ((MetaData)this.tab_meta[i]).clone() : (this.tab_meta[i] instanceof IMetaData ? ((IMetaData)this.tab_meta[i]).clone() : null));
                    }
                    ++i;
                }
            }
        }

        protected void internalSize(DataSize size) {
            if (this.isNestedType1Structure() && this.type1_data != null) {
                this.type1_data.internalSize(size);
            }
            int i = this.name.length;
            while (--i >= 0) {
                size.addMetaDataBytes(this.name[i].length() * 2);
            }
            size.addMetaDataBytes(this.num_fields * 4 * 4);
            size.addMetaDataBytes(this.num_fields * 1 * 3);
        }

        protected int getObjectId() {
            return super.hashCode();
        }

        protected String getUnicodeTypeAsString() {
            switch (this.getUnicodeType()) {
                case 0: {
                    return "nuc/uc compatible";
                }
                case 1: {
                    return "nuc";
                }
                case 2: {
                    return "uc";
                }
                case 3: {
                    return "mixed";
                }
            }
            return "error";
        }

        protected byte getUnicodeType() {
            if (this.unicode_type == 4) {
                this.unicode_type = 0;
                int i = 0;
                while (i < this.num_fields) {
                    switch (this.type[i]) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 6: {
                            if (this.length[i] == this.blength[i]) {
                                this.unicode_type = (byte)(this.unicode_type | 1);
                                break;
                            }
                            if (this.length[i] == this.blength[i] * 2) {
                                this.unicode_type = (byte)(this.unicode_type | 2);
                                break;
                            }
                            this.unicode_type = (byte)(this.unicode_type | 3);
                            break;
                        }
                        case 17: 
                        case 99: {
                            try {
                                if (this.tab_meta[i] != null) {
                                    this.unicode_type = (byte)(this.unicode_type | ((MetaData)this.tab_meta[i]).getUnicodeType());
                                    break;
                                }
                                this.unicode_type = (byte)(this.unicode_type | ((MetaData)((Record)this).odata[this.oindex[i]]).getUnicodeType());
                                break;
                            }
                            catch (ClassCastException ex) {
                                break;
                            }
                            catch (NullPointerException ex) {
                                JCO.fireTrace(1, "null in tab_meta/odata [" + this.rec_name + " at field " + i + " type " + this.getTypeAsString(i) + "]");
                            }
                        }
                    }
                    ++i;
                }
            }
            return this.unicode_type;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof IMetaData)) {
                return false;
            }
            IMetaData m = (IMetaData)obj;
            if (this.num_fields != m.getFieldCount()) {
                return false;
            }
            int i = 0;
            while (i < this.num_fields) {
                if (this.type[i] != m.getType(i)) {
                    return false;
                }
                if (this.length[i] != m.getInternalLength(i)) {
                    return false;
                }
                if (!this.name[i].equals(m.getName(i))) {
                    return false;
                }
                if (this.decimals[i] != m.getDecimals(i)) {
                    return false;
                }
                if (this.type[i] == 17 || this.type[i] == 99) {
                    String o1 = this.getTabName(i);
                    String o2 = m.getTabName(i);
                    if (o1 != null && o2 != null && !o1.equals(o2)) {
                        return false;
                    }
                    if (o1 != null && o2 == null) {
                        return false;
                    }
                    if (o1 == null && o2 != null) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            int hashcode = 1;
            int i = 0;
            while (i < this.num_fields) {
                hashcode = 31 * hashcode + this.type[i];
                hashcode = 31 * hashcode + this.length[i];
                hashcode = 31 * hashcode + this.name[i].hashCode();
                hashcode = 31 * hashcode + this.decimals[i];
                if (this.type[i] == 17 || this.type[i] == 99) {
                    String o = this.getTabName(i);
                    hashcode = 31 * hashcode + (o == null ? 0 : o.hashCode());
                }
                ++i;
            }
            return hashcode;
        }

        public Object clone() {
            try {
                MetaData obj = (MetaData)super.clone();
                obj.copy(this);
                obj.flags = (byte[])this.flags.clone();
                return obj;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        protected void copy(IMetaData obj) {
            if (obj == null) {
                return;
            }
            this.ensureCapacity(obj.getFieldCount());
            this.setTabLength(obj.getTabLength());
            this.rec_name = obj.getName();
            if (obj instanceof MetaData) {
                MetaData meta = (MetaData)obj;
                this.num_fields = meta.num_fields;
                this.num_odata = meta.num_odata;
                this.type_handle = meta.type_handle;
                System.arraycopy(meta.name, 0, this.name, 0, this.num_fields);
                System.arraycopy(meta.tab_meta, 0, this.tab_meta, 0, this.num_fields);
                System.arraycopy(meta.offset, 0, this.offset, 0, this.num_fields);
                System.arraycopy(meta.boffset, 0, this.boffset, 0, this.num_fields);
                System.arraycopy(meta.length, 0, this.length, 0, this.num_fields);
                System.arraycopy(meta.blength, 0, this.blength, 0, this.num_fields);
                System.arraycopy(meta.type, 0, this.type, 0, this.num_fields);
                System.arraycopy(meta.decimals, 0, this.decimals, 0, this.num_fields);
                System.arraycopy(meta.oindex, 0, this.oindex, 0, this.num_fields);
                System.arraycopy(meta.flags, 0, this.flags, 0, this.num_fields);
                if (meta.defaults != null) {
                    this.defaults = (String[])meta.defaults.clone();
                }
                if (meta.description != null) {
                    this.description = (String[])meta.description.clone();
                }
                if (meta.extended_field_meta_data != null) {
                    this.extended_field_meta_data = (IExtendedFieldMetaData[])meta.extended_field_meta_data.clone();
                }
                if (meta.type1_data != null) {
                    this.type1_data = (Type1Data)meta.type1_data.clone();
                }
                this.type_name = meta.type_name;
            } else {
                int n = obj.getFieldCount();
                int i = 0;
                while (i < n) {
                    int flags = (obj.isOptional(i) ? 4 : 0) | (obj.isExport(i) ? 2 : 0) | (obj.isImport(i) ? 1 : 0) | (obj.isNestedType1Structure(i) ? 128 : 0);
                    this.addInfo(obj.getName(i), obj.getType(i), obj.getLength(i), obj.getInternalLength(i), obj.getOffset(i), obj.getDecimals(i), obj.getDefault(i), obj.getDescription(i), flags, obj.getTabName(i), obj.getExtendedFieldMetaData(i));
                    ++i;
                }
                if (obj.isNestedType1Structure()) {
                    this.type1_data = new Type1Data();
                    this.type1_data.constructMetaData();
                }
            }
        }

        private void ensureCapacity(int capacity) {
            if (this.defaults != null && this.defaults.length < capacity) {
                String[] old_defaults = this.defaults;
                this.defaults = new String[capacity];
                System.arraycopy(old_defaults, 0, this.defaults, 0, this.num_fields);
            }
            if (this.description != null && this.description.length < capacity) {
                String[] old_description = this.description;
                this.description = new String[capacity];
                System.arraycopy(old_description, 0, this.description, 0, this.num_fields);
            }
            if (this.extended_field_meta_data != null && this.extended_field_meta_data.length < capacity) {
                IExtendedFieldMetaData[] old_extended_field_meta_data = this.extended_field_meta_data;
                this.extended_field_meta_data = new IExtendedFieldMetaData[capacity];
                System.arraycopy(old_extended_field_meta_data, 0, this.extended_field_meta_data, 0, this.num_fields);
            }
            if (this.name.length >= capacity) {
                return;
            }
            String[] old_name = this.name;
            this.name = new String[capacity];
            System.arraycopy(old_name, 0, this.name, 0, this.num_fields);
            Object[] old_tab_meta = this.tab_meta;
            this.tab_meta = new Object[capacity];
            System.arraycopy(old_tab_meta, 0, this.tab_meta, 0, this.num_fields);
            int[] old_offset = this.offset;
            this.offset = new int[capacity];
            System.arraycopy(old_offset, 0, this.offset, 0, this.num_fields);
            int[] old_boffset = this.boffset;
            this.boffset = new int[capacity];
            System.arraycopy(old_boffset, 0, this.boffset, 0, this.num_fields);
            int[] old_length = this.length;
            this.length = new int[capacity];
            System.arraycopy(old_length, 0, this.length, 0, this.num_fields);
            int[] old_blength = this.blength;
            this.blength = new int[capacity];
            System.arraycopy(old_blength, 0, this.blength, 0, this.num_fields);
            byte[] old_type = this.type;
            this.type = new byte[capacity];
            System.arraycopy(old_type, 0, this.type, 0, this.num_fields);
            byte[] old_decimals = this.decimals;
            this.decimals = new byte[capacity];
            System.arraycopy(old_decimals, 0, this.decimals, 0, this.num_fields);
            byte[] old_oindex = this.oindex;
            this.oindex = new byte[capacity];
            System.arraycopy(old_oindex, 0, this.oindex, 0, this.num_fields);
            byte[] old_flags = this.flags;
            this.flags = new byte[capacity];
            System.arraycopy(old_flags, 0, this.flags, 0, this.num_fields);
        }

        public final int indexOf(String field_name) {
            Integer hindex;
            if (this.hash_of_indices == null || this.name != null && this.hash_of_indices.size() < this.name.length) {
                this.hash_of_indices = new Hashtable(this.name.length);
                int i = 0;
                while (i < this.name.length) {
                    this.hash_of_indices.put(this.name[i], new Integer(i));
                    ++i;
                }
            }
            if ((hindex = (Integer)this.hash_of_indices.get(field_name)) != null) {
                return hindex;
            }
            throw new Exception(127, "JCO_ERROR_FIELD_NOT_FOUND", "Field " + field_name + " not a member of " + this.rec_name);
        }

        public final boolean hasField(String field_name) {
            if (field_name == null) {
                return false;
            }
            if (this.hash_of_indices == null || this.name != null && this.hash_of_indices.size() < this.name.length) {
                this.hash_of_indices = new Hashtable(this.name.length);
                int i = 0;
                while (i < this.name.length) {
                    this.hash_of_indices.put(this.name[i], new Integer(i));
                    ++i;
                }
            }
            return this.hash_of_indices.get(field_name) != null;
        }

        public String getName() {
            return this.rec_name;
        }

        public String getLineTypeName() {
            return this.type_name;
        }

        public int getFieldCount() {
            return this.num_fields;
        }

        public int getNumFields() {
            return this.num_fields;
        }

        public int getCapacity() {
            return this.name != null ? this.name.length : 0;
        }

        public IMetaData getMetaData() {
            return new MetaData(this);
        }

        public void addInfo(String name, int type, int length) {
            this.addInfo(name, type, length, -1, 0, null, null, 0, null, null);
        }

        public void addInfo(String name, int type, int length, int offset) {
            this.addInfo(name, type, length, offset, 0, null, null, 0, null, null);
        }

        public void addInfo(String name, int type, int length, int offset, int decimals) {
            this.addInfo(name, type, length, offset, decimals, null, null, 0, null, null);
        }

        public void addInfo(String name, int type, int length, int offset, int decimals, int flags, Object tab_meta) {
            this.addInfo(name, type, length, offset, decimals, null, null, flags, tab_meta, null);
        }

        public void addInfo(String name, int type, int length, int offset, int decimals, String sdefault, String description, int flags, Object tab_meta, IExtendedFieldMetaData extended) {
            this.addInfo(name, type, length, length, offset, decimals, sdefault, description, flags, tab_meta, extended);
        }

        public void addInfo(String name, int type, int charlength, int length, int offset, int decimals, String sdefault, String description, int flags, Object tab_meta, IExtendedFieldMetaData extended) {
            this.ensureCapacity(this.num_fields + 1);
            if (offset < 0) {
                int n = offset = this.num_fields > 0 ? this.offset[this.num_fields - 1] + this.length[this.num_fields - 1] : 0;
            }
            if (length < 0) {
                length = -length;
                if (charlength <= 0) {
                    charlength = length / 2;
                }
            } else if (charlength <= 0) {
                charlength = length;
            }
            this.oindex[this.num_fields] = -1;
            switch (type) {
                case 0: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = charlength;
                    break;
                }
                case 1: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = 8;
                    break;
                }
                case 2: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = length / 2 + length % 2;
                    break;
                }
                case 3: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = 6;
                    break;
                }
                case 4: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = length / 2 + length % 2;
                    break;
                }
                case 5: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = charlength;
                    break;
                }
                case 6: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = charlength;
                    break;
                }
                case 7: {
                    this.length[this.num_fields] = 8;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = 4;
                    break;
                }
                case 8: {
                    this.length[this.num_fields] = 4;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = 2;
                    break;
                }
                case 9: {
                    this.length[this.num_fields] = 2;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = 1;
                    break;
                }
                case 10: {
                    this.length[this.num_fields] = 1;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = 1;
                    break;
                }
                case 29: {
                    this.length[this.num_fields] = 8;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = name.length();
                    this.oindex[this.num_fields] = (byte)this.num_odata++;
                    break;
                }
                case 30: {
                    this.length[this.num_fields] = 8;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = name.length();
                    this.oindex[this.num_fields] = (byte)this.num_odata++;
                    break;
                }
                case 17: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = name.length();
                    this.oindex[this.num_fields] = (byte)this.num_odata++;
                    break;
                }
                case 99: {
                    this.length[this.num_fields] = length;
                    this.offset[this.num_fields] = offset;
                    this.blength[this.num_fields] = name.length();
                    this.oindex[this.num_fields] = (byte)this.num_odata++;
                    break;
                }
                case 98: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.name[this.num_fields] = name;
            this.tab_meta[this.num_fields] = tab_meta;
            this.type[this.num_fields] = (byte)type;
            this.decimals[this.num_fields] = type == 2 || type == 7 ? (byte)decimals : (byte)0;
            this.flags[this.num_fields] = (byte)flags;
            if (sdefault != null) {
                if (this.defaults == null) {
                    this.defaults = new String[this.num_fields + 1];
                }
                this.defaults[this.num_fields] = sdefault;
            }
            if (description != null) {
                if (this.description == null) {
                    this.description = new String[this.num_fields + 1];
                }
                this.description[this.num_fields] = description;
            }
            if (extended != null) {
                if (this.extended_field_meta_data == null) {
                    this.extended_field_meta_data = new IExtendedFieldMetaData[this.num_fields + 1];
                }
                this.extended_field_meta_data[this.num_fields] = extended;
            }
            ++this.num_fields;
            if (this.num_fields > 1) {
                this.boffset[this.num_fields - 1] = this.boffset[this.num_fields - 2] + this.blength[this.num_fields - 2];
            }
        }

        public void addInfo(String name, char type, int offset, int length) {
            this.addInfo(name, JCO.getJCOType(type), length, offset, 0);
        }

        public void addInfo(String name, char type, int offset, int length, int decimals) {
            this.addInfo(name, JCO.getJCOType(type), length, offset, decimals);
        }

        public String getName(int index) {
            return this.name[index];
        }

        public String getTabName(int index) {
            if (this.tab_meta[index] instanceof String) {
                return (String)this.tab_meta[index];
            }
            if (this.tab_meta[index] instanceof IMetaData) {
                return ((IMetaData)this.tab_meta[index]).getName();
            }
            return null;
        }

        public String getTabName(String field_name) {
            return this.getTabName(this.indexOf(field_name));
        }

        public IMetaData getMetaData(int index) {
            return this.tab_meta[index] instanceof IMetaData ? (IMetaData)this.tab_meta[index] : null;
        }

        public IMetaData getMetaData(String field_name) {
            return this.getMetaData(this.indexOf(field_name));
        }

        public int getLength(int index) {
            byte t = this.type[index];
            int l = this.length[index];
            switch (t) {
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    l = this.blength[index];
                }
            }
            return l;
        }

        public int getLength(String field_name) {
            return this.getLength(this.indexOf(field_name));
        }

        public int getInternalLength(int index) {
            return this.length[index];
        }

        public int getInternalLength(String field_name) {
            return this.length[this.indexOf(field_name)];
        }

        public int getOffset(int index) {
            return this.offset[index];
        }

        public int getOffset(String field_name) {
            return this.offset[this.indexOf(field_name)];
        }

        protected int getDataBufferLength(int index) {
            return this.blength[index];
        }

        protected int getDataBufferOffset(int index) {
            return this.boffset[index];
        }

        protected void setDataBufferLength(int index, int dataBufferLength) {
            this.blength[index] = dataBufferLength;
        }

        protected void setDataBufferOffset(int index, int dataBufferOffset) {
            this.boffset[index] = dataBufferOffset;
        }

        protected void setName(String name) {
            this.rec_name = name;
        }

        public int getType(int index) {
            return this.type[index];
        }

        public int getType(String field_name) {
            return this.type[this.indexOf(field_name)];
        }

        public String getTypeAsString(int index) {
            return JCO.getJCOTypeString(this.type[index]);
        }

        public String getTypeAsString(String field_name) {
            return JCO.getJCOTypeString(this.type[this.indexOf(field_name)]);
        }

        public int getDecimals(int index) {
            return this.decimals[index];
        }

        public int getDecimals(String field_name) {
            return this.decimals[this.indexOf(field_name)];
        }

        public String getDefault(int index) {
            return this.defaults != null ? this.defaults[index] : null;
        }

        public String getDefault(String field_name) {
            return this.defaults != null ? this.defaults[this.indexOf(field_name)] : null;
        }

        public String getDescription(int index) {
            return this.description != null ? this.description[index] : null;
        }

        public String getDescription(String field_name) {
            return this.description != null ? this.description[this.indexOf(field_name)] : null;
        }

        public int getFlags(int index) {
            return this.flags[index];
        }

        public int getFlags(String field_name) {
            return this.flags[this.indexOf(field_name)];
        }

        public IExtendedFieldMetaData getExtendedFieldMetaData(int index) {
            return this.extended_field_meta_data == null ? null : this.extended_field_meta_data[index];
        }

        public IExtendedFieldMetaData getExtendedFieldMetaData(String field_name) {
            return this.extended_field_meta_data == null ? null : this.extended_field_meta_data[this.indexOf(field_name)];
        }

        public void setExtendedFieldMetaData(IExtendedFieldMetaData extended_field_meta_data, int index) {
            if (this.extended_field_meta_data == null) {
                this.extended_field_meta_data = new IExtendedFieldMetaData[this.num_fields + 1];
            }
            this.extended_field_meta_data[index] = extended_field_meta_data;
        }

        public void setExtendedFieldMetaData(IExtendedFieldMetaData extended_field_meta_data, String field_name) {
            this.setExtendedFieldMetaData(extended_field_meta_data, this.indexOf(field_name));
        }

        public boolean isOptional(int index) {
            return (this.flags[index] & 4) != 0;
        }

        public boolean isOptional(String field_name) {
            return (this.flags[this.indexOf(field_name)] & 4) != 0;
        }

        public boolean isImport(int index) {
            return (this.flags[index] & 1) != 0;
        }

        public boolean isImport(String field_name) {
            return (this.flags[this.indexOf(field_name)] & 1) != 0;
        }

        public boolean isExport(int index) {
            return (this.flags[index] & 2) != 0;
        }

        public boolean isExport(String field_name) {
            return (this.flags[this.indexOf(field_name)] & 2) != 0;
        }

        public boolean isStructure(int index) {
            return this.type[index] == 17;
        }

        public boolean isStructure(String field_name) {
            return this.type[this.indexOf(field_name)] == 17;
        }

        public boolean isNestedType1Structure(int index) {
            return (this.flags[index] & 0x80) != 0;
        }

        public boolean isNestedType1Structure(String field_name) {
            return (this.flags[this.indexOf(field_name)] & 0x80) != 0;
        }

        public boolean isTable(int index) {
            return this.type[index] == 99;
        }

        public boolean isTable(String field_name) {
            return this.type[this.indexOf(field_name)] == 99;
        }

        public boolean isException(int index) {
            return this.type[index] == 98;
        }

        public boolean isException(String field_name) {
            return this.type[this.indexOf(field_name)] == 98;
        }

        public int getTabLength() {
            return this.tab_length;
        }

        public boolean isNestedType1Structure() {
            return this.type1_data != null;
        }

        public boolean isActive(int index) {
            return (this.flags[index] & 0x10) == 0;
        }

        public boolean isActive(String field_name) {
            return (this.flags[this.indexOf(field_name)] & 0x10) == 0;
        }

        public boolean isInitialized(int index) {
            return (this.flags[index] & 8) == 0;
        }

        public boolean isInitialized(String field_name) {
            return (this.flags[this.indexOf(field_name)] & 8) == 0;
        }

        public void setFlags(int index, int flags) {
            this.flags[index] = (byte)flags;
        }

        public void setTabLength(int tab_length) {
            this.tab_length = tab_length;
        }

        public void setNestedType1Structure(boolean isType1) {
            if (isType1) {
                this.type1_data = new Type1Data();
                this.type1_data.constructMetaData();
            } else {
                this.type1_data = null;
            }
        }

        public String toString() {
            return this.toString(0);
        }

        protected String toString(int level) {
            int n = this.getFieldCount();
            StringBuffer s = new StringBuffer();
            int i = 0;
            while (i < n) {
                int l;
                int k = 0;
                while (k < level * 10) {
                    s.append(' ');
                    ++k;
                }
                s.append(this.name[i]);
                k = l = this.name[i].length();
                while (k < 32) {
                    s.append(' ');
                    ++k;
                }
                s.append(',');
                if (this.tab_meta[i] != null && this.tab_meta[i] instanceof String) {
                    s.append((String)this.tab_meta[i]);
                    k = l = ((String)this.tab_meta[i]).length();
                    while (k < 32) {
                        s.append(' ');
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < 32) {
                        s.append(' ');
                        ++k;
                    }
                }
                s.append(',');
                s.append(JCO.getJCOTypeChar(this.type[i]));
                s.append(',');
                s.append(this.blength[i]);
                s.append(',');
                s.append(this.boffset[i]);
                s.append(',');
                s.append(this.decimals[i]);
                if (this.defaults != null) {
                    s.append(',');
                    s.append(this.getDefault(i) != null ? this.getDefault(i) : " ");
                }
                if (this.description != null) {
                    s.append(',');
                    s.append(this.getDescription(i) != null ? this.getDescription(i) : " ");
                }
                if (this.isImport(i)) {
                    s.append(',');
                    s.append("IMPORT");
                }
                if (this.isExport(i)) {
                    s.append(',');
                    s.append("EXPORT");
                }
                if (this.isOptional(i)) {
                    s.append(',');
                    s.append("OPTIONAL");
                }
                if (!this.isActive(i)) {
                    s.append(',');
                    s.append("INACTIVE");
                }
                if (this.tab_meta[i] != null && this.tab_meta[i] instanceof MetaData) {
                    s.append(CRLF);
                    s.append(((MetaData)this.tab_meta[i]).toString(level + 1));
                } else if (this.tab_meta[i] != null && this.tab_meta[i] instanceof String) {
                    s.append(',');
                    s.append((String)this.tab_meta[i]);
                    s.append(CRLF);
                } else {
                    s.append(CRLF);
                }
                ++i;
            }
            return s.toString();
        }

        public void writeHTML(String html_filename) {
            try {
                this.writeHTML(new FileWriter(html_filename));
            }
            catch (IOException ex) {
                throw new ConversionException("Cannot write meta data for " + this.getName() + " to HTML file " + html_filename);
            }
        }

        public void writeHTML(Writer writer) throws IOException {
            PrintWriter os = new PrintWriter(writer);
            os.println("<html><head></head>");
            os.println("<body bgcolor='" + JCO.getProperty(JCO.JCO_HTML_BACKGROUND) + "'>");
            this.printHTML(os, this, 0);
            os.println("</body></html>");
            os.close();
        }

        protected void printHTML(PrintWriter os, IMetaData m, int level) {
            this.printHTML(os, m, level, PRINT_HEADER_ALL);
        }

        protected void printHTML(PrintWriter os, IMetaData m, int level, int print_flags) {
            String th = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND2);
            String hc = JCO.getProperty(JCO.JCO_HTML_TABLE_HEADER_BACKGROUND3);
            String bdr = JCO.getProperty(JCO.JCO_HTML_TABLE_BORDER);
            String fface = JCO.getProperty(JCO.JCO_HTML_FONT_FACE);
            String fsize = JCO.getProperty(JCO.JCO_HTML_FONT_SIZE);
            int num_fields = m.getFieldCount();
            String text = m.getName();
            if (m.getTabLength() > 0) {
                text = text + "&nbsp;&nbsp;[" + Integer.toString(m.getTabLength()) + "&nbsp;bytes]";
            }
            os.println("<font face='" + fface + "' size='" + fsize + "'>");
            os.println("<table border='" + bdr + "' bgcolor='" + th + "'" + (level > 0 ? " width='100%'" : "") + ">");
            os.println("<tr align='LEFT'>");
            os.print("<th colspan='" + (num_fields + 1) + "'>" + (text != null ? text : "") + "</th>" + CRLF);
            os.println(CRLF + "</tr>");
            os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Index:</th>");
            int i = 0;
            while (i < num_fields) {
                os.print("<th>" + (i + 1) + "</th>");
                ++i;
            }
            os.println(CRLF + "</tr>");
            if ((print_flags & PRINT_HEADER_NAME) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Name:</th>");
                i = 0;
                while (i < num_fields) {
                    os.print("<th>" + m.getName(i) + "</th>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & PRINT_HEADER_TYPE) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Type:</th>");
                i = 0;
                while (i < num_fields) {
                    os.print("<td>" + JCO.getJCOTypeString(m.getType(i)) + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & PRINT_HEADER_LENGTH) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Size:</th>");
                i = 0;
                while (i < num_fields) {
                    os.print("<td>" + m.getLength(i) + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & PRINT_HEADER_OFFSET) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Offset:</th>");
                i = 0;
                while (i < num_fields) {
                    os.print("<td>" + m.getOffset(i) + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & PRINT_HEADER_DECIMALS) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Decimals:</th>");
                i = 0;
                while (i < num_fields) {
                    os.print("<td>" + m.getDecimals(i) + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if ((print_flags & PRINT_HEADER_DEFAULT) != 0) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Default:</th>");
                i = 0;
                while (i < num_fields) {
                    os.print("<td>" + (m.getDefault(i) != null ? m.getDefault(i) : "&nbsp;") + "</td>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            i = 0;
            while (i < num_fields) {
                if (m.getMetaData(i) != null) break;
                ++i;
            }
            if (i < num_fields) {
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>&nbsp;</th>");
                i = 0;
                while (i < num_fields) {
                    if (m.getMetaData(i) != null) {
                        os.println("<td align='center' valign='top'>");
                        this.printHTML(os, m.getMetaData(i), level + 1, print_flags);
                        os.println("</td>");
                    } else {
                        os.println("<td align='left'>&nbsp;</td>");
                    }
                    ++i;
                }
                os.println(CRLF + "</tr>");
            }
            if (m instanceof MetaData && ((MetaData)m).type1_data != null) {
                os.println("</table>");
                Type1Data type1Data = ((MetaData)m).type1_data;
                os.println("<table border='" + bdr + "' bgcolor='" + th + "'" + (level > 0 ? " width='100%'" : "") + ">");
                os.println("<tr align='LEFT'>");
                os.print("<th colspan='" + (type1Data.num_fields + 1) + "'>" + (text != null ? text : "") + "</th>" + CRLF);
                os.println(CRLF + "</tr>");
                os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Index:</th>");
                i = 0;
                while (i < type1Data.num_fields) {
                    os.print("<th>" + (i + 1) + "</th>");
                    ++i;
                }
                os.println(CRLF + "</tr>");
                if ((print_flags & PRINT_HEADER_NAME) != 0) {
                    os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Name:</th>");
                    i = 0;
                    while (i < type1Data.num_fields) {
                        os.print("<th>" + type1Data.name[i] + "</th>");
                        ++i;
                    }
                    os.println(CRLF + "</tr>");
                }
                if ((print_flags & PRINT_HEADER_TYPE) != 0) {
                    os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Type:</th>");
                    i = 0;
                    while (i < type1Data.num_fields) {
                        os.print("<td>" + JCO.getJCOTypeString(type1Data.type[i]) + "</td>");
                        ++i;
                    }
                    os.println(CRLF + "</tr>");
                }
                if ((print_flags & PRINT_HEADER_LENGTH) != 0) {
                    os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Size:</th>");
                    i = 0;
                    while (i < type1Data.num_fields) {
                        os.print("<td>" + type1Data.length[i] + "</td>");
                        ++i;
                    }
                    os.println(CRLF + "</tr>");
                }
                if ((print_flags & PRINT_HEADER_OFFSET) != 0) {
                    os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Offset:</th>");
                    i = 0;
                    while (i < type1Data.num_fields) {
                        os.print("<td>" + type1Data.offset[i] + "</td>");
                        ++i;
                    }
                    os.println(CRLF + "</tr>");
                }
                if ((print_flags & PRINT_HEADER_DECIMALS) != 0) {
                    os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Decimals:</th>");
                    i = 0;
                    while (i < type1Data.num_fields) {
                        os.print("<td>" + type1Data.decimals[i] + "</td>");
                        ++i;
                    }
                    os.println(CRLF + "</tr>");
                }
            }
            os.println("</table></font>");
        }

        protected class Type1Data
        implements Cloneable,
        Serializable {
            private static final long serialVersionUID = 110011052001L;
            protected String[] name = new String[0];
            protected int[] offset = new int[0];
            protected int[] length = new int[0];
            protected int[] boffset = new int[0];
            protected int[] blength = new int[0];
            protected byte[] type = new byte[0];
            protected byte[] decimals = new byte[0];
            protected byte[] flags = new byte[0];
            protected int num_fields = 0;

            protected Type1Data() {
            }

            public Object clone() {
                try {
                    Type1Data obj = (Type1Data)super.clone();
                    obj.copy(this);
                    return obj;
                }
                catch (CloneNotSupportedException ex) {
                    return null;
                }
            }

            protected void copy(Type1Data type1Data) {
                if (type1Data == null) {
                    return;
                }
                this.ensureCapacity(type1Data.num_fields);
                this.num_fields = type1Data.num_fields;
                System.arraycopy(type1Data.name, 0, this.name, 0, this.num_fields);
                System.arraycopy(type1Data.offset, 0, this.offset, 0, this.num_fields);
                System.arraycopy(type1Data.boffset, 0, this.boffset, 0, this.num_fields);
                System.arraycopy(type1Data.length, 0, this.length, 0, this.num_fields);
                System.arraycopy(type1Data.blength, 0, this.blength, 0, this.num_fields);
                System.arraycopy(type1Data.type, 0, this.type, 0, this.num_fields);
                System.arraycopy(type1Data.decimals, 0, this.decimals, 0, this.num_fields);
                System.arraycopy(type1Data.flags, 0, this.flags, 0, this.num_fields);
            }

            private void ensureCapacity(int capacity) {
                if (this.name.length < capacity) {
                    String[] old_name = this.name;
                    this.name = new String[capacity];
                    System.arraycopy(old_name, 0, this.name, 0, old_name.length);
                    int[] old_offset = this.offset;
                    this.offset = new int[capacity];
                    System.arraycopy(old_offset, 0, this.offset, 0, old_offset.length);
                    int[] old_boffset = this.boffset;
                    this.boffset = new int[capacity];
                    System.arraycopy(old_boffset, 0, this.boffset, 0, old_boffset.length);
                    int[] old_length = this.length;
                    this.length = new int[capacity];
                    System.arraycopy(old_length, 0, this.length, 0, old_length.length);
                    int[] old_blength = this.blength;
                    this.blength = new int[capacity];
                    System.arraycopy(old_blength, 0, this.blength, 0, old_blength.length);
                    byte[] old_type = this.type;
                    this.type = new byte[capacity];
                    System.arraycopy(old_type, 0, this.type, 0, old_type.length);
                    byte[] old_decimals = this.decimals;
                    this.decimals = new byte[capacity];
                    System.arraycopy(old_decimals, 0, this.decimals, 0, old_decimals.length);
                    byte[] old_flags = this.flags;
                    this.flags = new byte[capacity];
                    System.arraycopy(old_flags, 0, this.flags, 0, old_flags.length);
                }
            }

            private int countNumFields(MetaData metaData, int fieldCount) {
                int i = 0;
                while (i < metaData.getNumFields()) {
                    fieldCount = metaData.getType(i) == 17 ? this.countNumFields((MetaData)metaData.getMetaData(i), fieldCount) : ++fieldCount;
                    ++i;
                }
                return fieldCount;
            }

            protected void constructMetaData() {
                this.num_fields = this.countNumFields(MetaData.this, 0);
                this.ensureCapacity(this.num_fields);
                this.constructMetaData(MetaData.this, 0, "", 0);
                this.boffset[0] = 0;
                int i = 0;
                while (i < this.num_fields - 1) {
                    this.boffset[i + 1] = this.boffset[i] + this.blength[i];
                    ++i;
                }
            }

            private final int constructMetaData(MetaData metaData, int pos, String prefix, int structOffset) {
                int i = 0;
                while (i < metaData.getNumFields()) {
                    if (metaData.getType(i) == 17) {
                        pos = this.constructMetaData((MetaData)metaData.getMetaData(i), pos, prefix + metaData.name[i] + '-', structOffset + metaData.offset[i]);
                    } else {
                        this.name[pos] = prefix + metaData.name[i];
                        this.offset[pos] = structOffset + metaData.offset[i];
                        this.length[pos] = metaData.length[i];
                        this.blength[pos] = metaData.blength[i];
                        this.type[pos] = metaData.type[i];
                        this.decimals[pos] = metaData.decimals[i];
                        this.flags[pos] = metaData.flags[i];
                        ++pos;
                    }
                    ++i;
                }
                return pos;
            }

            protected void internalSize(DataSize size) {
                int i = this.name.length;
                while (--i >= 0) {
                    size.addMetaDataBytes(this.name[i].length() * 2);
                }
                size.addMetaDataBytes(this.num_fields * 4 * 4);
                size.addMetaDataBytes(this.num_fields * 1 * 3);
            }
        }
    }

    static class DataSize {
        private long meta_bytes = 0L;
        private long data_bytes = 0L;

        DataSize() {
        }

        public void addMetaDataBytes(long bytes) {
            this.meta_bytes += bytes;
        }

        public void addDataBytes(long bytes) {
            this.data_bytes += bytes;
        }

        public long getMetaDataBytes() {
            return this.meta_bytes;
        }

        public long getDataBytes() {
            return this.data_bytes;
        }
    }

    public static class Server
    extends Connection
    implements Runnable {
        public static final int AUTHORIZATION_MODE_SNC = 0;
        public static final int AUTHORIZATION_MODE_BASIC = 1;
        public static final int FUNCTION_MODEL = 0;
        public static final int REQUEST_RESPONSE_MODEL = 1;
        protected IMiddleware.IServer m_middleware;
        private volatile IServerThread m_thread;
        private IRepository m_repository;
        private Object m_semaphore = new Object();
        private int m_call_model = 0;
        private final int TABLE_COPY = 1;
        private int m_dispatch_mode = 1;
        private static final String JCO_MAX_STARTUP_DELAY = "jco.server.max_startup_delay";
        private int m_startup_delay = 0;
        private int m_max_startup_delay = -1;

        protected static synchronized IMiddleware.IServer getServerInterface() {
            try {
                IMiddleware mw = (IMiddleware)middleware_class.newInstance();
                return mw.getServerInterface();
            }
            catch (java.lang.Exception ex) {
                JCO.fireTrace(0, "[JAV-LAYER] JCO.Server(): could not get middleware interface");
                return null;
            }
        }

        public Server(Properties properties) {
            this(properties, null, null);
        }

        public Server(Properties properties, IRepository repository) {
            this(properties, null, repository);
        }

        public Server(Properties properties, IServerThread thread, IRepository repository) {
            if (thread != null && !(thread instanceof Thread)) {
                throw new IllegalArgumentException("thread argument must be subclass of Thread");
            }
            this.m_thread = thread != null ? thread : new ServerThread(this);
            this.m_repository = repository;
            if (properties != null) {
                this.properties = (Properties)((Hashtable)properties).clone();
            }
            this.m_middleware = Server.getServerInterface();
        }

        public Server(String[][] params, IRepository repository) {
            this(null, null, repository);
            int i = 0;
            while (i < params.length) {
                String val;
                String key = params[i][0];
                if (key != null && (val = params[i][1]) != null) {
                    if ((key = key.toLowerCase().trim()).indexOf("jco.server.") != 0) {
                        key = "jco.server." + key;
                    }
                    ((Hashtable)this.properties).put(key, val);
                }
                ++i;
            }
        }

        public Server(String[] argv, IRepository repository) {
            this(null, null, repository);
            if (argv != null) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < argv.length) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(argv[i]);
                    ++i;
                }
                ((Hashtable)this.properties).put("jco.server.params", sb.toString());
            }
        }

        public Server(String gwhost, String gwserv, String progid, IRepository repository) {
            this(gwhost, gwserv, progid, null, repository);
        }

        public Server(String gwhost, String gwserv, String progid, IServerThread thread, IRepository repository) {
            this(null, thread, repository);
            if (gwhost != null) {
                ((Hashtable)this.properties).put("jco.server.gwhost", gwhost);
            }
            if (gwserv != null) {
                ((Hashtable)this.properties).put("jco.server.gwserv", gwserv);
            }
            if (progid != null) {
                ((Hashtable)this.properties).put("jco.server.progid", progid);
            }
        }

        protected Server(String gwhost, String gwserv, String progid) {
            if (gwhost != null) {
                ((Hashtable)this.properties).put("jco.server.gwhost", gwhost);
            }
            if (gwserv != null) {
                ((Hashtable)this.properties).put("jco.server.gwserv", gwserv);
            }
            if (progid != null) {
                ((Hashtable)this.properties).put("jco.server.progid", progid);
            }
            this.m_middleware = Server.getServerInterface();
        }

        protected void setThread(IServerThread thread) {
            if (!(thread instanceof Thread)) {
                throw new IllegalArgumentException("thread argument must be subclass of Thread");
            }
            this.m_thread = thread;
        }

        protected IRepository getRepository() {
            return this.m_repository;
        }

        protected void setRepository(IRepository repository) {
            this.m_repository = repository;
        }

        protected IMiddleware.IServer getMiddlewareImplementation() {
            return this.m_middleware;
        }

        public final String[][] getPropertyInfo() {
            return this.m_middleware.getPropertyInfo();
        }

        /*
         * Unable to fully structure code
         */
        protected void setProperty(String key, String value) {
            if (key != null && key.equals("jco.server.max_startup_delay")) {
                if (value != null) {
                    try {
                        this.m_max_startup_delay = Integer.parseInt(value);
                        if (this.m_max_startup_delay >= 0) ** GOTO lbl11
                        this.m_max_startup_delay = -255;
                    }
                    catch (java.lang.Exception ex) {
                        throw new Exception(122, "JCO_ERROR_CONVERSION", "Value of property jco.server.max_startup_delay not an integer.");
                    }
                } else {
                    this.m_max_startup_delay = -255;
                }
            }
lbl11:
            // 5 sources

            super.setProperty(key, value);
        }

        public void setCallModel(int call_model) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "JCO.Server.setCallModell(" + call_model + ")");
            }
            this.m_call_model = call_model;
            this.m_dispatch_mode = !middleware_layer.equals("com.sap.mw.jco.rfc.MiddlewareRFC") ? (this.m_dispatch_mode &= 0xFFFFFFFE) : (this.m_dispatch_mode |= 1);
        }

        public int getCallModel() {
            return this.m_call_model;
        }

        protected void setState(byte state) {
            if (this.state == state) {
                return;
            }
            byte old_state = this.state;
            byte new_state = state;
            super.setState(state);
            JCO.fireServerStateChangeOccurred(this, old_state, new_state);
        }

        public byte getState() {
            return super.getState();
        }

        public Thread getThread() {
            return (Thread)((Object)this.m_thread);
        }

        public final Attributes getAttributes() {
            if (this.attributes == null) {
                this.state = (byte)(this.state | 4);
                if (this.getConnectionHandle() != 0L) {
                    this.m_middleware.getAttributes(this);
                }
                this.state = (byte)(this.state & 0xFFFFFFFB);
            }
            this.last_active_timestamp = System.currentTimeMillis();
            return this.attributes;
        }

        public final String getGWHost() {
            return this.properties.getProperty("jco.server.gwhost");
        }

        public final String getGWServ() {
            return this.properties.getProperty("jco.server.gwserv");
        }

        public final String getProgID() {
            return this.properties.getProperty("jco.server.progid");
        }

        public final boolean getTrace() {
            String value = this.properties.getProperty("jco.server.trace");
            return value != null && value.equals("1");
        }

        public final void setTrace(boolean trace) {
            this.setProperty("jco.server.trace", trace ? "1" : "0");
        }

        private final int getMaxStartupDelay() {
            if (this.m_max_startup_delay == -255) {
                return middleware.getMaxStartupDelay();
            }
            if (this.m_max_startup_delay < 0) {
                String value = this.properties.getProperty(JCO_MAX_STARTUP_DELAY);
                if (value != null) {
                    try {
                        this.m_max_startup_delay = Integer.parseInt(value);
                    }
                    catch (java.lang.Exception ex) {
                        throw new Exception(122, "JCO_ERROR_CONVERSION", "Value of property jco.server.max_startup_delay not an integer.");
                    }
                }
                if (this.m_max_startup_delay < 0) {
                    this.m_max_startup_delay = -255;
                    return middleware.getMaxStartupDelay();
                }
            }
            return this.m_max_startup_delay;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DsrIPassport getDsrPassport() {
            DsrIPassport dsrIPassport;
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] getDsrPassport for connection with handle " + this.getConnectionHandle() + " [enter]");
            }
            try {
                if (this.passport_bytes == null) {
                    Exception e = new Exception(151, "JCO_ERROR_DSR_PASSPORT_NOT_RECEIVED", "Dsr Passport wasn't sent from partner side.");
                    if (trace_level <= 2) throw e;
                    JCO.fireTrace(3, "[JAV-LAYER] " + e.toString());
                    throw e;
                }
                DsrIPassport passport = DsrFactory.makeDsrPassport();
                if (!passport.setByNetPassport(this.passport_bytes)) {
                    throw new Exception(152, "JCO_ERROR_DSR_PASSPORT_NOT_VALID", "jDSR library cannot parse received passport.");
                }
                if (this.dsr_monitor != null) {
                    passport.setPrevCompName("com.sap.mw.jco.JCO.Server");
                }
                dsrIPassport = passport;
                Object var4_4 = null;
                if (trace_level <= 4) return dsrIPassport;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (trace_level <= 4) throw throwable;
                JCO.fireTrace(5, "[JAV-LAYER] getDsrPassport for connection with handle " + this.getConnectionHandle() + "  [leave]");
                throw throwable;
            }
            JCO.fireTrace(5, "[JAV-LAYER] getDsrPassport for connection with handle " + this.getConnectionHandle() + "  [leave]");
            return dsrIPassport;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void disconnect() {
            block5: {
                block4: {
                    try {
                        if (trace_level > 0) {
                            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.disconnect() on [" + this.getConnectionHandle() + "]                     [enter]");
                        }
                        this.setState((byte)(this.state & 0xF0 | 1));
                        if (!this.isValid()) {
                            Object var2_1 = null;
                            if (trace_level <= 0) return;
                            break block4;
                        }
                        this.m_middleware.disconnect(this);
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        if (trace_level <= 0) throw throwable;
                        JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.disconnect() on [" + this.getConnectionHandle() + "]                     [leave]");
                        throw throwable;
                    }
                }
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.disconnect() on [" + this.getConnectionHandle() + "]                     [leave]");
                return;
            }
            Object var2_2 = null;
            if (trace_level <= 0) return;
            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.disconnect() on [" + this.getConnectionHandle() + "]                     [leave]");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abort(String message) {
            block5: {
                block4: {
                    try {
                        if (trace_level > 0) {
                            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.abort(\"" + message + "\") on [" + this.getConnectionHandle() + "]               [enter]");
                        }
                        if (!this.isValid()) {
                            Object var3_2 = null;
                            this.setState((byte)(this.state & 0xF0 | 1));
                            if (trace_level <= 0) return;
                            break block4;
                        }
                        this.m_middleware.abort(this, message);
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        this.setState((byte)(this.state & 0xF0 | 1));
                        if (trace_level <= 0) throw throwable;
                        JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.abort(\"" + message + "\") on [" + this.getConnectionHandle() + "]               [leave]");
                        throw throwable;
                    }
                }
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.abort(\"" + message + "\") on [" + this.getConnectionHandle() + "]               [leave]");
                return;
            }
            Object var3_3 = null;
            this.setState((byte)(this.state & 0xF0 | 1));
            if (trace_level <= 0) return;
            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.abort(\"" + message + "\") on [" + this.getConnectionHandle() + "]               [leave]");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void start() {
            try {
                if (trace_level > 0) {
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.start() on [" + this.getConnectionHandle() + "]                     [enter]");
                }
                this.checkProperties();
                Thread thread = this.getThread();
                if (thread == null) {
                    throw new Exception(129, "JCO_ERROR_SERVER_STARTUP", "A server that has been stopped cannot be restarted");
                }
                try {
                    Object object = this.m_semaphore;
                    synchronized (object) {
                        this.m_startup_delay = 0;
                        if (!thread.isAlive()) {
                            thread.start();
                        } else if ((this.state & 0x40) != 0) {
                            this.state = (byte)(this.state & 0xFFFFFFBF);
                            this.m_semaphore.notifyAll();
                        }
                    }
                }
                catch (java.lang.Exception ex) {
                    JCO.fireServerExceptionOccurred(this, ex);
                }
                Object var5_5 = null;
                if (trace_level <= 0) return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (trace_level <= 0) throw throwable;
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.start() on [" + this.getConnectionHandle() + "]                     [leave]");
                throw throwable;
            }
            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.start() on [" + this.getConnectionHandle() + "]                     [leave]");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stop() {
            try {
                Thread thread;
                if (trace_level > 0) {
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.stop() on [" + this.getConnectionHandle() + "]                     [enter]");
                }
                if ((thread = this.getThread()) != null) {
                    Object object = this.m_semaphore;
                    synchronized (object) {
                        this.m_thread = null;
                        this.state = (byte)(this.state & 0xFFFFFFF7);
                        this.m_semaphore.notifyAll();
                    }
                }
                Object var5_4 = null;
                if (trace_level <= 0) return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (trace_level <= 0) throw throwable;
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.stop() on [" + this.getConnectionHandle() + "]                     [leave]");
                throw throwable;
            }
            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.stop() on [" + this.getConnectionHandle() + "]                     [leave]");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void suspend() {
            try {
                block10: {
                    if (trace_level > 0) {
                        JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.suspend() on [" + this.getConnectionHandle() + "]                     [enter]");
                    }
                    if (this.getThread() == null) break block10;
                    if (this.getThread().isAlive()) break block11;
                }
                Object var4_1 = null;
                if (trace_level <= 0) return;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (trace_level <= 0) throw throwable;
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.suspend() on [" + this.getConnectionHandle() + "]                     [leave]");
                throw throwable;
            }
            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.suspend() on [" + this.getConnectionHandle() + "]                     [leave]");
            {
                block11: {
                    return;
                }
                Object object = this.m_semaphore;
                synchronized (object) {
                    this.state = (byte)(this.state & 0xFFFFFFF7 | 0x40);
                }
            }
            Object var4_2 = null;
            if (trace_level <= 0) return;
            JCO.fireTrace(1, "[JAV-LAYER] JCO.Server.suspend() on [" + this.getConnectionHandle() + "]                     [leave]");
        }

        public void run() {
            this.setState((byte)2);
            Thread current_thread = Thread.currentThread();
            while (this.getThread() == current_thread) {
                Object object;
                if (this.m_startup_delay > 0) {
                    object = this.m_semaphore;
                    synchronized (object) {
                        try {
                            this.m_semaphore.wait(this.m_startup_delay * 1000);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    if (this.getThread() != current_thread) break;
                }
                this.listen();
                object = this.m_semaphore;
                synchronized (object) {
                    if ((this.state & 0x40) != 0) {
                        JCO.fireServerStateChangeOccurred(this, this.state & 0xFFFFFFBF, this.state);
                        while ((this.state & 0x40) != 0 && this.getThread() == current_thread) {
                            try {
                                this.m_semaphore.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        JCO.fireServerStateChangeOccurred(this, this.state | 0x40, this.state);
                    }
                }
            }
            this.setState((byte)1);
        }

        public boolean isAlive() {
            return this.m_middleware.isAlive(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void listen() {
            block19: {
                if (this.isValid()) {
                    return;
                }
                String lastErrorMsg = null;
                this.last_active_timestamp = System.currentTimeMillis();
                this.m_middleware.initialize(this, this.properties);
                this.setState((byte)2);
                try {
                    try {
                        this.m_middleware.listen(this, this.conn_params);
                        this.m_startup_delay = 0;
                    }
                    catch (Exception ex) {
                        if (ex.getGroup() == 129) {
                            this.m_startup_delay = this.m_startup_delay == 0 ? 1 : this.m_startup_delay * 2;
                            int maxStartupDelay = this.getMaxStartupDelay();
                            if (this.m_startup_delay > maxStartupDelay) {
                                this.m_startup_delay = maxStartupDelay;
                            }
                            ex = new Exception(ex.getGroup(), ex.getKey(), "Server startup failed at " + new Date() + "." + CRLF + "This is caused by either a) erroneous server settings, b) the backend system has been shutdown, " + "c) network problems." + (this.m_startup_delay == 0 ? "" : " Will try next startup in " + this.m_startup_delay + " seconds.") + CRLF + ex.getMessage());
                        } else {
                            this.m_startup_delay = 0;
                        }
                        JCO.fireServerExceptionOccurred(this, ex);
                        lastErrorMsg = ex.getKey() + ": " + ex.getMessage();
                        Object var6_3 = null;
                        this.setState((byte)(this.state & 0xFFFFFFF7));
                        if (lastErrorMsg != null && this.isAlive()) {
                            try {
                                this.abort(lastErrorMsg);
                                return;
                            }
                            catch (Throwable t) {
                                if (trace_level != 1) return;
                                JCO.fireTrace(1, "[JAV-LAYER] Error during sending the error message [" + lastErrorMsg + "] to backend: " + t.toString());
                                return;
                            }
                        }
                        this.disconnect();
                        return;
                    }
                    catch (java.lang.Exception ex) {
                        this.m_startup_delay = 0;
                        JCO.fireServerExceptionOccurred(this, ex);
                        lastErrorMsg = ex.toString();
                        Object var6_4 = null;
                        this.setState((byte)(this.state & 0xFFFFFFF7));
                        if (lastErrorMsg != null && this.isAlive()) {
                            try {}
                            catch (Throwable t) {
                                if (trace_level != 1) return;
                                JCO.fireTrace(1, "[JAV-LAYER] Error during sending the error message [" + lastErrorMsg + "] to backend: " + t.toString());
                                return;
                            }
                            this.abort(lastErrorMsg);
                            return;
                        }
                        this.disconnect();
                        return;
                    }
                    catch (Error err) {
                        this.m_startup_delay = 0;
                        JCO.fireServerErrorOccurred(this, err);
                        lastErrorMsg = err.toString();
                        throw err;
                    }
                    Object var6_2 = null;
                    this.setState((byte)(this.state & 0xFFFFFFF7));
                    if (lastErrorMsg == null || !this.isAlive()) break block19;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.setState((byte)(this.state & 0xFFFFFFF7));
                    if (lastErrorMsg != null && this.isAlive()) {
                        try {}
                        catch (Throwable t) {
                            if (trace_level != 1) throw throwable;
                            JCO.fireTrace(1, "[JAV-LAYER] Error during sending the error message [" + lastErrorMsg + "] to backend: " + t.toString());
                            throw throwable;
                        }
                        this.abort(lastErrorMsg);
                        throw throwable;
                    }
                    this.disconnect();
                    throw throwable;
                }
                try {}
                catch (Throwable t) {
                    if (trace_level != 1) return;
                    JCO.fireTrace(1, "[JAV-LAYER] Error during sending the error message [" + lastErrorMsg + "] to backend: " + t.toString());
                    return;
                }
                this.abort(lastErrorMsg);
                return;
            }
            this.disconnect();
        }

        protected Function getFunction(String function_name) {
            IFunctionTemplate ft = null;
            ft = this.m_repository.getFunctionTemplate(function_name);
            return ft != null ? new Function(ft) : null;
        }

        protected boolean checkAuthorization(String function_name, int authorization_mode, String authorization_partner, byte[] authorization_key) {
            System.out.println("checkSNCAuthorization: " + CRLF + "Function:    " + function_name + CRLF + "SNC Name:    " + authorization_partner + CRLF + "SNC ACL Key: " + Codecs.Hex.encode(authorization_key) + CRLF);
            return true;
        }

        private void traceBeforeDispatchRequest(Request request, Response response) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] dispatchRequest() before handleRequest(").append(request == null ? "null" : request.getName()).append(", ").append(response == null ? "null" : response.getName()).append(")");
            boolean trace_data = false;
            byte unicodeType = (byte)((request != null ? request.getUnicodeType() : (byte)0) | (response != null ? response.getUnicodeType() : (byte)0));
            if (unicodeType == 3) {
                buf.append(" WARNING: mixed unicode/non-unicode metadata");
                trace_data = true;
            } else if (unicodeType == 1 && this.attributes.partner_codepage.charAt(0) == '4') {
                buf.append(" WARNING: non-unicode metadata is used for communication with a unicode backend");
                trace_data = true;
            } else if (unicodeType == 2 && this.attributes.partner_codepage.charAt(0) != '4') {
                buf.append(" WARNING: unicode metadata is used for communication with a non-unicode backend");
                trace_data = true;
            }
            if (trace_level > 5 || trace_data) {
                buf.append(CRLF);
                buf.append("Request: ");
                if (request != null) {
                    buf.append(CRLF).append(request.dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
                if (trace_data) {
                    buf.append(CRLF);
                    buf.append("Response: ");
                    if (response != null) {
                        buf.append(CRLF).append(response.dumpContent());
                    } else {
                        buf.append("null");
                    }
                    buf.append(CRLF);
                }
            }
            JCO.fireTrace(trace_level, buf.toString());
        }

        private void traceAfterDispatchRequest(Request request, Response response) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] dispatchRequest() after handleRequest(").append(request == null ? "null" : request.getName()).append(", ").append(response == null ? "null" : response.getName()).append(")");
            if (trace_level > 5) {
                buf.append(CRLF);
                buf.append("Response: ");
                if (response != null) {
                    buf.append(CRLF).append(response.dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
            }
            JCO.fireTrace(trace_level, buf.toString());
        }

        private void traceBeforeDispatchRequest(Function function) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] dispatchRequest() before handleRequest(").append(function.getName()).append(") on handle [").append(this.getConnectionHandle()).append("]");
            boolean trace_data = false;
            byte unicodeType = (byte)((function.getImportParameterList() != null ? function.getImportParameterList().getUnicodeType() : (byte)0) | (function.getExportParameterList() != null ? function.getExportParameterList().getUnicodeType() : (byte)0) | (function.getTableParameterList() != null ? (int)function.getTableParameterList().getUnicodeType() : 0));
            if (unicodeType == 3) {
                JCO.fireTrace(1, "[JAV-LAYER] WARNING: mixed unicode/non-unicode metadata");
                trace_data = true;
            } else if (unicodeType == 1 && this.attributes.partner_codepage.charAt(0) == '4') {
                JCO.fireTrace(1, "[JAV-LAYER] WARNING: non-unicode metadata is used for communication with a unicode backend");
                trace_data = true;
            } else if (unicodeType == 2 && this.attributes.partner_codepage.charAt(0) != '4') {
                JCO.fireTrace(1, "[JAV-LAYER] WARNING: unicode metadata is used for communication with a non-unicode backend");
                trace_data = true;
            }
            if (trace_level > 5 || trace_data) {
                buf.append(CRLF);
                buf.append("Function ").append(function.getName());
                buf.append(CRLF);
                buf.append("Input: ");
                if (function.getImportParameterList() != null) {
                    buf.append(CRLF).append(function.getImportParameterList().dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
                if (trace_data) {
                    buf.append("Output: ");
                    if (function.getExportParameterList() != null) {
                        buf.append(CRLF).append(function.getExportParameterList().dumpContent());
                    } else {
                        buf.append("null");
                    }
                    buf.append(CRLF);
                }
                buf.append("Tables: ");
                if (function.getTableParameterList() != null) {
                    buf.append(CRLF).append(function.getTableParameterList().dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
            }
            JCO.fireTrace(trace_level, buf.toString());
        }

        private void traceAfterDispatchRequest(Function function) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] dispatchRequest() after handleRequest(").append(function.getName()).append(") on handle [").append(this.getConnectionHandle()).append("]");
            if (trace_level > 5) {
                buf.append(CRLF);
                buf.append("Function ").append(function.getName());
                buf.append(CRLF);
                buf.append("Output: ");
                if (function.getExportParameterList() != null) {
                    buf.append(CRLF).append(function.getExportParameterList().dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
                buf.append("Tables: ");
                if (function.getTableParameterList() != null) {
                    buf.append(CRLF).append(function.getTableParameterList().dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
            }
            JCO.fireTrace(trace_level, buf.toString());
        }

        protected void dispatchRequest(Function function) throws java.lang.Exception {
            if (trace_level > 2) {
                JCO.fireTrace(3, "[JAV-LAYER] dispatchRequest( " + (function == null ? "null" : function.getName()) + ")    enter");
            }
            try {
                block36: {
                    try {
                        ParameterList input = function.getImportParameterList();
                        ParameterList output = function.getExportParameterList();
                        if (input != null) {
                            int num_parameters = input.getFieldCount();
                            int i = 0;
                            while (i < num_parameters) {
                                if (input.isExport(i)) {
                                    try {
                                        int j = output.indexOf(input.getName(i));
                                        if (output.isImport(j)) {
                                            output.setValue(input.getValue(i), j);
                                        }
                                    }
                                    catch (java.lang.Exception ex) {
                                        // empty catch block
                                    }
                                }
                                ++i;
                            }
                        }
                        if (this.m_call_model != 0) {
                            Response response;
                            String old_response_name;
                            block35: {
                                String old_request_name = null;
                                old_response_name = null;
                                ParameterList table_parameters = function.getTableParameterList();
                                Request request = (Request)function.getImportParameterList();
                                if (request == null && table_parameters != null) {
                                    request = new Request(function.getName(), function.getExceptionList());
                                }
                                if (request != null) {
                                    old_request_name = request.rec_name;
                                    request.rec_type = (byte)(request.rec_type | 0x10);
                                    request.rec_name = function.getName();
                                }
                                if ((response = (Response)function.getExportParameterList()) == null && table_parameters != null) {
                                    response = new Response(function.getName(), function.getExceptionList());
                                }
                                int num_response_params = 0;
                                if (response != null) {
                                    old_response_name = response.rec_name;
                                    response.rec_type = (byte)(response.rec_type | 0x20);
                                    response.rec_name = function.getName();
                                    num_response_params = response.num_fields;
                                }
                                int num_tables = table_parameters != null ? table_parameters.getFieldCount() : 0;
                                int i = 0;
                                while (i < num_tables) {
                                    request.appendValue(table_parameters.getName(i), table_parameters.getTable(i));
                                    int n = request.num_fields - 1;
                                    request.flags[n] = (byte)(request.flags[n] | 0x40);
                                    response.appendValue(table_parameters.getName(i), table_parameters.getTable(i));
                                    int n2 = response.num_fields - 1;
                                    response.flags[n2] = (byte)(response.flags[n2] | 0x40);
                                    ++i;
                                }
                                try {
                                    if (trace_level > 0) {
                                        this.traceBeforeDispatchRequest(request, response);
                                    }
                                    this.handleRequest(request, response);
                                    if (trace_level > 0) {
                                        this.traceAfterDispatchRequest(request, response);
                                    }
                                    int i2 = 0;
                                    while (i2 < num_tables) {
                                        Table table = table_parameters.getTable(i2);
                                        if (response.getTable(num_response_params + i2) != table) {
                                            if ((this.m_dispatch_mode & 1) != 0) {
                                                table.clear();
                                                table.copyFrom(response.getTable(num_response_params + i2));
                                            } else {
                                                table_parameters.setValue(response.getTable(num_response_params + i2), i2);
                                            }
                                        }
                                        ++i2;
                                    }
                                    Object var15_21 = null;
                                    if (request == null) break block35;
                                }
                                catch (Throwable throwable) {
                                    Object var15_22 = null;
                                    if (request != null) {
                                        request.rec_type = (byte)(request.rec_type & 0xFFFFFFEF);
                                        request.rec_name = old_request_name;
                                    }
                                    if (response != null) {
                                        response.rec_type = (byte)(response.rec_type & 0xFFFFFFDF);
                                        response.rec_name = old_response_name;
                                    }
                                    throw throwable;
                                }
                                request.rec_type = (byte)(request.rec_type & 0xFFFFFFEF);
                                request.rec_name = old_request_name;
                            }
                            if (response != null) {
                                response.rec_type = (byte)(response.rec_type & 0xFFFFFFDF);
                                response.rec_name = old_response_name;
                            }
                            break block36;
                        }
                        if (trace_level > 0) {
                            this.traceBeforeDispatchRequest(function);
                        }
                        this.handleRequest(function);
                        if (trace_level <= 0) break block36;
                        this.traceAfterDispatchRequest(function);
                    }
                    catch (Throwable t) {
                        if (trace_level > 2) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            t.printStackTrace(pw);
                            pw.close();
                            JCO.fireTrace(3, "[JAV-LAYER] Exception in dispatchRequest( " + (function == null ? "null" : function.getName()) + "):" + sw.getBuffer());
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof java.lang.Exception) {
                            throw (java.lang.Exception)t;
                        }
                        Object var17_25 = null;
                        if (trace_level > 2) {
                            JCO.fireTrace(3, "[JAV-LAYER] dispatchRequest( " + (function == null ? "null" : function.getName()) + ")    leave");
                        }
                    }
                }
                Object var17_24 = null;
                if (trace_level > 2) {
                    JCO.fireTrace(3, "[JAV-LAYER] dispatchRequest( " + (function == null ? "null" : function.getName()) + ")    leave");
                }
            }
            catch (Throwable throwable) {
                Object var17_26 = null;
                if (trace_level > 2) {
                    JCO.fireTrace(3, "[JAV-LAYER] dispatchRequest( " + (function == null ? "null" : function.getName()) + ")    leave");
                }
                throw throwable;
            }
        }

        protected void handleRequest(Function function) throws java.lang.Exception {
        }

        protected void handleRequest(Request request, Response response) throws java.lang.Exception {
        }

        protected boolean onCheckTID(String tid) {
            return true;
        }

        protected void onConfirmTID(String tid) {
        }

        protected void onCommit(String tid) {
        }

        protected void onRollback(String tid) {
        }

        protected void beginCall() {
            if ((jco_mode & 7) != 0) {
                this.jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.mw.jco.JCO.Server");
                if (this.jarm_monitor != null) {
                    this.jarm_monitor.startComponent("com.sap.mw.jco.JCO.Server");
                }
                if (this.dsr_monitor == null && this.passport_bytes != null) {
                    this.dsr_monitor = Dsr.createMonitor();
                }
                if (this.dsr_monitor != null && this.passport_bytes != null) {
                    this.dsr_monitor.openDsrRecord(this.getConnectionHandle(), 1, this.passport_bytes, this.start_time);
                }
            }
        }

        protected void endCall() {
            if ((jco_mode & 7) != 0) {
                if (this.jarm_monitor != null) {
                    Attributes attributes = this.getAttributes();
                    this.jarm_monitor.setUser(attributes != null ? attributes.getUser() : (String)null);
                    this.jarm_monitor.endComponent();
                    this.jarm_monitor.endRequest();
                }
                if (this.dsr_monitor != null && this.passport_bytes != null) {
                    this.dsr_monitor.closeDsrRecord(this.getConnectionHandle(), 1, this.rfm_name, this.time_total, this.time_middleware, this.time_handle_request, this.num_sent_bytes, this.num_received_bytes);
                }
            }
        }
    }

    public static class ServerThread
    extends Thread
    implements IServerThread {
        private Server m_server;
        private static int threadId = 0;

        protected ServerThread(Server server) {
            super((Runnable)server, "JCO.ServerThread-" + ServerThread.createThreadId());
            this.m_server = server;
        }

        public Server getServer() {
            return this.m_server;
        }

        private static synchronized int createThreadId() {
            return ++threadId;
        }
    }

    public static class PoolManager {
        private static PoolManager singleton = null;
        private static Vector pool_changed_listeners = new Vector();
        protected Hashtable pools = new Hashtable();
        protected TimeoutChecker timeout_checker;
        protected long max_wait_time = -1L;
        protected long connection_timeout = -1L;
        protected long timeout_check_period = -1L;

        protected PoolManager() {
            this.startTimeoutChecker();
        }

        protected void startTimeoutChecker() {
            try {
                this.timeout_checker = new TimeoutChecker(this);
                Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(this){
                    static /* synthetic */ Class class$com$sap$mw$jco$JCO;
                    private final /* synthetic */ PoolManager this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        Thread thread = null;
                        thread = new Thread(this.this$0.timeout_checker);
                        try {
                            thread.setName("JCO.TimeoutChecker");
                            thread.setDaemon(true);
                        }
                        catch (SecurityException ex) {
                            JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager(): Unable to change the thread name for TimeoutChecker and set it as daemon " + ex.toString());
                        }
                        try {
                            thread.setContextClassLoader((class$com$sap$mw$jco$JCO == null ? (class$com$sap$mw$jco$JCO = 1.class$("com.sap.mw.jco.JCO")) : class$com$sap$mw$jco$JCO).getClassLoader());
                        }
                        catch (SecurityException ex) {
                            JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager(): Unable to change the context classloader " + ex.toString());
                        }
                        return thread;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
                thread.start();
            }
            catch (Exception ex) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager(): Unable to start the TimeoutChecker " + ex.toString());
            }
        }

        public static PoolManager singleton() {
            if (singleton == null) {
                singleton = PoolManager.createPoolManager();
            }
            return singleton;
        }

        private static PoolManager createPoolManager() {
            Vector vector = pool_changed_listeners;
            synchronized (vector) {
                PoolManager poolManager = new PoolManager();
                return poolManager;
            }
        }

        protected static void registerPoolManager(PoolManager pool_manager) {
            Vector vector = pool_changed_listeners;
            synchronized (vector) {
                if (singleton != null) {
                    throw new Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "PoolManager instance is already registered.");
                }
                singleton = pool_manager;
            }
        }

        public void addPoolChangedListener(PoolChangedListener listener) {
            Vector vector = pool_changed_listeners;
            synchronized (vector) {
                pool_changed_listeners.addElement(listener);
            }
        }

        public void removePoolChangedListener(PoolChangedListener listener) {
            Vector vector = pool_changed_listeners;
            synchronized (vector) {
                pool_changed_listeners.removeElement(listener);
            }
        }

        protected void firePoolChanged(Pool pool) {
            Vector list;
            Vector vector = pool_changed_listeners;
            synchronized (vector) {
                list = (Vector)pool_changed_listeners.clone();
            }
            Enumeration e = list.elements();
            while (e.hasMoreElements()) {
                PoolChangedListener listener = (PoolChangedListener)e.nextElement();
                listener.poolChanged(pool);
            }
        }

        public void addPool(String pool_name, Client master, int max_pool_size) {
            Pool pool;
            Hashtable hashtable = this.pools;
            synchronized (hashtable) {
                if (this.pools.containsKey(pool_name)) {
                    throw new Exception(102, "JCO_ERROR_COMMUNICATION", "A pool with the identifier '" + pool_name + "' already exists");
                }
                pool = new Pool(this, pool_name, master, max_pool_size);
                if (this.max_wait_time != -1L) {
                    pool.setMaxWaitTime(this.max_wait_time);
                }
                if (this.connection_timeout != -1L) {
                    pool.setConnectionTimeout(this.connection_timeout);
                }
                if (this.timeout_check_period != -1L) {
                    pool.setTimeoutCheckPeriod(this.timeout_check_period);
                }
                this.pools.put(pool_name, pool);
                if (trace_level > 0) {
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager.addPool: \n\t name = " + pool_name + ", \n\t connection = " + master.getHashKey(true) + ", \n\t pool_size = " + pool.getMaxPoolSize() + ", \n\t max_wait_time = " + pool.getMaxWaitTime() + ", \n\t pooled_connection_timeout = " + pool.getConnectionTimeout() + ", \n\t timeout_check_period = " + pool.getTimeoutCheckPeriod());
                }
            }
            this.firePoolChanged(pool);
        }

        public String[] getPoolNames() {
            String[] pool_names = new String[this.pools.size()];
            int i = 0;
            Hashtable hashtable = this.pools;
            synchronized (hashtable) {
                Enumeration e = this.pools.keys();
                while (e.hasMoreElements()) {
                    pool_names[i++] = (String)e.nextElement();
                }
            }
            return pool_names;
        }

        public Pool getPool(String pool_name) {
            return (Pool)this.pools.get(pool_name);
        }

        public void removePool(String pool_name) {
            Pool pool;
            if (trace_level > 0) {
                StringBuffer out = new StringBuffer("[JAV-LAYER] JCO.PoolManager.removePool(\"").append(pool_name).append("\") ");
                if (trace_level > 4) {
                    Throwable throwable = new Throwable();
                    throwable.fillInStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    pw.close();
                    out.append(CRLF);
                    out.append("-------------- Trace of where JCO.Pool.removePool(");
                    out.append(pool_name).append(") was called -----------------");
                    out.append(sw.getBuffer().delete(0, "java.lang.Throwable".length()).toString());
                    out.append("--------------------------------------------------------------------------");
                }
                JCO.fireTrace(1, out.toString());
            }
            Hashtable hashtable = this.pools;
            synchronized (hashtable) {
                pool = (Pool)this.pools.get(pool_name);
                if (pool == null) {
                    return;
                }
                this.pools.remove(pool_name);
            }
            pool.manager = null;
            this.timeout_checker.stopCheckerFor(pool);
            pool.clear();
            this.firePoolChanged(pool);
        }

        public Client getClient(String pool_name) {
            return this.getClient(pool_name, true);
        }

        public Client getClient(String pool_name, boolean reset) {
            Client client = null;
            Pool pool = (Pool)this.pools.get(pool_name);
            if (pool == null) {
                if (trace_level > 0) {
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager.getClient(" + pool_name + ", " + reset + ") Error: application tries to get client from removed or non existent pool.");
                }
                return null;
            }
            if (!pool.is_initialized) {
                pool.initPool();
            }
            client = pool.getClient(reset);
            this.firePoolChanged(pool);
            return client;
        }

        public void releaseClient(Client client) {
            if (client == null) {
                if (trace_level > 2) {
                    JCO.fireTrace(3, "[JAV-LAYER] JCO.PoolManager.releaseClient: Cannot release client equals null \n");
                }
                return;
            }
            if (client.pool == null) {
                client.disconnect(false);
                return;
            }
            client.pool.releaseClient(client);
            this.firePoolChanged(client.pool);
        }

        public void detachFromPool(Client client) {
            if (client == null || client.pool == null) {
                StringBuffer to_trace = new StringBuffer("[JAV-LAYER] Cannot detach client equals ");
                if (client == null) {
                    to_trace.append("null\n");
                } else {
                    to_trace.append(client.toString()).append(" from pool equals null\n");
                }
                StringWriter buf = new StringWriter();
                Throwable t = new Throwable();
                t.fillInStackTrace();
                t.printStackTrace(new PrintWriter(buf));
                to_trace.append((Object)buf.getBuffer());
                JCO.fireTrace(3, to_trace.toString());
                return;
            }
            if ((client.state & 0x10) == 0) {
                Exception ex = new Exception(106, "JCO_ERROR_RESOURCE", "A client isn't allocated from pool cannot be detached." + CRLF + "Please, use JCO.getClient(String pool) first.");
                JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager.detachFromPool(): " + ex.toString());
                throw ex;
            }
            client.pool.detachFromPool(client);
            client.pool = null;
        }

        public void removeConnection(Connection connection) {
            if (connection == null) {
                JCO.fireTrace(5, "[JAV-LAYER] JCO.PoolManager.removeConnection: warning connection = null");
                return;
            }
            if (connection.pool == null) {
                JCO.fireTrace(5, "[JAV-LAYER] JCO.PoolManager.removeConnection: warning connection isn't pooled");
            }
            if (connection instanceof Client) {
                ((Client)connection).pool.detachFromPool((Client)connection);
                ((Client)connection).pool = null;
                ((Client)connection).disconnect(true);
            } else {
                connection.disconnect();
            }
        }

        public long getTimeoutCheckPeriod() {
            return this.timeout_check_period;
        }

        public void setTimeoutCheckPeriod(long timeout_check_period) {
            this.timeout_check_period = timeout_check_period;
        }

        public long getConnectionTimeout() {
            return this.connection_timeout;
        }

        public void setConnectionTimeout(long connection_timeout) {
            this.connection_timeout = connection_timeout;
        }

        public final long getMaxWaitTime() {
            return this.max_wait_time;
        }

        public final void setMaxWaitTime(long max_wait_time) {
            this.max_wait_time = max_wait_time;
        }

        protected static class TimeoutChecker
        implements Runnable {
            private PoolManager manager;
            private boolean is_stopped = false;
            private ObjectList pools = new ObjectList();
            private Thread ownThread = null;

            public TimeoutChecker(PoolManager manager) {
                this.manager = manager;
            }

            public final void startCheckerFor(Pool pool) {
                ObjectList objectList = this.pools;
                synchronized (objectList) {
                    if (!this.pools.contains(pool) && pool.getTimeoutCheckPeriod() > 0L) {
                        pool.next_timeout_check = System.currentTimeMillis() + pool.timeout_check_period;
                        this.pools.add(pool);
                        this.pools.notifyAll();
                    }
                }
            }

            public final void stopCheckerFor(Pool pool) {
                ObjectList objectList = this.pools;
                synchronized (objectList) {
                    if (this.pools.contains(pool)) {
                        this.pools.remove(pool);
                    }
                }
            }

            public final void run() {
                Pool pool_to_check = null;
                long to_sleep = 0L;
                while (true) {
                    long next_check = Long.MAX_VALUE;
                    pool_to_check = null;
                    ObjectList objectList = this.pools;
                    synchronized (objectList) {
                        if (this.pools.isEmpty()) {
                            try {
                                this.pools.wait();
                            }
                            catch (InterruptedException ex) {
                                JCO.fireTrace(1, "[JAV-LAYER] JCO.TimeoutChecker.run(): wait caused " + ex.toString());
                                break;
                            }
                        }
                        int i = this.pools.size();
                        while (--i >= 0) {
                            Pool pool = (Pool)this.pools.get(i);
                            if (pool.next_timeout_check >= next_check) continue;
                            pool_to_check = pool;
                            next_check = pool.next_timeout_check;
                        }
                    }
                    to_sleep = next_check - System.currentTimeMillis();
                    if (pool_to_check == null) continue;
                    if (to_sleep > 0L) {
                        ObjectList objectList2 = this.pools;
                        synchronized (objectList2) {
                            try {
                                this.pools.wait(to_sleep);
                            }
                            catch (InterruptedException ex) {
                                JCO.fireTrace(1, "[JAV-LAYER] TimeoutChecker.run(): wait caused " + ex.toString());
                                break;
                            }
                        }
                    }
                    if (!this.pools.contains(pool_to_check)) continue;
                    pool_to_check.checkForTimeout();
                    pool_to_check.next_timeout_check = System.currentTimeMillis() + pool_to_check.timeout_check_period;
                }
            }
        }
    }

    public static class Pool {
        public final int INFINITE = Integer.MAX_VALUE;
        protected String name;
        protected Client master;
        protected int max_pool_size;
        protected int max_connections;
        protected long max_wait_time = 30000L;
        protected long connection_timeout = 600000L;
        protected long timeout_check_period = 60000L;
        protected long next_timeout_check;
        protected int max_used;
        protected int current_used;
        protected LimitedList available;
        protected ObjectList waiting_threads = null;
        protected PoolManager manager;
        protected boolean is_initialized = false;
        protected byte r3_version = (byte)4;
        protected boolean reset_on_release = true;

        protected Pool(PoolManager manager, String name, Client master, int max_pool_size) {
            this.manager = manager;
            this.name = name;
            this.master = (Client)master.clone();
            this.max_pool_size = max_pool_size;
            this.max_connections = max_pool_size;
            this.available = new LimitedList(max_pool_size);
        }

        protected void initPool() {
            Pool pool = this;
            synchronized (pool) {
                if (this.is_initialized) {
                    return;
                }
                this.master.connect();
                if (this.master.properties.getProperty("jco.client.type", "3").equals("E")) {
                    this.master.ping();
                }
                Attributes attrib = this.master.getAttributes();
                this.master.disconnect();
                String prel = attrib.getPartnerRelease();
                this.r3_version = prel != null && prel.length() > 0 ? (byte)(prel.charAt(0) - 48) : (byte)0;
                if (properties.getProperty("jco.client.idle_timeout", null) != null) {
                    int idle_timeout = Integer.parseInt(properties.getProperty("jco.client.idle_timeout")) * 1000;
                    if (this.getConnectionTimeout() > (long)idle_timeout) {
                        this.setConnectionTimeout(idle_timeout);
                    }
                }
                this.is_initialized = true;
            }
        }

        public final void setResetOnRelease(boolean reset_on_release) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setResetOnRelease(" + reset_on_release + ")");
            }
            this.reset_on_release = reset_on_release;
        }

        public final boolean getResetOnRelease() {
            return this.reset_on_release;
        }

        public void setAbapDebug(boolean debug) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setAbapDebug(" + debug + ")");
            }
            if (this.getAbapDebug() != debug) {
                this.master.setAbapDebug(debug);
            }
        }

        public final boolean getAbapDebug() {
            return this.master.getAbapDebug();
        }

        public final boolean getTrace() {
            return this.master.getTrace();
        }

        public final void setTrace(boolean trace) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setTrace(" + trace + ")");
            }
            if (this.getTrace() != trace) {
                this.master.setTrace(trace);
            }
        }

        public final String getName() {
            return this.name;
        }

        public final PoolManager getPoolManager() {
            return this.manager;
        }

        public final int getMaxPoolSize() {
            return this.available.getLimit();
        }

        public final void setMaxPoolSize(int max_pool_size) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setMaxPoolSize(" + max_pool_size + ")");
            }
            if (max_pool_size < 0) {
                throw new IllegalArgumentException("max_pool_size [" + max_pool_size + "] less than zero");
            }
            LimitedList limitedList = this.available;
            synchronized (limitedList) {
                if (max_pool_size < this.available.size()) {
                    int i = 0;
                    int to = this.available.size() - max_pool_size;
                    while (i < to) {
                        Client to_close = (Client)this.available.remove(i);
                        to_close.disconnect(true);
                        ++i;
                    }
                }
                this.available.setLimit(max_pool_size);
            }
            if (max_pool_size == 0) {
                this.manager.timeout_checker.stopCheckerFor(this);
            }
            if (this.getMaxConnections() < max_pool_size) {
                this.setMaxConnections(max_pool_size);
            }
        }

        public final int getMaxConnections() {
            return this.max_connections;
        }

        public final void setMaxConnections(int max_connections) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setMaxConnections(" + max_connections + ")");
            }
            if (this.getMaxPoolSize() > max_connections) {
                this.setMaxPoolSize(max_connections);
            }
            this.max_connections = max_connections;
        }

        public final int getCurrentPoolSize() {
            int currSize = this.current_used + this.available.size();
            return currSize;
        }

        public final int getMaxUsed() {
            return this.max_used;
        }

        public final int getNumUsed() {
            return this.current_used;
        }

        public final int getNumWaitingThreads() {
            return this.waiting_threads != null ? this.waiting_threads.size() : 0;
        }

        public final void setMaxWaitTime(long max_wait_time) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setMaxWaitTime(" + max_wait_time + ")");
            }
            if (max_wait_time >= 0L) {
                this.max_wait_time = max_wait_time;
            }
        }

        public final long getMaxWaitTime() {
            return this.max_wait_time;
        }

        public long getConnectionTimeout() {
            return this.connection_timeout;
        }

        public void setConnectionTimeout(long connection_timeout) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setConnectionTimeout(" + connection_timeout + ")");
            }
            this.connection_timeout = connection_timeout;
        }

        public long getTimeoutCheckPeriod() {
            return this.timeout_check_period;
        }

        public void setTimeoutCheckPeriod(long timeout_check_period) {
            if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.setTimeoutCheckPeriod(" + timeout_check_period + ") on pool " + this.getName());
            }
            if (timeout_check_period < 0L) {
                throw new IllegalArgumentException("timeout_check_period " + timeout_check_period + " must be greater than or equal to zero.");
            }
            if (this.manager == null) {
                return;
            }
            this.timeout_check_period = timeout_check_period;
            if (timeout_check_period > 0L) {
                this.manager.timeout_checker.startCheckerFor(this);
            } else {
                this.manager.timeout_checker.stopCheckerFor(this);
            }
        }

        protected final void clear() {
            LimitedList limitedList = this.available;
            synchronized (limitedList) {
                while (!this.available.isEmpty()) {
                    ((Client)this.available.pop()).disconnect(true);
                }
                if (this.waiting_threads != null && this.waiting_threads.size() > 0) {
                    if (trace_level > 0) {
                        JCO.fireTrace(1, "[JAV-LAYER] Warning: Pool.clear() was called, although " + this.waiting_threads.size() + " threads are still waiting in getClient().");
                    }
                    this.available.notifyAll();
                }
            }
        }

        public final byte[] getStates() {
            return new byte[0];
        }

        protected final Client getClient(boolean reset) {
            boolean shouldStopTimeoutChecker = false;
            Client client = null;
            if (trace_level > 1) {
                JCO.fireTrace(2, "[JAV-LAYER] JCO.Pool.getClient(" + reset + ")  from pool " + this.getName() + "    [enter]");
            }
            if (this.manager == null) {
                throw new Exception(106, "JCO_ERROR_RESOURCE", "Connection pool " + this.name + " is removed.");
            }
            LimitedList limitedList = this.available;
            synchronized (limitedList) {
                if (!this.available.isEmpty()) {
                    client = (Client)this.available.pop();
                    if (this.available.isEmpty()) {
                        shouldStopTimeoutChecker = true;
                    }
                    ++this.current_used;
                } else if (this.current_used < this.max_connections) {
                    client = (Client)this.master.clone();
                    client.pool = this;
                    ++this.current_used;
                }
            }
            if (client == null && this.max_wait_time > 0L) {
                if (trace_level > 4) {
                    JCO.fireTrace(5, "[JAV-LAYER] JCO.Pool.getClient() no connections available " + "[pool size " + this.getCurrentPoolSize() + ", max conns " + this.getMaxConnections() + ", waiting threads " + this.getNumWaitingThreads() + ", currently used " + this.getNumUsed() + "]");
                }
                LimitedList limitedList2 = this.available;
                synchronized (limitedList2) {
                    long duration = this.max_wait_time;
                    try {
                        if (this.waiting_threads == null) {
                            this.waiting_threads = new ObjectList();
                        }
                        this.waiting_threads.add(Thread.currentThread());
                        while (client == null && duration > 0L) {
                            long t0 = System.currentTimeMillis();
                            this.available.wait(duration);
                            if (this.manager == null) {
                                Client client2 = null;
                                return client2;
                            }
                            int num_available = Math.min(this.max_connections - this.current_used, this.waiting_threads.size());
                            int i = 0;
                            while (i < num_available) {
                                if (this.waiting_threads.get(i) == Thread.currentThread()) {
                                    this.waiting_threads.remove(Thread.currentThread());
                                    if (this.waiting_threads.size() == 0) {
                                        this.waiting_threads = null;
                                    }
                                    if (!this.available.isEmpty()) {
                                        client = (Client)this.available.pop();
                                        if (this.available.isEmpty()) {
                                            shouldStopTimeoutChecker = true;
                                        }
                                        ++this.current_used;
                                        break;
                                    }
                                    if (this.current_used >= this.max_connections) break;
                                    client = (Client)this.master.clone();
                                    client.pool = this;
                                    ++this.current_used;
                                    break;
                                }
                                ++i;
                            }
                            duration -= System.currentTimeMillis() - t0;
                        }
                    }
                    catch (InterruptedException ex) {
                        this.waiting_threads.remove(Thread.currentThread());
                        if (this.waiting_threads.size() == 0) {
                            this.waiting_threads = null;
                        }
                        JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.getClient(): wait(" + duration + ") caused " + ex.toString());
                        throw new Exception(106, "JCO_ERROR_RESOURCE", ex.toString());
                    }
                }
            }
            if (client != null) {
                this.max_used = Math.max(this.max_used, this.current_used);
                if (reset && client.isValid() && !this.reset_on_release) {
                    if (this.r3_version < 4) {
                        try {
                            client.disconnect(true);
                        }
                        catch (Exception ex) {
                            LimitedList duration = this.available;
                            synchronized (duration) {
                                --this.current_used;
                                this.available.notifyAll();
                            }
                            throw ex;
                        }
                    }
                    try {
                        client.middleware.reset(client);
                    }
                    catch (Exception ex) {
                        JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.getClient(): Reset causes " + ex.toString());
                        try {
                            client.middleware.disconnect(client);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        LimitedList t = this.available;
                        synchronized (t) {
                            --this.current_used;
                            this.available.notifyAll();
                        }
                        throw ex;
                    }
                }
                try {
                    if (client.isValid() && !client.middleware.isAlive(client)) {
                        client.disconnect(true);
                    }
                    if ((client.state & 1) != 0) {
                        client.connect();
                    }
                }
                catch (Exception ex) {
                    LimitedList t = this.available;
                    synchronized (t) {
                        --this.current_used;
                        this.available.notifyAll();
                    }
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.getClient(): " + ex.toString());
                    throw ex;
                }
                client.state = (byte)(client.state | 0x10);
                if (trace_level < -10) {
                    Throwable throwable = new Throwable();
                    throwable.fillInStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println("-------------- Trace of where JCO.getClient() was called -----------------");
                    throwable.printStackTrace(pw);
                    pw.println("--------------------------------------------------------------------------");
                    client.stack_trace = sw.toString();
                }
            } else {
                Exception ex = new Exception(106, "JCO_ERROR_RESOURCE", "Connection pool " + this.name + " is exhausted. The current pool size limit (max connections) is " + this.max_connections + " connections.");
                JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.getClient(): No clients available. " + ex.toString());
                throw ex;
            }
            if (JCO.getTraceLevel() > 1) {
                JCO.fireTrace(2, "[JAV-LAYER] JCO.Pool.getClient(" + reset + ") returns [" + client.getConnectionHandle() + "]     [leave]");
            }
            if (shouldStopTimeoutChecker && this.available.isEmpty() && this.manager != null && this.timeout_check_period > 0L) {
                this.manager.timeout_checker.stopCheckerFor(this);
            }
            return client;
        }

        protected final void releaseClient(Client client) {
            LimitedList limitedList;
            if (trace_level > 1) {
                JCO.fireTrace(2, "[JAV-LAYER] JCO.Pool.releaseClient([" + client.getConnectionHandle() + "]) in pool " + this.getName());
            }
            if (client == null) {
                return;
            }
            if (client.pool == null) {
                client.disconnect(false);
                return;
            }
            Client clone = null;
            LimitedList limitedList2 = this.available;
            synchronized (limitedList2) {
                if ((client.state & 0x10) == 0) {
                    return;
                }
                client.state = (byte)(client.state & 0xFFFFFFEF);
            }
            try {
                clone = client.hide();
            }
            catch (Exception ex) {
                if (trace_level > 0) {
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Pool.releaseClient() concurrent release detected,the client is used by application in an other thread " + ex.toString());
                }
                client.state = (byte)(client.state | 0x10);
                throw ex;
            }
            try {
                if (this.manager == null) {
                    clone.pool = null;
                    clone.disconnect(false);
                    clone = null;
                } else if (this.connection_timeout <= 0L || !clone.isAlive() || this.reset_on_release && this.r3_version < 4) {
                    clone.state = (byte)(clone.state & 0xF0 | 1);
                    clone.middleware.disconnect(clone);
                    clone = null;
                } else {
                    if (clone.authorizationTraceID != null) {
                        clone.state = (byte)(clone.state | 0x10);
                        clone.endAuthorizationTracing();
                        clone.state = (byte)(clone.state & 0xFFFFFFEF);
                    }
                    if (this.reset_on_release && this.r3_version >= 4) {
                        try {
                            clone.middleware.reset(clone);
                        }
                        catch (Exception ex) {
                            if (trace_level > 0) {
                                JCO.fireTrace(1, "[JAV-LAYER] Pool.releaseClient [" + clone.rfc_handle + "] failed with " + ex.toString());
                            }
                            clone.middleware.disconnect(clone);
                            clone = null;
                            throw ex;
                        }
                    }
                }
                Object var6_7 = null;
                limitedList = this.available;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                LimitedList limitedList3 = this.available;
                synchronized (limitedList3) {
                    if (clone != null && (client = (Client)this.available.push(clone)) != null) {
                        try {
                            client.middleware.disconnect(client);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    --this.current_used;
                    this.available.notifyAll();
                }
                if (this.manager != null && !this.available.isEmpty() && this.timeout_check_period > 0L) {
                    this.manager.timeout_checker.startCheckerFor(this);
                }
                throw throwable;
            }
            synchronized (limitedList) {
                if (clone != null && (client = (Client)this.available.push(clone)) != null) {
                    try {
                        client.middleware.disconnect(client);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                --this.current_used;
                this.available.notifyAll();
            }
            if (this.manager != null && !this.available.isEmpty() && this.timeout_check_period > 0L) {
                this.manager.timeout_checker.startCheckerFor(this);
            }
        }

        public void detachFromPool(Client client) {
            if (client == null || client.pool == null) {
                return;
            }
            if ((client.state & 0x10) == 0) {
                Exception ex = new Exception(106, "JCO_ERROR_RESOURCE", "A client that is not allocated from pool cannot be detached." + CRLF + "Please, use JCO.getClient(String pool) first.");
                JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager.detachFromPool(): " + ex.toString());
                throw ex;
            }
            if (client.pool != this) {
                Exception ex = new Exception(106, "JCO_ERROR_RESOURCE", "A client allocated from pool " + client.pool.getName() + " cannot be detached from " + this.getName() + ".");
                JCO.fireTrace(1, "[JAV-LAYER] JCO.PoolManager.detachFromPool(): " + ex.toString());
                throw ex;
            }
            --this.current_used;
            client.pool = null;
            client.state = (byte)(client.state & 0xFFFFFFEF);
        }

        protected final void checkForTimeout() {
            if (this.available.isEmpty()) {
                return;
            }
            LimitedList limitedList = this.available;
            synchronized (limitedList) {
                long now = System.currentTimeMillis();
                int i = 0;
                while (i < this.available.size()) {
                    block8: {
                        Client conn = (Client)this.available.get(i);
                        if (now - conn.last_active_timestamp > this.connection_timeout) {
                            this.available.remove(conn);
                            try {
                                conn.disconnect(true);
                            }
                            catch (Exception ex) {
                                if (trace_level <= 7) break block8;
                                JCO.fireTrace(8, "[JAV-LAYER] JCO.Pool.CheckforTimeout: disconnect caused " + ex.toString());
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static interface PoolChangedListener {
        public void poolChanged(Pool var1);
    }

    public static class Client
    extends Connection {
        protected IMiddleware.IClient middleware;
        private static final char SPACE = ' ';
        protected String stack_trace = null;
        private Object semaphore = new Object();
        private String authorizationTraceID = null;
        protected static final MetaData auth_trace_set = new MetaData("AUTHTRACESET", 2);
        protected static final MetaData auth_trace_set_unicode = new MetaData("AUTHTRACESET", 2);
        protected static final MetaData auth_trace_status_rc = new MetaData("AUTHTRACESTATUSRC", 1);
        protected static final MetaData auth_trace_status_rc_unicode = new MetaData("AUTHTRACESTATUSRC", 1);
        protected static final MetaData auth_trace_status = new MetaData("AUTHTRACESTATUS", 1);
        protected static final MetaData auth_trace_status_unicode = new MetaData("AUTHTRACESTATUS", 1);

        protected static synchronized IMiddleware.IClient getClientInterface() {
            try {
                IMiddleware mw = (IMiddleware)middleware_class.newInstance();
                return mw.getClientInterface();
            }
            catch (java.lang.Exception ex) {
                JCO.fireTrace(0, "[JAV-LAYER] JCO.Client(): could not get middleware interface");
                return null;
            }
        }

        protected Client(Properties properties) {
            if (properties != null) {
                this.properties = (Properties)((Hashtable)properties).clone();
            }
            this.middleware = Client.getClientInterface();
        }

        protected Client(String[][] params) {
            int i = 0;
            while (i < params.length) {
                String val;
                String key = params[i][0];
                if (key != null && (val = params[i][1]) != null) {
                    if ((key = key.toLowerCase().trim()).indexOf("jco.client.") != 0) {
                        key = "jco.client." + key;
                    }
                    ((Hashtable)this.properties).put(key, val);
                }
                ++i;
            }
            this.middleware = Client.getClientInterface();
        }

        protected Client(String client, String user, String passwd, String lang, String ashost, String sysnr) {
            this(client, user, passwd, lang, ashost, sysnr, null, null);
        }

        protected Client(String client, String user, String passwd, String lang, String ashost, String sysnr, String gwhost, String gwserv) {
            ((Hashtable)this.properties).put("jco.client.type", "3");
            if (client != null) {
                ((Hashtable)this.properties).put("jco.client.client", client);
            }
            if (user != null) {
                ((Hashtable)this.properties).put("jco.client.user", user);
            }
            if (passwd != null) {
                ((Hashtable)this.properties).put("jco.client.passwd", passwd);
            }
            if (lang != null) {
                ((Hashtable)this.properties).put("jco.client.lang", lang);
            }
            if (ashost != null) {
                ((Hashtable)this.properties).put("jco.client.ashost", ashost);
            }
            if (sysnr != null) {
                ((Hashtable)this.properties).put("jco.client.sysnr", sysnr);
            }
            if (gwhost != null) {
                ((Hashtable)this.properties).put("jco.client.gwhost", gwhost);
            }
            if (gwserv != null) {
                ((Hashtable)this.properties).put("jco.client.gwserv", gwserv);
            }
            this.middleware = Client.getClientInterface();
        }

        protected Client(String client, String user, String passwd, String lang, String mshost, String r3name, String group) {
            ((Hashtable)this.properties).put("jco.client.type", "3");
            if (client != null) {
                ((Hashtable)this.properties).put("jco.client.client", client);
            }
            if (user != null) {
                ((Hashtable)this.properties).put("jco.client.user", user);
            }
            if (passwd != null) {
                ((Hashtable)this.properties).put("jco.client.passwd", passwd);
            }
            if (lang != null) {
                ((Hashtable)this.properties).put("jco.client.lang", lang);
            }
            if (mshost != null) {
                ((Hashtable)this.properties).put("jco.client.mshost", mshost);
            }
            if (r3name != null) {
                ((Hashtable)this.properties).put("jco.client.r3name", r3name);
            }
            if (group != null) {
                ((Hashtable)this.properties).put("jco.client.group", group);
            }
            this.middleware = Client.getClientInterface();
        }

        protected Client(String gwhost, String gwserv, String tpname) {
            ((Hashtable)this.properties).put("jco.client.type", "E");
            if (gwhost != null) {
                ((Hashtable)this.properties).put("jco.client.gwhost", gwhost);
            }
            if (gwserv != null) {
                ((Hashtable)this.properties).put("jco.client.gwserv", gwserv);
            }
            if (tpname != null) {
                ((Hashtable)this.properties).put("jco.client.tpname", tpname);
            }
            this.middleware = Client.getClientInterface();
        }

        protected Client(String gwhost, String gwserv, String tpname, String tphost) {
            ((Hashtable)this.properties).put("jco.client.type", "E");
            if (gwhost != null) {
                ((Hashtable)this.properties).put("jco.client.gwhost", gwhost);
            }
            if (gwserv != null) {
                ((Hashtable)this.properties).put("jco.client.gwserv", gwserv);
            }
            if (tpname != null) {
                ((Hashtable)this.properties).put("jco.client.tpname", tpname);
            }
            if (tphost != null) {
                ((Hashtable)this.properties).put("jco.client.tphost", tphost);
            }
            this.middleware = Client.getClientInterface();
        }

        protected Client(String client, String user, String passwd, String lang, String url) {
            if (client != null) {
                ((Hashtable)this.properties).put("jco.client.client", client);
            }
            if (user != null) {
                ((Hashtable)this.properties).put("jco.client.user", user);
            }
            if (passwd != null) {
                ((Hashtable)this.properties).put("jco.client.passwd", passwd);
            }
            if (lang != null) {
                ((Hashtable)this.properties).put("jco.client.lang", lang);
            }
            try {
                try {
                    URL uri = new URL(url);
                    ((Hashtable)this.properties).put("jco.client.url", uri.toString());
                }
                catch (MalformedURLException ex) {
                    throw new Exception(102, "JCO_ERROR_COMMUNICATION", ex.getMessage());
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.middleware = Client.getClientInterface();
                throw throwable;
            }
            this.middleware = Client.getClientInterface();
        }

        public synchronized Object clone() {
            Client client = (Client)super.clone();
            client.rfc_handle = 0L;
            client.state = 1;
            client.middleware = Client.getClientInterface();
            return client;
        }

        protected final Client hide() {
            Client hidden = null;
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                }
                hidden = (Client)super.hideConnection();
                hidden.middleware = this.middleware;
                this.state = (byte)(this.state | 1);
                this.middleware = null;
            }
            return hidden;
        }

        public void reset() {
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                }
                this.state = (byte)(this.state | 4);
            }
            try {
                if (this.isAlive()) {
                    byte r3ver = 0;
                    if (this.isPooled()) {
                        r3ver = this.pool.r3_version;
                    } else {
                        try {
                            r3ver = (byte)(this.getAttributesInternal().getPartnerRelease().charAt(0) - 48);
                        }
                        catch (RuntimeException e) {
                            r3ver = 0;
                        }
                    }
                    if (r3ver >= 4) {
                        this.middleware.reset(this);
                    } else {
                        this.state = (byte)(this.state & 0xFFFFFFFD);
                        this.state = (byte)(this.state | 1);
                        this.middleware.disconnect(this);
                        this.middleware.connect(this, this.conn_params);
                        this.state = (byte)(this.state & 0xFFFFFFFE);
                        this.state = (byte)(this.state | 2);
                    }
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.state = (byte)(this.state & 0xFFFFFFFB);
                this.last_active_timestamp = System.currentTimeMillis();
                throw throwable;
            }
            this.state = (byte)(this.state & 0xFFFFFFFB);
            this.last_active_timestamp = System.currentTimeMillis();
        }

        public final String[][] getPropertyInfo() {
            return this.middleware.getPropertyInfo();
        }

        public void setProperty(String key, String value) {
            if ((key = key.toLowerCase().trim()).indexOf("jco.client.") != 0) {
                key = "jco.client." + key;
            }
            super.setProperty(key, value);
        }

        public final String getUser() {
            return this.properties.getProperty("jco.client.user");
        }

        protected final String getPassword() {
            return "******";
        }

        public final String getClient() {
            return this.properties.getProperty("jco.client.client");
        }

        public final String getLanguage() {
            return this.properties.getProperty("jco.client.lang");
        }

        public final String getSystemNumber() {
            return this.properties.getProperty("jco.client.sysnr");
        }

        public final String getASHost() {
            return this.properties.getProperty("jco.client.ashost");
        }

        public final String getMSHost() {
            return this.properties.getProperty("jco.client.mshost");
        }

        public final String getGWHost() {
            return this.properties.getProperty("jco.client.gwhost");
        }

        public final String getGWServ() {
            return this.properties.getProperty("jco.client.gwserv");
        }

        public final String getSystemID() {
            return this.properties.getProperty("jco.client.r3name");
        }

        public final String getGroup() {
            return this.properties.getProperty("jco.client.group");
        }

        public final String getTPName() {
            return this.properties.getProperty("jco.client.tpname");
        }

        public final URL getURL() {
            URL url = null;
            try {
                String uri = this.properties.getProperty("jco.client.url");
                if (uri != null) {
                    url = new URL(uri);
                }
            }
            catch (MalformedURLException ex) {
                url = null;
            }
            return url;
        }

        public final boolean getTrace() {
            String value = this.properties.getProperty("jco.client.trace");
            return value != null && value.equals("1");
        }

        public final void setTrace(boolean trace) {
            if (trace_level > 5) {
                JCO.fireTrace(7, "[JAV-LAYER] JCO.Client.setTrace(" + trace + "), current state " + this.getTrace());
            }
            if (this.getTrace() == trace) {
                return;
            }
            this.setProperty("jco.client.trace", trace ? "1" : "0");
            if ((this.state & 2) != 0) {
                if (this.pool != null) {
                    this.disconnect(true);
                } else {
                    this.disconnect(false);
                }
                this.connect();
            }
        }

        public boolean getAbapDebug() {
            String value = this.properties.getProperty("jco.client.abap_debug");
            return value != null && value.equals("1");
        }

        public void setAbapDebug(boolean debug) {
            if (trace_level > 5) {
                JCO.fireTrace(7, "[JAV-LAYER] JCO.Client.setAbapDebug(" + debug + "), current state " + this.getAbapDebug());
            }
            if (this.getAbapDebug() == debug) {
                return;
            }
            this.setProperty("jco.client.abap_debug", debug ? "1" : "0");
            if ((this.state & 2) != 0 && (this.state & 4) == 0) {
                this.middleware.disconnect(this);
                this.connect();
            }
        }

        public int getSapGui() {
            String value = this.properties.getProperty("jco.client.use_sapgui");
            if (value == null) {
                return 0;
            }
            if (value.equals("0")) {
                return 0;
            }
            if (value.equals("1")) {
                return 1;
            }
            if (value.equals("2")) {
                return 2;
            }
            return 0;
        }

        public void setSapGui(int use_sapgui) {
            if (use_sapgui < 0) {
                use_sapgui = 0;
            }
            if (use_sapgui > 2) {
                use_sapgui = 2;
            }
            this.setProperty("jco.client.use_sapgui", Integer.toString(use_sapgui));
        }

        public byte getState() {
            return super.getState();
        }

        Attributes getAttributesInternal() {
            if (this.attributes == null) {
                if (this.pool != null && this.pool.master != null && this.pool.master.attributes != null) {
                    this.attributes = this.pool.master.attributes;
                } else {
                    try {
                        this.middleware.getAttributes(this);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        this.last_active_timestamp = System.currentTimeMillis();
                        throw throwable;
                    }
                    this.last_active_timestamp = System.currentTimeMillis();
                    {
                    }
                }
            }
            if (this.pool != null && this.pool.master != null) {
                if (this.pool.master.attributes == null) {
                    this.pool.master.attributes = this.attributes;
                }
                if (this.pool.master.codepage_converter == 0L) {
                    this.pool.master.codepage_converter = this.codepage_converter;
                }
            }
            return this.attributes;
        }

        public final Attributes getAttributes() {
            if (this.attributes == null) {
                Object object = this.semaphore;
                synchronized (object) {
                    if ((this.state & 4) != 0) {
                        throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                    }
                    this.state = (byte)(this.state | 4);
                }
                try {
                    this.getAttributesInternal();
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.state = (byte)(this.state & 0xFFFFFFFB);
                    this.last_active_timestamp = System.currentTimeMillis();
                    throw throwable;
                }
                this.state = (byte)(this.state & 0xFFFFFFFB);
                this.last_active_timestamp = System.currentTimeMillis();
                {
                }
            }
            return this.attributes;
        }

        public String getHashKey(boolean personalized) {
            String value;
            StringBuffer sb = new StringBuffer();
            if (personalized) {
                value = this.getUser();
                sb.append(value != null ? value : "");
                sb.append('|');
            }
            sb.append((value = this.getClient()) != null ? value : "");
            sb.append('|');
            value = this.getLanguage();
            sb.append(value != null ? value : "");
            sb.append('|');
            if (this.getASHost() != null) {
                sb.append("AS=[");
                value = this.getASHost();
                sb.append(value != null ? value : "");
                sb.append('|');
                value = this.getSystemNumber();
                sb.append(value != null ? value : "");
                sb.append('|');
                sb.append("]");
            } else if (this.getMSHost() != null) {
                sb.append("MS=[");
                value = this.getSystemID();
                sb.append(value != null ? value : "");
                sb.append('|');
                value = this.getMSHost();
                sb.append(value != null ? value : "");
                sb.append('|');
                value = this.getGroup();
                sb.append(value != null ? value : "");
                sb.append('|');
                sb.append("]");
            } else if (this.getURL() != null) {
                sb.append("URL=[");
                sb.append(this.getURL());
                sb.append("]");
            }
            if (this.getGWHost() != null) {
                sb.append("GW=[");
                value = this.getGWHost();
                sb.append(value != null ? value : "");
                sb.append('|');
                value = this.getGWServ();
                sb.append(value != null ? value : "");
                sb.append('|');
                value = this.getTPName();
                sb.append(value != null ? value : "");
                sb.append('|');
                sb.append("]");
            }
            if ((value = this.properties.getProperty("jco.client.use_sapgui")) != null) {
                sb.append('G');
                sb.append(value);
                sb.append('|');
            }
            if ((value = this.properties.getProperty("jco.client.abap_debug")) != null) {
                sb.append('D');
                sb.append(value);
                sb.append('|');
            }
            return sb.toString();
        }

        public boolean isAlive() {
            return this.middleware.isAlive(this);
        }

        public void connect() {
            if (this.isValid()) {
                return;
            }
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                }
                this.state = (byte)(this.state | 4);
            }
            try {
                this.checkProperties();
                this.middleware.initialize(this, this.properties);
                this.middleware.connect(this, this.conn_params);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.state = (byte)(this.state & 0xFFFFFFFB);
                throw throwable;
            }
            this.state = (byte)(this.state & 0xFFFFFFFB);
            this.state = (byte)(this.state & 0xFFFFFFF0 | 2);
            this.last_active_timestamp = System.currentTimeMillis();
        }

        public boolean isPooled() {
            return this.pool != null;
        }

        public void disconnect() {
            this.disconnect(false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void disconnect(boolean is_pooled) {
            block9: {
                block8: {
                    this.authorizationTraceID = null;
                    if (!is_pooled && this.pool != null && !this.getAbapDebug() && this.getSapGui() == 0) {
                        String string;
                        StringBuffer stringBuffer = new StringBuffer().append("A client allocated from pool ").append(this.pool.getName()).append(" cannot be disconnected directly.").append(CRLF).append("Please, use JCO.releaseClient(JCO.Client) instead.");
                        if (this.stack_trace == null) {
                            string = "";
                            throw new Exception(106, "JCO_ERROR_RESOURCE", stringBuffer.append(string).toString());
                        }
                        string = CRLF + "The client was allocated at: " + CRLF + this.stack_trace;
                        throw new Exception(106, "JCO_ERROR_RESOURCE", stringBuffer.append(string).toString());
                    }
                    Object object = this.semaphore;
                    synchronized (object) {
                        if ((this.state & 4) != 0) {
                            throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Connection cannot be disconnected. Connection currently used in another thread.");
                        }
                        this.state = (byte)(this.state | 4);
                    }
                    try {
                        this.state = (byte)(this.state & 0xF0 | 1 | 4);
                        if (!this.isValid()) {
                            Object var5_3 = null;
                            break block8;
                        }
                        this.middleware.disconnect(this);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        this.state = (byte)(this.state & 0xFFFFFFFB);
                        throw throwable;
                    }
                }
                this.state = (byte)(this.state & 0xFFFFFFFB);
                return;
            }
            Object var5_4 = null;
            this.state = (byte)(this.state & 0xFFFFFFFB);
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.isValid()) {
                    return;
                }
                if (this.pool != null) {
                    try {
                        this.pool.detachFromPool(this);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.finalize();
        }

        public void abort(String message) {
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Connection cannot be disconnected. Connection currently used in another thread.");
                }
            }
            if (!this.isValid()) {
                return;
            }
            try {
                this.middleware.abort(this, message);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.state = (byte)(this.state & 0xF0 | 1);
                throw throwable;
            }
            this.state = (byte)(this.state & 0xF0 | 1);
        }

        public void execute(Function function) {
            try {
                this.execute(function.getName(), function.getImportParameterList(), function.getTableParameterList(), function.getExportParameterList(), null, null, null, 0);
            }
            catch (AbapException ex) {
                AbapException ex2;
                if (ex.getKey().equals(ex.getMessage()) && (ex2 = function.getException(ex.getKey())) != null) {
                    ex = ex2;
                }
                throw ex;
            }
        }

        public void execute(Function function, String tid) {
            this.execute(function, tid, null, 0);
        }

        public void execute(Function function, String tid, String queue_name) {
            this.execute(function, tid, queue_name, 0);
        }

        public void execute(Function function, String tid, String queue_name, int queue_pos) {
            try {
                this.execute(function.getName(), function.getImportParameterList(), function.getTableParameterList(), null, null, tid, queue_name, queue_pos);
            }
            catch (AbapException ex) {
                AbapException ex2;
                if (ex.getKey().equals(ex.getMessage()) && (ex2 = function.getException(ex.getKey())) != null) {
                    ex = ex2;
                }
                throw ex;
            }
        }

        public void execute(String name, ParameterList input, ParameterList output) {
            this.execute(name, input, null, output, null, null, null, 0);
        }

        public void execute(String name, ParameterList input, ParameterList output, ParameterList tables) {
            this.execute(name, input, tables, output, null, null, null, 0);
        }

        public void execute(String name, ParameterList input, ParameterList tables, String tid) {
            this.execute(name, input, tables, null, null, tid, null, 0);
        }

        public void execute(String name, ParameterList input, ParameterList tables, String tid, String queue_name) {
            this.execute(name, input, tables, null, null, tid, queue_name, 0);
        }

        public void execute(String name, ParameterList input, ParameterList tables, String tid, String queue_name, int queue_pos) {
            this.execute(name, input, tables, null, null, tid, queue_name, queue_pos);
        }

        public Response execute(Request request) {
            return this.execute(request, null, null, 0, 0);
        }

        public void execute(Request request, String tid) {
            this.execute(request, tid, null, 0, 0);
        }

        public void execute(Request request, String tid, String queue_name) {
            this.execute(request, tid, queue_name, 0, 0);
        }

        public void execute(Request request, String tid, String queue_name, int queue_pos) {
            this.execute(request, tid, queue_name, queue_pos, 0);
        }

        protected Response execute(Request request, String tid, String queue_name, int queue_pos, int dummy) {
            Response response = null;
            ParameterList request_tables = null;
            ParameterList response_tables = null;
            int i = 0;
            while (i < request.num_fields) {
                if (request.type[i] == 99 && (request.flags[i] & 0x40) != 0) {
                    if (request_tables == null) {
                        request_tables = new ParameterList();
                    }
                    request_tables.appendValue(request.getName(i), request.getTable(i));
                }
                ++i;
            }
            if (request.dependant_meta_data != null && tid == null) {
                response = new Response(request.dependant_meta_data, null, request.exception_list);
                int i2 = 0;
                while (i2 < response.num_fields) {
                    if (response.type[i2] == 99 && (response.flags[i2] & 0x40) != 0) {
                        if (response_tables == null) {
                            response_tables = new ParameterList();
                        }
                        response_tables.appendValue(response.getName(i2), response.getTable(i2));
                    }
                    ++i2;
                }
            }
            try {
                this.execute(request.getName(), request, request_tables, response, response_tables, tid, queue_name, queue_pos);
                return response;
            }
            catch (AbapException ex) {
                AbapException ex2;
                if (ex.getKey().equals(ex.getMessage()) && (ex2 = request.getException(ex.getKey())) != null) {
                    ex = ex2;
                }
                throw ex;
            }
        }

        private void traceBeforeExecute(String name, ParameterList input, ParameterList input_tables, ParameterList output, ParameterList output_tables) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] JCO.Client.execute (").append(name).append(") on handle [").append(this.getConnectionHandle()).append("]");
            boolean trace_data = false;
            byte unicodeType = (byte)((input != null ? input.getUnicodeType() : (byte)0) | (output != null ? output.getUnicodeType() : (byte)0) | (input_tables != null ? input_tables.getUnicodeType() : (byte)0) | (output_tables != null ? output_tables.getUnicodeType() : (byte)0));
            if (unicodeType == 3) {
                buf.append(" WARNING: mixed unicode/non-unicode metadata");
                trace_data = true;
            } else if (unicodeType == 1 && this.attributes.partner_codepage.charAt(0) == '4') {
                buf.append(" WARNING: non-unicode metadata is used for communication with a unicode backend");
                trace_data = true;
            } else if (unicodeType == 2 && this.attributes.partner_codepage.charAt(0) != '4') {
                buf.append(" WARNING: unicode metadata is used for communication with a non-unicode backend");
                trace_data = true;
            }
            if (trace_data || trace_level > 5) {
                buf.append(CRLF);
                buf.append("Input: ");
                if (input != null) {
                    buf.append(CRLF).append(input.dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
                buf.append("Input tables: ");
                if (input_tables != null) {
                    buf.append(CRLF).append(input_tables.dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
            }
            JCO.fireTrace(trace_level, buf.toString());
        }

        private void traceAfterExecute(String name, ParameterList input_tables, ParameterList output, ParameterList output_tables) {
            StringBuffer buf = new StringBuffer("[JAV-LAYER] JCO.Client.execute (").append(name);
            buf.append(") on handle [").append(this.getConnectionHandle()).append("] returns after ");
            buf.append(System.currentTimeMillis() - this.start_time).append(" ms");
            if (trace_level > 5) {
                buf.append(CRLF);
                buf.append("Output: ");
                if (output != null) {
                    buf.append(CRLF).append(output.dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
                buf.append("Output tables: ");
                if (output_tables != null) {
                    buf.append(CRLF).append(output_tables.dumpContent());
                } else if (input_tables != null) {
                    buf.append(CRLF).append(input_tables.dumpContent());
                } else {
                    buf.append("null");
                }
                buf.append(CRLF);
            }
            JCO.fireTrace(1, buf.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute(String name, ParameterList input, ParameterList input_tables, ParameterList output, ParameterList output_tables, String tid, String queue_name, int queue_pos) {
            if (this.pool != null && (this.state & 0x10) == 0) {
                throw new Exception(102, "JCO_ERROR_COMMUNICATION", "Trying to use a JCO.Client from pool " + this.pool.getName() + " which has not been allocated properly");
            }
            if ((this.state & 2) == 0) {
                this.connect();
            }
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                }
                this.state = (byte)(this.state | 4);
            }
            try {
                block48: {
                    int i3;
                    Throwable throwable2;
                    block49: {
                        int i2;
                        this.start_time = System.currentTimeMillis();
                        if ((jco_mode & 7) != 0) {
                            this.rfm_name = name;
                            this.beginCall();
                        }
                        if (input != null) {
                            if (input.rec_name == null) {
                                input.rec_name = "INPUT";
                            }
                            input.checkIfInitialized();
                            i2 = 0;
                            while (i2 < input.num_fields) {
                                if ((input.flags[i2] & 0x10) != 0 || (input.flags[i2] & 8) != 0) {
                                    int n = i2;
                                    input.flags[n] = (byte)(input.flags[n] | 0x20);
                                }
                                ++i2;
                            }
                        }
                        if (input_tables != null) {
                            if (input_tables.rec_name == null) {
                                input_tables.rec_name = output_tables == null ? "TABLES" : "INPUT_TABLES";
                            }
                            i2 = 0;
                            while (i2 < input_tables.num_fields) {
                                if ((input_tables.flags[i2] & 0x10) != 0) {
                                    int n = i2;
                                    input_tables.flags[n] = (byte)(input_tables.flags[n] | 0x20);
                                }
                                ++i2;
                            }
                        }
                        if (output != null) {
                            if (output.rec_name == null) {
                                output.rec_name = "OUTPUT";
                            }
                            i2 = 0;
                            while (i2 < output.num_fields) {
                                if ((output.flags[i2] & 0x10) != 0) {
                                    int n = i2;
                                    output.flags[n] = (byte)(output.flags[n] | 0x20);
                                }
                                ++i2;
                            }
                        }
                        if (output_tables != null) {
                            if (output_tables.rec_name == null) {
                                output_tables.rec_name = "OUTPUT_TABLES";
                            }
                            i2 = 0;
                            while (i2 < output_tables.num_fields) {
                                if ((output_tables.flags[i2] & 0x10) != 0) {
                                    int n = i2;
                                    output_tables.flags[n] = (byte)(output_tables.flags[n] | 0x20);
                                }
                                ++i2;
                            }
                        }
                        if (trace_level > 0) {
                            this.traceBeforeExecute(name, input, input_tables, output, output_tables);
                        }
                        try {
                            int i3;
                            try {
                                this.middleware.execute(this, name, input, input_tables, output, output_tables, tid, queue_name, queue_pos);
                            }
                            catch (AbapException ex) {
                                if (trace_level <= 4) throw ex;
                                JCO.fireTrace(5, "[JAV-LAYER] JCO.Client.execute (" + name + ") threw an ABAP exception: " + ex.toString());
                                throw ex;
                            }
                            catch (Exception ex) {
                                if (trace_level > 0) {
                                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Client.execute (" + name + ") threw a NON-ABAP exception: " + ex.toString());
                                }
                                this.state = (byte)(this.state & 0xF0 | 1 | 4);
                                this.middleware.disconnect(this);
                                throw ex;
                            }
                            Object var13_12 = null;
                            if (trace_level > 0) {
                                this.traceAfterExecute(name, input_tables, output, output_tables);
                            }
                            if (input != null) {
                                i3 = 0;
                                while (i3 < input.num_fields) {
                                    int n = i3++;
                                    input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFDF);
                                }
                            }
                            if (input_tables != null) {
                                i3 = 0;
                                while (i3 < input_tables.num_fields) {
                                    int n = i3++;
                                    input_tables.flags[n] = (byte)(input_tables.flags[n] & 0xFFFFFFDF);
                                }
                            }
                            if (output != null) {
                                i3 = 0;
                                while (i3 < output.num_fields) {
                                    int n = i3++;
                                    output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFDF);
                                }
                            }
                            if (output_tables != null) {
                                i3 = 0;
                                while (i3 < output_tables.num_fields) {
                                    int n = i3++;
                                    output_tables.flags[n] = (byte)(output_tables.flags[n] & 0xFFFFFFDF);
                                }
                            }
                            break block48;
                        }
                        catch (Throwable throwable2) {
                            Object var13_13 = null;
                            if (trace_level > 0) {
                                this.traceAfterExecute(name, input_tables, output, output_tables);
                            }
                            if (input == null) break block49;
                            i3 = 0;
                        }
                        while (i3 < input.num_fields) {
                            int n = i3++;
                            input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFDF);
                        }
                    }
                    if (input_tables != null) {
                        i3 = 0;
                        while (i3 < input_tables.num_fields) {
                            int n = i3++;
                            input_tables.flags[n] = (byte)(input_tables.flags[n] & 0xFFFFFFDF);
                        }
                    }
                    if (output != null) {
                        i3 = 0;
                        while (i3 < output.num_fields) {
                            int n = i3++;
                            output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFDF);
                        }
                    }
                    if (output_tables == null) throw throwable2;
                    i3 = 0;
                    while (true) {
                        if (i3 >= output_tables.num_fields) {
                            throw throwable2;
                        }
                        int n = i3++;
                        output_tables.flags[n] = (byte)(output_tables.flags[n] & 0xFFFFFFDF);
                    }
                }
                Object var16_18 = null;
                this.state = (byte)(this.state & 0xFFFFFFFB);
                this.last_active_timestamp = System.currentTimeMillis();
                if ((jco_mode & 7) == 0) return;
                this.endCall();
                return;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                this.state = (byte)(this.state & 0xFFFFFFFB);
                this.last_active_timestamp = System.currentTimeMillis();
                if ((jco_mode & 7) == 0) throw throwable;
                this.endCall();
                throw throwable;
            }
        }

        public void send(Object idoc, String tid) {
            this.send(idoc, tid, null, 0, '0');
        }

        public void send(Object idoc, String tid, String queue_name) {
            this.send(idoc, tid, queue_name, 0, '0');
        }

        public void send(Object idoc, String tid, String queue_name, int queue_pos) {
            this.send(idoc, tid, queue_name, queue_pos, '0');
        }

        public void send(Object idoc, String tid, char idoc_version) {
            this.send(idoc, tid, null, 0, idoc_version);
        }

        public void send(Object idoc, String tid, String queue_name, char idoc_version) {
            this.send(idoc, tid, queue_name, 0, idoc_version);
        }

        public void send(Object idoc, String tid, String queue_name, int queue_pos, char idoc_version) {
            if (!(idoc instanceof IDocument)) {
                throw new Exception(131, "JCO_ILLEGAL_ARGUMENT", "Illegal argument encountered: Expecting IDoc parameter to be an instance of class com.sap.mw.jco.JCO.IDocument.");
            }
            ((IDocument)idoc).send(this, tid, queue_name, queue_pos, idoc_version, 0);
        }

        public String createTID() {
            String tid = null;
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                }
                this.state = (byte)(this.state | 4);
            }
            this.last_active_timestamp = System.currentTimeMillis();
            try {
                tid = this.middleware.createTID(this);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.state = (byte)(this.state & 0xFFFFFFFB);
                this.last_active_timestamp = System.currentTimeMillis();
                throw throwable;
            }
            this.state = (byte)(this.state & 0xFFFFFFFB);
            this.last_active_timestamp = System.currentTimeMillis();
            return tid;
        }

        public void confirmTID(String tid) {
            Object object = this.semaphore;
            synchronized (object) {
                if ((this.state & 4) != 0) {
                    throw new Exception(132, "JCO_ERROR_CONCURRENT_CALL", "Concurrent call. Connection currently used in another thread.");
                }
                this.state = (byte)(this.state | 4);
            }
            this.last_active_timestamp = System.currentTimeMillis();
            try {
                this.middleware.confirmTID(this, tid);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.state = (byte)(this.state & 0xFFFFFFFB);
                this.last_active_timestamp = System.currentTimeMillis();
                throw throwable;
            }
            this.state = (byte)(this.state & 0xFFFFFFFB);
            this.last_active_timestamp = System.currentTimeMillis();
        }

        public final void ping() {
            this.execute("RFC_PING", (ParameterList)null, (ParameterList)null, (ParameterList)null);
        }

        public void setDsrPassport(DsrIPassport passport) {
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] setDsrPassport for connection with handle " + this.getConnectionHandle() + "  [enter]");
            }
            if (passport == null || !passport.isValid()) {
                Exception e = new Exception(152, "JCO_ERROR_DSR_PASSPORT_NOT_VALID", passport == null ? "Dsr passport equals null." : "Dsr passport is not valid.");
                if (trace_level > 2) {
                    JCO.fireTrace(3, "[JAV-LAYER] " + e.toString());
                }
                throw e;
            }
            this.passport_bytes = passport.getNetPassport();
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] setDsrPassport for connection with handle " + this.getConnectionHandle() + "  [leave]");
            }
        }

        protected void beginCall() {
            try {
                if ((jco_mode & 7) != 0) {
                    this.jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.mw.jco.JCO.Client");
                    if (this.jarm_monitor != null) {
                        this.jarm_monitor.startComponent("com.sap.mw.jco.JCO.Client");
                    }
                    if (this.dsr_monitor == null && this.passport_bytes != null) {
                        this.dsr_monitor = Dsr.createMonitor();
                    }
                    if (this.dsr_monitor != null && this.passport_bytes != null) {
                        this.dsr_monitor.openDsrRecord(this.getConnectionHandle(), 0, this.passport_bytes, this.start_time);
                    }
                }
            }
            catch (RuntimeException ex) {
                if (trace_level > 0) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    sw.flush();
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Client.beginCall() throws exception " + CRLF + sw.getBuffer());
                }
                throw ex;
            }
        }

        protected void endCall() {
            try {
                if ((jco_mode & 7) != 0) {
                    if (this.jarm_monitor != null) {
                        Attributes attributes = this.getAttributes();
                        this.jarm_monitor.setUser(attributes != null ? attributes.getUser() : (String)null);
                        this.jarm_monitor.endComponent();
                        this.jarm_monitor.endRequest();
                    }
                    if (this.dsr_monitor != null && this.passport_bytes != null) {
                        this.dsr_monitor.closeDsrRecord(this.getConnectionHandle(), 0, this.rfm_name, this.time_total, this.time_middleware, -1L, this.num_sent_bytes, this.num_received_bytes);
                    }
                }
            }
            catch (RuntimeException ex) {
                if (trace_level > 0) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    sw.flush();
                    JCO.fireTrace(1, "[JAV-LAYER] JCO.Client.endCall() throws exception " + CRLF + sw.getBuffer());
                }
                throw ex;
            }
        }

        public void startAuthorizationTracing(String traceID, String serviceType) {
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] startAuthorizationTracing (" + traceID + ", " + serviceType + ") for client with handle " + this.getConnectionHandle() + "  [enter]");
            }
            if (!this.isValid()) {
                throw new Exception(102, "JCO_ERROR_COMMUNICATION", "JCO.Client not connected, which is required for enabling authorization tracing");
            }
            try {
                if (this.attributes == null) {
                    this.getAttributes();
                }
                if (this.attributes.getPartnerReleaseNumber() >= 620) {
                    boolean isUnicode = this.attributes.getPartnerCodepage().startsWith("4");
                    ParameterList imports = new ParameterList(isUnicode ? auth_trace_set_unicode : auth_trace_set);
                    imports.setValue(serviceType, 0);
                    imports.setValue(traceID, 1);
                    Function function = new Function("AUTH_TRACE_SET_SERVICE", imports, null, null);
                    this.execute(function);
                    this.authorizationTraceID = traceID;
                }
            }
            catch (AbapException jae) {
                JCO.fireTrace(1, "[JAV-LAYER] startAuthorizationTracing (" + traceID + ", " + serviceType + ") for client with handle " + this.getConnectionHandle() + "  failed in backend: " + jae.getMessage());
            }
            catch (Exception ex) {
                JCO.fireTrace(1, "[JAV-LAYER] startAuthorizationTracing (" + traceID + ", " + serviceType + ") for client with handle " + this.getConnectionHandle() + "  failed: " + ex.getMessage());
            }
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] startAuthorizationTracing for client with handle " + this.getConnectionHandle() + "  [leave]");
            }
        }

        public boolean isAuthorizationTracingEnabled() {
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] isAuthorizationTracingEnabled for client with handle " + this.getConnectionHandle() + "  [enter]");
            }
            if (!this.isValid()) {
                throw new Exception(102, "JCO_ERROR_COMMUNICATION", "JCO.Client not connected, which is required for setting authorization tracing");
            }
            boolean ret = false;
            try {
                if (this.attributes == null) {
                    this.getAttributes();
                }
                if (this.attributes.getPartnerReleaseNumber() >= 620) {
                    boolean isUnicode = this.attributes.getPartnerCodepage().startsWith("4");
                    ParameterList exports = new ParameterList(isUnicode ? auth_trace_status_unicode : auth_trace_status);
                    Function function = new Function("AUTH_TRACE_GET_STATUS", null, exports, null);
                    this.execute(function);
                    Structure rc = exports.getStructure(0);
                    ret = "X".equals(rc.getString(0));
                }
            }
            catch (Exception ex) {
                JCO.fireTrace(1, "[JAV-LAYER] isAuthorizationTracingEnabled for client with handle " + this.getConnectionHandle() + "  failed: " + ex.getMessage());
            }
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] isAuthorizationTracingEnabled for client with handle " + this.getConnectionHandle() + "  [leave]");
            }
            return ret;
        }

        public String getAuthorizationTraceID() {
            return this.authorizationTraceID;
        }

        public void endAuthorizationTracing() {
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] endAuthorizationTracing for client with handle " + this.getConnectionHandle() + "  [enter]");
            }
            if (this.authorizationTraceID != null) {
                this.authorizationTraceID = null;
                if (this.isValid()) {
                    try {
                        if (this.attributes == null) {
                            this.getAttributes();
                        }
                        if (this.attributes.getPartnerReleaseNumber() >= 620) {
                            Function function = new Function("AUTH_TRACE_RESET", null, null, null);
                            this.execute(function);
                        }
                    }
                    catch (Exception ex) {
                        JCO.fireTrace(1, "[JAV-LAYER] WARNING: endAuthorizationTracing for client with handle " + this.getConnectionHandle() + "  failed: " + ex.getMessage());
                    }
                }
            } else if (trace_level > 0) {
                JCO.fireTrace(1, "[JAV-LAYER] WARNING: endAuthorizationTracing for client with handle " + this.getConnectionHandle() + "  cannot be execute because the trace is not turned on.");
            }
            if (trace_level > 4) {
                JCO.fireTrace(5, "[JAV-LAYER] endAuthorizationTracing for client with handle " + this.getConnectionHandle() + "  [leave]");
            }
        }

        static {
            auth_trace_set.addInfo("SERVICE_TYPE", 0, 16, 0);
            auth_trace_set.addInfo("SERVICE", 29, 0, 16);
            auth_trace_set_unicode.addInfo("SERVICE_TYPE", 0, -32, 0);
            auth_trace_set_unicode.addInfo("SERVICE", 29, 0, 32);
            auth_trace_status_rc.addInfo("BOOLE", 0, 1, 0);
            auth_trace_status.addInfo("RC", 17, 0, 0, 0, 0, auth_trace_status_rc);
            auth_trace_status_rc_unicode.addInfo("BOOLE", 0, -2, 0);
            auth_trace_status_unicode.addInfo("RC", 17, 0, 0, 0, 0, auth_trace_status_rc_unicode);
        }
    }

    public static abstract class Connection
    implements Cloneable {
        protected String conn_params;
        protected Object conn_object = null;
        protected Properties properties = new Properties();
        protected Attributes attributes;
        protected Jarm.Monitor jarm_monitor;
        protected Dsr dsr_monitor;
        protected byte[] passport_bytes = null;
        protected long rfc_handle = 0L;
        protected long codepage_converter = 0L;
        protected int connection_cpc_mode = 0;
        protected byte state = 1;
        protected long last_active_timestamp = System.currentTimeMillis();
        protected Throughput throughput;
        protected long start_time;
        protected long time_handle_request;
        protected long time_total;
        protected long num_sent_bytes;
        protected long num_received_bytes;
        protected long time_middleware;
        protected String rfm_name;
        protected Pool pool;

        protected Connection() {
        }

        public long getConnectionHandle() {
            return this.rfc_handle;
        }

        public synchronized Object clone() {
            try {
                Connection conn = (Connection)super.clone();
                conn.properties = (Properties)((Hashtable)this.properties).clone();
                conn.rfc_handle = 0L;
                if (this.dsr_monitor != null) {
                    conn.dsr_monitor = new Dsr();
                }
                conn.last_active_timestamp = System.currentTimeMillis();
                return conn;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        protected synchronized Connection hideConnection() {
            try {
                Connection conn = (Connection)super.clone();
                conn.last_active_timestamp = System.currentTimeMillis();
                conn.rfc_handle = this.rfc_handle;
                conn.state = this.state;
                this.rfc_handle = 0L;
                this.state = (byte)(this.state | 1);
                return conn;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.isValid()) {
                    return;
                }
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.finalize();
        }

        public final Properties getProperties() {
            return this.properties;
        }

        public String[][] getPropertyInfo() {
            return null;
        }

        public final String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        protected void setProperty(String key, String value) {
            if (key != null) {
                if (value != null) {
                    ((Hashtable)this.properties).put(key, value);
                } else {
                    ((Hashtable)this.properties).remove(key);
                }
            }
        }

        public boolean isValid() {
            return this.rfc_handle != 0L;
        }

        protected byte getState() {
            return this.state;
        }

        protected void setState(byte state) {
            this.state = state;
        }

        public boolean getTrace() {
            return false;
        }

        public void setTrace(boolean trace) {
        }

        public final Throughput getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Throughput throughput) {
            this.throughput = throughput;
        }

        public abstract Attributes getAttributes();

        public abstract void disconnect();

        public abstract void abort(String var1);

        public abstract boolean isAlive();

        protected abstract void beginCall();

        protected abstract void endCall();

        protected void checkProperties() {
            try {
                this.connection_cpc_mode = Integer.parseInt(this.properties.getProperty("jco.cpc.ignore_icons", "0"));
            }
            catch (NumberFormatException ex) {
                this.connection_cpc_mode = 0;
            }
            if (this.properties.getProperty("jco.client.idle_timeout", null) != null) {
                try {
                    int idle_timeout = Integer.parseInt(this.properties.getProperty("jco.client.idle_timeout"));
                    if (idle_timeout <= 0) {
                        throw new NumberFormatException("only positive values are allowed");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new Exception(122, "JCO_ERROR_CONVERSION", "Invalid idle timeout [" + this.properties.getProperty("jco.client.idle_timeout") + "]: " + ex.getMessage());
                }
            }
        }
    }

    public static class Throughput
    implements Cloneable {
        protected long num_calls;
        protected long time_marshall;
        protected long time_unmarshall;
        protected long time_middleware;
        protected long time_handle_request;
        protected long time_total;
        protected long num_sent_bytes;
        protected long num_received_bytes;
        protected int num_import_bytes;
        protected int num_export_bytes;
        protected int num_import_meta_bytes;
        protected int num_export_meta_bytes;

        public synchronized Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public final void reset() {
            this.num_calls = 0L;
            this.time_marshall = 0L;
            this.time_unmarshall = 0L;
            this.time_middleware = 0L;
            this.time_handle_request = 0L;
            this.time_total = 0L;
            this.num_sent_bytes = 0L;
            this.num_received_bytes = 0L;
        }

        public final long getNumCalls() {
            return this.num_calls;
        }

        public final long getMarshallTime() {
            return this.time_marshall;
        }

        public final long getUnmarshallTime() {
            return this.time_unmarshall;
        }

        public final long getMiddlewareTime() {
            return this.time_middleware;
        }

        public final long getHandleRequestTime() {
            return this.time_handle_request;
        }

        public final long getTotalTime() {
            return this.time_total;
        }

        public final long getNumSentBytes() {
            return this.num_sent_bytes;
        }

        public final long getNumReceivedBytes() {
            return this.num_received_bytes;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("No. of calls:                   ");
            sb.append(this.num_calls);
            sb.append(CRLF);
            sb.append("No. of bytes sent:              ");
            sb.append(this.num_sent_bytes);
            sb.append(CRLF);
            sb.append("No. of bytes received:          ");
            sb.append(this.num_received_bytes);
            sb.append(CRLF);
            sb.append("Time for marshalling (ms):      ");
            sb.append(this.time_marshall);
            sb.append(CRLF);
            sb.append("Time for unmarshalling (ms):    ");
            sb.append(this.time_unmarshall);
            sb.append(CRLF);
            sb.append("Time for middleware calls (ms): ");
            sb.append(this.time_middleware);
            sb.append(CRLF);
            sb.append("Time for handling request (ms): ");
            sb.append(this.time_handle_request);
            sb.append(CRLF);
            sb.append("Total elapsed time (ms):        ");
            sb.append(this.time_total);
            sb.append(CRLF);
            return sb.toString();
        }
    }

    public static class Attributes {
        protected String dest;
        protected String own_host;
        protected String partner_host;
        protected String systnr;
        protected String sysid;
        protected String client;
        protected String user;
        protected String language;
        protected String ISO_language;
        protected String own_codepage;
        protected String partner_codepage;
        protected String own_charset;
        protected String partner_charset;
        protected String own_encoding;
        protected String partner_encoding;
        protected byte own_bytes_per_char;
        protected byte partner_bytes_per_char;
        protected String own_rel;
        protected String partner_rel;
        protected String kernel_rel;
        protected char partner_type;
        protected char trace;
        protected char rfc_role;
        protected char own_type;
        protected String CPIC_convid;
        protected String sso_ticket;
        protected int partner_rel_number = -1;

        protected Attributes() {
        }

        public final String getDestination() {
            return this.dest;
        }

        public final String getHost() {
            return this.own_host;
        }

        public final String getPartnerHost() {
            return this.partner_host;
        }

        public final String getSystemID() {
            return this.sysid;
        }

        public final String getSystemNumber() {
            return this.systnr;
        }

        public final String getClient() {
            return this.client;
        }

        public final String getUser() {
            return this.user;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final String getISOLanguage() {
            return this.ISO_language;
        }

        public final String getOwnCodepage() {
            return this.own_codepage;
        }

        public final String getOwnCharset() {
            return this.own_charset;
        }

        public final String getOwnEncoding() {
            return this.own_encoding;
        }

        public final int getOwnBytesPerChar() {
            return this.own_bytes_per_char;
        }

        public final String getPartnerCodepage() {
            return this.partner_codepage;
        }

        public final String getPartnerCharset() {
            return this.partner_charset;
        }

        public final String getPartnerEncoding() {
            return this.partner_encoding;
        }

        public final int getPartnerBytesPerChar() {
            return this.partner_bytes_per_char;
        }

        public final String getRelease() {
            return this.own_rel;
        }

        public final String getPartnerRelease() {
            return this.partner_rel;
        }

        public final String getKernelRelease() {
            return this.kernel_rel;
        }

        public final char getPartnerType() {
            return this.partner_type;
        }

        public final boolean getTrace() {
            return this.trace == 'X' || this.trace == 'x';
        }

        public final char getRfcRole() {
            return this.rfc_role;
        }

        public final char getType() {
            return this.own_type;
        }

        public final String getCPICConversationID() {
            return this.CPIC_convid;
        }

        public final String getSSOTicket() {
            return this.sso_ticket;
        }

        protected final int getPartnerReleaseNumber() {
            if (this.partner_rel_number >= 0) {
                return this.partner_rel_number;
            }
            String string = this.CPIC_convid;
            synchronized (string) {
                if (this.partner_type == '2') {
                    this.partner_rel_number = 200;
                } else if (this.partner_rel != null && this.partner_rel.length() > 0) {
                    this.partner_rel_number = (this.partner_rel.charAt(0) - 48) * 100;
                    this.partner_rel_number += (this.partner_rel.charAt(1) - 48) * 10;
                    this.partner_rel_number = Character.isDigit(this.partner_rel.charAt(2)) ? (this.partner_rel_number += this.partner_rel.charAt(2) - 48) : (this.partner_rel_number += this.partner_rel.charAt(2) - 65);
                } else {
                    int n = 0;
                    return n;
                }
            }
            return this.partner_rel_number;
        }

        public final String toString() {
            StringBuffer s = new StringBuffer();
            s.append("DEST:                  ");
            s.append(this.dest);
            s.append(CRLF);
            s.append("OWN_HOST:              ");
            s.append(this.own_host);
            s.append(CRLF);
            s.append("PARTNER_HOST:          ");
            s.append(this.partner_host);
            s.append(CRLF);
            s.append("SYSTNR:                ");
            s.append(this.systnr);
            s.append(CRLF);
            s.append("SYSID:                 ");
            s.append(this.sysid);
            s.append(CRLF);
            s.append("CLIENT:                ");
            s.append(this.client);
            s.append(CRLF);
            s.append("USER:                  ");
            s.append(this.user);
            s.append(CRLF);
            s.append("LANGUAGE:              ");
            s.append(this.language);
            s.append(CRLF);
            s.append("ISO_LANGUAGE:          ");
            s.append(this.ISO_language);
            s.append(CRLF);
            s.append("OWN_CODEPAGE:          ");
            s.append(this.own_codepage);
            s.append(CRLF);
            s.append("OWN_CHARSET:           ");
            s.append(this.own_charset);
            s.append(CRLF);
            s.append("OWN_ENCODING:          ");
            s.append(this.own_encoding);
            s.append(CRLF);
            s.append("OWN_BYTES_PER_CHAR:    ");
            s.append(this.own_bytes_per_char);
            s.append(CRLF);
            s.append("PARTNER_CODEPAGE:      ");
            s.append(this.partner_codepage);
            s.append(CRLF);
            s.append("PARTNER_CHARSET:       ");
            s.append(this.partner_charset);
            s.append(CRLF);
            s.append("PARTNER_ENCODING:      ");
            s.append(this.partner_encoding);
            s.append(CRLF);
            s.append("PARNER_BYTES_PER_CHAR: ");
            s.append(this.partner_bytes_per_char);
            s.append(CRLF);
            s.append("OWN_REL:               ");
            s.append(this.own_rel);
            s.append(CRLF);
            s.append("PARTNER_REL:           ");
            s.append(this.partner_rel);
            s.append(CRLF);
            s.append("PARTNER_TYPE:          ");
            s.append(this.partner_type);
            s.append(CRLF);
            s.append("KERNEL_REL:            ");
            s.append(this.kernel_rel);
            s.append(CRLF);
            s.append("TRACE:                 ");
            s.append(this.trace);
            s.append(CRLF);
            s.append("RFC_ROLE:              ");
            s.append(this.rfc_role);
            s.append(CRLF);
            s.append("OWN_TYPE:              ");
            s.append(this.own_type);
            s.append(CRLF);
            s.append("CPIC_CONVID:           ");
            s.append(this.CPIC_convid);
            s.append(CRLF);
            if (this.sso_ticket != null) {
                s.append("SSOTICKET:             ");
                s.append(this.sso_ticket.substring(0, 10) + "...");
                s.append(CRLF);
            }
            return s.toString();
        }
    }

    public static class J2EEAbapException
    extends java.lang.Exception {
        private AbapException m_abapException = null;

        public J2EEAbapException(AbapException ex) {
            super(ex.getMessage());
            this.m_abapException = ex;
        }

        public J2EEAbapException(String key) {
            super(key);
            this.m_abapException = new AbapException(key);
        }

        public J2EEAbapException(String key, String message) {
            super(message == null ? key : message);
            this.m_abapException = new AbapException(key, message);
        }

        public final AbapException getAbapException() {
            return this.m_abapException;
        }

        public final int getGroup() {
            return this.m_abapException.getGroup();
        }

        public final String getKey() {
            return this.m_abapException.getKey();
        }

        public String toString() {
            return this.getClass().getName() + ": " + "(" + this.m_abapException.getGroup() + ") " + this.m_abapException.getKey() + ": " + this.getMessage();
        }
    }

    public static class AbapException
    extends Exception {
        public AbapException(String key) {
            super(126, key, key);
        }

        public AbapException(String key, String message) {
            super(126, key, message == null ? key : message);
        }
    }

    public static class ConversionException
    extends Exception {
        public ConversionException(String message) {
            super(122, "JCO_ERROR_CONVERSION", message);
        }
    }

    public static class Exception
    extends RuntimeException {
        public static final int JCO_ERROR_PROGRAM = 101;
        public static final int JCO_ERROR_COMMUNICATION = 102;
        public static final int JCO_ERROR_LOGON_FAILURE = 103;
        public static final int JCO_ERROR_SYSTEM_FAILURE = 104;
        public static final int JCO_ERROR_APPLICATION_EXCEPTION = 105;
        public static final int JCO_ERROR_RESOURCE = 106;
        public static final int JCO_ERROR_PROTOCOL = 107;
        public static final int JCO_ERROR_INTERNAL = 108;
        public static final int JCO_ERROR_CANCELLED = 109;
        public static final int JCO_ERROR_STATE_BUSY = 110;
        public static final int JCO_ERROR_EXTENSION = 120;
        public static final int JCO_ERROR_NULL_HANDLE = 121;
        public static final int JCO_ERROR_CONVERSION = 122;
        public static final int JCO_ERROR_FUNCTION_NOT_FOUND = 123;
        public static final int JCO_ERROR_ILLEGAL_TID = 124;
        public static final int JCO_ERROR_UNSUPPORTED_CODEPAGE = 125;
        public static final int JCO_ERROR_ABAP_EXCEPTION = 126;
        public static final int JCO_ERROR_FIELD_NOT_FOUND = 127;
        public static final int JCO_ERROR_NOT_SUPPORTED = 128;
        public static final int JCO_ERROR_SERVER_STARTUP = 129;
        public static final int JCO_ERROR_XML_PARSER = 130;
        public static final int JCO_ERROR_ILLEGAL_ARGUMENT = 131;
        public static final int JCO_ERROR_CONCURRENT_CALL = 132;
        public static final int JCO_ERROR_INVALID_HANDLE = 133;
        public static final int JCO_ERROR_INITIALIZATION = 134;
        public static final int JCO_ERROR_DSR_LOAD_ERROR = 150;
        public static final int JCO_ERROR_DSR_PASSPORT_NOT_RECEIVED = 151;
        public static final int JCO_ERROR_DSR_PASSPORT_NOT_VALID = 152;
        public static final int JCO_ERROR_JARM_LOAD_ERROR = 155;
        private int group;
        private String key;

        public Exception(int group, String key, String message) {
            super(message);
            this.key = key;
            this.group = group;
        }

        public final int getGroup() {
            return this.group;
        }

        public final String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getClass().getName() + ": " + "(" + this.group + ") " + this.key + ": " + this.getMessage();
        }
    }

    public static interface ServerStateChangedListener {
        public void serverStateChangeOccurred(Server var1, int var2, int var3);
    }

    public static interface ServerErrorListener {
        public void serverErrorOccurred(Server var1, Error var2);
    }

    public static interface ServerExceptionListener {
        public void serverExceptionOccurred(Server var1, java.lang.Exception var2);
    }

    public static interface TraceListener {
        public void trace(int var1, String var2);
    }

    protected static final class BASE64
    extends Codecs.Base64 {
        protected BASE64() {
        }
    }

    protected static final class HEX
    extends Codecs.Hex {
        protected HEX() {
        }
    }
}

