/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Version;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Messages.java\t1.9 07/05/05")
public class Messages {
    protected static final Context.Key<Messages> messagesKey = new Context.Key();
    private List<ResourceBundle> bundles = List.nil();
    private static final String defaultBundleName = "com.sun.tools.javac.resources.compiler";
    private static ResourceBundle defaultBundle;
    private static Messages defaultMessages;

    public static Messages instance(Context context) {
        Messages instance = context.get(messagesKey);
        if (instance == null) {
            instance = new Messages(context);
        }
        return instance;
    }

    public Messages(Context context) {
        context.put(messagesKey, this);
        this.add(Messages.getDefaultBundle());
    }

    public Messages(String bundleName) throws MissingResourceException {
        this.add(bundleName);
    }

    public Messages(ResourceBundle bundle) throws MissingResourceException {
        this.add(bundle);
    }

    public void add(String bundleName) throws MissingResourceException {
        this.add(ResourceBundle.getBundle(bundleName));
    }

    public void add(ResourceBundle bundle) {
        this.bundles = this.bundles.prepend(bundle);
    }

    public String getLocalizedString(String key, Object ... args) {
        return Messages.getLocalizedString(this.bundles, key, args);
    }

    static String getDefaultLocalizedString(String key, Object ... args) {
        return Messages.getLocalizedString(List.of(Messages.getDefaultBundle()), key, args);
    }

    static Messages getDefaultMessages() {
        if (defaultMessages == null) {
            defaultMessages = new Messages(Messages.getDefaultBundle());
        }
        return defaultMessages;
    }

    public static ResourceBundle getDefaultBundle() {
        try {
            if (defaultBundle == null) {
                defaultBundle = ResourceBundle.getBundle(defaultBundleName);
            }
            return defaultBundle;
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for compiler is missing", e);
        }
    }

    private static String getLocalizedString(List<ResourceBundle> bundles, String key, Object ... args) {
        String msg = null;
        List<ResourceBundle> l = bundles;
        while (l.nonEmpty() && msg == null) {
            ResourceBundle rb = (ResourceBundle)l.head;
            try {
                msg = rb.getString(key);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            l = l.tail;
        }
        if (msg == null) {
            msg = "compiler message file broken: key=" + key + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
        }
        return MessageFormat.format(msg, args);
    }
}

