/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UtilClassCollector {
    private static final Logger LOG = LoggerFactory.getLogger(UtilClassCollector.class);

    private UtilClassCollector() {
    }

    static Set<Class> visitClassCollector(Set<Class> result, Class clazz) {
        Set<Class> returnedResult = result;
        if (UtilClassCollector.skipClassColletor(result, clazz)) {
            LOG.debug("DON'T Collect[" + clazz + "]");
        } else {
            List<Class> types = null;
            if (clazz.isArray()) {
                LOG.debug("Found an array:" + clazz);
                returnedResult = UtilClassCollector.visitClassCollector(result, clazz.getComponentType());
            } else {
                result.add(clazz);
                LOG.debug("Collect[" + clazz + "]");
                types = UtilClassCollector.extractTypes(clazz);
                for (Class currentType : types) {
                    returnedResult = UtilClassCollector.visitClassCollector(result, currentType);
                }
            }
        }
        return returnedResult;
    }

    protected static boolean skipClassColletor(Set<Class> result, Class clazz) {
        if (clazz == null || UtilClassCollector.contains(result, clazz)) {
            return true;
        }
        String name = clazz.getCanonicalName();
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.omg.") || clazz.isPrimitive();
    }

    protected static boolean contains(Set<Class> result, Class clazz) {
        if (result == null) {
            return false;
        }
        String className = null;
        if (clazz != null) {
            className = clazz.getCanonicalName();
        }
        for (Class item : result) {
            String itemClassName = item.getCanonicalName();
            if (!itemClassName.equals(className)) continue;
            return true;
        }
        return false;
    }

    public static List<Class> extractTypes(Class clazz) {
        List<Class> types = new ArrayList<Class>();
        types = UtilClassCollector.extractTypesFromMethods(clazz, types);
        types = UtilClassCollector.extractTypesFromFields(clazz, types);
        return types;
    }

    private static List<Class> extractTypesFromFields(Class clazz, List<Class> types) {
        Field[] fields = clazz.getFields();
        if (fields == null) {
            return types;
        }
        for (Field currField : fields) {
            Class<?> ft = currField.getType();
            if (types.contains(ft)) continue;
            types.add(ft);
        }
        return types;
    }

    private static List<Class> extractTypesFromMethods(Class clazz, List<Class> types) {
        Method[] methods = clazz.getMethods();
        if (methods == null) {
            return types;
        }
        List<Class> returnedTypes = types;
        for (Method currentMethod : methods) {
            Class[] paramTypes = currentMethod.getParameterTypes();
            returnedTypes = UtilClassCollector.extractFromArray(paramTypes, types);
            Class[] exTypes = currentMethod.getExceptionTypes();
            returnedTypes = UtilClassCollector.extractFromArray(exTypes, types);
            Class<?> ret = currentMethod.getReturnType();
            if (ret == null || types.contains(ret)) continue;
            returnedTypes.add(ret);
        }
        return returnedTypes;
    }

    private static List<Class> extractFromArray(Class[] array, List<Class> types) {
        if (array == null) {
            return types;
        }
        for (Class currentType : array) {
            if (types.contains(currentType)) continue;
            types.add(currentType);
        }
        return types;
    }
}

