/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component.runtime;

import it.imolinfo.jbi4ejb.jbi.component.runtime.ComponentRuntime;
import it.imolinfo.jbi4ejb.jbi.component.runtime.MessageExchangeReceiver;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public abstract class AbstractComponentLifeCycle
implements ComponentLifeCycle {
    private ComponentRuntime mCompRuntime;
    private ObjectName mExtensionMBeanName;
    private StandardMBean mExtensionMBeanImpl;
    private MessageExchangeReceiver mMsgExchReceiver;

    private AbstractComponentLifeCycle() {
    }

    protected AbstractComponentLifeCycle(ComponentRuntime compRuntime) {
        this.mCompRuntime = compRuntime;
    }

    public final void init(ComponentContext context) throws JBIException {
        if (context == null) {
            throw new JBIException("Null Component Context received in Component Lifecycle init ");
        }
        this.initContext(context);
        this.initMessageExchangeHandlerFactory();
        this.initMessageExchangeReceiver();
        this.registerExtensionMBean();
        this.onInit();
        RuntimeHelper.logInfo("Component " + RuntimeHelper.getComponentName() + " initialized");
    }

    public final void start() throws JBIException {
        this.openDeliveryChannel();
        this.activateServiceProviders();
        this.activateServiceConsumers();
        this.startMessageExchangeProcessing();
        this.onStart();
        RuntimeHelper.logInfo("Component " + RuntimeHelper.getComponentName() + " started");
    }

    public final void stop() throws JBIException {
        this.stopMessageExchangeProcessing();
        this.deactivateServiceConsumers();
        this.deactivateServiceProviders();
        this.closeDeliveryChannel();
        this.onStop();
        RuntimeHelper.logInfo("Component " + RuntimeHelper.getComponentName() + " stopped");
    }

    public final void shutDown() throws JBIException {
        this.shutdownMessageExchangeReceiver();
        this.unregisterExtensionMBean();
        this.onShutDown();
        RuntimeHelper.logInfo("Component " + RuntimeHelper.getComponentName() + " shut down");
    }

    public final ObjectName getExtensionMBeanName() {
        return this.mExtensionMBeanName;
    }

    private void registerExtensionMBean() throws JBIException {
        this.mExtensionMBeanName = this.createExtensionMBeanName();
        if (this.mExtensionMBeanName == null) {
            RuntimeHelper.logDebug("No Extension MBean is registerd with MBeanServer for " + RuntimeHelper.getComponentName());
            return;
        }
        this.mExtensionMBeanImpl = this.createExtensionMBean();
        if (this.mExtensionMBeanImpl == null) {
            this.mExtensionMBeanName = null;
            RuntimeHelper.logDebug("No Extension MBean is registerd with MBeanServer for " + RuntimeHelper.getComponentName());
            return;
        }
        try {
            MBeanServer mbServer = RuntimeHelper.getComponentContext().getMBeanServer();
            mbServer.registerMBean(this.mExtensionMBeanImpl, this.mExtensionMBeanName);
        }
        catch (Exception e) {
            this.mExtensionMBeanName = null;
            this.mExtensionMBeanImpl = null;
            throw new JBIException("Can not register Extension MBean with MBeanServer for " + RuntimeHelper.getComponentName(), (Throwable)e);
        }
    }

    private void unregisterExtensionMBean() throws JBIException {
        if (this.mExtensionMBeanName != null) {
            try {
                MBeanServer mbServer = RuntimeHelper.getComponentContext().getMBeanServer();
                mbServer.unregisterMBean(this.mExtensionMBeanName);
            }
            catch (Exception e) {
                throw new JBIException("Can not unregister Extension MBean from MBeanServer for " + RuntimeHelper.getComponentName(), (Throwable)e);
            }
            finally {
                this.mExtensionMBeanName = null;
                this.mExtensionMBeanImpl = null;
            }
        }
    }

    public final ComponentRuntime getComponentRuntime() {
        return this.mCompRuntime;
    }

    private void initContext(ComponentContext context) {
        RuntimeContext.getInstance().setComponentContext(context);
        RuntimeContext.getInstance().setLogger(this.getClass().getPackage().getName(), null);
    }

    private void initMessageExchangeReceiver() throws JBIException {
        try {
            this.mMsgExchReceiver = this.createMessageExchangeReceiver();
            if (this.mMsgExchReceiver != null) {
                this.mMsgExchReceiver.initReceiver();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownMessageExchangeReceiver() throws JBIException {
        try {
            if (this.mMsgExchReceiver != null) {
                this.mMsgExchReceiver.shutdownReceiver();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.mMsgExchReceiver = null;
        }
    }

    private void startMessageExchangeProcessing() throws JBIException {
        try {
            if (this.mMsgExchReceiver != null) {
                this.mMsgExchReceiver.startProcessing();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void stopMessageExchangeProcessing() throws JBIException {
        try {
            if (this.mMsgExchReceiver != null) {
                this.mMsgExchReceiver.stopProcessing();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void openDeliveryChannel() {
        RuntimeContext.getInstance().openDeliveryChannel();
    }

    private void closeDeliveryChannel() {
        RuntimeContext.getInstance().closeDeliveryChannel();
    }

    protected abstract ObjectName createExtensionMBeanName();

    protected abstract StandardMBean createExtensionMBean();

    protected abstract void initMessageExchangeHandlerFactory() throws JBIException;

    protected abstract MessageExchangeReceiver createMessageExchangeReceiver() throws Exception;

    protected abstract void activateServiceProviders() throws JBIException;

    protected abstract void deactivateServiceProviders() throws JBIException;

    protected abstract void activateServiceConsumers() throws JBIException;

    protected abstract void deactivateServiceConsumers() throws JBIException;

    protected void onInit() throws JBIException {
    }

    protected void onStart() throws JBIException {
    }

    protected void onStop() throws JBIException {
    }

    protected void onShutDown() throws JBIException {
    }
}

