/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.typemapping.cobol;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import java.math.BigDecimal;

public class ZonedMarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(ZonedMarshaller.class);
    private static final Messages MESSAGES = Messages.getMessages(ZonedMarshaller.class);
    private static final byte EBCDIC_PLUS = 78;
    private static final byte EBCDIC_MINUS = 96;

    public static void marshallZoned(BigDecimal value, byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, String codePage) {
        value = value.movePointRight(virtualDecimalPoint);
        value = value.setScale(0);
        int signOffset = signFormat == 2 && signed ? 1 : 0;
        int dataSize = size - signOffset;
        boolean isNegative = false;
        if (value.compareTo(new BigDecimal(0)) == -1) {
            value = value.abs();
            isNegative = true;
        }
        String stringValue = value.toPlainString();
        StringBuffer stringBufferValue = new StringBuffer(stringValue);
        for (int i = 0; i < dataSize - stringValue.length(); ++i) {
            stringBufferValue.insert(0, '0');
        }
        LOG.debug("stringValue after padding: " + stringBufferValue);
        byte[] valueArray = stringBufferValue.toString().getBytes();
        int dataStartingOffset = startingOffset + signOffset;
        for (int i = dataSize - 1; i >= 0; --i) {
            byte currentByte = (byte)(valueArray[i] & 0xF);
            currentByte = signFormat == 1 && signed && i == dataSize - 1 || signFormat == 0 && signed && i == 0 ? (isNegative ? (byte)(0xD0 | currentByte) : (byte)(0xC0 | currentByte)) : (byte)(0xF0 | currentByte);
            buffer[dataStartingOffset + i] = currentByte;
        }
        if (signFormat == 2 && signed) {
            buffer[startingOffset] = isNegative ? 96 : 78;
        }
    }

    public static BigDecimal unmarshallZoned(byte[] buffer, int startingOffset, int size, boolean signed, int virtualDecimalPoint, int signFormat, String codePage) throws FormatException {
        int signOffset = signFormat == 2 && signed ? 1 : 0;
        int dataStartingOffset = startingOffset + signOffset;
        int dataSize = size - signOffset;
        boolean positive = true;
        if (signFormat == 2 && signed) {
            byte signByte = buffer[startingOffset];
            switch (signByte) {
                case 78: {
                    positive = true;
                    break;
                }
                case 96: {
                    positive = false;
                    break;
                }
                default: {
                    LOG.error("CIC002119_Sign_not_recognized", signByte);
                    throw new FormatException(MESSAGES.getString("CIC002119_Sign_not_recognized", signByte));
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dataSize; ++i) {
            byte signByte;
            byte currentByte = buffer[dataStartingOffset + i];
            if ((signFormat == 1 && signed && i == dataSize - 1 || signFormat == 0 && signed && i == 0) && (signByte = (byte)((currentByte & 0xF0) >> 4)) == 13) {
                positive = false;
            }
            stringBuffer.append(String.valueOf(currentByte & 0xF));
        }
        BigDecimal result = new BigDecimal(stringBuffer.toString());
        result = result.movePointLeft(virtualDecimalPoint);
        if (!positive) {
            result = result.negate();
        }
        return result;
    }
}

