/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.messageformat.jdbc;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.MappingDescriptor;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcParameterDescriptor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcStatementDescriptor
implements MappingDescriptor {
    public static final int PREPARED_STATEMENT = 0;
    public static final int CALLABLE_STATEMENT = 1;
    public static final int UPDATE_SQL = 0;
    public static final int SELECT_SQL = 1;
    private String sql;
    private int statementType;
    private int sqlType;
    private Map<Integer, FieldDescriptor> parameterList = new HashMap<Integer, FieldDescriptor>();
    private Map<String, Integer> propertyNameParameterIndexMap = new HashMap<String, Integer>();
    private Class beanClass;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcStatementDescriptor.class);
    private static final Messages MESSAGES = Messages.getMessages(JdbcStatementDescriptor.class);

    public JdbcParameterDescriptor getParameter(int paramterIndex) {
        return (JdbcParameterDescriptor)this.parameterList.get(new Integer(paramterIndex));
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void setStatementType(int statementType) {
        this.statementType = statementType;
    }

    @Override
    public void addFieldMapping(String propertyName, String fieldName, FieldDescriptor fieldDescriptor) throws FormatException {
    }

    @Override
    public void addFieldMapping(String propertyName, Integer fieldIndex, FieldDescriptor fieldDescriptor) throws FormatException {
        if (!(fieldDescriptor instanceof JdbcParameterDescriptor)) {
            LOG.error("CIC001805_Jdbc_parameter_descriptor_not_found", fieldDescriptor.getClass());
            throw new FormatException(MESSAGES.getString("CIC001805_Jdbc_parameter_descriptor_not_found", fieldDescriptor.getClass()));
        }
        this.parameterList.put(fieldIndex, fieldDescriptor);
        this.propertyNameParameterIndexMap.put(propertyName, fieldIndex);
    }

    public Map<String, Integer> getPropertyNameParameterIndexMap() {
        return this.propertyNameParameterIndexMap;
    }

    @Override
    public Map<String, FieldDescriptor> getFieldMap() throws FormatException {
        throw new FormatException(MESSAGES.getString("CIC001800_Not_implemented", new Object[0]));
    }

    @Override
    public Class getBeanClass() {
        return this.beanClass;
    }

    @Override
    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public void setCodePage(String codePage) {
    }
}

