/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jdbc.util;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.jdbc.util.PreparedStatementInvocationHandler;
import it.imolinfo.jbi4cics.jbi.Messages;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CallableStatementInvocationHandler
extends PreparedStatementInvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CallableStatementInvocationHandler.class);
    private static final Messages MESSAGES = Messages.getMessages(CallableStatementInvocationHandler.class);
    private List<Object> paramterNameList = new Vector<Object>();
    private List<Object> parameterIndexList = new Vector<Object>();
    private Map<String, Object> nameValueParamterMap = new HashMap<String, Object>();
    private Map<Integer, Object> indexValueParamterMap = new HashMap<Integer, Object>();

    public CallableStatementInvocationHandler(String sql) {
        super(sql);
    }

    public CallableStatementInvocationHandler(String sql, int resultSetType, int resultSetConcurrency) {
        super(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatementInvocationHandler(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected Statement createStatement() throws SQLException {
        return this.getConnection().prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("execute")) {
            Object object = super.invoke(proxy, method, args);
            this.handlePostExecute();
            return object;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (!clazz.equals(CallableStatement.class)) {
            return super.invoke(proxy, method, args);
        }
        if (method.getName().startsWith("set")) {
            return super.invoke(proxy, method, args);
        }
        if (method.getName().startsWith("register")) {
            return this.handleRegister(proxy, method, args);
        }
        if (method.getName().startsWith("get")) {
            return this.handleGetParameter(method, args);
        }
        return null;
    }

    private Object handleRegister(Object proxy, Method method, Object[] args) throws Throwable, SQLException {
        LOG.debug("method.getParameterTypes(): " + Arrays.toString(method.getParameterTypes()));
        if (method.getParameterTypes()[0].equals(String.class)) {
            this.paramterNameList.add(args[0]);
            return super.invoke(proxy, method, args);
        }
        if (method.getParameterTypes()[0].equals(Integer.TYPE)) {
            this.parameterIndexList.add(args[0]);
            return super.invoke(proxy, method, args);
        }
        throw new SQLException(MESSAGES.getString("CIC000700_Error_registering_parameter", Arrays.toString(args)));
    }

    private Object handleGetParameter(Method method, Object[] args) throws SQLException {
        if (this.isConnected()) {
            return this.invokeMethod(method, args);
        }
        if (args.length > 1) {
            throw new SQLException(MESSAGES.getString("CIC000701_Getting_multiple_parameters_unsupported", new Object[0]));
        }
        if (method.getParameterTypes()[0].equals(String.class)) {
            return this.nameValueParamterMap.get(args[0]);
        }
        if (method.getParameterTypes()[0].equals(Integer.TYPE)) {
            return this.indexValueParamterMap.get(args[0]);
        }
        throw new SQLException(MESSAGES.getString("CIC000702_Unknown_arguments", Arrays.toString(args)));
    }

    private void handlePostExecute() throws SQLException {
        Object value;
        for (String string : this.paramterNameList) {
            value = ((CallableStatement)this.getUnderlyingStatement()).getObject(string);
            this.nameValueParamterMap.put(string, value);
        }
        Iterator<Object> i = this.parameterIndexList.iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            value = ((CallableStatement)this.getUnderlyingStatement()).getObject(n);
            this.indexValueParamterMap.put(new Integer(n), value);
        }
        LOG.debug("name : value keys: " + Arrays.toString(this.nameValueParamterMap.keySet().toArray()));
        LOG.debug("name : value values: " + Arrays.toString(this.nameValueParamterMap.values().toArray()));
        LOG.debug("index : value keys: " + Arrays.toString(this.indexValueParamterMap.keySet().toArray()));
        LOG.debug("index : value values: " + Arrays.toString(this.indexValueParamterMap.values().toArray()));
    }
}

