/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.type.AbstractTypeCreator;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.aegis.type.basic.BeanTypeInfo;
import org.codehaus.xfire.aegis.type.java5.AnnotatedTypeInfo;
import org.codehaus.xfire.aegis.type.java5.EnumType;
import org.codehaus.xfire.aegis.type.java5.XmlAttribute;
import org.codehaus.xfire.aegis.type.java5.XmlElement;
import org.codehaus.xfire.aegis.type.java5.XmlParamType;
import org.codehaus.xfire.aegis.type.java5.XmlReturnType;
import org.codehaus.xfire.aegis.type.java5.XmlType;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.ServiceUtils;

public class Java5TypeCreator
extends AbstractTypeCreator {
    public AbstractTypeCreator.TypeClassInfo createClassInfo(Method m, int index) {
        XmlReturnType xmlParam;
        AbstractTypeCreator.TypeClassInfo info;
        if (index >= 0) {
            AbstractTypeCreator.TypeClassInfo info2;
            java.lang.reflect.Type genericType = m.getGenericParameterTypes()[index];
            if (genericType instanceof Class) {
                info2 = this.nextCreator.createClassInfo(m, index);
            } else {
                info2 = new AbstractTypeCreator.TypeClassInfo();
                info2.setGenericType((Object)genericType);
            }
            info2.setTypeClass(m.getParameterTypes()[index]);
            XmlParamType xmlParam2 = this.getXmlParamAnnotation(m, index);
            if (xmlParam2 != null) {
                if (xmlParam2.type() != Type.class) {
                    info2.setType(xmlParam2.type());
                }
                info2.setTypeName(this.createQName(m.getParameterTypes()[index], xmlParam2.name(), xmlParam2.namespace()));
            }
            return info2;
        }
        java.lang.reflect.Type genericReturnType = m.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            info = this.nextCreator.createClassInfo(m, index);
        } else {
            info = new AbstractTypeCreator.TypeClassInfo();
            info.setGenericType((Object)genericReturnType);
        }
        info.setTypeClass(m.getReturnType());
        if (m.getParameterAnnotations() != null && m.getAnnotations().length > 0) {
            info.setAnnotations((Object[])m.getAnnotations());
        }
        if ((xmlParam = m.getAnnotation(XmlReturnType.class)) != null) {
            if (xmlParam.type() != Type.class) {
                info.setType(xmlParam.type());
            }
            info.setTypeName(this.createQName(m.getReturnType(), xmlParam.name(), xmlParam.namespace()));
        }
        return info;
    }

    public XmlParamType getXmlParamAnnotation(Method m, int index) {
        if (m.getParameterAnnotations() == null || m.getParameterAnnotations().length <= index || m.getParameterAnnotations()[index] == null) {
            return null;
        }
        Annotation[] annotations = m.getParameterAnnotations()[index];
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            if (!annotation.annotationType().equals(XmlParamType.class)) continue;
            return (XmlParamType)annotations[i];
        }
        return null;
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        XmlAttribute att;
        AbstractTypeCreator.TypeClassInfo info = this.createBasicClassInfo(pd.getPropertyType());
        info.setGenericType((Object)pd.getReadMethod().getGenericReturnType());
        info.setAnnotations((Object[])pd.getReadMethod().getAnnotations());
        XmlElement el = pd.getReadMethod().getAnnotation(XmlElement.class);
        if (el != null && !el.type().equals(Type.class)) {
            info.setType(el.type());
        }
        if ((att = pd.getReadMethod().getAnnotation(XmlAttribute.class)) != null && !att.type().equals(Type.class)) {
            info.setType(att.type());
        }
        return info;
    }

    public Type createCollectionType(AbstractTypeCreator.TypeClassInfo info) {
        Object genericType = info.getGenericType();
        Class paramClass = this.getComponentType(genericType, 0);
        if (paramClass != null) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    protected Type getOrCreateGenericType(AbstractTypeCreator.TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getGenericType(), 0);
    }

    protected Type getOrCreateMapKeyType(AbstractTypeCreator.TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getGenericType(), 0);
    }

    protected Type getOrCreateMapValueType(AbstractTypeCreator.TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getGenericType(), 1);
    }

    protected Type getOrCreateParameterizedType(Object generic, int index) {
        Class clazz = this.getComponentType(generic, index);
        AbstractTypeCreator.TypeClassInfo info = this.createBasicClassInfo(clazz);
        info.setDescription(clazz.toString());
        info.setGenericType(this.getGenericComponent(generic, index));
        Type type = this.createTypeForClass(info);
        return type;
    }

    private Object getGenericComponent(Object genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            if (type.getActualTypeArguments()[index] instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type.getActualTypeArguments()[index];
                return wildcardType;
            }
            if (type.getActualTypeArguments()[index] instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type.getActualTypeArguments()[index];
                return ptype;
            }
        }
        return null;
    }

    protected Class getComponentType(Object genericType, int index) {
        Class paramClass = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            if (type.getActualTypeArguments()[index] instanceof Class) {
                paramClass = (Class)type.getActualTypeArguments()[index];
            } else if (type.getActualTypeArguments()[index] instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type.getActualTypeArguments()[index];
                if (wildcardType.getUpperBounds()[index] instanceof Class) {
                    paramClass = (Class)wildcardType.getUpperBounds()[index];
                }
            } else if (type.getActualTypeArguments()[index] instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type.getActualTypeArguments()[index];
                paramClass = (Class)ptype.getRawType();
            }
        }
        return paramClass;
    }

    public Type createDefaultType(AbstractTypeCreator.TypeClassInfo info) {
        QName typeName = info.getTypeName();
        if (typeName == null) {
            typeName = this.createQName(info.getTypeClass());
        }
        AnnotatedTypeInfo typeInfo = new AnnotatedTypeInfo(this.getTypeMapping(), info.getTypeClass(), typeName.getNamespaceURI());
        XmlType xtype = info.getTypeClass().getAnnotation(XmlType.class);
        if (xtype != null) {
            typeInfo.setExtensibleElements(xtype.extensibleElements());
            typeInfo.setExtensibleAttributes(xtype.extensibleAttributes());
        } else {
            typeInfo.setExtensibleElements(this.getConfiguration().isDefaultExtensibleElements());
            typeInfo.setExtensibleAttributes(this.getConfiguration().isDefaultExtensibleAttributes());
        }
        typeInfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
        typeInfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
        BeanType type = new BeanType((BeanTypeInfo)typeInfo);
        type.setTypeMapping(this.getTypeMapping());
        type.setSchemaType(typeName);
        return type;
    }

    public Type createEnumType(AbstractTypeCreator.TypeClassInfo info) {
        EnumType type = new EnumType();
        type.setSchemaType(this.createQName(info.getTypeClass()));
        type.setTypeClass(info.getTypeClass());
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    public QName createQName(Class typeClass) {
        String name = null;
        String ns = null;
        XmlType xtype = typeClass.getAnnotation(XmlType.class);
        if (xtype != null) {
            name = xtype.name();
            ns = xtype.namespace();
        }
        return this.createQName(typeClass, name, ns);
    }

    private QName createQName(Class typeClass, String name, String ns) {
        String clsName = typeClass.getName();
        if (name == null || name.length() == 0) {
            name = ServiceUtils.makeServiceNameFromClassName((Class)typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = NamespaceHelper.makeNamespaceFromClassName((String)clsName, (String)"http");
        }
        return new QName(ns, name);
    }

    protected boolean isEnum(Class javaType) {
        return javaType.isEnum();
    }
}

