/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.jbi.Messages;
import java.text.MessageFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;

final class Log4jLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
Logger {
    private static final String FQCN = Log4jLoggerAdapter.class.getName();
    private final org.apache.log4j.Logger logger;
    private final Messages messages;

    Log4jLoggerAdapter(org.apache.log4j.Logger logger, Messages messages) {
        if (logger == null) {
            throw new NullPointerException("Log4j logger null");
        }
        this.logger = logger;
        this.messages = messages;
    }

    private boolean isI18N() {
        return this.messages != null;
    }

    private String formatMessage(String format, Object ... args) {
        String msg;
        if (this.isI18N()) {
            msg = args.length == 0 ? this.messages.getString(format, new Object[0]) : this.messages.getString(format, args);
        } else if (args.length == 0) {
            msg = format;
        } else {
            try {
                msg = MessageFormat.format(format, args);
            }
            catch (IllegalArgumentException e) {
                msg = format;
            }
        }
        return msg;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            String msg = MessageFormat.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            String msg = MessageFormat.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
        }
    }

    public void debug(String format, Object[] args) {
        if (this.isDebugEnabled()) {
            String msg = MessageFormat.format(format, args);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
        }
    }

    public void debug(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(msg, new Object[0]), null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(format, arg), null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            String msg = this.formatMessage(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, null);
        }
    }

    public void info(String format, Object[] args) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(format, args), null);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(msg, new Object[0]), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(msg, new Object[0]), null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(format, arg), null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            String msg = this.formatMessage(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, null);
        }
    }

    public void warn(String format, Object[] args) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(format, args), null);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(msg, new Object[0]), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(msg, new Object[0]), null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            String msg = this.formatMessage(format, arg);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            String msg = this.formatMessage(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
        }
    }

    public void error(String format, Object[] args) {
        if (this.isErrorEnabled()) {
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(format, args), null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(msg, new Object[0]), t);
        }
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Throwable t) {
        Level log4jLevel;
        switch (level) {
            case 0: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case 1: {
                log4jLevel = Level.INFO;
                break;
            }
            case 2: {
                log4jLevel = Level.WARN;
                break;
            }
            case 3: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Level number " + level + " is not recognized.");
            }
        }
        this.logger.log(callerFQCN, (Priority)log4jLevel, (Object)msg, t);
    }

    public void debug(String format, Object[] args, Throwable t) {
        if (this.isDebugEnabled()) {
            String msg = MessageFormat.format(format, args);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
        }
    }

    public void info(String format, Object[] args, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(format, args), t);
        }
    }

    public void warn(String format, Object[] args, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(format, args), t);
        }
    }

    public void error(String format, Object[] args, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(format, args), t);
        }
    }
}

