/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.runtime;

import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaRuntimeException;
import it.imolinfo.jbi4corba.exception.ServiceCreationException;
import it.imolinfo.jbi4corba.jbi.Messages;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4corba.jbi.endpoint.ConsumerEndpoint;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.JbiMessage;
import it.imolinfo.jbi4corba.jbi.processor.MessageDenormalizer;
import it.imolinfo.jbi4corba.jbi.processor.MessageNormalizer;
import it.imolinfo.jbi4corba.jbi.processor.transform.SourceTransformer;
import it.imolinfo.jbi4corba.jbi.processor.transform.StringSource;
import it.imolinfo.jbi4corba.webservice.descriptor.ConsumerServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.generator.WsdlInformation;
import it.imolinfo.jbi4corba.webservice.runtime.Jbi4CorbaServiceConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.jaxb2.JaxbTypeRegistry;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.SoapSerializer;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.STAXUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConsumerInvocationHandler
implements InvocationHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerInvocationHandler.class);
    public static final URI IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OUT = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final URI ROBUST_IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    public static final String CONTEXT_KEY = "client.call";
    public String JBI_SERVICE_ENGINE_BINDING = "http://java.sun.com/xml/ns/jbi/binding/service+engine";
    public String JBI_HTTP_SOAP_BINDING = "http://schemas.xmlsoap.org/soap/http";
    private static final Messages MESSAGES = Messages.getMessages(ConsumerInvocationHandler.class);
    private static String transportURI = "jbi4corba://";
    private Service xfireService;
    private XFire xfire;
    private Client client;
    private Binding binding;
    private Jbi4CorbaEndpoint endpoint;
    private ServiceEndpoint mirroredEndpoint;
    private DeliveryChannel channel;
    private SourceTransformer sourceTransformer = new SourceTransformer();
    private ConsumerServiceDescriptor consumerServiceDescriptor;
    private MessageDenormalizer messageDenormalizer;
    private MessageNormalizer messageNormalizer;

    public ConsumerInvocationHandler(ConsumerServiceDescriptor sd) throws ServiceCreationException {
        try {
            this.messageDenormalizer = new MessageDenormalizer();
            this.messageNormalizer = new MessageNormalizer();
        }
        catch (Jbi4CorbaException e) {
            Object[] logArgs = new Object[]{e.getMessage()};
            LOG.error("CRB000749_XML_toString_Error", logArgs, e);
            throw new ServiceCreationException("CRB000749_XML_toString_Error", logArgs, e);
        }
        this.consumerServiceDescriptor = sd;
        this.xfire = this.consumerServiceDescriptor.getXfire();
        this.endpoint = this.consumerServiceDescriptor.getEndpoint();
        this.mirroredEndpoint = this.consumerServiceDescriptor.getProxiedService();
        TransportManager tm = this.xfire.getTransportManager();
        AnnotationServiceFactory factory = new AnnotationServiceFactory((WebAnnotations)new Jsr181WebAnnotations(), this.xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider((TypeMappingRegistry)new JaxbTypeRegistry()));
        HashMap props = new HashMap();
        factory.getSoap12Transports().clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("--- wsdl definition:\n" + this.consumerServiceDescriptor.getServiceWSDLDefinition() + "\n ---");
        }
        Jbi4CorbaServiceConfiguration config = new Jbi4CorbaServiceConfiguration(this.consumerServiceDescriptor.getServiceWSDLDefinition());
        config.setServiceFactory((ObjectServiceFactory)factory);
        ArrayList<Jbi4CorbaServiceConfiguration> serviceConfigurations = new ArrayList<Jbi4CorbaServiceConfiguration>();
        serviceConfigurations.add(config);
        factory.setServiceConfigurations(serviceConfigurations);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.consumerServiceDescriptor.getServerCorbaClassesHolder().getUrlClassLoader());
        try {
            Class impl = this.consumerServiceDescriptor.getServerCorbaClassesHolder().getWebServiceImpl();
            this.xfireService = factory.create(impl, props);
        }
        catch (RuntimeException e) {
            LOG.error("RuntimeExcection:" + e.getMessage(), e);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        this.prepareOnewayOperation();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.xfireService.getWSDLWriter().write((OutputStream)baos);
        }
        catch (IOException e1) {
            LOG.error("Cannot write the WSDL.", e1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ByteOutputStream:\n" + baos.toString());
            LOG.debug("created xfire service: " + this.xfireService);
        }
        this.xfire.getServiceRegistry().register(this.xfireService);
        LOG.debug("available transports: " + tm.getTransports());
        Transport transport = tm.getTransportForUri("xfire.local://" + this.xfireService.getSimpleName());
        this.binding = this.xfireService.getBinding(this.JBI_HTTP_SOAP_BINDING);
        if (this.binding != null) {
            LOG.debug("Found http binding: " + this.binding.getName());
        }
        if (this.binding == null) {
            this.binding = this.xfireService.getBinding(this.JBI_SERVICE_ENGINE_BINDING);
            LOG.debug("Found jbi binding: " + this.binding.getName());
        }
        if (this.binding == null && this.xfireService.getBindings().size() != 0) {
            this.binding = (Binding)this.xfireService.getBindings().iterator().next();
            LOG.debug("Found binding: " + this.binding.getName());
        }
        LOG.debug("transportURI=" + transportURI + "; URI+NAME=" + transportURI + this.xfireService.getSimpleName());
        this.client = new Client(transport, this.xfireService, transportURI + this.xfireService.getSimpleName());
        ComponentContext context = RuntimeContext.getInstance().getComponentContext();
        try {
            this.channel = context.getDeliveryChannel();
        }
        catch (MessagingException e) {
            Object[] args = new Object[]{context};
            LOG.error("CRB000700_Unable_to_get_delivery_channel_from_context", args, e);
            throw new ServiceCreationException("CRB000700_Unable_to_get_delivery_channel_from_context", args, e);
        }
        LOG.debug("context class name: " + context.getClass().getName());
    }

    protected void prepareOnewayOperation() {
        Map<QName, List<String>> map = this.consumerServiceDescriptor.getServerCorbaClassesHolder().getWsdlInformation().getAsynchOperationMap();
        QName xfirePortType = this.xfireService.getServiceInfo().getPortType();
        for (QName portType : map.keySet()) {
            if (!xfirePortType.equals(portType)) continue;
            List<String> opNameList = map.get(portType);
            for (Object op : this.xfireService.getServiceInfo().getOperations()) {
                OperationInfo opx = (OperationInfo)op;
                String loc = opx.getQName().getLocalPart();
                for (String opName : opNameList) {
                    if (!loc.equals(opName)) continue;
                    opx.setAsync(true);
                    opx.setMEP("urn:xfire:mep:in");
                    opx.setOutputMessage(null);
                }
            }
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LOG.debug("ConsumerInvocationHandler.invoke; invoked endpoint: " + this.endpoint + " with method: " + method + " and args: " + Arrays.toString(args));
        ExecutionContext executionContext = new ExecutionContext();
        QName portType = this.extractPortType();
        OperationInfo op = this.getOperationInfo(method);
        LOG.debug("PortType=" + portType + "; OperationInfo: " + op);
        executionContext.setOperationInfo(op);
        Node nodeResult = this.fromObjectToXML(executionContext, args, op);
        if (LOG.isDebugEnabled()) {
            String node2string = null;
            try {
                node2string = this.sourceTransformer.toString(nodeResult);
            }
            catch (TransformerException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            LOG.debug("soap serialized request: " + node2string);
        }
        Object exchangeResult = null;
        if (this.isAsynch(portType, op.getName())) {
            Object[] logArgs = new Object[]{op.getName()};
            LOG.info("CRB000747_ConsumerInOnlyInvoke", logArgs);
            this.exchangeInOnly(executionContext, op, nodeResult);
        } else {
            Object[] logArgs = new Object[]{op.getName()};
            LOG.info("CRB000748_ConsumerInOutInvoke", logArgs);
            exchangeResult = this.exchangeInOut(executionContext, op, nodeResult);
        }
        LOG.debug("exchangeResult=" + exchangeResult);
        return exchangeResult;
    }

    protected Object exchangeInOnly(ExecutionContext executionContext, OperationInfo op, Node nodeResult) throws Jbi4CorbaRuntimeException {
        String in2string;
        NormalizedMessage inMessage;
        InOnly jbiExchange = this.createInOnlyExchange(op);
        LOG.debug("Created InOnlyExchange: " + jbiExchange);
        try {
            inMessage = jbiExchange.createMessage();
            LOG.debug("created inMessage: " + inMessage);
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{jbiExchange};
            LOG.error("CRB000701_Unable_to_create_message_from_exchange", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000701_Unable_to_create_message_from_exchange", params, e);
        }
        Node content = nodeResult.getFirstChild().getFirstChild().getFirstChild();
        DOMSource domContent = new DOMSource(content);
        if (LOG.isDebugEnabled()) {
            try {
                String stringContent = this.sourceTransformer.toString(content);
                LOG.debug("stringContent: " + stringContent);
            }
            catch (TransformerException e1) {
                Object[] logArgs = new Object[]{e1.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e1);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e1);
            }
        }
        QName messageQName = op.getInputMessage().getName();
        LOG.debug("operation input message: " + messageQName);
        Source wrappedContent = null;
        try {
            wrappedContent = this.messageNormalizer.normalize(domContent, this.endpoint, op.getQName(), true, false);
        }
        catch (Jbi4CorbaException e) {
            Object[] logArgs = new Object[]{e.getMessage()};
            LOG.error("CRB000744_MessageWrapping_Error", logArgs, e);
            throw new Jbi4CorbaRuntimeException("CRB000744_MessageWrapping_Error", logArgs, e);
        }
        try {
            inMessage.setContent(wrappedContent);
        }
        catch (MessagingException e) {
            Object[] logArgs = new Object[]{e.getMessage()};
            LOG.error("CRB000745_NormalizedMessageSetContent_Error", logArgs, e);
            throw new Jbi4CorbaRuntimeException("CRB000745_NormalizedMessageSetContent_Error", logArgs, e);
        }
        executionContext.setJbiInMessage(inMessage);
        if (LOG.isDebugEnabled()) {
            in2string = null;
            try {
                in2string = this.sourceTransformer.contentToString(inMessage);
            }
            catch (MessagingException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (TransformerException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (ParserConfigurationException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (IOException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (SAXException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            LOG.debug("JBI-inMessage.getContent()=" + in2string);
        }
        try {
            jbiExchange.setInMessage(inMessage);
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{inMessage, jbiExchange};
            LOG.error("CRB000703_Unable_to_set_message_in_exchange", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000703_Unable_to_set_message_in_exchange", params, e);
        }
        if (LOG.isDebugEnabled()) {
            in2string = null;
            try {
                in2string = this.sourceTransformer.contentToString(inMessage);
            }
            catch (MessagingException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (TransformerException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (ParserConfigurationException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (IOException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (SAXException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            LOG.debug("Sending asynch message: InMessage: " + in2string + " on exchange: " + jbiExchange.getExchangeId());
        }
        ConsumerEndpoint consEP = null;
        try {
            consEP.sendAsynch((MessageExchange)jbiExchange, this.channel);
        }
        catch (MessagingException e) {
            Object[] logArgs = new Object[]{jbiExchange, consEP};
            LOG.error("CRB000704_Unable_to_send_exchange_with_endpoint", logArgs, e);
            throw new Jbi4CorbaRuntimeException("CRB000704_Unable_to_send_exchange_with_endpoint", logArgs, e);
        }
        LOG.debug("... message sending complete.");
        LOG.debug("jbiExchange.getStatus()=" + jbiExchange.getStatus());
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object exchangeInOut(ExecutionContext executionContext, OperationInfo op, Node nodeResult) throws Jbi4CorbaRuntimeException {
        Object err2;
        String in2string;
        NormalizedMessage inMessage;
        InOut jbiExchange = this.createInOutExchange(op);
        LOG.debug("Created InOutExchange: " + jbiExchange);
        try {
            inMessage = jbiExchange.createMessage();
            LOG.debug("created inMessage: " + inMessage);
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{jbiExchange};
            LOG.error("CRB000701_Unable_to_create_message_from_exchange", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000701_Unable_to_create_message_from_exchange", params, e);
        }
        Node content = nodeResult.getFirstChild().getFirstChild().getFirstChild();
        DOMSource domContent = new DOMSource(content);
        if (LOG.isDebugEnabled()) {
            try {
                String stringContent = this.sourceTransformer.toString(content);
                LOG.debug("stringContent: " + stringContent);
            }
            catch (TransformerException e1) {
                Object[] logArgs = new Object[]{e1.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e1);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e1);
            }
        }
        LOG.debug("The message needs wrapping");
        QName messageQName = op.getInputMessage().getName();
        LOG.debug("operation input message: " + messageQName);
        Source wrappedContent = null;
        try {
            wrappedContent = this.messageNormalizer.normalize(domContent, this.endpoint, op.getQName(), true, false);
        }
        catch (Jbi4CorbaException e) {
            Object[] logArgs = new Object[]{e.getMessage()};
            LOG.error("CRB000744_MessageWrapping_Error", logArgs, e);
            throw new Jbi4CorbaRuntimeException("CRB000744_MessageWrapping_Error", logArgs, e);
        }
        try {
            inMessage.setContent(wrappedContent);
        }
        catch (MessagingException e) {
            Object[] logArgs = new Object[]{e.getMessage()};
            LOG.error("CRB000745_NormalizedMessageSetContent_Error", logArgs, e);
            throw new Jbi4CorbaRuntimeException("CRB000745_NormalizedMessageSetContent_Error", logArgs, e);
        }
        executionContext.setJbiInMessage(inMessage);
        if (LOG.isDebugEnabled()) {
            in2string = null;
            try {
                in2string = this.sourceTransformer.contentToString(inMessage);
            }
            catch (MessagingException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (TransformerException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (ParserConfigurationException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (IOException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (SAXException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            LOG.debug("JBI-inMessage.getContent()=" + in2string);
        }
        try {
            jbiExchange.setInMessage(inMessage);
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{inMessage, jbiExchange};
            LOG.error("CRB000703_Unable_to_set_message_in_exchange", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000703_Unable_to_set_message_in_exchange", params, e);
        }
        if (LOG.isDebugEnabled()) {
            in2string = null;
            try {
                in2string = this.sourceTransformer.contentToString(inMessage);
            }
            catch (MessagingException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (TransformerException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (ParserConfigurationException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (IOException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            catch (SAXException e) {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000743_XML_toString_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000743_XML_toString_Error", logArgs, e);
            }
            LOG.debug("Sending synch message: InMessage: " + in2string + " on exchange: " + jbiExchange.getExchangeId());
        }
        boolean sendingReturn = false;
        try {
            sendingReturn = this.sendSynch(jbiExchange);
        }
        catch (MessagingException e1) {
            Object[] logArgs = new Object[]{jbiExchange, ""};
            LOG.error("CRB000704_Unable_to_send_exchange_with_endpoint", logArgs, e1);
            throw new Jbi4CorbaRuntimeException("CRB000704_Unable_to_send_exchange_with_endpoint", logArgs, e1);
        }
        LOG.debug("... message response:" + sendingReturn);
        if (jbiExchange.getStatus() == ExchangeStatus.ERROR) {
            Exception err2 = jbiExchange.getError();
            LOG.error("CRB000705_Exchange_status_error", err2);
            if (err2 == null) throw new Jbi4CorbaRuntimeException("CRB000706_Unknown_error");
            throw new Jbi4CorbaRuntimeException(err2);
        }
        if (jbiExchange.getStatus() != ExchangeStatus.ACTIVE) {
            throw new IllegalStateException(MESSAGES.getString("CRB000712_Unexpected_exchange_status", jbiExchange.getStatus()));
        }
        LOG.debug("exchange status ACTIVE");
        try {
            err2 = this.exchangeStatusACTIVE(jbiExchange, executionContext);
        }
        catch (MessagingException e) {
            try {
                Object[] logArgs = new Object[]{e.getMessage()};
                LOG.error("CRB000746_SetExchangeStatus_Error", logArgs, e);
                throw new Jbi4CorbaRuntimeException("CRB000746_SetExchangeStatus_Error", logArgs, e);
                catch (TransformerException e2) {
                    logArgs = new Object[]{e2.getMessage()};
                    LOG.error("CRB000746_SetExchangeStatus_Error", logArgs, e2);
                    throw new Jbi4CorbaRuntimeException("CRB000746_SetExchangeStatus_Error", logArgs, e2);
                }
                catch (ParserConfigurationException e3) {
                    logArgs = new Object[]{e3.getMessage()};
                    LOG.error("CRB000746_SetExchangeStatus_Error", logArgs, e3);
                    throw new Jbi4CorbaRuntimeException("CRB000746_SetExchangeStatus_Error", logArgs, e3);
                }
                catch (IOException e4) {
                    logArgs = new Object[]{e4.getMessage()};
                    LOG.error("CRB000746_SetExchangeStatus_Error", logArgs, e4);
                    throw new Jbi4CorbaRuntimeException("CRB000746_SetExchangeStatus_Error", logArgs, e4);
                }
                catch (SAXException e5) {
                    logArgs = new Object[]{e5.getMessage()};
                    LOG.error("CRB000746_SetExchangeStatus_Error", logArgs, e5);
                    throw new Jbi4CorbaRuntimeException("CRB000746_SetExchangeStatus_Error", logArgs, e5);
                }
                catch (WrapperProcessingException e6) {
                    logArgs = new Object[]{e6.getMessage()};
                    LOG.error("CRB000746_SetExchangeStatus_Error", logArgs, e6);
                    throw new Jbi4CorbaRuntimeException("CRB000746_SetExchangeStatus_Error", logArgs, e6);
                }
            }
            catch (Throwable throwable) {
                this.setJbiExhangeToDONE((MessageExchange)jbiExchange);
                try {
                    this.channel.send((MessageExchange)jbiExchange);
                    throw throwable;
                }
                catch (MessagingException e7) {
                    Object[] params = new Object[]{jbiExchange, this.channel};
                    LOG.error("CRB000711_Unable_to_send_exchange_on_channel", params, e7);
                    throw new Jbi4CorbaRuntimeException("CRB000711_Unable_to_send_exchange_on_channel", params, e7);
                }
            }
        }
        this.setJbiExhangeToDONE((MessageExchange)jbiExchange);
        try {
            this.channel.send((MessageExchange)jbiExchange);
            return err2;
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{jbiExchange, this.channel};
            LOG.error("CRB000711_Unable_to_send_exchange_on_channel", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000711_Unable_to_send_exchange_on_channel", params, e);
        }
    }

    protected void setJbiExhangeToDONE(MessageExchange jbiExchange) throws Jbi4CorbaRuntimeException {
        try {
            jbiExchange.setStatus(ExchangeStatus.DONE);
        }
        catch (MessagingException e) {
            Object[] par = new Object[]{jbiExchange};
            LOG.error("CRB000710_Unable_to_set_status_DONE_for_exchange", par, e);
            throw new Jbi4CorbaRuntimeException("CRB000710_Unable_to_set_status_DONE_for_exchange", par, e);
        }
    }

    protected Object exchangeStatusACTIVE(InOut jbiExchange, ExecutionContext executionContext) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException, WrapperProcessingException {
        if (jbiExchange.getFault() != null) {
            LOG.warn("CRB000707_Exchange_returned_a_fault", jbiExchange.getFault());
            throw new Jbi4CorbaRuntimeException("CRB000708_SOAP_fault", new Object[]{jbiExchange.getFault()}, null);
        }
        NormalizedMessage outMsg = jbiExchange.getOutMessage();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received Message class:" + outMsg.getClass().getName());
            LOG.debug("Received Message content: " + this.sourceTransformer.contentToString(outMsg));
        }
        executionContext.setJbiOutMessage(outMsg);
        if (outMsg == null) {
            throw new NullPointerException(MESSAGES.getString("CRB000709_Exchange_returned_a_null_message", new Object[0]));
        }
        JbiMessage jbiMessage = null;
        try {
            jbiMessage = this.messageDenormalizer.denormalize(outMsg, this.endpoint, jbiExchange.getOperation(), false);
        }
        catch (Jbi4CorbaException e) {
            Object[] par = new Object[]{jbiExchange};
            LOG.error("CRB000710_Unable_to_set_status_DONE_for_exchange", par, e);
            throw new Jbi4CorbaRuntimeException("CRB000710_Unable_to_set_status_DONE_for_exchange", par, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("jbi unwrapped content:" + this.sourceTransformer.toString(jbiMessage.getMessageSource()));
        }
        Object result = this.fromXMLToObject(executionContext, this.sourceTransformer.toString(jbiMessage.getMessageSource()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deserialized soap message returned: " + result);
        }
        return result;
    }

    protected void sendASynch(InOnly jbiExchange) throws MessagingException {
        try {
            LOG.debug("Before sendASync. Sending message:");
            LOG.debug("Channel:" + this.channel.getClass().getName());
            LOG.info("CRB000736_Sending_message");
            this.channel.send((MessageExchange)jbiExchange);
            LOG.debug("After sendASync");
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{jbiExchange, this.endpoint};
            LOG.error("CRB000704_Unable_to_send_exchange_with_endpoint", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000704_Unable_to_send_exchange_with_endpoint", params, e);
        }
    }

    protected boolean sendSynch(InOut jbiExchange) throws MessagingException {
        try {
            LOG.debug("Before sendSync. Sending message:");
            LOG.debug("Channel:" + this.channel.getClass().getName());
            LOG.info("CRB000736_Sending_message");
            boolean ret = this.channel.sendSync((MessageExchange)jbiExchange);
            LOG.debug("After sendSync (send sync returned: " + ret + ")");
            return ret;
        }
        catch (MessagingException e) {
            Object[] params = new Object[]{jbiExchange, this.endpoint};
            LOG.error("CRB000704_Unable_to_send_exchange_with_endpoint", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000704_Unable_to_send_exchange_with_endpoint", params, e);
        }
    }

    private Document toDom(XMLStreamReader reader) {
        DocumentBuilder mBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            LOG.debug("factory.isNamespaceAware=" + factory.isNamespaceAware());
            mBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new Jbi4CorbaRuntimeException(ex);
        }
        Document contentResult = mBuilder.newDocument();
        try {
            STAXUtils.readDocElements((Node)contentResult, (XMLStreamReader)reader, (boolean)true);
        }
        catch (XMLStreamException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new Jbi4CorbaRuntimeException(ex);
        }
        return contentResult;
    }

    private Object fromXMLToObject(ExecutionContext executionContext, String out) {
        LOG.debug(">>>>> fromXMLToObject - begin. ExecutionContext=" + executionContext + ". out=" + out);
        SoapSerializer soapSerializer = executionContext.getSoapSerializer();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        InMessage inMessage = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.consumerServiceDescriptor.getServerCorbaClassesHolder().getUrlClassLoader());
            inMessage = new InMessage(xmlInputFactory.createXMLStreamReader(new StringSource(out)));
            if (LOG.isDebugEnabled()) {
                String inAsString = inMessage == null ? "null" : ReflectionToStringBuilder.toString((Object)inMessage);
                LOG.debug("fromXMLToObject.XFire.InMessageAsString=" + inAsString);
            }
            executionContext.setXfireOutMessage(inMessage);
            executionContext.getXfireContext().setCurrentMessage((AbstractMessage)inMessage);
            executionContext.getXfireContext().getExchange().setInMessage(inMessage);
            MessageSerializer messageSerializer = this.binding.getSerializer(executionContext.getOperationInfo());
            LOG.debug("MessageSerializer.class=" + messageSerializer.getClass());
            messageSerializer.readMessage(inMessage, executionContext.getXfireContext());
        }
        catch (XMLStreamException e) {
            Object[] args = new Object[]{out};
            LOG.error("CRB000713_Unable_to_create_inMessage_from_source", args, e);
            throw new Jbi4CorbaRuntimeException("CRB000713_Unable_to_create_inMessage_from_source", args, e);
        }
        catch (XFireFault e) {
            Object[] args = new Object[]{inMessage, executionContext.getXfireContext(), soapSerializer};
            LOG.error("CRB000714_Unable_to_deserialize_message", args, e);
            throw new Jbi4CorbaRuntimeException("CRB000714_Unable_to_deserialize_message", args, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        LOG.debug("Deserializing message ...");
        Object result = inMessage.getBody();
        if (LOG.isDebugEnabled()) {
            String bodyAsString = result == null ? "null" : ReflectionToStringBuilder.toString((Object)result);
            LOG.debug("XFire.InMessage.bodyAsString=" + bodyAsString);
        }
        if (result != null && result instanceof List) {
            List list = (List)result;
            if (list.isEmpty()) {
                LOG.warn("CRB000715_Deserialized_list_empty", list);
                LOG.debug("<<<<< fromXMLToObject - end");
                return null;
            }
            LOG.debug("returned list contains: " + list.size() + "elements.");
            if (list.size() != 1) {
                throw new Jbi4CorbaRuntimeException("CRB000716_Deserialized_list_too_big", new Object[]{list}, null);
            }
            result = list.get(0);
            if (LOG.isDebugEnabled()) {
                String resultAsString = ReflectionToStringBuilder.toString((Object)result);
                LOG.debug("resultAsString=" + resultAsString);
            }
        } else {
            LOG.debug("Deserializing message ... nothing to do because the body of the XFire.InMessage is null OR because the body is not a List. XFire.InMessage=" + result + ". XFire.InMessage 'is a' List=" + (result instanceof List));
        }
        LOG.debug("Deserializing message ... done");
        executionContext.setOutResult(result);
        LOG.debug("<<<<< fromXMLToObject - end. ExecutionContext.outResult=" + executionContext.getOutResult() + ". result=" + result);
        return result;
    }

    private InOut createInOutExchange(OperationInfo op) {
        InOut jbiExchange = this.createInOutExchange();
        jbiExchange.setOperation(op.getQName());
        jbiExchange.setEndpoint(this.mirroredEndpoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mirrored endpoint:" + this.mirroredEndpoint);
        }
        return jbiExchange;
    }

    private InOnly createInOnlyExchange(OperationInfo op) {
        InOnly jbiExchange = this.createInOnlyExchange();
        jbiExchange.setOperation(op.getQName());
        jbiExchange.setEndpoint(this.mirroredEndpoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mirrored endpoint:" + this.mirroredEndpoint);
        }
        return jbiExchange;
    }

    protected boolean isAsynch(QName portType, String operationName) {
        if (portType == null || operationName == null) {
            return false;
        }
        WsdlInformation wi = this.consumerServiceDescriptor.getServerCorbaClassesHolder().getWsdlInformation();
        if (wi == null) {
            return false;
        }
        List<String> opList = wi.getAsynchOperationMap().get(portType);
        if (opList == null) {
            return false;
        }
        for (String op : opList) {
            if (!operationName.equals(op)) continue;
            return true;
        }
        return false;
    }

    private OperationInfo getOperationInfo(Method method) {
        OperationInfo op = this.client.getService().getServiceInfo().getOperation(method);
        if (op == null) {
            op = this.client.getService().getServiceInfo().getOperation(method.getName());
        }
        return op;
    }

    protected QName extractPortType() {
        return this.client.getService().getServiceInfo().getPortType();
    }

    private Node fromObjectToXML(ExecutionContext executionContext, Object[] args, OperationInfo op) {
        XMLStreamWriter writer;
        LOG.debug(">>>>> fromObjectToXML - begin. ExecutionContext=" + executionContext + ". OperationInfo=" + op);
        MessageContext context = new MessageContext();
        OutMessage message = new OutMessage("");
        message.setBody((Object)args);
        message.setChannel(this.client.getOutChannel());
        message.setSoapVersion((SoapVersion)Soap11.getInstance());
        context.setService(this.client.getService());
        context.setXFire(this.client.getXFire());
        context.setBinding(this.binding);
        context.setProperty("client.mode", (Object)Boolean.TRUE);
        context.setClient(this.client);
        context.setProperty(CONTEXT_KEY, (Object)this);
        context.setCurrentMessage((AbstractMessage)message);
        org.codehaus.xfire.exchange.MessageExchange exchange = new org.codehaus.xfire.exchange.MessageExchange(context);
        exchange.setOperation(op);
        exchange.setOutMessage(message);
        SoapSerializer soapSerializer = new SoapSerializer(this.binding.getSerializer());
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            writer = factory.createXMLStreamWriter(BAOS);
        }
        catch (XMLStreamException e) {
            Object[] params = new Object[]{factory};
            LOG.error("CRB000717_Unable_to_create_writer_with_factory", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000717_Unable_to_create_writer_with_factory", params, e);
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.consumerServiceDescriptor.getServerCorbaClassesHolder().getUrlClassLoader());
        try {
            soapSerializer.writeMessage(message, writer, context);
        }
        catch (Exception e) {
            Object[] params = new Object[]{message, soapSerializer, context, writer};
            LOG.error("CRB000718_Unable_to_write_message", params, e);
            throw new Jbi4CorbaRuntimeException("CRB000718_Unable_to_write_message", params, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        String stringResult = BAOS.toString();
        LOG.debug("deserialized xml message: " + stringResult);
        StringSource source = new StringSource(stringResult);
        Node result = null;
        try {
            result = this.sourceTransformer.toDOMNode(source);
        }
        catch (Exception e) {
            LOG.error("error creating node: " + source, e);
            throw new Jbi4CorbaRuntimeException("error creating node: " + source, e);
        }
        executionContext.setInParameters(args);
        executionContext.setXfireContext(context);
        executionContext.setXfireInMessage(message);
        executionContext.setSoapSerializer(soapSerializer);
        return result;
    }

    protected InOut createInOutExchange() {
        InOut exchange;
        DeliveryChannel channel;
        ComponentContext context = RuntimeContext.getInstance().getComponentContext();
        LOG.debug("Component context class:" + context.getClass().getName());
        try {
            channel = context.getDeliveryChannel();
            LOG.debug("Channel:" + channel.getClass().getName());
        }
        catch (MessagingException e) {
            Object[] args = new Object[]{context};
            LOG.error("CRB000719_Unable_to_get_delivery_channel_from_context", args, e);
            throw new Jbi4CorbaRuntimeException("CRB000719_Unable_to_get_delivery_channel_from_context", args, e);
        }
        MessageExchangeFactory factory = channel.createExchangeFactory();
        try {
            exchange = factory.createInOutExchange();
        }
        catch (MessagingException e) {
            Object[] args = new Object[]{factory};
            LOG.error("CRB000720_Unable_to_create_exchange_from_factory", args, e);
            throw new Jbi4CorbaRuntimeException("CRB000720_Unable_to_create_exchange_from_factory", args, e);
        }
        return exchange;
    }

    protected InOnly createInOnlyExchange() {
        InOnly exchange;
        DeliveryChannel channel;
        ComponentContext context = RuntimeContext.getInstance().getComponentContext();
        LOG.debug("Component context class:" + context.getClass().getName());
        try {
            channel = context.getDeliveryChannel();
            LOG.debug("Channel:" + channel.getClass().getName());
        }
        catch (MessagingException e) {
            Object[] args = new Object[]{context};
            LOG.error("CRB000719_Unable_to_get_delivery_channel_from_context", args, e);
            throw new Jbi4CorbaRuntimeException("CRB000719_Unable_to_get_delivery_channel_from_context", args, e);
        }
        MessageExchangeFactory factory = channel.createExchangeFactory();
        try {
            exchange = factory.createInOnlyExchange();
        }
        catch (MessagingException e) {
            Object[] args = new Object[]{factory};
            LOG.error("CRB000720_Unable_to_create_exchange_from_factory", args, e);
            throw new Jbi4CorbaRuntimeException("CRB000720_Unable_to_create_exchange_from_factory", args, e);
        }
        return exchange;
    }

    public void process(MessageExchange exchange) throws Exception {
        LOG.debug(">>>>> process - begin. MessageExchange=" + exchange);
        if (IN_ONLY.equals(exchange.getPattern())) {
            this.processInOnly(exchange);
        } else if (IN_OUT.equals(exchange.getPattern())) {
            this.processInOut(exchange);
        } else {
            Object[] args = new Object[]{exchange.getPattern(), exchange.getStatus(), exchange.getExchangeId()};
            LOG.error("CRB000740_ConsumerUnsupportedMep", args);
            throw new Jbi4CorbaException("CRB000740_ConsumerUnsupportedMep", args);
        }
        LOG.debug("<<<<< process - end");
    }

    protected void processInOnly(MessageExchange exchange) throws Jbi4CorbaException {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            LOG.debug("PROCESS_OK[Pattern=InOnly; Status=Done]");
        } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Object[] args = new Object[]{exchange.getExchangeId()};
            LOG.error("CRB000737_ExchangeProcessorConsumerInOnlyError", args);
        } else if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            Object[] args = new Object[]{"Active", exchange.getExchangeId()};
            LOG.error("CRB000738_ExchangeProcessorConsumerInOnlyUnexpectedStatus", args);
            throw new Jbi4CorbaException("CRB000738_ExchangeProcessorConsumerInOnlyUnexpectedStatus", args);
        }
    }

    protected void processInOut(MessageExchange exchange) throws Jbi4CorbaException {
        Object[] args = new Object[]{exchange.getStatus(), exchange.getExchangeId()};
        LOG.error("CRB000739_UnexpectedExchangeProcessorForConsumerInOutMep", args);
        throw new Jbi4CorbaException("CRB000739_UnexpectedExchangeProcessorForConsumerInOutMep", args);
    }

    public static class ExecutionContext {
        private MessageContext xfireContext;
        private OperationInfo operationInfo;
        private Object[] inParameters;
        private OutMessage xfireInMessage;
        private NormalizedMessage jbiInMessage;
        private InMessage xfireOutMessage;
        private NormalizedMessage jbiOutMessage;
        private Object outResult;
        private MessageExchange jbiExchange;
        private SoapSerializer soapSerializer;

        public SoapSerializer getSoapSerializer() {
            return this.soapSerializer;
        }

        public void setSoapSerializer(SoapSerializer soapSerializer) {
            this.soapSerializer = soapSerializer;
        }

        public Object[] getInParameters() {
            return this.inParameters;
        }

        public void setInParameters(Object[] inParameters) {
            this.inParameters = inParameters;
        }

        public MessageExchange getJbiExchange() {
            return this.jbiExchange;
        }

        public void setJbiExchange(MessageExchange jbiExchange) {
            this.jbiExchange = jbiExchange;
        }

        public NormalizedMessage getJbiInMessage() {
            return this.jbiInMessage;
        }

        public void setJbiInMessage(NormalizedMessage jbiInMessage) {
            this.jbiInMessage = jbiInMessage;
        }

        public NormalizedMessage getJbiOutMessage() {
            return this.jbiOutMessage;
        }

        public void setJbiOutMessage(NormalizedMessage jbiOutMessage) {
            this.jbiOutMessage = jbiOutMessage;
        }

        public OperationInfo getOperationInfo() {
            return this.operationInfo;
        }

        public void setOperationInfo(OperationInfo operationInfo) {
            this.operationInfo = operationInfo;
        }

        public Object getOutResult() {
            return this.outResult;
        }

        public void setOutResult(Object outResult) {
            this.outResult = outResult;
        }

        public MessageContext getXfireContext() {
            return this.xfireContext;
        }

        public void setXfireContext(MessageContext xfireContext) {
            this.xfireContext = xfireContext;
        }

        public OutMessage getXfireInMessage() {
            return this.xfireInMessage;
        }

        public void setXfireInMessage(OutMessage xfireInMessage) {
            this.xfireInMessage = xfireInMessage;
        }

        public InMessage getXfireOutMessage() {
            return this.xfireOutMessage;
        }

        public void setXfireOutMessage(InMessage xfireOutMessage) {
            this.xfireOutMessage = xfireOutMessage;
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }
}

