/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.xfire;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.Messages;
import it.imolinfo.jbi4corba.jbi.processor.transform.SourceTransformer;
import it.imolinfo.jbi4corba.jbi.xfire.JbiTransport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Transport;

public class JbiChannel
extends AbstractChannel {
    public static final String JBI_INTERFACE_NAME = "jbi.interface";
    public static final String JBI_SERVICE_NAME = "jbi.service";
    public static final String JBI_ENDPOINT = "jbi.endpoint";
    private static final Logger LOG = LoggerFactory.getLogger(JbiChannel.class);
    private static final Messages MESSAGES = Messages.getMessages(JbiChannel.class);
    private SourceTransformer sourceTransformer;
    private XMLOutputFactory outputFactory;

    public JbiChannel(String uri, JbiTransport transport) {
        this.setTransport((Transport)transport);
        this.setUri(uri);
        this.sourceTransformer = new SourceTransformer();
        this.outputFactory = XMLOutputFactory.newInstance();
    }

    public void open() throws Exception {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if ("urn:xfire:channel:backchannel".equals(message.getUri())) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                try {
                    XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(out, message.getEncoding());
                    message.getSerializer().writeMessage(message, writer, context);
                    writer.close();
                }
                catch (XMLStreamException e) {
                    LOG.error(e.getMessage(), e);
                    throw new XFireException(MESSAGES.getString("CRB000400_Error_closing_output_stream", new Object[0]), (Throwable)e);
                }
                return;
            }
        } else {
            try {
                DeliveryChannel channel = ((JbiTransport)this.getTransport()).getContext().getDeliveryChannel();
                MessageExchangeFactory factory = channel.createExchangeFactory();
                if (context.getExchange().hasOutMessage()) {
                    InOut me = factory.createInOutExchange();
                    me.setInterfaceName((QName)context.getService().getProperty(JBI_INTERFACE_NAME));
                    me.setService((QName)context.getService().getProperty(JBI_SERVICE_NAME));
                    me.setEndpoint((ServiceEndpoint)context.getService().getProperty(JBI_ENDPOINT));
                    NormalizedMessage msg = me.createMessage();
                    me.setInMessage(msg);
                    msg.setContent(this.getContent(context, message));
                    if (!channel.sendSync((MessageExchange)me)) {
                        throw new XFireException(MESSAGES.getString("CRB000401_Unable_to_send_jbi_exchange", new Object[0]));
                    }
                    if (me.getStatus() == ExchangeStatus.ERROR) {
                        me.setStatus(ExchangeStatus.DONE);
                        channel.send((MessageExchange)me);
                        if (me.getError() != null) {
                            throw new XFireFault((Throwable)me.getError(), XFireFault.RECEIVER);
                        }
                        if (me.getFault() != null) {
                            throw new XFireFault(MESSAGES.getString("CRB000402_Fault_received", new Object[0]), XFireFault.RECEIVER);
                        }
                        throw new XFireFault(MESSAGES.getString("CRB000403_Unknown_error", new Object[0]), XFireFault.RECEIVER);
                    }
                    Source outSrc = me.getOutMessage().getContent();
                    me.setStatus(ExchangeStatus.DONE);
                    channel.send((MessageExchange)me);
                    InMessage inMessage = new InMessage(this.sourceTransformer.toXMLStreamReader(outSrc), this.getUri());
                    this.getEndpoint().onReceive(context, inMessage);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
                throw new XFireException(MESSAGES.getString("CRB000404_Error_sending_jbi_exchange", new Object[0]), (Throwable)e);
            }
        }
    }

    protected Source getContent(MessageContext context, OutMessage message) throws XMLStreamException, IOException, XFireException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(outStream, message.getEncoding());
        MessageSerializer serializer = context.getOutMessage().getSerializer();
        if (serializer == null) {
            AbstractSoapBinding binding = (AbstractSoapBinding)context.getBinding();
            if (binding == null) {
                throw new XFireException(MESSAGES.getString("CRB000405_Could_not_find_the_binding", new Object[0]));
            }
            serializer = AbstractSoapBinding.getSerializer((String)binding.getStyle(), (String)binding.getUse());
        }
        serializer.writeMessage(message, writer, context);
        writer.close();
        outStream.close();
        StreamSource src = new StreamSource(new ByteArrayInputStream(outStream.toByteArray()));
        return src;
    }
}

