/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.processor;

import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperParser;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.JbiMessage;
import java.util.Iterator;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDenormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDenormalizer.class);
    private WrapperParser wrapperParser = null;
    private Transformer mTrans = null;

    public MessageDenormalizer() throws Jbi4CorbaException {
        try {
            this.wrapperParser = HelperFactory.createParser();
        }
        catch (WrapperProcessingException ex) {
            throw new Jbi4CorbaException("Failed to create WrapperParser", ex);
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            this.mTrans = factory.newTransformer();
        }
        catch (TransformerFactoryConfigurationError ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(ex);
        }
        catch (TransformerConfigurationException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(e);
        }
    }

    public JbiMessage denormalize(NormalizedMessage normalizedMessage, Jbi4CorbaEndpoint endpoint, QName operation, boolean isInput) throws Jbi4CorbaException {
        try {
            Service service = endpoint.getDefinition().getService(endpoint.getServiceName());
            Port port = service.getPort(QName.valueOf(endpoint.getEndpointName()).getLocalPart());
            PortType portType = port.getBinding().getPortType();
            Iterator it = portType.getOperations().iterator();
            Message wsdlMessage = null;
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                if (!op.getName().equals(operation.toString()) && !op.getName().equals(operation.getLocalPart())) continue;
                if (isInput) {
                    wsdlMessage = op.getInput().getMessage();
                    continue;
                }
                wsdlMessage = op.getOutput().getMessage();
            }
            DOMResult result = new DOMResult();
            Source src = normalizedMessage.getContent();
            if (src != null) {
                TransformerFactory fact = TransformerFactory.newInstance();
                Transformer transformer = fact.newTransformer();
                transformer.transform(src, result);
            }
            Node node = result.getNode();
            Document normalizedDoc = null;
            normalizedDoc = node instanceof Document ? (Document)node : ((Element)node).getOwnerDocument();
            this.wrapperParser.parse(normalizedDoc, endpoint.getDefinition());
            Source source = normalizedMessage.getContent();
            if (source instanceof DOMSource) {
                node = ((DOMSource)source).getNode();
            } else {
                DOMResult domResult = new DOMResult();
                this.mTrans.transform(source, domResult);
                node = domResult.getNode();
            }
            JbiMessage jbiMessage = this.denormalizeNode(node, wsdlMessage);
            return jbiMessage;
        }
        catch (TransformerException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(ex);
        }
        catch (WrapperProcessingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(ex);
        }
    }

    public JbiMessage denormalize(Node node, Jbi4CorbaEndpoint endpoint, QName operation, boolean isInput) throws Jbi4CorbaException {
        Service service = endpoint.getDefinition().getService(endpoint.getServiceName());
        Port port = service.getPort(QName.valueOf(endpoint.getEndpointName()).getLocalPart());
        PortType portType = port.getBinding().getPortType();
        Iterator it = portType.getOperations().iterator();
        Message wsdlMessage = null;
        while (it.hasNext()) {
            Operation op = (Operation)it.next();
            if (!op.getName().equals(operation.toString()) && !op.getName().equals(operation.getLocalPart())) continue;
            if (isInput) {
                wsdlMessage = op.getInput().getMessage();
                continue;
            }
            wsdlMessage = op.getOutput().getMessage();
        }
        JbiMessage jbiMessage = this.denormalizeNode(node, wsdlMessage);
        return jbiMessage;
    }

    private JbiMessage denormalizeNode(Node node, Message wsdlMessage) throws Jbi4CorbaException {
        try {
            if (node instanceof Document) {
                this.wrapperParser.parse((Document)node, wsdlMessage);
            } else {
                this.wrapperParser.parse(node.getOwnerDocument(), wsdlMessage);
            }
            if (this.wrapperParser.getNoOfParts() != 0) {
                String[] partNames = this.wrapperParser.getPartNames();
                NodeList nodes = this.wrapperParser.getPartNodes(partNames[0]);
                if (nodes == null || nodes.getLength() == 0) {
                    throw new Jbi4CorbaException("Unable to find valid part during denormalization");
                }
                return new JbiMessage(new DOMSource(nodes.item(0)), true);
            }
            return new JbiMessage(new DOMSource((Document)node), false);
        }
        catch (WrapperProcessingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(ex);
        }
    }
}

