/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.endpoint;

import com.sun.jbi.eManager.provider.EndpointStatus;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.jbi.component.Jbi4CorbaSUManager;
import it.imolinfo.jbi4corba.jbi.processor.ExchangeProcessor;
import java.io.File;
import java.io.Serializable;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public abstract class Jbi4CorbaEndpoint
implements Serializable {
    public static final int SHUTDOWN = 0;
    public static final int STOPPED = 1;
    public static final int RUNNING = 2;
    private QName serviceName = null;
    private String endpointName = null;
    private Definition definition;
    private int state;
    private EndpointStatus endpointStatus = null;
    private ServiceEndpoint serviceEndpoint = null;
    private Document serviceDescription = null;
    private String suName = null;
    private Jbi4CorbaSUManager suManager = null;
    private ExchangeProcessor exchangeProcessor = null;
    private File endpointWSDL = null;

    public Jbi4CorbaEndpoint() {
    }

    public Jbi4CorbaEndpoint(QName serviceName, String endpointName) {
        this.serviceName = serviceName;
        this.endpointName = endpointName;
    }

    public String getUniqueName() {
        if (this.serviceName != null && this.endpointName != null) {
            return this.serviceName + "," + this.endpointName;
        }
        return null;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public EndpointStatus getEndpointStatus() {
        return this.endpointStatus;
    }

    public void setEndpointStatus(EndpointStatus endpointStatus) {
        this.endpointStatus = endpointStatus;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public Document getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(Document serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public String getSuName() {
        return this.suName;
    }

    public void setSuName(String suName) {
        this.suName = suName;
    }

    public Jbi4CorbaSUManager getSuManager() {
        return this.suManager;
    }

    public void setSuManager(Jbi4CorbaSUManager suManager) {
        this.suManager = suManager;
    }

    public ExchangeProcessor getExchangeProcessor() {
        return this.exchangeProcessor;
    }

    public void setExchangeProcessor(ExchangeProcessor exchangeProcessor) {
        this.exchangeProcessor = exchangeProcessor;
    }

    public File getEndpointWSDL() {
        return this.endpointWSDL;
    }

    public void setEndpointWSDL(File endpointWSDL) {
        this.endpointWSDL = endpointWSDL;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Jbi4CorbaEndpoint) {
            Jbi4CorbaEndpoint c = (Jbi4CorbaEndpoint)obj;
            if (this.serviceName.equals(c.serviceName) && this.endpointName.equals(c.endpointName) && this.getRole().equals(c.getRole())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.serviceName.hashCode() ^ this.endpointName.hashCode() ^ this.getRole().hashCode();
    }

    public String toString() {
        return this.serviceName + ":" + this.endpointName + "/" + (this.getRole().equals(MessageExchange.Role.PROVIDER) ? "PROVIDER" : "CONSUMER");
    }

    public abstract void registerService() throws Jbi4CorbaException;

    public abstract void unregisterService() throws Jbi4CorbaException;

    public abstract void validate() throws Jbi4CorbaException;

    public abstract void activate() throws Jbi4CorbaException;

    public abstract MessageExchange.Role getRole();
}

