/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.component;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import com.sun.jbi.management.descriptor.ConfigurationException;
import com.sun.jbi.management.descriptor.EndpointIdentifier;
import com.sun.jbi.management.descriptor.SUDescriptorSupport;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaDeployException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.jbi.JbiServiceDescriptor;
import it.imolinfo.jbi4corba.jbi.Messages;
import it.imolinfo.jbi4corba.jbi.component.Jbi4CorbaLifeCycle;
import it.imolinfo.jbi4corba.jbi.component.runtime.ComponentRuntime;
import it.imolinfo.jbi4corba.jbi.component.runtime.DefaultServiceUnitManager;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeHelper;
import it.imolinfo.jbi4corba.jbi.endpoint.ConsumerEndpoint;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.endpoint.ProviderEndpoint;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaAddress;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaBinding;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaExtension;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaExtensionUtils;
import it.imolinfo.jbi4corba.webservice.descriptor.ConsumerServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.generator.ClientCorbaClassesHolder;
import it.imolinfo.jbi4corba.webservice.generator.ProviderServiceClassesGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jbi4CorbaSUManager
extends DefaultServiceUnitManager {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CorbaSUManager.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4CorbaSUManager.class);
    private List<Jbi4CorbaEndpoint> deployedEndpoints = new ArrayList<Jbi4CorbaEndpoint>();
    private List<Jbi4CorbaEndpoint> activatedEndpoints = new ArrayList<Jbi4CorbaEndpoint>();
    private Jbi4CorbaLifeCycle lifeCycle = null;

    public Jbi4CorbaSUManager(ComponentRuntime ctx) {
        super(ctx);
        this.lifeCycle = (Jbi4CorbaLifeCycle)ctx.getLifeCycle();
    }

    @Override
    public String deploy(String suName, String suZipPath) throws DeploymentException {
        String taskName = "deploy";
        boolean isSuccess = true;
        LOG.info("Deploying the su " + suName + " in the SA:" + suZipPath);
        String retMsg = this.createComponentTaskResultXML("deploy", isSuccess);
        LOG.info("********************************************************");
        LOG.info("Logger: " + LOG.getClass().getName());
        LOG.info("Logger Factory: " + LoggerFactory.class.getName());
        LOG.info("********************************************************");
        return retMsg;
    }

    @Override
    public void start(String serviceUnitName) throws DeploymentException {
        LOG.info("Starting the serviceUnit: " + serviceUnitName);
        LOG.info("Deployed Endpoints number: " + this.deployedEndpoints.size());
        for (Jbi4CorbaEndpoint endpoint : this.deployedEndpoints) {
            LOG.debug("endpoint.getSuName():" + endpoint.getSuName());
            if (!endpoint.getSuName().equals(serviceUnitName)) continue;
            try {
                LOG.debug("Registering the service: " + endpoint.getServiceName());
                endpoint.registerService();
                endpoint.activate();
                LOG.debug("Activating the service for the bus: " + endpoint.getServiceName());
                this.activateEndpoint(endpoint);
                this.activatedEndpoints.add(endpoint);
            }
            catch (Jbi4CorbaException e) {
                LOG.error(e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    @Override
    public String undeploy(String serviceUnitName, String suZipPath) throws DeploymentException {
        String taskName = "undeploy";
        boolean isSuccess = true;
        String retMsg = this.createComponentTaskResultXML("undeploy", isSuccess);
        return retMsg;
    }

    @Override
    public void stop(String serviceUnitName) throws DeploymentException {
        ArrayList<Jbi4CorbaEndpoint> endpointsToRemove = new ArrayList<Jbi4CorbaEndpoint>();
        for (Jbi4CorbaEndpoint corbaEndpoint : this.activatedEndpoints) {
            if (!corbaEndpoint.getSuName().equals(serviceUnitName)) continue;
            try {
                corbaEndpoint.unregisterService();
                this.deactivateEndpoint(corbaEndpoint);
                endpointsToRemove.add(corbaEndpoint);
            }
            catch (Jbi4CorbaException e) {
                LOG.error(e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
        }
        this.activatedEndpoints.removeAll(endpointsToRemove);
    }

    @Override
    public void init(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        this.deployedEndpoints.addAll(this.processDeploy(serviceUnitName, serviceUnitRootPath));
        LOG.info("Init: do nothing");
    }

    @Override
    public void shutDown(String serviceUnitName) throws DeploymentException {
        ArrayList<Jbi4CorbaEndpoint> deployedEndpointsToRemove = new ArrayList<Jbi4CorbaEndpoint>();
        for (Jbi4CorbaEndpoint corbaEndpoint : this.deployedEndpoints) {
            if (!corbaEndpoint.getSuName().equals(serviceUnitName)) continue;
            deployedEndpointsToRemove.add(corbaEndpoint);
        }
        this.deployedEndpoints.removeAll(deployedEndpointsToRemove);
    }

    public Jbi4CorbaEndpoint getStartedEndpoint(ServiceEndpoint endpoint) {
        for (Jbi4CorbaEndpoint corbaEndpoint : this.activatedEndpoints) {
            if (!corbaEndpoint.getServiceName().equals(endpoint.getServiceName()) || !corbaEndpoint.getEndpointName().equals(endpoint.getEndpointName())) continue;
            return corbaEndpoint;
        }
        return null;
    }

    private List<Jbi4CorbaEndpoint> processDeploy(String suName, String suZipPath) throws DeploymentException {
        File suDir = new File(suZipPath);
        LOG.debug("The SU dir path is: " + suDir.getAbsolutePath());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error(ex.getMessage());
            throw new DeploymentException((Throwable)ex);
        }
        FileToDefinitionInfo[] fileToDefs = this.readAllDefinitions(suDir);
        ArrayList<Jbi4CorbaEndpoint> endpoints = new ArrayList<Jbi4CorbaEndpoint>();
        LOG.info("About to parse jbi.xml to resolve service end point in path:" + suDir.getAbsolutePath());
        EndpointIdentifier[] svcs = null;
        SUDescriptorSupport descSupport = null;
        try {
            descSupport = new SUDescriptorSupport(suDir.getAbsolutePath());
            svcs = descSupport.getServices();
        }
        catch (ConfigurationException ex) {
            LOG.error(ex.getMessage());
            throw new DeploymentException((Throwable)ex);
        }
        int len = svcs.length;
        LOG.info("Found " + svcs.length + " endpoint declared in the jbi.xml");
        for (int i = 0; i < len; ++i) {
            Document result;
            Definition matchedDef = null;
            File matchedWSDL = null;
            Jbi4CorbaBinding corbaBinding = null;
            Jbi4CorbaAddress corbaAddress = null;
            EndpointIdentifier epDesc = svcs[i];
            for (FileToDefinitionInfo element : fileToDefs) {
                corbaBinding = Jbi4CorbaExtensionUtils.getCorbaBinding(element.getDefinition(), epDesc.getServiceName().toString(), epDesc.getEndpointName());
                if (corbaBinding == null) continue;
                matchedDef = element.getDefinition();
                matchedWSDL = element.getFile();
                break;
            }
            if (corbaBinding == null) continue;
            corbaAddress = Jbi4CorbaExtensionUtils.getCorbaAddress(matchedDef, epDesc.getServiceName().toString(), epDesc.getEndpointName());
            if (corbaAddress == null) {
                String msg = "No address found!";
                throw new DeploymentException(msg);
            }
            String endpoint = epDesc.getEndpointName();
            String endpointNameLocalPart = QName.valueOf(endpoint).getLocalPart();
            Jbi4CorbaEndpoint corbaEndpoint = null;
            Binding binding = Jbi4CorbaExtensionUtils.getBinding(matchedDef, epDesc.getServiceName().toString(), epDesc.getEndpointName());
            Service service = Jbi4CorbaExtensionUtils.getService(matchedDef, epDesc.getServiceName().toString());
            PortType portType = Jbi4CorbaExtensionUtils.getPortType(matchedDef, epDesc.getServiceName().toString(), epDesc.getEndpointName());
            String role = epDesc.isProvider() ? "provider" : "consumer";
            JbiServiceDescriptor jbiServiceDescriptor = this.createServiceDescriptor(service, binding, portType, corbaAddress, corbaBinding, role, suZipPath);
            File rootDir = new File(suZipPath + "/" + jbiServiceDescriptor.hashCode());
            boolean resultMk = rootDir.mkdir();
            if (!resultMk) {
                throw new DeploymentException(MESSAGES.getString("CRB000201_Unable_to_create_working_directory", rootDir.getAbsolutePath()));
            }
            LOG.debug("created working directory:" + rootDir.getAbsolutePath());
            if (epDesc.isProvider()) {
                ProviderServiceClassesGenerator serviceClassesGenerator = new ProviderServiceClassesGenerator();
                List<ProviderServiceDescriptor> serviceDescriptors = null;
                try {
                    serviceDescriptors = this.getProviderServiceDescriptor(jbiServiceDescriptor, suZipPath, serviceClassesGenerator, rootDir);
                }
                catch (ClassGenerationException e) {
                    String msg = MESSAGES.getString("CRB000202_Error_creating_services_from_service_descriptor", e.getMessage());
                    LOG.error(msg, e);
                    throw new DeploymentException(msg, (Throwable)e);
                }
                ProviderServiceDescriptor providerServiceDescriptor = serviceDescriptors.get(0);
                try {
                    corbaEndpoint = new ProviderEndpoint(epDesc.getServiceName(), endpointNameLocalPart, providerServiceDescriptor);
                }
                catch (Jbi4CorbaException e1) {
                    LOG.error(e1.getMessage());
                    throw new DeploymentException((Throwable)e1);
                }
            }
            ConsumerServiceDescriptor consumerServiceDescriptor = this.getConsumerServiceDescriptor(epDesc, jbiServiceDescriptor, rootDir);
            consumerServiceDescriptor.setServiceWSDLDefinition(matchedDef);
            corbaEndpoint = new ConsumerEndpoint(epDesc.getServiceName(), endpointNameLocalPart, consumerServiceDescriptor);
            corbaEndpoint.setDefinition(matchedDef);
            corbaEndpoint.setState(0);
            corbaEndpoint.setSuName(suName);
            corbaEndpoint.setSuManager(this);
            corbaEndpoint.setEndpointWSDL(matchedWSDL);
            LOG.info("Parses the matched WSDL");
            try {
                result = documentBuilder.parse(matchedWSDL);
            }
            catch (SAXException e) {
                LOG.error("Error in parsing the deploy WSDL:" + e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Error in parsing the deploy WSDL: " + e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
            if (corbaEndpoint == null) continue;
            corbaEndpoint.setServiceDescription(result);
            endpoints.add(corbaEndpoint);
        }
        return endpoints;
    }

    private void activateEndpoint(Jbi4CorbaEndpoint endpoint) throws Jbi4CorbaDeployException {
        LOG.info("Activating endpoint: " + endpoint.getUniqueName());
        if (this.activatedEndpoints.indexOf(endpoint) != -1) {
            String msg = "Failed to deploy endpoint: " + endpoint.getUniqueName() + ": endpoint already registered";
            throw new Jbi4CorbaDeployException(msg);
        }
        try {
            QName serviceName = endpoint.getServiceName();
            ServiceEndpoint serviceEndpoint = RuntimeHelper.getComponentContext().activateEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
            endpoint.setServiceEndpoint(serviceEndpoint);
            LOG.info("Endpoint " + serviceName + " activated");
            endpoint.setState(2);
        }
        catch (JBIException me) {
            String msg = "Cannot activate endpoint " + endpoint.getServiceName() + ", reason: " + me.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaDeployException(msg);
        }
    }

    public void deactivateEndpoint(Jbi4CorbaEndpoint endpoint) throws Jbi4CorbaDeployException {
        LOG.info("Deactivating endpoint: " + endpoint.getUniqueName());
        if (!this.activatedEndpoints.contains(endpoint)) {
            LOG.error("The endpoint " + endpoint.getUniqueName() + " is not active: cannot deactivate");
        } else {
            try {
                RuntimeHelper.getComponentContext().deactivateEndpoint(endpoint.getServiceEndpoint());
                LOG.info("Endpoint " + endpoint.getServiceEndpoint() + " deactivated");
                endpoint.setState(1);
            }
            catch (JBIException me) {
                String msg = "Cannot deactivate endpoint " + endpoint.getServiceName() + ", reason: " + me.getMessage();
                LOG.error(msg);
                throw new Jbi4CorbaDeployException(msg);
            }
        }
    }

    private List<File> listWSDLFiles(File currentDir) {
        File[] filesInCurrentDir;
        ArrayList<File> cumulativeResults = new ArrayList<File>();
        for (File element : filesInCurrentDir = currentDir.listFiles()) {
            if (element.isFile()) {
                if (!element.getName().toLowerCase().endsWith(".wsdl")) continue;
                cumulativeResults.add(element);
                continue;
            }
            if (!element.isDirectory()) continue;
            List<File> wsdlsInSubDirectories = this.listWSDLFiles(element);
            cumulativeResults.addAll(wsdlsInSubDirectories);
        }
        return cumulativeResults;
    }

    FileToDefinitionInfo[] readAllDefinitions(File dir) throws DeploymentException {
        List<File> wsdls = this.listWSDLFiles(dir);
        File[] wsdlFiles = wsdls.toArray(new File[0]);
        FileToDefinitionInfo[] fileToDefs = null;
        if (wsdlFiles != null) {
            fileToDefs = new FileToDefinitionInfo[wsdlFiles.length];
            for (int i = 0; i < wsdlFiles.length; ++i) {
                Definition def;
                try {
                    def = Jbi4CorbaSUManager.readWsdl(wsdlFiles[i]);
                }
                catch (WSDLException e) {
                    LOG.error(e.getMessage());
                    throw new DeploymentException((Throwable)e);
                }
                fileToDefs[i] = new FileToDefinitionInfo(wsdlFiles[i], def);
            }
        }
        return fileToDefs;
    }

    public static Definition readWsdl(File f) throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        WSDLReader reader = ((WSDLFactoryImpl)wsdlFactory).newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Jbi4CorbaExtension.register(registry);
        LOG.debug("Extension QName: uri://schemas.imola.it/jbi/wsdl-extensions/corba/");
        reader.setExtensionRegistry(registry);
        Definition def = reader.readWSDL(f.getAbsolutePath());
        return def;
    }

    public Jbi4CorbaLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(Jbi4CorbaLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public List<Jbi4CorbaEndpoint> getDeployedEndpoints() {
        return this.deployedEndpoints;
    }

    protected JbiServiceDescriptor createServiceDescriptor(Service service, Binding binding, PortType portType, Jbi4CorbaAddress addressExtension, Jbi4CorbaBinding bindingExtension, String role, String rootPath) throws DeploymentException {
        JbiServiceDescriptor serviceDescriptor = new JbiServiceDescriptor();
        LOG.debug("Creating a JbiServiceDescriptor ... ");
        if ("provider".equals(role)) {
            String idlFileName = binding.getQName().getLocalPart() + ".idl";
            LOG.debug("Binding local part: " + binding.getQName().getLocalPart());
            LOG.debug("IdlFileName: " + idlFileName);
            String idlAbsoluteFileName = rootPath + File.separator + idlFileName;
            String idl = bindingExtension.getIdl();
            LOG.info("CRB000203_Producing_idl_file_to", idlAbsoluteFileName);
            try {
                FileWriter fr = new FileWriter(idlAbsoluteFileName);
                fr.write(idl);
                fr.close();
            }
            catch (IOException e) {
                String msg = MESSAGES.getString("CRB000204_Unable_to_open_filename", idlAbsoluteFileName, e.getMessage());
                LOG.error(msg, e);
                throw new DeploymentException(msg, (Throwable)e);
            }
            serviceDescriptor.setIdlFileName(idlFileName);
            serviceDescriptor.setIdlFileNameDirectory(rootPath);
            serviceDescriptor.setServiceNameSpace(service.getQName().getNamespaceURI());
            serviceDescriptor.setLocalizationType(addressExtension.getLocalizationType());
            serviceDescriptor.setLocalizationType(addressExtension.getCorbaUrl());
            serviceDescriptor.setOrbProperties(addressExtension.getOrbProperties());
            serviceDescriptor.setPortTypeName(portType.getQName());
        } else if (!"consumer".equals(role)) {
            LOG.error("CRB000205_Invalid_role=", role);
            throw new DeploymentException(MESSAGES.getString("CRB000205_Invalid_role=", role));
        }
        serviceDescriptor.setRole(role);
        serviceDescriptor.setServiceNameSpace(service.getQName().getNamespaceURI());
        serviceDescriptor.setServiceName(service.getQName().getLocalPart());
        serviceDescriptor.setCorbaServiceName(addressExtension.getName());
        serviceDescriptor.setLocalizationType(addressExtension.getLocalizationType());
        serviceDescriptor.setCorbaUrl(addressExtension.getCorbaUrl());
        serviceDescriptor.setOrbProperties(addressExtension.getOrbProperties());
        LOG.debug("Created a JbiServiceDescriptor=" + serviceDescriptor);
        return serviceDescriptor;
    }

    private List<ProviderServiceDescriptor> getProviderServiceDescriptor(JbiServiceDescriptor jbiServiceDescriptor, String serviceUnitRootPath, ProviderServiceClassesGenerator serviceClassesGenerator, File rootDir) throws ClassGenerationException, DeploymentException {
        jbiServiceDescriptor.setIdlFileNameDirectory(serviceUnitRootPath);
        List<ClientCorbaClassesHolder> classes = serviceClassesGenerator.generateProviderServiceClasses(jbiServiceDescriptor, rootDir.getAbsolutePath(), RuntimeContext.getInstance().getComponentContext().getInstallRoot());
        ArrayList<ProviderServiceDescriptor> providerServiceDescriptorList = new ArrayList<ProviderServiceDescriptor>();
        for (ClientCorbaClassesHolder corbaClasses : classes) {
            LOG.debug("ClientCorbaClassesHolder=" + corbaClasses);
            ProviderServiceDescriptor providerServiceDescriptor = new ProviderServiceDescriptor();
            providerServiceDescriptor.setValueTypeIdAndInstance(corbaClasses.getValueTypeIdAndInstance());
            providerServiceDescriptor.setServiceNameSpace(jbiServiceDescriptor.getServiceNameSpace());
            providerServiceDescriptor.setServiceInterface(corbaClasses.getOperationsClass());
            providerServiceDescriptor.setCorbaHelperClass(corbaClasses.getHelperClass());
            providerServiceDescriptor.setWsdlRootDirectory(serviceUnitRootPath);
            providerServiceDescriptor.setUrlClassLoader(serviceClassesGenerator.getUrlClassLoader());
            String serviceName = jbiServiceDescriptor.getServiceName();
            LOG.debug("ServiceName: " + serviceName);
            if (serviceName == null) {
                LOG.error("CRB000206_No_ServiceName_found");
                throw new DeploymentException(MESSAGES.getString("CRB000206_No_ServiceName_found", new Object[0]));
            }
            providerServiceDescriptor.setServiceName(serviceName);
            providerServiceDescriptor.setCorbaServiceName(jbiServiceDescriptor.getCorbaServiceName());
            LOG.debug("Provider CORBA name:" + providerServiceDescriptor.getCorbaServiceName());
            providerServiceDescriptor.setOrbProperties(jbiServiceDescriptor.getOrbProperties());
            providerServiceDescriptor.setLocalizationType(jbiServiceDescriptor.getLocalizationType());
            providerServiceDescriptor.setCorbaUrl(jbiServiceDescriptor.getCorbaUrl());
            providerServiceDescriptorList.add(providerServiceDescriptor);
        }
        return providerServiceDescriptorList;
    }

    private ConsumerServiceDescriptor getConsumerServiceDescriptor(EndpointIdentifier epDesc, JbiServiceDescriptor jbiServiceDescriptor, File rootDir) {
        ConsumerServiceDescriptor consumerServiceDescriptor = new ConsumerServiceDescriptor();
        consumerServiceDescriptor.setRootPath(rootDir.getAbsolutePath());
        consumerServiceDescriptor.setServiceName(jbiServiceDescriptor.getServiceName());
        consumerServiceDescriptor.setCorbaServiceName(jbiServiceDescriptor.getCorbaServiceName());
        LOG.debug("Consumer CORBA name:" + consumerServiceDescriptor.getCorbaServiceName());
        consumerServiceDescriptor.setOrbProperties(jbiServiceDescriptor.getOrbProperties());
        consumerServiceDescriptor.setLocalizationType(jbiServiceDescriptor.getLocalizationType());
        consumerServiceDescriptor.setTargetEndpoint(epDesc.getEndpointName());
        consumerServiceDescriptor.setTargetInterfaceName(epDesc.getInterfaceName());
        consumerServiceDescriptor.setTargetService(epDesc.getServiceName());
        return consumerServiceDescriptor;
    }

    static class FileToDefinitionInfo {
        private File mFile;
        private Definition mDefinition;

        FileToDefinitionInfo(File file, Definition definition) {
            this.mFile = file;
            this.mDefinition = definition;
        }

        public File getFile() {
            return this.mFile;
        }

        public Definition getDefinition() {
            return this.mDefinition;
        }
    }
}

