/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Utf8InputStreamConverter
extends InputStream {
    private String _targetEncoding = null;
    private InputStream _utf8Stream = null;

    public Utf8InputStreamConverter(InputStream utf8Stream, String targetEncoding) throws UnsupportedEncodingException {
        if (!targetEncoding.equals("US-ASCII")) {
            throw new UnsupportedEncodingException(targetEncoding);
        }
        this._targetEncoding = targetEncoding;
        this._utf8Stream = utf8Stream;
    }

    public int read() throws IOException {
        int theByte = this._utf8Stream.read();
        if (theByte > 127) {
            throw new IOException("Could not convert stream from UTF-8 to " + this._targetEncoding);
        }
        return theByte;
    }
}

