/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntList;
import org.axiondb.engine.rowcollection.IntHashMap;
import org.axiondb.util.BTreeMetaData;

abstract class BaseBTree {
    private IntList _childIds = null;
    private int _fileId = 0;
    private BTreeMetaData _metaData = null;
    private IntList _vals = null;

    protected BaseBTree(BTreeMetaData meta) throws IOException, ClassNotFoundException {
        this._metaData = meta;
        this.setValues((IntList)new ArrayIntList(this.getMinimizationFactor() - 1));
        this.setChildIds((IntList)new ArrayIntList(this.getMinimizationFactor()));
    }

    protected BaseBTree(File dir, String name, int minimizationFactor) throws IOException, ClassNotFoundException {
        this._metaData = new BTreeMetaData(dir, name, minimizationFactor, this);
        this.setValues((IntList)new ArrayIntList(this.getMinimizationFactor() - 1));
        this.setChildIds((IntList)new ArrayIntList(this.getMinimizationFactor()));
    }

    public abstract void save() throws IOException, ClassNotFoundException;

    public void save(File dataDirectory) throws IOException, ClassNotFoundException {
        this.getBTreeMetaData().setDataDirectory(dataDirectory);
        if (this.getBTreeMetaData().hasDirtyNodes()) {
            this.getBTreeMetaData().saveCounter();
        }
        IntHashMap.ValueIterator iter = this.getBTreeMetaData().getDirtyNodes();
        while (iter.hasNext()) {
            BaseBTree tree = (BaseBTree)iter.next();
            tree.write();
            iter.remove();
        }
    }

    public void saveAfterTruncate() throws IOException, ClassNotFoundException {
        this.getBTreeMetaData().setAllClean();
        this.save();
    }

    public abstract int size();

    public void truncate() {
        this.getValues().clear();
        this.getChildIds().clear();
    }

    protected final void addFileId(int fileId) {
        this.getChildIds().add(fileId);
        this.getBTreeMetaData().setDirty(this);
    }

    protected final void addFileId(int index, int fileid) {
        this.getChildIds().add(index, fileid);
        this.getBTreeMetaData().setDirty(this);
    }

    protected final void addFileIds(IntList fileIds) {
        this.getChildIds().addAll((IntCollection)fileIds);
        this.getBTreeMetaData().setDirty(this);
    }

    protected void clearData() {
        this.getValues().clear();
        this.getChildIds().clear();
        this.getBTreeMetaData().setDirty(this);
    }

    protected final BTreeMetaData getBTreeMetaData() {
        return this._metaData;
    }

    protected final IntList getChildIds() {
        return this._childIds;
    }

    protected final int getFileId() {
        return this._fileId;
    }

    protected final int getFileIdForIndex(int index) {
        return this.getChildIds().get(index);
    }

    protected final int getKeyCapacity() {
        return 2 * this.getMinimizationFactor() - 1;
    }

    protected final int getMinimizationFactor() {
        return this._metaData.getMinimizationFactor();
    }

    protected final int getValue(int index) {
        return this._vals.get(index);
    }

    protected final IntList getValues() {
        return this._vals;
    }

    protected final boolean isFull() {
        return this.size() == this.getKeyCapacity();
    }

    protected final boolean isLeaf() {
        return this.getChildIds().isEmpty();
    }

    protected final boolean isRoot() {
        return this._metaData.isRoot(this);
    }

    protected abstract void read() throws IOException, ClassNotFoundException;

    protected final void saveCounterIfRoot() throws IOException {
        if (this.isRoot()) {
            this._metaData.saveCounter();
        }
    }

    protected final void setChildIds(IntList childIds) {
        this._childIds = childIds;
    }

    protected final void setFileId(int fileId) {
        this._fileId = fileId;
    }

    protected final void setValue(int index, int val) {
        this._vals.set(index, val);
    }

    protected final void setValues(IntList vals) {
        this._vals = vals;
    }

    protected final String space(int n) {
        StringBuffer buf = new StringBuffer(0);
        for (int i = 0; i < n; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    protected abstract void write() throws IOException, ClassNotFoundException;
}

