/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class IntegerType
extends BaseNumberDataType {
    private static final long serialVersionUID = -2053752932959735929L;

    public int getJdbcType() {
        return 4;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Integer";
    }

    public int getPrecision() {
        return String.valueOf(Integer.MAX_VALUE).length();
    }

    public int getColumnDisplaySize() {
        return String.valueOf(Integer.MIN_VALUE).length();
    }

    public String toString() {
        return "integer";
    }

    public Object convert(Object value) throws AxionException {
        long rawValue = 0L;
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof BigDecimal) {
            rawValue = ((BigDecimal)value).longValue();
        } else if (value instanceof Number) {
            rawValue = ((Number)value).longValue();
        } else if (value instanceof String) {
            try {
                rawValue = new BigDecimal(value.toString().trim()).longValue();
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        } else {
            return super.convert(value);
        }
        this.assertValueInRange(rawValue);
        return new Integer((int)rawValue);
    }

    public Object successor(Object value) throws IllegalArgumentException {
        int v = (Integer)value;
        if (v == Integer.MAX_VALUE) {
            return value;
        }
        return new Integer(v + 1);
    }

    public Object read(DataInput in) throws IOException {
        int value = in.readInt();
        if (Integer.MIN_VALUE == value && !in.readBoolean()) {
            return null;
        }
        return new Integer(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeInt(Integer.MIN_VALUE);
            out.writeBoolean(false);
        } else {
            try {
                int val = (Integer)this.convert(value);
                out.writeInt(val);
                if (Integer.MIN_VALUE == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new IntegerType();
    }

    public int compare(Object a, Object b) {
        int ib;
        int ia = ((Number)a).intValue();
        return ia < (ib = ((Number)b).intValue()) ? -1 : (ia == ib ? 0 : 1);
    }

    protected Comparator getComparator() {
        return this;
    }

    private void assertValueInRange(long value) throws AxionException {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new AxionException(22003);
        }
    }
}

