/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.axiondb.jdbc.AxionBlob;

public class ByteArrayBlob
implements AxionBlob {
    private byte[] _value = null;

    public ByteArrayBlob(byte[] value) {
        if (null == value) {
            throw new NullPointerException();
        }
        this._value = value;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this._value);
    }

    public byte[] getBytes() {
        return this._value;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos > this.length() || pos < 0L) {
            throw new SQLException("position " + pos + " is out of bounds.");
        }
        if (length < 0) {
            throw new SQLException("length" + length + " is invalid.");
        }
        if ((long)length + pos > this.length()) {
            length = (int)(this.length() - pos);
        }
        byte[] returning = new byte[length];
        System.arraycopy(this._value, (int)pos, returning, 0, length);
        return returning;
    }

    public long length() throws SQLException {
        return this._value.length;
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLException("Not supported");
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLException("Not supported");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("Not supported");
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new SQLException("Unsupported.");
    }
}

